/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiig;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import oracle.sysman.oii.oiig.OiigNotifConfigXmlHandler;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oix.oixp.OixpIElement;
import oracle.sysman.oix.oixp.OixpIXmlParser;
import oracle.sysman.oix.oixp.OixpXmlParserFactory;
import oracle.sysman.oix.oixw.OixwIXmlWriter;
import oracle.sysman.oix.oixw.OixwXmlWriterOps;

public class OiigNotifConfig
implements OixwIXmlWriter {
    private static final String DEF_BROWSERLOC = "netscape";
    private static final String DEF_UPLOADLOC = "http://oraclesupport.us.oracle.com";
    private String m_GUID = null;
    private String m_emailId;
    private String m_hostName;
    private String m_browserLoc;
    private boolean m_bCheckPatches = true;
    private boolean m_bUploadInv = false;
    private String m_uploadLoc = "http://oraclesupport.us.oracle.com";
    private boolean m_bRegisterForNotifs = false;
    private String m_persistLoc = null;
    public static final String MAIN_TAG = "NotifConfig";
    private static final String GUID_ATTR = "GUID";
    private static final String EMAILID_ATTR = "EmailID";
    private static final String HOSTNAME_ATTR = "HostName";
    private static final String CHECKPATCHES_ATTR = "CheckPatches";
    private static final String UPLOADINV_ATTR = "UploadInv";
    private static final String REGNOTIFS_ATTR = "RegNotifs";
    private static final String UPLOADLOC_ATTR = "UploadLoc";
    private static final String BROWSERLOC_ATTR = "BrowserLoc";
    public static final String LOC_UNDER_ORAINV = "oui";
    public static final String FILENAME = "patchReq.cfg";

    public OiigNotifConfig(String guid, String emailId, String hostName, String browserLoc) {
        this.m_GUID = guid;
        this.m_emailId = emailId;
        this.m_hostName = hostName;
        this.m_browserLoc = browserLoc;
        if (this.m_hostName == null) {
            this.m_hostName = this.computeHostName();
        }
        if (this.m_browserLoc == null) {
            this.m_browserLoc = DEF_BROWSERLOC;
        }
        if (this.m_GUID == null) {
            this.m_GUID = this.generateGUID(this.m_hostName);
        }
        if (this.m_emailId == null) {
            this.m_emailId = "";
        }
    }

    public OiigNotifConfig(OixpIElement el) {
        this(el.getAttribValue(GUID_ATTR), el.getAttribValue(EMAILID_ATTR), el.getAttribValue(HOSTNAME_ATTR), el.getAttribValue(BROWSERLOC_ATTR));
        String uploadLoc;
        String regNotifStr;
        String uploadInvStr;
        String chkPatchStr = el.getAttribValue(CHECKPATCHES_ATTR);
        if (chkPatchStr != null) {
            this.setCheckPatches(Boolean.valueOf(chkPatchStr));
        }
        if ((uploadInvStr = el.getAttribValue(UPLOADINV_ATTR)) != null) {
            this.setUploadInv(Boolean.valueOf(uploadInvStr));
        }
        if ((regNotifStr = el.getAttribValue(REGNOTIFS_ATTR)) != null) {
            this.setRegisterForNotifs(Boolean.valueOf(regNotifStr));
        }
        if ((uploadLoc = el.getAttribValue(UPLOADLOC_ATTR)) != null) {
            this.setUploadLoc(uploadLoc);
        }
    }

    public OiigNotifConfig() {
        this(null, null, null, null);
    }

    private String computeHostName() {
        int dotPos;
        String hostName = "<unknown>";
        InetAddress iAddr = null;
        try {
            iAddr = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            System.out.println(e.getMessage());
        }
        if (iAddr != null && (dotPos = (hostName = iAddr.getHostName()).indexOf(46)) != -1) {
            hostName = hostName.substring(0, dotPos);
        }
        return hostName;
    }

    private String generateGUID(String hostName) {
        return hostName + System.currentTimeMillis();
    }

    public void setGUID(String guid) {
        this.m_GUID = guid;
    }

    public void setEmailId(String emailId) {
        this.m_emailId = emailId;
    }

    public void setHostName(String hostName) {
        this.m_hostName = hostName;
    }

    public void setUploadLoc(String uploadLoc) {
        this.m_uploadLoc = uploadLoc;
    }

    public void setBrowserLoc(String browserLoc) {
        this.m_browserLoc = browserLoc;
    }

    public void setCheckPatches(boolean bCheckPatches) {
        this.m_bCheckPatches = bCheckPatches;
    }

    public void setUploadInv(boolean bUploadInv) {
        this.m_bUploadInv = bUploadInv;
    }

    public void setRegisterForNotifs(boolean bRegisterForNotifs) {
        this.m_bRegisterForNotifs = bRegisterForNotifs;
    }

    public void setPersistLoc(String persistLoc) {
        this.m_persistLoc = persistLoc;
    }

    public String getGUID() {
        return this.m_GUID;
    }

    public String getEmailId() {
        return this.m_emailId;
    }

    public String getHostName() {
        return this.m_hostName;
    }

    public String getUploadLoc() {
        return this.m_uploadLoc;
    }

    public String getBrowserLoc() {
        return this.m_browserLoc;
    }

    public boolean shouldCheckPatches() {
        return this.m_bCheckPatches;
    }

    public boolean shouldUploadInv() {
        return this.m_bUploadInv;
    }

    public boolean shouldRegisterForNotifs() {
        return this.m_bRegisterForNotifs;
    }

    public String getPersistLoc() {
        return this.m_persistLoc;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("NotifConfig :: \n");
        sbuf.append(" GUID = ").append(this.m_GUID).append("\n");
        sbuf.append(" EmailID = ").append(this.m_emailId).append("\n");
        sbuf.append(" HostName = ").append(this.m_hostName).append("\n");
        sbuf.append(" BrowserLoc = ").append(this.m_browserLoc).append("\n");
        return sbuf.toString();
    }

    @Override
    public void writeXmlForm(PrintWriter pw) throws IOException {
        pw.println("<NotifConfig");
        pw.println("   GUID=\"" + OixwXmlWriterOps.encodeSplChars(this.m_GUID) + "\" ");
        pw.println("   EmailID=\"" + OixwXmlWriterOps.encodeSplChars(this.m_emailId) + "\" ");
        pw.println("   HostName=\"" + OixwXmlWriterOps.encodeSplChars(this.m_hostName) + "\" ");
        pw.println("   CheckPatches=\"" + this.m_bCheckPatches + "\" ");
        pw.println("   UploadInv=\"" + this.m_bUploadInv + "\" ");
        pw.println("   UploadLoc=\"" + OixwXmlWriterOps.encodeSplChars(this.m_uploadLoc) + "\" ");
        pw.println("   RegNotifs=\"" + this.m_bRegisterForNotifs + "\" ");
        pw.println("   BrowserLoc=\"" + OixwXmlWriterOps.encodeSplChars(this.m_browserLoc) + "\" ");
        pw.println("></NotifConfig>");
    }

    public static String calcFileLoc(String invDir) {
        String stdPath = OiixPathOps.getStandardForm(invDir);
        stdPath = OiixPathOps.concatPath(stdPath, "oui/patchReq.cfg");
        return OiixPathOps.getNativeForm(stdPath);
    }

    public static OiigNotifConfig loadFromFile(String loc) throws IOException {
        OiigNotifConfig notCfg = null;
        try (FileInputStream fis = null;){
            OixpIXmlParser parser = OixpXmlParserFactory.createXmlParser();
            fis = new FileInputStream(loc);
            parser.setInputStream(fis);
            OiigNotifConfigXmlHandler hndlr = new OiigNotifConfigXmlHandler();
            parser.setHandler(hndlr);
            parser.readXML();
            notCfg = hndlr.getNotifConfig();
        }
        return notCfg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToFile() throws IOException {
        FileOutputStream fos = null;
        PrintWriter pw = null;
        try {
            File perFile = new File(this.m_persistLoc);
            File parDir = new File(perFile.getParent());
            if (!parDir.exists()) {
                OiixFileOps.mkdirs(parDir);
            }
            fos = new FileOutputStream(this.m_persistLoc);
            pw = new PrintWriter(fos, true);
            this.writeXmlForm(pw);
        }
        finally {
            if (pw != null) {
                pw.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }
}

