/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiig;

import java.io.IOException;
import java.io.PrintWriter;
import oracle.sysman.oix.oixp.OixpIElement;
import oracle.sysman.oix.oixw.OixwIXmlWriter;

public class OiigInvUploadAttrs
implements OixwIXmlWriter {
    private boolean m_bUploadServer;
    private int m_frequency;
    public static final String INVUPLOAD_TAG = "InvUpload";
    private static final String UPLOAD_ATTR = "Upload";
    private static final String FREQUENCY_ATTR = "Frequency";
    public static final int UPL_USER_INIT = 0;
    public static final String UPL_USER_INIT_STR = "UserInitiated";
    public static final int UPL_SERVER_CONN = 5;
    public static final String UPL_SERVER_CONN_STR = "PerConnection";
    public static final int UPL_EVERY_SESSION = 10;
    public static final String UPL_EVERY_SESSION_STR = "PerSession";
    private static final int[] s_iFreqs = new int[]{0, 5, 10};
    private static final String[] s_sFreqs = new String[]{"UserInitiated", "PerConnection", "PerSession"};

    public OiigInvUploadAttrs(boolean bUploadServer, int frequency) {
        this.m_bUploadServer = bUploadServer;
        this.m_frequency = frequency;
    }

    public OiigInvUploadAttrs(OixpIElement el) {
        this(Boolean.valueOf(el.getAttribValue(UPLOAD_ATTR)), OiigInvUploadAttrs.stringFreqToInt(el.getAttribValue(FREQUENCY_ATTR)));
    }

    public static String intFreqToString(int freq) {
        String sFreq = null;
        for (int i = 0; i < s_iFreqs.length; ++i) {
            if (freq != s_iFreqs[i]) continue;
            sFreq = s_sFreqs[i];
        }
        return sFreq;
    }

    public static int stringFreqToInt(String sFreq) {
        int freq = 0;
        for (int i = 0; i < s_iFreqs.length; ++i) {
            if (!sFreq.equalsIgnoreCase(s_sFreqs[i])) continue;
            freq = s_iFreqs[i];
        }
        return freq;
    }

    public boolean isUploadServer() {
        return this.m_bUploadServer;
    }

    public void setUploadServer(boolean bUploadServer) {
        this.m_bUploadServer = bUploadServer;
    }

    public int getFrequency() {
        return this.m_frequency;
    }

    public void setFrequency(int frequency) {
        this.m_frequency = frequency;
    }

    public String toString() {
        return "[InvUpload : " + this.m_bUploadServer + " at " + OiigInvUploadAttrs.intFreqToString(this.m_frequency) + "] ";
    }

    public boolean equals(OiigInvUploadAttrs upload) {
        return this.m_bUploadServer == upload.isUploadServer() && this.m_frequency == upload.getFrequency();
    }

    @Override
    public void writeXmlForm(PrintWriter pw) throws IOException {
        pw.println("<InvUpload Upload=\"" + this.m_bUploadServer + "\" " + FREQUENCY_ATTR + "=\"" + OiigInvUploadAttrs.intFreqToString(this.m_frequency) + "\"></" + INVUPLOAD_TAG + ">");
    }
}

