/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiig;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.sysman.oii.oiig.OiigSetContent;
import oracle.sysman.oii.oiig.OiigXmlOps;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oix.oixp.OixpIElement;
import oracle.sysman.oix.oixw.OixwIXmlWriter;
import oracle.sysman.oix.oixw.OixwXmlWriterOps;

public class OiigDepComp
implements OiigSetContent,
OixwIXmlWriter {
    private String m_internalName;
    private String m_displayName;
    private String m_description;
    private OiiiVersion m_version;
    private long m_index;
    private Vector m_ohomes;
    private int m_compType;
    private boolean m_topLevel;
    private Vector m_assocPatches;
    private Vector m_assocPatchSets;
    public static final String DEPCOMP_TAG = "DepComp";
    public static final String ASSOC_PATCHES_TAG = "AssocPatches";
    public static final String ASSOC_PATCHSETS_TAG = "AssocPatchSets";
    private static final String INTNAME_ATTR = "InternalName";
    private static final String DISPNAME_ATTR = "DisplayName";
    private static final String DESC_ATTR = "Description";
    private static final String VERSION_ATTR = "Version";
    private static final String COMPTYPE_ATTR = "CompType";
    private static final String TOPLEVEL_ATTR = "TopLevel";
    private static final String OHOMELOCS_ATTR = "OHomeLocs";
    private static final String INDEX_ATTR = "Index";

    public OiigDepComp(String internalName, String displayName, String description, OiiiVersion version, int compType, boolean topLevel, Vector ohomes, long index) {
        this.m_internalName = internalName;
        this.m_displayName = displayName;
        this.m_description = description;
        this.m_version = version;
        this.m_compType = compType;
        this.m_topLevel = topLevel;
        this.m_ohomes = ohomes;
        this.m_index = index;
        this.m_assocPatches = new Vector();
        this.m_assocPatchSets = new Vector();
    }

    public OiigDepComp(OixpIElement el) {
        this(el.getAttribValue(INTNAME_ATTR), el.getAttribValue(DISPNAME_ATTR), el.getAttribValue(DESC_ATTR), new OiiiVersion(el.getAttribValue(VERSION_ATTR)), Integer.parseInt(el.getAttribValue(COMPTYPE_ATTR)), Boolean.valueOf(el.getAttribValue(COMPTYPE_ATTR)), OiigDepComp.parseEls(el.getAttribValue(OHOMELOCS_ATTR)), Long.parseLong(el.getAttribValue(INDEX_ATTR)));
    }

    public String getInternalName() {
        return this.m_internalName;
    }

    public String getDisplayName() {
        return this.m_displayName;
    }

    public String getDescription() {
        return this.m_description;
    }

    public OiiiVersion getVersion() {
        return this.m_version;
    }

    public int getCompType() {
        return this.m_compType;
    }

    public boolean isTopLevel() {
        return this.m_topLevel;
    }

    public Vector getOHomeLocs() {
        return this.m_ohomes;
    }

    @Override
    public long getIndex() {
        return this.m_index;
    }

    public Vector getAssocPatches() {
        return this.m_assocPatches;
    }

    public Vector getAssocPatchSets() {
        return this.m_assocPatchSets;
    }

    public void setInternalName(String internalName) {
        this.m_internalName = internalName;
    }

    public void setDisplayName(String displayName) {
        this.m_displayName = displayName;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public void setVersion(OiiiVersion version) {
        this.m_version = version;
    }

    public void setCompType(int compType) {
        this.m_compType = compType;
    }

    public void setTopLevel(boolean topLevel) {
        this.m_topLevel = topLevel;
    }

    public void setOHomeLocs(Vector ohomes) {
        this.m_ohomes = ohomes;
    }

    public void addOHomeLoc(String ohome) {
        if (!this.m_ohomes.contains(ohome)) {
            this.m_ohomes.addElement(ohome);
        }
    }

    public void setIndex(long index) {
        this.m_index = index;
    }

    public void setAssocPatches(Vector assocPatches) {
        this.m_assocPatches = assocPatches;
    }

    public void addAssocPatch(long assocPatchId) {
        this.m_assocPatches.addElement(new Long(assocPatchId));
    }

    public void setAssocPatchSets(Vector assocPatchSets) {
        this.m_assocPatchSets = assocPatchSets;
    }

    public void addAssocPatchSet(long assocPatchSetId) {
        this.m_assocPatchSets.addElement(new Long(assocPatchSetId));
    }

    public String toString() {
        return "\n[Comp " + this.m_index + ": IntName = " + this.m_internalName + ": Ver = " + this.m_version.getVerString() + ": DispName = " + this.m_displayName + ": Description = " + this.m_description + ": CompType = " + this.m_compType + ": TopLevel = " + this.m_topLevel + ": AssocPatches = " + this.m_assocPatches + ": AssocPatchSets = " + this.m_assocPatchSets + "]";
    }

    @Override
    public void writeXmlForm(PrintWriter pw) throws IOException {
        pw.println("<DepComp InternalName=\"" + OixwXmlWriterOps.encodeSplChars(this.m_internalName) + "\" " + DISPNAME_ATTR + "=\"" + OixwXmlWriterOps.encodeSplChars(this.m_displayName) + "\" " + DESC_ATTR + "=\"" + OixwXmlWriterOps.encodeSplChars(this.m_description) + "\" " + VERSION_ATTR + "=\"" + this.m_version.getVerString() + "\" " + COMPTYPE_ATTR + "=\"" + this.m_compType + "\" " + TOPLEVEL_ATTR + "=\"" + this.m_topLevel + "\" " + OHOMELOCS_ATTR + "=\"" + OiigDepComp.combineEls(this.m_ohomes) + "\" " + INDEX_ATTR + "=\"" + this.m_index + "\">");
        if (this.m_assocPatches != null && !this.m_assocPatches.isEmpty()) {
            pw.println("<AssocPatches>" + OiigXmlOps.stringWithNumVect(this.m_assocPatches) + "</" + ASSOC_PATCHES_TAG + "> ");
        }
        if (this.m_assocPatchSets != null && !this.m_assocPatchSets.isEmpty()) {
            pw.println("<AssocPatchSets>" + OiigXmlOps.stringWithNumVect(this.m_assocPatchSets) + "</" + ASSOC_PATCHSETS_TAG + "> ");
        }
        pw.println("</DepComp>");
    }

    private static String combineEls(Vector ohomes) {
        StringBuffer sbuf = new StringBuffer();
        int numHomes = ohomes != null ? ohomes.size() : 0;
        for (int i = 0; i < numHomes - 1; ++i) {
            sbuf.append((String)ohomes.elementAt(i)).append(";");
        }
        if (numHomes > 0) {
            sbuf.append((String)ohomes.elementAt(numHomes - 1));
        }
        return sbuf.toString();
    }

    private static Vector parseEls(String strWithEls) {
        StringTokenizer stok = new StringTokenizer(strWithEls, ";");
        Vector<String> els = new Vector<String>();
        while (stok.hasMoreTokens()) {
            els.addElement(stok.nextToken());
        }
        return els;
    }
}

