/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiig;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import oracle.sysman.oii.oiig.OiigSetContent;
import oracle.sysman.oii.oiii.OiiiStageCompInvEntry;
import oracle.sysman.oix.oixp.OixpIElement;
import oracle.sysman.oix.oixw.OixwIXmlWriter;
import oracle.sysman.oix.oixw.OixwXmlWriterOps;

public class OiigCompInfo
implements OiigSetContent,
OixwIXmlWriter {
    private String m_internalName;
    private String m_displayName;
    private String m_verStr;
    private String m_instVerStr;
    private String m_baseCompVerStr;
    private int m_compType;
    private long m_index;
    private long m_uploadTime;
    private String m_description;
    private Vector m_platforms;
    private long[][] m_platSizes;
    private long m_size;
    private OiiiStageCompInvEntry m_scie;
    private boolean m_bCompInTarget = false;
    private boolean m_selected;
    public static final String COMP_TAG = "Comp";
    private static final String DISPNAME_ATTR = "DisplayName";
    private static final String INTNAME_ATTR = "InternalName";
    private static final String VERSTR_ATTR = "VerStr";
    private static final String INSTVERSTR_ATTR = "InstVerStr";
    private static final String COMPTYPE_ATTR = "CompType";
    private static final String INDEX_ATTR = "Index";
    private static final String UPLOADTIME_ATTR = "UploadTime";

    public OiigCompInfo(String displayName, String internalName, String verStr, String instVerStr, int compType, long index) {
        this.m_displayName = displayName;
        this.m_internalName = internalName;
        this.m_verStr = verStr;
        this.m_instVerStr = instVerStr;
        this.m_compType = compType;
        this.m_index = index;
        this.m_scie = null;
        this.m_selected = false;
    }

    public OiigCompInfo(String internalName, String verStr, long index) {
        this(internalName, internalName, verStr, "0", 1, index);
        this.setUploadTime(System.currentTimeMillis());
    }

    public OiigCompInfo(OixpIElement el) {
        this(el.getAttribValue(DISPNAME_ATTR), el.getAttribValue(INTNAME_ATTR), el.getAttribValue(VERSTR_ATTR), el.getAttribValue(INSTVERSTR_ATTR), Integer.parseInt(el.getAttribValue(COMPTYPE_ATTR)), Long.parseLong(el.getAttribValue(INDEX_ATTR)));
        String uploadVal = el.getAttribValue(UPLOADTIME_ATTR);
        if (uploadVal != null) {
            this.setUploadTime(Long.parseLong(uploadVal));
        }
    }

    public String getDisplayName() {
        return this.m_displayName;
    }

    public String getInternalName() {
        return this.m_internalName;
    }

    public String getVerStr() {
        return this.m_verStr;
    }

    public String getInstVerStr() {
        return this.m_instVerStr;
    }

    public String getBaseCompVerStr() {
        return this.m_baseCompVerStr;
    }

    public void setBaseCompVerStr(String baseCompVerStr) {
        this.m_baseCompVerStr = baseCompVerStr;
    }

    public void setCompType(int compType) {
        this.m_compType = compType;
    }

    public int getCompType() {
        return this.m_compType;
    }

    @Override
    public long getIndex() {
        return this.m_index;
    }

    public long getUploadTime() {
        return this.m_uploadTime;
    }

    public void setUploadTime(long uploadTime) {
        this.m_uploadTime = uploadTime;
    }

    public String getDescription() {
        return this.m_description;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public long[][] getPlatSizes() {
        return this.m_platSizes;
    }

    public Vector getPlatforms() {
        if (this.m_platforms == null) {
            this.m_platforms = new Vector();
            int numPlats = this.m_platSizes.length;
            for (int i = 0; i < numPlats; ++i) {
                this.m_platforms.addElement(new Integer((int)this.m_platSizes[i][0]));
            }
        }
        return this.m_platforms;
    }

    public void setPlatSizes(long[][] platSizes) {
        this.m_platSizes = platSizes;
        this.m_platforms = null;
    }

    public long getSize() {
        return this.m_size;
    }

    public void setSize(long size) {
        this.m_size = size;
    }

    public boolean isCompInTarget() {
        return this.m_bCompInTarget;
    }

    public void setSelected(boolean selected) {
        this.m_selected = selected;
    }

    public boolean isSelected() {
        return this.m_selected;
    }

    public void setStageCompInvEntry(OiiiStageCompInvEntry scie) {
        this.m_scie = scie;
    }

    public OiiiStageCompInvEntry getStageCompInvEntry() {
        return this.m_scie;
    }

    public void setCompInTarget(boolean bCompInTarget) {
        this.m_bCompInTarget = bCompInTarget;
    }

    public String toString() {
        return "\n[Comp " + this.m_index + ": IntName = " + this.m_internalName + ", ver = " + this.m_verStr + "]";
    }

    @Override
    public void writeXmlForm(PrintWriter pw) throws IOException {
        pw.println("<Comp DisplayName=\"" + OixwXmlWriterOps.encodeSplChars(this.m_displayName) + "\" " + INTNAME_ATTR + "=\"" + OixwXmlWriterOps.encodeSplChars(this.m_internalName) + "\" " + VERSTR_ATTR + "=\"" + this.m_verStr + "\" " + INSTVERSTR_ATTR + "=\"" + this.m_instVerStr + "\" " + COMPTYPE_ATTR + "=\"" + this.m_compType + "\" " + INDEX_ATTR + "=\"" + this.m_index + "\" " + UPLOADTIME_ATTR + "=\"" + this.m_uploadTime + "\"></" + COMP_TAG + ">");
    }
}

