/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiig;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;
import oracle.sysman.oii.oiig.OiigAvailSoftwareUpdater;
import oracle.sysman.oii.oiig.OiigCompInfo;
import oracle.sysman.oii.oiig.OiigPubClient;
import oracle.sysman.oii.oiig.OiigSetContent;
import oracle.sysman.oii.oiig.OiigSetInfo;
import oracle.sysman.oii.oiig.OiigSetItemNotFoundException;
import oracle.sysman.oii.oiii.OiiiAreaInventory;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiCompInvEntry;
import oracle.sysman.oii.oiii.OiiiStageCompInvEntry;
import oracle.sysman.oii.oiii.OiiiStageInventory;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oix.oixp.OixpIElement;
import oracle.sysman.oix.oixw.OixwIXmlWriter;
import oracle.sysman.oix.oixw.OixwXmlWriterOps;

public class OiigAvailSoftware
implements OixwIXmlWriter {
    private Vector m_allSets = new Vector();
    private Vector m_allComps = new Vector();
    public static final String MAIN_TAG_TYPE = "AvailSoft";
    public static final String COMPS_TAG = "Comps";
    public static final String SETS_TAG = "Sets";
    private OiiiAreaInventory m_filterInv = null;
    private int m_ohInd = -1;
    private OiigAvailSoftwareUpdater m_updater;
    private Hashtable m_completions;
    private int m_batchID;
    private Vector m_curRequestSets;
    private Vector m_nextRequestSets;
    private Object m_updateLock;
    private boolean m_updatedFully = false;

    public OiigAvailSoftware() {
        this.doUpdateInitializations();
    }

    public OiigAvailSoftware(OixpIElement el) {
        this();
    }

    public void addSet(OiigSetInfo set) {
        this.m_allSets.addElement(set);
    }

    public void addComp(OiigCompInfo comp) {
        this.m_allComps.addElement(comp);
    }

    public long[] getAllCompIDs() {
        return this.getAllSetContentIDs(this.m_allComps);
    }

    public long[] getAllSetIDs() {
        return this.getAllSetContentIDs(this.m_allSets);
    }

    private synchronized long[] getAllSetContentIDs(Vector vect) {
        int numElems = vect.size();
        long[] retArr = new long[numElems];
        for (int i = 0; i < numElems; ++i) {
            OiigSetContent sc = (OiigSetContent)vect.elementAt(i);
            retArr[i] = sc.getIndex();
        }
        return retArr;
    }

    public Vector getTopLevelSets() {
        Vector<OiigSetInfo> tlSets = new Vector<OiigSetInfo>();
        int numSets = this.m_allSets.size();
        for (int i = 0; i < numSets; ++i) {
            OiigSetInfo setInfo = (OiigSetInfo)this.m_allSets.elementAt(i);
            if (!setInfo.isTopLevel()) continue;
            tlSets.addElement(setInfo);
        }
        return tlSets;
    }

    public Vector getTopLevelDispSets() {
        Vector<Long> reachableSets = new Vector<Long>();
        Hashtable<Long, Long> reachableMap = new Hashtable<Long, Long>();
        int numSets = this.m_allSets.size();
        for (int i = 0; i < numSets; ++i) {
            OiigSetInfo setInfo = (OiigSetInfo)this.m_allSets.elementAt(i);
            if (!setInfo.isTopLevel()) continue;
            Long setID = new Long(setInfo.getIndex());
            reachableSets.addElement(setID);
            reachableMap.put(setID, setID);
        }
        Hashtable<Long, Long> knownSets = new Hashtable<Long, Long>();
        long[] knownSetIDs = this.getAllSetIDs();
        long numKnownSets = knownSetIDs.length;
        int i = 0;
        while ((long)i < numKnownSets) {
            Long setID = new Long(knownSetIDs[i]);
            knownSets.put(setID, setID);
            ++i;
        }
        int numReachable = reachableSets.size();
        for (int i2 = 0; i2 < numReachable; ++i2) {
            Long setID = (Long)reachableSets.elementAt(i2);
            if (knownSets.get(setID) == null) continue;
            long index = setID;
            OiigSetInfo setInfo = this.getSet(index);
            long[] childSetIDs = setInfo.getChildSetIDs();
            int numChildSets = childSetIDs != null ? childSetIDs.length : 0;
            for (int j = 0; j < numChildSets; ++j) {
                Long childSetID = new Long(childSetIDs[j]);
                if (reachableMap.get(childSetID) != null) continue;
                reachableSets.addElement(childSetID);
                reachableMap.put(childSetID, childSetID);
                ++numReachable;
            }
        }
        Vector<OiigSetInfo> tlSets = new Vector<OiigSetInfo>();
        for (int i3 = 0; i3 < numSets; ++i3) {
            OiigSetInfo setInfo = (OiigSetInfo)this.m_allSets.elementAt(i3);
            if (!setInfo.isTopLevel() && reachableMap.get(new Long(setInfo.getIndex())) != null) continue;
            tlSets.addElement(setInfo);
        }
        return tlSets;
    }

    private Vector getMissingSets() {
        Hashtable<Long, Long> knownSets = new Hashtable<Long, Long>();
        Vector<Long> missingSets = new Vector<Long>();
        long[] knownSetIDs = this.getAllSetIDs();
        long numKnownSets = knownSetIDs.length;
        int i = 0;
        while ((long)i < numKnownSets) {
            Long setID = new Long(knownSetIDs[i]);
            knownSets.put(setID, setID);
            ++i;
        }
        i = 0;
        while ((long)i < numKnownSets) {
            OiigSetInfo setInfo = this.getSet(knownSetIDs[i]);
            long[] childSetIDs = setInfo.getChildSetIDs();
            int numChildSets = childSetIDs != null ? childSetIDs.length : 0;
            for (int j = 0; j < numChildSets; ++j) {
                Long childSetID = new Long(childSetIDs[j]);
                if (knownSets.get(childSetID) != null) continue;
                missingSets.addElement(childSetID);
            }
            ++i;
        }
        return missingSets;
    }

    public Vector getAllSets() {
        return this.m_allSets;
    }

    public Vector getAllComps() {
        return this.m_allComps;
    }

    public OiigCompInfo getComp(long index) {
        return (OiigCompInfo)this.getItem(this.m_allComps, index);
    }

    private synchronized OiigSetContent getItem(Vector allItems, long index) {
        OiigSetContent retCont = null;
        int numItems = allItems.size();
        for (int i = 0; i < numItems; ++i) {
            OiigSetContent sc = (OiigSetContent)allItems.elementAt(i);
            if (sc.getIndex() != index) continue;
            retCont = sc;
            break;
        }
        return retCont;
    }

    public void initialize(OiigPubClient pubClient, OiiiStageInventory si, OiiiAreaInventory filterInv, int lkHmInd) throws OiigSetItemNotFoundException {
        OiigAvailSoftwareUpdater updater = new OiigAvailSoftwareUpdater(pubClient);
        updater.setStgInv(si);
        this.setUpdater(updater);
        this.m_filterInv = filterInv;
        this.m_ohInd = lkHmInd;
        this.resolveComps(si);
    }

    public boolean resolveComps(OiiiStageInventory si, Vector compIDs) {
        boolean success = true;
        int numComps = this.m_allComps.size();
        for (int i = 0; i < numComps; ++i) {
            OiiiStageCompInvEntry scie;
            OiigCompInfo compI = (OiigCompInfo)this.m_allComps.elementAt(i);
            if (compIDs != null && !compIDs.contains(new Long(compI.getIndex()))) continue;
            String intName = compI.getInternalName();
            String verStr = compI.getVerStr();
            OiiiCompInstallID tid = new OiiiCompInstallID(intName, new OiiiVersion(verStr), new Vector(), new OiiiVersion("0"), 0, 0, 0);
            int srchPlat = 0;
            if (this.m_ohInd != -1) {
                srchPlat = OiixPlatform.getCurrentPlatform();
            }
            if ((scie = (OiiiStageCompInvEntry)si.getCompatCompEntry(tid, 0, srchPlat)) != null) {
                compI.setStageCompInvEntry(scie);
                tid = scie.getCompInstallID();
            } else {
                System.out.println("Resolvecomps fails for tid : " + tid);
                success = false;
            }
            if (this.findFilterInvEntry(tid) == null) continue;
            compI.setCompInTarget(true);
        }
        return success;
    }

    private boolean resolveComps(OiiiStageInventory si) {
        return this.resolveComps(si, null);
    }

    public String toString() {
        return "All Comps \n" + this.m_allComps + "\nAllSets \n" + this.m_allSets;
    }

    public OiiiCompInvEntry findFilterInvEntry(OiiiCompInstallID cid) {
        OiiiCompInvEntry cie = null;
        if (this.m_filterInv != null && (this.m_ohInd == -1 || (cie = this.m_filterInv.getCompatCompEntry(cid, this.m_ohInd)) == null)) {
            cie = this.m_filterInv.getCompatCompEntry(cid, 0);
        }
        return cie;
    }

    private void doUpdateInitializations() {
        this.m_updater = null;
        this.m_completions = new Hashtable();
        this.m_batchID = 0;
        this.m_nextRequestSets = new Vector();
        this.m_curRequestSets = new Vector();
        this.m_updateLock = new Object();
    }

    private synchronized boolean wasReqCompleted(long setIndex) {
        return this.m_completions.get(new Long(setIndex)) != null;
    }

    private synchronized void setReqCompleted(long setIndex) {
        if (this.m_updater != null) {
            Long setID = new Long(setIndex);
            this.m_completions.put(setID, setID);
        }
    }

    public OiigSetInfo getSet(long index) {
        OiigSetInfo retInfo = (OiigSetInfo)this.getItem(this.m_allSets, index);
        if (retInfo == null && !this.wasReqCompleted(index)) {
            retInfo = this.requestUpdate(index);
            if (retInfo == null) {
                retInfo = (OiigSetInfo)this.getItem(this.m_allSets, index);
            }
            this.setReqCompleted(index);
        }
        return retInfo;
    }

    public synchronized void setUpdater(OiigAvailSoftwareUpdater updater) {
        this.m_updater = updater;
    }

    public synchronized OiigAvailSoftwareUpdater getUpdater() {
        return this.m_updater;
    }

    private Vector curReqs() {
        System.out.println("In curReqs : " + this.m_curRequestSets);
        return this.m_curRequestSets;
    }

    private synchronized int getRequestBatchID(long setIndex) {
        Long setID = new Long(setIndex);
        if (!this.m_curRequestSets.contains(setID) && !this.m_nextRequestSets.contains(setID)) {
            this.m_nextRequestSets.addElement(setID);
        }
        return this.m_batchID;
    }

    private int getCurBatchID() {
        return this.m_batchID;
    }

    private synchronized void updateBatchIDAndRequests() {
        this.m_curRequestSets = this.m_nextRequestSets;
        this.m_nextRequestSets = new Vector();
        this.m_batchID = (this.m_batchID + 1) % 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OiigSetInfo requestUpdate(long setIndex) {
        OiigSetInfo retInfo = null;
        OiigAvailSoftwareUpdater updater = this.getUpdater();
        if (updater != null) {
            int curBatch = this.getRequestBatchID(setIndex);
            Object object = this.m_updateLock;
            synchronized (object) {
                if (curBatch == this.getCurBatchID() && (retInfo = (OiigSetInfo)this.getItem(this.m_allSets, setIndex)) == null) {
                    this.updateBatchIDAndRequests();
                    updater.updateAvailSoftware(this, this.curReqs());
                }
            }
        }
        return retInfo;
    }

    public OiigSetInfo updateSetContents(long setIndex, int numLevels) {
        OiigSetInfo setInfo = this.getSet(setIndex);
        if (numLevels > 0 && setInfo != null) {
            long[] cSetIDs = setInfo.getChildSetIDs();
            int numCSets = cSetIDs != null ? cSetIDs.length : 0;
            for (int i = 0; i < numCSets; ++i) {
                this.updateSetContents(cSetIDs[i], numLevels - 1);
            }
        }
        return setInfo;
    }

    public boolean updateFully() {
        boolean couldUpdate = false;
        if (this.m_updatedFully) {
            return true;
        }
        if (this.m_updater != null) {
            Vector missingSets = this.getMissingSets();
            int numMissing = missingSets.size();
            if (numMissing == 0) {
                return true;
            }
            for (int i = 0; i < numMissing; ++i) {
                this.getRequestBatchID((Long)missingSets.elementAt(i));
            }
            this.m_updater.setNumReqLevels(-1);
            this.requestUpdate((Long)missingSets.elementAt(0));
        }
        if (couldUpdate) {
            this.m_updatedFully = true;
        }
        return couldUpdate;
    }

    @Override
    public void writeXmlForm(PrintWriter pw) throws IOException {
        pw.println("<AvailSoft>");
        pw.println("<Comps>");
        OixwXmlWriterOps.writeXmlForm(this.m_allComps, pw);
        pw.println("</Comps>");
        pw.println("<Sets>");
        OixwXmlWriterOps.writeXmlForm(this.m_allSets, pw);
        pw.println("</Sets>");
        pw.println("</AvailSoft>");
    }

    public static void main(String[] args) {
        try {
            int i;
            int numComps = 5;
            int numSets = 5;
            OiigCompInfo[] comps = new OiigCompInfo[numComps];
            comps[0] = new OiigCompInfo("compA", "1.0", 0L);
            comps[1] = new OiigCompInfo("compB", "1.5", 1L);
            comps[2] = new OiigCompInfo("compC", "2.0", 2L);
            comps[3] = new OiigCompInfo("compD", "1.3", 3L);
            comps[4] = new OiigCompInfo("compE", "1.5", 4L);
            OiigSetInfo[] sets = new OiigSetInfo[numSets];
            sets[0] = new OiigSetInfo("Set A", 0L);
            sets[1] = new OiigSetInfo("Set B", 1L);
            sets[2] = new OiigSetInfo("Set C", 2L);
            sets[3] = new OiigSetInfo("Set D", 3L);
            sets[4] = new OiigSetInfo("Set E", 4L);
            sets[0].addChildSet(1L);
            sets[0].addChildSet(2L);
            sets[0].addChildSet(4L);
            sets[0].addChildComp(1L);
            sets[0].addChildComp(2L);
            sets[1].addChildSet(3L);
            sets[1].addChildSet(4L);
            sets[1].addChildComp(0L);
            sets[1].addChildComp(4L);
            sets[2].addChildSet(4L);
            sets[2].addChildComp(0L);
            sets[2].addChildComp(3L);
            sets[3].addChildComp(1L);
            sets[3].addChildComp(4L);
            sets[4].addChildComp(2L);
            sets[4].addChildComp(0L);
            OiigAvailSoftware as = new OiigAvailSoftware();
            for (i = 0; i < numSets; ++i) {
                as.addSet(sets[i]);
            }
            for (i = 0; i < numComps; ++i) {
                as.addComp(comps[i]);
            }
            System.out.println(as);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

