/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiig;

import java.io.IOException;
import java.io.PrintWriter;
import oracle.sysman.oii.oiix.OiixVectorOps;
import oracle.sysman.oix.oixp.OixpIElement;
import oracle.sysman.oix.oixw.OixwIXmlWriter;
import oracle.sysman.oix.oixw.OixwXmlWriterOps;

public class OiigAuthDetails
implements OixwIXmlWriter {
    private boolean m_bAnonLogin;
    private String m_username;
    private String m_password;
    private String m_category;
    private String[] m_supCategories;
    public static final String AUTHDETS_TAG = "AuthDetails";
    private static final String LOGINTYPE_ATTR = "LoginType";
    private static final String ANON_LOGIN = "Anonymous";
    private static final String REG_LOGIN = "Registered";
    private static final String USERNAME_ATTR = "Username";
    private static final String PASSWORD_ATTR = "Password";
    private static final String CATEGORY_ATTR = "Category";
    private static final String SUPPCAT_ATTR = "SuppCats";

    public OiigAuthDetails(boolean bAnonLogin, String username, String password, String category, String[] supCategories) {
        this.m_bAnonLogin = bAnonLogin;
        this.m_username = username;
        this.m_password = password;
        this.m_category = category;
        this.m_supCategories = supCategories;
    }

    public OiigAuthDetails(OixpIElement el) {
        this(ANON_LOGIN.equalsIgnoreCase(el.getAttribValue(LOGINTYPE_ATTR)), el.getAttribValue(USERNAME_ATTR), el.getAttribValue(PASSWORD_ATTR), el.getAttribValue(CATEGORY_ATTR), OiixVectorOps.parseStringArrFromString(el.getAttribValue(SUPPCAT_ATTR), ","));
    }

    public OiigAuthDetails() {
        this(true, "anonymous", "", "internal", new String[]{"internal"});
    }

    public boolean isAnonLogin() {
        return this.m_bAnonLogin;
    }

    public void setAnonLogin(boolean bAnonLogin) {
        this.m_bAnonLogin = bAnonLogin;
    }

    public String getUsername() {
        return this.m_username;
    }

    public void setUsername(String username) {
        this.m_username = username;
    }

    public String getPassword() {
        return this.m_password;
    }

    public void setPassword(String password) {
        this.m_password = password;
    }

    public String getCategory() {
        return this.m_category;
    }

    public void setCategory(String category) {
        this.m_category = category;
    }

    public String[] getSupCategories() {
        return this.m_supCategories;
    }

    public void setSupCategories(String[] supCategories) {
        this.m_supCategories = supCategories;
    }

    public boolean checkCategory() {
        return OiixVectorOps.strArr2Vect(this.m_supCategories).contains(this.m_category);
    }

    public String toString() {
        return "[AuthDets : " + (this.m_bAnonLogin ? ANON_LOGIN : REG_LOGIN) + ", " + this.m_username + ", " + this.m_password + ", " + this.m_category + ", " + OiixVectorOps.objToString(this.m_supCategories) + "] ";
    }

    public boolean equals(OiigAuthDetails authDets) {
        return this.m_bAnonLogin == authDets.isAnonLogin() && this.m_username.equals(authDets.getUsername()) && this.m_password.equals(authDets.getPassword()) && this.m_category.equals(authDets.getCategory());
    }

    @Override
    public void writeXmlForm(PrintWriter pw) throws IOException {
        String suppCatStr = OiixVectorOps.composeStringArrayIntoString(this.m_supCategories, ",");
        pw.println("<AuthDetails LoginType=\"" + (this.m_bAnonLogin ? ANON_LOGIN : REG_LOGIN) + "\" " + USERNAME_ATTR + "=\"" + OixwXmlWriterOps.encodeSplChars(this.m_username) + "\" " + PASSWORD_ATTR + "=\"" + OixwXmlWriterOps.encodeSplChars(this.m_password) + "\" " + CATEGORY_ATTR + "=\"" + OixwXmlWriterOps.encodeSplChars(this.m_category) + "\" " + SUPPCAT_ATTR + "=\"" + OixwXmlWriterOps.encodeSplChars(suppCatStr) + "\" />");
    }
}

