/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifw;

import java.text.MessageFormat;
import oracle.sysman.oii.oiic.OiicInstallSession;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifb.OiifbWizOperation;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixOraparam;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifwValidateTopLevelSelWCCE
implements OiifbWizOperation {
    private int m_nextInd = -1;
    private OiisVariableOwner m_vo = null;
    private boolean m_bShow = true;

    public OiifwValidateTopLevelSelWCCE(OiisVariableOwner vo, int nextInd) {
        this.m_vo = vo;
        this.m_nextInd = nextInd;
    }

    @Override
    public void initialize() {
        this.m_bShow = !OiicPullSession.isSilentMode();
    }

    @Override
    public void dispose() {
        this.m_vo = null;
    }

    @Override
    public int doOperation(boolean isBack) throws OiifbEndIterateException {
        if (isBack) {
            return 1;
        }
        boolean bProper = true;
        try {
            bProper = !this.checkForDowngrade();
        }
        catch (OiifbCancelException e) {
            bProper = false;
            throw new OiifbEndIterateException(e);
        }
        return bProper ? 0 : 1;
    }

    public int getNext() {
        return this.m_nextInd;
    }

    private boolean checkForDowngrade() throws OiifbCancelException {
        boolean nRet = false;
        OiisVariable topLevel = this.m_vo.getVariable("ToplevelComp");
        OiiiCompInstallID id = (OiiiCompInstallID)topLevel.getValue();
        OiicInstallSession oSession = (OiicInstallSession)this.m_vo.getSession();
        OiiiInstallInventory installInv = oSession.getInstallAreaControl().getInstallInventory();
        boolean bIgnoreBuildNumber = OiixOraparam.canIgnoreBuildNumber();
        OiiiCompInvEntry ie = installInv.getCompatCompEntry(id, oSession.getHomeIndex(id), OiixPlatform.getCurrentPlatform(), bIgnoreBuildNumber);
        if (ie != null && !ie.getCompInstallID().equals(id, bIgnoreBuildNumber)) {
            nRet = true;
        }
        if (nRet) {
            String sTitle = OiixResourceBundle.getString("S_ERROR");
            String sMsg = OiixResourceBundle.getString("S_TOP_LEVEL_DOWNGRADE");
            Object[] s = new String[]{ie.getName()};
            sMsg = MessageFormat.format(sMsg, s);
            if (id.isOracleHomeComp()) {
                sMsg = sMsg + OiixResourceBundle.getString("S_TOP_LEVEL_DOWNGRADE_OH");
            } else if (id.isAppltopComponent()) {
                sMsg = sMsg + OiixResourceBundle.getString("S_TOP_LEVEL_DOWNGRADE_APPLTOP");
            }
            OiifmAlert.displayError(sMsg);
            if (!this.m_bShow || oSession.isSuppressedSource()) {
                throw new OiifbCancelException("", true);
            }
            OiisVariable oOracleHome = this.m_vo.getVariable("ORACLE_HOME");
            OiisVariable oOracleHomeName = this.m_vo.getVariable("ORACLE_HOME_NAME");
            oOracleHome.invalidateValue();
            oOracleHomeName.invalidateValue();
        }
        return nRet;
    }
}

