/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifw;

import java.io.File;
import java.io.IOException;
import oracle.sysman.oii.oiic.OiicExitCode;
import oracle.sysman.oii.oiic.OiicInstallSession;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifb.OiifbUserEndException;
import oracle.sysman.oii.oiif.oiifb.OiifbWizOperation;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiii.OiiiTargetAreaControl;
import oracle.sysman.oii.oiio.oiiof.OiiofFileLoaderFactory;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifwValidateShipHomeVarsWCCE
implements OiifbWizOperation {
    private boolean m_bShow = true;
    private OiisVariableOwner m_vo = null;
    private int m_nextInd = -1;
    private boolean m_bIsLangAddonMode = false;
    public static String STAGED_LOC_JAR = "products.jar";

    public OiifwValidateShipHomeVarsWCCE(OiisVariableOwner vo, int nextInd) {
        this.m_vo = vo;
        this.m_nextInd = nextInd;
    }

    @Override
    public void initialize() {
        this.m_bShow = !OiicPullSession.isSilentMode();
        this.m_bIsLangAddonMode = OiicPullSession.isLangAddonMode();
    }

    @Override
    public int doOperation(boolean isBack) throws OiifbEndIterateException {
        boolean bAllVariableValuesProper = true;
        if (isBack) {
            return 1;
        }
        if (!this.validateShipHomeVariableValues()) {
            OiisVariable oFromLoc = this.m_vo.getVariable("FROM_LOCATION");
            oFromLoc.setAdvice(false);
            if (this.m_bShow) {
                oFromLoc.invalidateValue();
            }
            if (System.getProperty("oracle.installer.exitOnVarValidationFailure", "false").equals("true")) {
                OiicExitCode.setExitCode(-2);
                OiicSessionInterfaceManager sSessionInterfaceManager = OiicSessionInterfaceManager.getInterfaceManager();
                if (sSessionInterfaceManager != null) {
                    sSessionInterfaceManager.dispose();
                }
                throw new OiifbEndIterateException(new OiifbUserEndException(""));
            }
            return 1;
        }
        OiicPullSession oSession = this.m_vo.getSession();
        if (!oSession.isCloneMode()) {
            OiisVariable oFromLoc = this.m_vo.getVariable("FROM_LOCATION");
            String sLocation = (String)oFromLoc.getValue();
            File fProductsJar = new File(sLocation);
            File fProductsDir = fProductsJar.getParentFile();
            String sStageDir = OiixPathOps.getParentDir(OiixPathOps.getStandardForm(sLocation));
            OiipgFileSystem oFS = new OiipgFileSystem();
            String sTempLoc = OiipgFileSystem.getTempLoc();
            String sTempVolume = oFS.getVolumeName(sTempLoc);
            OiicInstallSession oInstSess = null;
            try {
                if (!this.m_bIsLangAddonMode) {
                    oInstSess = (OiicInstallSession)oSession;
                }
                sStageDir = OiixPathOps.getFileCanonicalPath(sStageDir);
                boolean bNetworkMode = OiiofFileLoaderFactory.isNetworkSource("");
                long lLibsAggregate = this.getLibrariesSize(sStageDir);
                long lCompDefnAggregate = bNetworkMode ? this.getCompDefnSize(sStageDir) : 0L;
                long lAvailableSpace = oFS.getVolumeFreeSpace(sTempVolume);
                long lAggregate = lLibsAggregate / 2L + lCompDefnAggregate;
                if (!this.m_bIsLangAddonMode) {
                    oInstSess.setLibsSpaceRequired(lLibsAggregate);
                }
                if (lAvailableSpace < lAggregate) {
                    String sTempSpace = OiixPathOps.getDiskSpaceString(lAggregate - lAvailableSpace, 2);
                    Object[] args = new String[]{sTempLoc, sTempSpace};
                    String sErr = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_NO_TEMP_MIN_SPACE", args);
                    OiifmAlert.displayError(sErr);
                    return 1;
                }
            }
            catch (IOException e) {
                if (!this.m_bIsLangAddonMode && oInstSess != null) {
                    oInstSess.setLibsSpaceRequired(0L);
                }
                System.err.println(e.getMessage());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    @Override
    public void dispose() {
        this.m_vo = null;
    }

    private boolean validateShipHomeVariableValues() {
        OiisVariable oSLVar = this.m_vo.getVariable("FROM_LOCATION");
        String val = (String)oSLVar.getValue();
        String sErr = null;
        if (null == val || 0 >= val.trim().length()) {
            sErr = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ERROR_EMPTY_FROMLOC");
            OiifmAlert.displayError(sErr);
        } else if ((val = val.toLowerCase()).endsWith(STAGED_LOC_JAR)) {
            sErr = OiixResourceBundle.getString("S_ERROR_OLD_FROMLOC");
            OiifmAlert.displayError(sErr);
        }
        return null == sErr;
    }

    private long getLibrariesSize(String sStageDir) {
        long lDirsTotalSize = 0L;
        for (int i = 0; i < OiiiTargetAreaControl.LIBS_LOC.length; ++i) {
            String sLoc = OiixPathOps.concatPath(sStageDir, OiiiTargetAreaControl.LIBS_LOC[i]);
            File fNew = new File(sLoc);
            lDirsTotalSize += OiixFileOps.getTotalFileSize(fNew, true);
        }
        return lDirsTotalSize;
    }

    private long getCompDefnSize(String sStageDir) {
        return OiixFileOps.getTotalFileSize(new File(sStageDir), false);
    }

    public int getNext() {
        return this.m_nextInd;
    }
}

