/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifw;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicExitCode;
import oracle.sysman.oii.oiic.OiicInstallSession;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifb.OiifbUserEndException;
import oracle.sysman.oii.oiif.oiifb.OiifbWizOperation;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiii.OiiiOracleHomePlugin;
import oracle.sysman.oii.oiii.OiiiTargetAreaControl;
import oracle.sysman.oii.oiio.oiiof.OiiofFileLoaderFactory;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;
import oracle.sysman.oii.oiis.OiisVarSettingException;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixOraparam;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifwValidateOraHomeVarsWCCE
implements OiifbWizOperation {
    private boolean m_bShow = true;
    private OiisVariableOwner m_vo = null;
    private int m_nextInd = -1;
    private boolean m_bIsLangAddonMode = false;

    public OiifwValidateOraHomeVarsWCCE(OiisVariableOwner vo, int nextInd) {
        this.m_vo = vo;
        this.m_nextInd = nextInd;
    }

    @Override
    public void initialize() {
        this.m_bShow = !OiicPullSession.isSilentMode();
        this.m_bIsLangAddonMode = OiicPullSession.isLangAddonMode();
        this.setOracleBase();
    }

    @Override
    public int doOperation(boolean isBack) throws OiifbEndIterateException {
        boolean bAllVariableValuesProper = true;
        if (isBack) {
            return 1;
        }
        bAllVariableValuesProper = this.m_bIsLangAddonMode ? this.validateLangAddonVariableValues() : this.validateVariableValues();
        OiisVariable oOracleHome = this.m_vo.getVariable("ORACLE_HOME");
        OiisVariable oOracleHomeName = this.m_vo.getVariable("ORACLE_HOME_NAME");
        OiisVariable oOracleBaseName = this.m_vo.getVariable("ORACLE_BASE");
        if (!bAllVariableValuesProper) {
            String s = System.getProperty("oracle.installer.useORACLE_BASE");
            if (s != null && s.equalsIgnoreCase("true")) {
                oOracleBaseName.setAdvice(false);
            }
            oOracleHome.setAdvice(false);
            oOracleHomeName.setAdvice(false);
            if (this.m_bShow) {
                if (s != null && s.equalsIgnoreCase("true")) {
                    oOracleBaseName.invalidateValue();
                }
                oOracleHome.invalidateValue();
                oOracleHomeName.invalidateValue();
            }
            if (System.getProperty("oracle.installer.exitOnVarValidationFailure", "false").equals("true")) {
                OiicExitCode.setExitCode(-2);
                OiicSessionInterfaceManager sSessionInterfaceManager = OiicSessionInterfaceManager.getInterfaceManager();
                if (sSessionInterfaceManager != null) {
                    sSessionInterfaceManager.dispose();
                }
                throw new OiifbEndIterateException(new OiifbUserEndException(""));
            }
            return 1;
        }
        OiicPullSession oSession = this.m_vo.getSession();
        if (!oSession.isCloneMode()) {
            OiisVariable oFromLoc = this.m_vo.getVariable("FROM_LOCATION");
            String sLocation = (String)oFromLoc.getValue();
            String sStageDir = OiixPathOps.getParentDir(OiixPathOps.getStandardForm(sLocation));
            OiipgFileSystem oFS = new OiipgFileSystem();
            String sTempLoc = OiipgFileSystem.getTempLoc();
            String sTempVolume = oFS.getVolumeName(sTempLoc);
            OiicInstallSession oInstSess = null;
            if (!this.m_bIsLangAddonMode) {
                oInstSess = (OiicInstallSession)oSession;
            }
            try {
                sStageDir = OiixPathOps.getFileCanonicalPath(sStageDir);
                boolean bNetworkMode = OiiofFileLoaderFactory.isNetworkSource("");
                long lLibsAggregate = this.getLibrariesSize(sStageDir);
                long lCompDefnAggregate = bNetworkMode ? this.getCompDefnSize(sStageDir) : 0L;
                long lAvailableSpace = oFS.getVolumeFreeSpace(sTempVolume);
                long lAggregate = lLibsAggregate / 2L + lCompDefnAggregate;
                if (!this.m_bIsLangAddonMode) {
                    oInstSess.setLibsSpaceRequired(lLibsAggregate);
                }
                if (lAvailableSpace < lAggregate) {
                    String sTempSpace = OiixPathOps.getDiskSpaceString(lAggregate - lAvailableSpace, 2);
                    Object[] args = new String[]{sTempLoc, sTempSpace};
                    String sErr = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_NO_TEMP_MIN_SPACE", args);
                    OiifmAlert.displayError(sErr);
                    return 1;
                }
            }
            catch (IOException e) {
                if (!this.m_bIsLangAddonMode) {
                    oInstSess.setLibsSpaceRequired(0L);
                }
                System.err.println(e.getMessage());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        oSession.updateSourceConfigs();
        this.processOracleHomePlugin();
        return 0;
    }

    @Override
    public void dispose() {
        this.m_vo = null;
    }

    private boolean isValidBaseAndHome(String p_sBaseLocVar, String p_sHomeLocVar, String alertIfNotInBase, String alertIfInBase, String alertType) {
        String sWarningMsg;
        boolean bHomeInBase = true;
        boolean bGUI = !OiicPullSession.isSilentMode();
        OiisVariable oBaseLocVar = this.m_vo.getVariable(p_sBaseLocVar);
        String baseLoc = (String)oBaseLocVar.getValue();
        if (baseLoc == null) {
            baseLoc = "";
        }
        String baseLocNative = OiixPathOps.getNativeForm(baseLoc);
        String baseLocStandard = OiixPathOps.getStandardForm(baseLoc);
        if (baseLocStandard.charAt(baseLocStandard.length() - 1) != '/') {
            baseLocStandard = baseLocStandard + "/";
        }
        OiisVariable oHomeLocVar = this.m_vo.getVariable(p_sHomeLocVar);
        String homeLoc = (String)oHomeLocVar.getValue();
        String homeLocNative = OiixPathOps.getNativeForm(homeLoc);
        String homeLocStandard = OiixPathOps.getStandardForm(homeLoc);
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup(curPlatId);
        if (curPlatGroup == -3) {
            homeLocStandard = homeLocStandard.toLowerCase();
            baseLocStandard = baseLocStandard.toLowerCase();
        }
        if (homeLocStandard.charAt(homeLocStandard.length() - 1) != '/') {
            homeLocStandard = homeLocStandard + "/";
        }
        bHomeInBase = homeLocStandard.startsWith(baseLocStandard);
        Object[] sArgs = new String[]{homeLocNative, baseLocNative};
        if (bHomeInBase && alertIfInBase.equalsIgnoreCase("true")) {
            if (alertType.equalsIgnoreCase("error")) {
                String sErr = OiixResourceBundle.getString("S_ERROR_HOME_SPECIFIED_IN_BASE", sArgs);
                OiifmAlert.displayError(sErr);
                return false;
            }
            sWarningMsg = OiixResourceBundle.getString("S_WARNING_HOME_SPECIFIED_IN_BASE", sArgs);
            if (bGUI) {
                int result = OiifmAlert.displayAlert(OiixResourceBundle.getString("S_WARNING"), sWarningMsg, 30, 3, 1, 10);
                return result != 2;
            }
            sWarningMsg = OiixResourceBundle.getString("S_WARNING_HOME_SPECIFIED_IN_BASE_SILENT", sArgs);
            OiiolTextLogger.appendText(sWarningMsg, OiiolTextLogger.LOG_WARNING);
        }
        if (!bHomeInBase && alertIfNotInBase.equalsIgnoreCase("true")) {
            if (alertType.equalsIgnoreCase("error")) {
                String sErr = OiixResourceBundle.getString("S_ERROR_HOME_NOT_SPECIFIED_IN_BASE", sArgs);
                OiifmAlert.displayError(sErr);
                return false;
            }
            sWarningMsg = OiixResourceBundle.getString("S_WARNING_HOME_NOT_SPECIFIED_IN_BASE", sArgs);
            if (bGUI) {
                int result = OiifmAlert.displayAlert(OiixResourceBundle.getString("S_WARNING"), sWarningMsg, 30, 3, 1, 10);
                return result != 2;
            }
            sWarningMsg = OiixResourceBundle.getString("S_WARNING_HOME_NOT_SPECIFIED_IN_BASE_SILENT", sArgs);
            OiiolTextLogger.appendText(sWarningMsg, OiiolTextLogger.LOG_WARNING);
        }
        return true;
    }

    private boolean validateVariableValues() {
        String useOB = System.getProperty("oracle.installer.useORACLE_BASE");
        String alertIfInBase = System.getProperty("oracle.installer.alertIfOHInBase", "false");
        String alertIfNotInBase = System.getProperty("oracle.installer.alertIfOHNotInBase", "false");
        String alertType = System.getProperty("oracle.installer.alertTypeForOH", "warning");
        if (useOB != null && useOB.equalsIgnoreCase("true") && !this.validateBaseVar("ORACLE_BASE")) {
            return false;
        }
        boolean isValid = this.validateOracleHomeVariables();
        if (isValid && useOB != null && useOB.equalsIgnoreCase("true") && (alertIfInBase.equalsIgnoreCase("true") || alertIfNotInBase.equalsIgnoreCase("true"))) {
            isValid = this.isValidBaseAndHome("ORACLE_BASE", "ORACLE_HOME", alertIfNotInBase, alertIfInBase, alertType);
        }
        if (isValid && OiixOraparam.isApplTopStage()) {
            isValid = this.validateAppltopVariables();
        }
        isValid = isValid && this.validateCompositeHomeVariables();
        return isValid;
    }

    private boolean validateLangAddonVariableValues() {
        boolean isValid = this.validateOracleHomeVariables();
        if (isValid) {
            isValid = this.validateHomeExistsLangAddon();
        }
        if (isValid) {
            isValid = this.validateHomeHasTLC();
        }
        return isValid;
    }

    private boolean validateHomeExistsLangAddon() {
        String sErr = null;
        boolean bHomeExists = false;
        boolean bl = bHomeExists = this.getHomeIndex() >= 0;
        if (!bHomeExists) {
            sErr = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-25026");
            OiifmAlert.displayError(sErr, OiixResourceBundle.getString("S_ERROR"), "OUI-25026");
        }
        return bHomeExists;
    }

    private int getHomeIndex() {
        int homeIndex = -1;
        OiisVariable oHomeNameVar = this.m_vo.getVariable("ORACLE_HOME_NAME");
        OiisVariable oHomeLocVar = this.m_vo.getVariable("ORACLE_HOME");
        String sLoc = (String)oHomeLocVar.getValue();
        String sName = (String)oHomeNameVar.getValue();
        OiiiInstallAreaControl oAreaControl = (OiiiInstallAreaControl)OiiiInstallAreaControl.getInventoryAreaControl();
        OiiiInstallInventory oInventory = oAreaControl.getInstallInventory();
        if (null != oInventory) {
            Vector vHomes = oInventory.getHomes();
            int nHomeCount = vHomes.size();
            OiipgFileSystem oFileOps = new OiipgFileSystem();
            String sAbsHomeLoc = OiixPathOps.getAbsolutePath(sLoc);
            for (int i = 0; i < nHomeCount; ++i) {
                OiiiOracleHomeInfo oInfo = (OiiiOracleHomeInfo)vHomes.get(i);
                String sHomeLoc = OiixPathOps.getAbsolutePath(oInfo.getLocation());
                String sHomeName = oInfo.getName();
                boolean bLocsSame = oFileOps.areLocsSame(sHomeLoc, sAbsHomeLoc);
                boolean bSameHomeName = sHomeName.equalsIgnoreCase(sName);
                if (!bLocsSame || !bSameHomeName) continue;
                homeIndex = oInfo.getIndex();
                break;
            }
        }
        return homeIndex;
    }

    private boolean validateHomeHasTLC() {
        int iIndex;
        String sErr = null;
        boolean bTLCExists = false;
        OiiiInstallAreaControl oAreaControl = (OiiiInstallAreaControl)OiiiInstallAreaControl.getInventoryAreaControl();
        OiiiInstallInventory oInventory = oAreaControl.getInstallInventory();
        if (null != oInventory && (iIndex = this.getHomeIndex()) != -1) {
            Vector tlcList = oInventory.getTopLevelComps(iIndex);
            if (tlcList.size() > 0) {
                bTLCExists = true;
            } else {
                sErr = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-25027");
                OiifmAlert.displayError(sErr, OiixResourceBundle.getString("S_ERROR"), "OUI-25027");
                bTLCExists = false;
            }
        }
        return bTLCExists;
    }

    private boolean validateOracleHomeVariables() {
        return this.isValidHome("ORACLE_HOME_NAME", "ORACLE_HOME", 0);
    }

    private boolean validateCompositeHomeVariables() {
        return this.isValidCompositeHome("COMPOSITE_HOME_TYPE", "COMPOSITE_HOME", 4);
    }

    private boolean validateAppltopVariables() {
        return this.isValidHome("APPLTOP_NAME", "APPLTOP", 1);
    }

    private boolean isValidHome(String p_sHomeNameVar, String p_sHomeLocVar, int p_nHomeType) {
        OiisVariable oHomeNameVar = this.m_vo.getVariable(p_sHomeNameVar);
        OiisVariable oHomeLocVar = this.m_vo.getVariable(p_sHomeLocVar);
        boolean retVal = true;
        String sErr = null;
        String sLoc = (String)oHomeLocVar.getValue();
        String sName = (String)oHomeNameVar.getValue();
        if (0 >= sLoc.length()) {
            sErr = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_EMPTY_TOLOC");
        } else if (0 >= sName.length()) {
            sErr = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ERR_NO_HOME_NAME");
        } else if (!this.validateHomeName(sName)) {
            sErr = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ERR_BAD_HOME_NAME");
        }
        if (null != sErr) {
            Object[] sArgs = new String[]{OiiiOracleHomeInfo.getHomeTypeString(p_nHomeType)};
            String sErrMsg = MessageFormat.format(sErr, sArgs);
            OiifmAlert.displayError(sErrMsg);
            retVal = false;
        } else if (!this.m_bIsLangAddonMode) {
            boolean cloneForce = false;
            if (this.m_vo.getSession().isCloneMode()) {
                cloneForce = Boolean.getBoolean("oracle.installer.force");
            }
            if (!cloneForce) {
                retVal = this.isConflictingHome(sName, sLoc, p_nHomeType);
            }
            if (retVal || cloneForce) {
                try {
                    retVal = this.isValidHomeLoc(sLoc);
                }
                catch (IOException e) {
                    sErr = e.getMessage();
                    OiifmAlert.displayError(sErr);
                    retVal = false;
                }
            }
        }
        return retVal;
    }

    private boolean isValidCompositeHome(String p_sHomeNameVar, String p_sHomeLocVar, int p_nHomeType) {
        OiisVariable oHomeLocVar = this.m_vo.getVariable(p_sHomeLocVar);
        boolean retVal = true;
        String sErr = null;
        String sLoc = (String)oHomeLocVar.getValue();
        if (sLoc == null) {
            return true;
        }
        if (0 >= sLoc.length()) {
            sErr = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_EMPTY_TOLOC");
        }
        if (null != sErr) {
            Object[] sArgs = new String[]{OiiiOracleHomeInfo.getHomeTypeString(p_nHomeType)};
            String sErrMsg = MessageFormat.format(sErr, sArgs);
            OiifmAlert.displayError(sErrMsg);
            retVal = false;
        } else if (!this.m_bIsLangAddonMode) {
            try {
                retVal = this.isValidCompositeHomeLoc(sLoc);
            }
            catch (IOException e) {
                sErr = e.getMessage();
                OiifmAlert.displayError(sErr);
                retVal = false;
            }
        }
        return retVal;
    }

    private boolean isConflictingHome(String sName, String sLoc, int nHomeType) {
        OiicPullSession pullSession = this.m_vo.getSession();
        String sErr = null;
        boolean bConflict = false;
        boolean bConflictPossible = false;
        OiiiInstallAreaControl oAreaControl = (OiiiInstallAreaControl)OiiiInstallAreaControl.getInventoryAreaControl();
        OiiiInstallInventory oInventory = oAreaControl.getInstallInventory();
        Hashtable oOhLocName = pullSession.getOhLocName();
        pullSession.setNewOraclHome(false);
        boolean bNewHomeSelected = true;
        if (null != oInventory) {
            Vector vHomes = oInventory.getHomes();
            int nHomeCount = vHomes.size();
            OiipgFileSystem oFileOps = new OiipgFileSystem();
            String sNatHomeLoc = OiixPathOps.getNativeCanonicalPath(sLoc);
            Object[] vArgs = new String[4];
            if (nHomeCount == 0) {
                pullSession.setNewOraclHome(true);
            }
            for (int i = 0; i < nHomeCount; ++i) {
                String OHName;
                String[] ohInfo;
                OiiiOracleHomeInfo oInfo = (OiiiOracleHomeInfo)vHomes.get(i);
                String sNativeHomeLoc = OiixPathOps.getNativeCanonicalPath(oInfo.getLocation());
                String sHomeName = oInfo.getName();
                int nExistingHomeType = oInfo.getHomeType();
                vArgs[0] = OiiiOracleHomeInfo.getHomeTypeString(nExistingHomeType);
                boolean bSameHomeType = nExistingHomeType == nHomeType;
                boolean bLocsSame = oFileOps.areLocsSame(sNativeHomeLoc, sNatHomeLoc);
                boolean bSameHomeName = sHomeName.equalsIgnoreCase(sName);
                boolean bInstalledHomeInInv = true;
                if (oOhLocName.containsKey(sNativeHomeLoc) && (ohInfo = (String[])oOhLocName.get(sNativeHomeLoc)) != null && sHomeName.equals(OHName = ohInfo[1])) {
                    bInstalledHomeInInv = false;
                }
                if (bLocsSame && bSameHomeType && bSameHomeName) {
                    bNewHomeSelected = false;
                    break;
                }
                if (!(!bLocsSame || bSameHomeType && bSameHomeName)) {
                    bConflictPossible = true;
                    vArgs[1] = oInfo.getName();
                    vArgs[2] = sLoc;
                    if (bInstalledHomeInInv) {
                        vArgs[3] = OiiiOracleHomeInfo.getHomeTypeString(nHomeType);
                        sErr = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ERR_CONFLICTING_HOME_LOC");
                        sErr = MessageFormat.format(sErr, vArgs);
                        bConflict = true;
                        break;
                    }
                }
                if (!(!bSameHomeName || bSameHomeType && bLocsSame)) {
                    bConflictPossible = true;
                    vArgs[1] = sHomeName;
                    vArgs[2] = oInfo.getLocation();
                    if (bInstalledHomeInInv) {
                        vArgs[3] = OiiiOracleHomeInfo.getHomeTypeString(nHomeType);
                        sErr = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ERR_CONFLICTING_HOME_NAME");
                        sErr = MessageFormat.format(sErr, vArgs);
                        bConflict = true;
                        break;
                    }
                }
                if (bInstalledHomeInInv || !bNewHomeSelected) continue;
                pullSession.setNewOraclHome(true);
                oInventory.updateInventory(oInfo, sName, OiixPathOps.getNativeCanonicalPath(sLoc), nHomeType);
            }
            if (bConflict) {
                OiifmAlert.displayError(sErr);
                return false;
            }
        }
        if (!bConflictPossible && bNewHomeSelected) {
            pullSession.setNewOraclHome(true);
        }
        if (oOhLocName.containsKey(sLoc = OiixPathOps.getNativeCanonicalPath(sLoc)) && bConflictPossible) {
            String[] ohInfo = (String[])oOhLocName.get(sLoc);
            String OHLoc = ohInfo[0];
            oOhLocName.remove(sLoc);
            if (!OHLoc.equals("")) {
                OHLoc = OiixPathOps.getNativeForm(OHLoc);
                File dir = new File(OHLoc);
                String scratch = System.getProperty("oracle.installer.scratchPath");
                scratch = OiixPathOps.getStandardForm(scratch);
                String delDir = OiixPathOps.getStandardForm(OHLoc);
                if (!delDir.startsWith(scratch)) {
                    OiiolTextLogger.appendText("recDelete: " + OHLoc);
                    OiixFileOps.recdelete(dir);
                }
            }
        }
        return true;
    }

    private boolean validateHomeName(String name) {
        int length;
        int n = length = name != null ? name.length() : 0;
        if (length <= 0 || length > 128) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            char thisChar = name.charAt(i);
            if (Character.isLetterOrDigit(thisChar) || thisChar == '_') continue;
            return false;
        }
        return true;
    }

    private boolean validateBaseVar(String p_sBaseLocVar) {
        String sNatLoc;
        OiiiOracleHomeInfo oHomeInfo;
        boolean bValidLoc = true;
        String sErr = null;
        OiisVariable oBaseLocVar = this.m_vo.getVariable(p_sBaseLocVar);
        String sLoc = (String)oBaseLocVar.getValue();
        if (sLoc == null) {
            sLoc = "";
        }
        String v_sLocNative = OiixPathOps.getNativeForm(sLoc);
        Object[] sArgs = new String[10];
        sArgs[0] = v_sLocNative;
        OiisVariable oHomeLocVar = this.m_vo.getVariable("ORACLE_HOME");
        String OracleHome = (String)oHomeLocVar.getValue();
        boolean bGUI = !OiicPullSession.isSilentMode();
        OiiiInstallAreaControl oAreaControl = (OiiiInstallAreaControl)OiiiInstallAreaControl.getInventoryAreaControl();
        OiiiInstallInventory oInventory = oAreaControl.getInstallInventory();
        if (null != oInventory && (oHomeInfo = oInventory.getHomeWithLocation(OracleHome)) != null) {
            String propVal = System.getProperty("oracle.installer.ORACLE_BASEvar");
            String ob = oHomeInfo.getAdditionalOracleHomeProperty(propVal);
            if (ob != null && sLoc.length() > 0 && !ob.equalsIgnoreCase(sLoc)) {
                boolean v_bcloneMode;
                String cloneMode = System.getProperty("oracle.installer.clone", "false");
                boolean bl = v_bcloneMode = cloneMode.equals("true");
                if (!v_bcloneMode) {
                    if (!bGUI) {
                        sArgs[0] = sLoc;
                        sArgs[1] = ob;
                        sErr = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ERR_BASE_DIFF_SPECIFIED", sArgs);
                        OiifmAlert.displayError(sErr);
                        bValidLoc = false;
                        return bValidLoc;
                    }
                    try {
                        oBaseLocVar.setValue(ob);
                    }
                    catch (OiifbCancelException e) {
                        OiiolTextLogger.appendException(e);
                    }
                    catch (OiisVarSettingException e) {
                        OiiolTextLogger.appendException(e);
                    }
                    sLoc = ob;
                }
            } else if (sLoc.length() <= 0 || ob != null) {
                if (ob != null && 0 >= sLoc.length()) {
                    try {
                        oBaseLocVar.setValue(ob);
                    }
                    catch (OiifbCancelException e) {
                        OiiolTextLogger.appendException(e);
                    }
                    catch (OiisVarSettingException e) {
                        OiiolTextLogger.appendException(e);
                    }
                    sLoc = ob;
                } else if (ob == null && 0 >= sLoc.length()) {
                    sArgs[0] = "ORACLE_BASE";
                    sErr = !bGUI ? OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ERR_BASE_NONE_SPECIFIED", sArgs) : OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_EMPTY_BASE_LOC", sArgs);
                    OiifmAlert.displayError(sErr);
                    bValidLoc = false;
                    return bValidLoc;
                }
            }
        }
        if (0 >= sLoc.length()) {
            sArgs[0] = "ORACLE_BASE";
            sErr = !bGUI ? OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ERR_BASE_NONE_SPECIFIED", sArgs) : OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_EMPTY_BASE_LOC");
        }
        if (null != sErr) {
            Object[] sBase = new String[]{"ORACLE_BASE"};
            String sErrMsg = MessageFormat.format(sErr, sBase);
            OiifmAlert.displayError(sErrMsg);
            bValidLoc = false;
            return bValidLoc;
        }
        File fLoc = new File(sLoc);
        if (fLoc.exists() && fLoc.isFile()) {
            sErr = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ERR_BASE_FILENAME_SPECIFIED", sArgs);
            OiifmAlert.displayError(sErr);
            bValidLoc = false;
            return bValidLoc;
        }
        OiipgFileSystem oFileOps = new OiipgFileSystem();
        String sNatUserHomeLoc = OiixPathOps.getNativeCanonicalPath(System.getProperty("user.home"));
        if (oFileOps.areLocsSame(sNatUserHomeLoc, sNatLoc = OiixPathOps.getNativeCanonicalPath(sLoc))) {
            String warningMsg = OiixResourceBundle.getString("S_WARNING_HOME_SPECIFIED", sArgs);
            boolean isAPIMode = System.getProperty("oracle.installer.ouiApiMode", "false").equalsIgnoreCase("true");
            if (bGUI && !isAPIMode) {
                int result = OiifmAlert.displayAlert(OiixResourceBundle.getString("S_WARNING"), warningMsg, 30, 3, 1, 10);
                if (result == 2) {
                    bValidLoc = false;
                }
            } else {
                OiiolTextLogger.appendText(warningMsg);
            }
        }
        return bValidLoc;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isValidHomeLoc(String sLoc) throws IOException {
        String sMsg;
        boolean bValidLoc = true;
        File fLoc = new File(sLoc);
        if (!fLoc.exists()) return bValidLoc;
        String v_sLocNative = OiixPathOps.getNativeForm(sLoc);
        if (fLoc.isFile()) {
            Object[] sArgs = new String[]{v_sLocNative};
            throw new IOException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ERR_FILENAME_SPECIFIED", sArgs));
        }
        if (!fLoc.isDirectory()) return bValidLoc;
        String[] dirList = fLoc.list();
        if (null == dirList) return bValidLoc;
        if (0 >= dirList.length) return bValidLoc;
        OiiiInstallAreaControl oAreaControl = (OiiiInstallAreaControl)OiiiInstallAreaControl.getInventoryAreaControl();
        OiiiInstallInventory oInventory = oAreaControl.getInstallInventory();
        if (null == oInventory) return bValidLoc;
        OiiiOracleHomeInfo oHomeInfo = oInventory.getHomeWithLocation(sLoc);
        if (null == oHomeInfo) {
            Object[] sArgs = new String[]{v_sLocNative};
            if (this.isForceOrGUI()) {
                String warningMsg = OiixResourceBundle.getString("S_WARNING_NONEMPTY_HOME_SPECIFIED", sArgs);
                boolean bProceed = this.warnForcedInstall(sLoc, warningMsg);
                if (bProceed) return bValidLoc;
                return false;
            }
            String sMsg2 = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ERR_NONEMPTY_HOME_SPECIFIED", sArgs);
            throw new IOException(sMsg2);
        }
        if (!this.m_vo.getSession().isInstallMode()) return bValidLoc;
        String sOHPropLoc = OiiiInstallAreaControl.getOHPropertiesFileLoc(sLoc);
        File f = new File(sOHPropLoc);
        if (!f.exists()) {
            OiisVariable oFromLoc;
            String sSHLoc = "";
            if (this.m_vo != null && (oFromLoc = this.m_vo.getVariable("FROM_LOCATION")) != null) {
                String sLocation = (String)oFromLoc.getValue();
                String sStageDir = OiixPathOps.getParentDir(OiixPathOps.getStandardForm(sLocation));
                sSHLoc = OiixPathOps.concatPath(sStageDir, "shiphomeproperties.xml");
            }
            sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFW1001", new Object[]{sLoc, sSHLoc});
            OiiolTextLogger.appendText(sMsg);
        }
        String s_compsNewLoc = OiixPathOps.concatPath(sLoc, "inventory");
        s_compsNewLoc = OiixPathOps.concatPath(s_compsNewLoc, "ContentsXML");
        if ((s_compsNewLoc = OiixPathOps.concatPath(s_compsNewLoc, "comps.new.xml")) != null && s_compsNewLoc != "" && new File(s_compsNewLoc).exists()) {
            if (this.isForceOrGUI()) {
                String warningMsg = OiixResourceBundle.getString("S_SAVED_PATCHSET_INVENTORY_ERROR");
                int result = OiifmAlert.displayAlert(OiixResourceBundle.getString("S_WARNING"), warningMsg, 30, 3, 1, 10);
                if (result == 2) {
                    bValidLoc = false;
                }
            } else {
                sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_SAVED_PATCHSET_INVENTORY_ERROR");
                throw new IOException(sMsg);
            }
        }
        if (oHomeInfo.isCRSHome()) return bValidLoc;
        try {
            OiipgFileSystem.checkWritablePath(sLoc);
            return bValidLoc;
        }
        catch (Exception e) {
            String sMsg3 = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-35100", new String[]{sLoc});
            throw new IOException(sMsg3);
        }
    }

    private boolean isValidCompositeHomeLoc(String sLoc) throws IOException {
        boolean bValidLoc = true;
        File fLoc = new File(sLoc);
        if (fLoc.exists()) {
            String v_sLocNative = OiixPathOps.getNativeForm(sLoc);
            if (fLoc.isFile()) {
                Object[] sArgs = new String[]{v_sLocNative};
                throw new IOException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ERR_FILENAME_SPECIFIED", sArgs));
            }
            if (fLoc.isDirectory()) {
                try {
                    OiipgFileSystem.checkWritablePath(sLoc);
                }
                catch (Exception e) {
                    String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-35100", new String[]{sLoc});
                    throw new IOException(sMsg);
                }
            }
        }
        return bValidLoc;
    }

    private long getLibrariesSize(String sStageDir) {
        long lDirsTotalSize = 0L;
        for (int i = 0; i < OiiiTargetAreaControl.LIBS_LOC.length; ++i) {
            String sLoc = OiixPathOps.concatPath(sStageDir, OiiiTargetAreaControl.LIBS_LOC[i]);
            File fNew = new File(sLoc);
            lDirsTotalSize += OiixFileOps.getTotalFileSize(fNew, true);
        }
        return lDirsTotalSize;
    }

    private long getCompDefnSize(String sStageDir) {
        return OiixFileOps.getTotalFileSize(new File(sStageDir), false);
    }

    private boolean isForceOrGUI() {
        boolean bGUI = !OiicPullSession.isSilentMode();
        boolean bForce = Boolean.getBoolean("oracle.installer.force");
        return bGUI || bForce;
    }

    private boolean warnForcedInstall(String sHomeLoc, String sWarningMsg) {
        int result;
        boolean shouldProceed = true;
        boolean bGUI = !OiicPullSession.isSilentMode();
        boolean bForce = Boolean.getBoolean("oracle.installer.force");
        if (!bForce && bGUI && (result = OiifmAlert.displayAlert(OiixResourceBundle.getString("S_WARNING"), sWarningMsg, 30, 3, 1, 10)) == 2) {
            shouldProceed = false;
        }
        if (bForce) {
            OiiolTextLogger.appendText(OiixResourceBundle.getString("S_LOG_FORCE_OPTION"));
        }
        return shouldProceed;
    }

    public int getNext() {
        return this.m_nextInd;
    }

    private void processOracleHomePlugin() {
        String pluginClassName = System.getProperty("oracle.installer.processOracleHomePlugin");
        if (pluginClassName != null && pluginClassName != "") {
            try {
                Class<?> pluginClass = Class.forName(pluginClassName);
                OiiiOracleHomePlugin plugin = (OiiiOracleHomePlugin)pluginClass.newInstance();
                if (plugin != null) {
                    OiiiInstallAreaControl oAreaControl;
                    OiiiInstallInventory oInventory;
                    if (this.m_vo != null) {
                        plugin.setContext(this.m_vo);
                    }
                    if ((oInventory = (oAreaControl = (OiiiInstallAreaControl)OiiiInstallAreaControl.getInventoryAreaControl()).getInstallInventory()) != null) {
                        plugin.setInstallInventory(oInventory);
                    }
                    OiisVariable oOracleHome = this.m_vo.getVariable("ORACLE_HOME");
                    String sLoc = (String)oOracleHome.getValue();
                    plugin.doOperation(sLoc);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void setOracleBase() {
        String oBase;
        OiiiOracleHomeInfo oHomeInfo;
        OiisVariable oHomeLocVar = this.m_vo.getVariable("ORACLE_HOME");
        String OracleHome = (String)oHomeLocVar.getValue();
        OiiiInstallAreaControl oAreaControl = (OiiiInstallAreaControl)OiiiInstallAreaControl.getInventoryAreaControl();
        OiiiInstallInventory oInventory = oAreaControl.getInstallInventory();
        if (null != oInventory && (oHomeInfo = oInventory.getHomeWithLocation(OracleHome)) != null && (oBase = oHomeInfo.getAdditionalOracleHomeProperty("ORACLE_BASE")) != null && oBase != "") {
            OiisVariable oOracleBaseName = this.m_vo.getVariable("ORACLE_BASE");
            try {
                String oBaseVal = (String)oOracleBaseName.getValue();
                if (oBaseVal == null) {
                    oOracleBaseName.setValue(oBase);
                    oOracleBaseName.setValueTypeAsCloneXML();
                }
            }
            catch (Exception e) {
                OiiolTextLogger.appendException(e);
            }
        }
    }
}

