/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifw;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicExitCode;
import oracle.sysman.oii.oiic.OiicInstallSession;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifb.OiifbUserEndException;
import oracle.sysman.oii.oiif.oiifb.OiifbWizOperation;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiif.oiifw.OiifwValidateShipHomeVarsWCCE;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiii.OiiiTargetAreaControl;
import oracle.sysman.oii.oiio.oiiof.OiiofFileLoaderFactory;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixOraparam;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifwValidateHomeVarsWCCE
implements OiifbWizOperation {
    private OiisVariableOwner m_vo = null;
    private int m_nextInd = -1;
    private boolean m_bIsLangAddonMode = false;

    public OiifwValidateHomeVarsWCCE(OiisVariableOwner vo, int nextInd) {
        this.m_vo = vo;
        this.m_nextInd = nextInd;
    }

    @Override
    public void initialize() {
        this.m_bIsLangAddonMode = OiicPullSession.isLangAddonMode();
    }

    @Override
    public int doOperation(boolean isBack) throws OiifbEndIterateException {
        boolean bAllVariableValuesProper = true;
        if (isBack) {
            return 1;
        }
        boolean bl = bAllVariableValuesProper = this.m_bIsLangAddonMode ? this.validateLangAddonVariableValues() : this.validateVariableValues();
        if (!bAllVariableValuesProper) {
            OiisVariable oFromLoc = this.m_vo.getVariable("FROM_LOCATION");
            OiisVariable oOracleHome = this.m_vo.getVariable("ORACLE_HOME");
            OiisVariable oOracleHomeName = this.m_vo.getVariable("ORACLE_HOME_NAME");
            oFromLoc.setAdvice(false);
            oOracleHome.setAdvice(false);
            oOracleHomeName.setAdvice(false);
            if (!OiicPullSession.isSilentMode()) {
                oFromLoc.invalidateValue();
                oOracleHome.invalidateValue();
                oOracleHomeName.invalidateValue();
            }
            if (System.getProperty("oracle.installer.exitOnVarValidationFailure", "false").equals("true")) {
                OiicExitCode.setExitCode(-2);
                OiicSessionInterfaceManager sSessionInterfaceManager = OiicSessionInterfaceManager.getInterfaceManager();
                if (sSessionInterfaceManager != null) {
                    sSessionInterfaceManager.dispose();
                }
                throw new OiifbEndIterateException(new OiifbUserEndException(""));
            }
            return 1;
        }
        if (!this.m_vo.getSession().isCloneMode()) {
            OiisVariable oFromLoc = this.m_vo.getVariable("FROM_LOCATION");
            String sLocation = (String)oFromLoc.getValue();
            String sStageDir = OiixPathOps.getParentDir(OiixPathOps.getStandardForm(sLocation));
            OiipgFileSystem oFS = new OiipgFileSystem();
            String sTempLoc = OiipgFileSystem.getTempLoc();
            String sTempVolume = oFS.getVolumeName(sTempLoc);
            OiicInstallSession oInstSess = null;
            if (!this.m_bIsLangAddonMode) {
                oInstSess = (OiicInstallSession)this.m_vo.getSession();
            }
            try {
                sStageDir = OiixPathOps.getFileCanonicalPath(sStageDir);
                boolean bNetworkMode = OiiofFileLoaderFactory.isNetworkSource("");
                long lLibsAggregate = this.getLibrariesSize(sStageDir);
                long lCompDefnAggregate = bNetworkMode ? this.getCompDefnSize(sStageDir) : 0L;
                long lAvailableSpace = oFS.getVolumeFreeSpace(sTempVolume);
                long lAggregate = lLibsAggregate / 2L + lCompDefnAggregate;
                if (!this.m_bIsLangAddonMode) {
                    oInstSess.setLibsSpaceRequired(lLibsAggregate);
                }
                if (lAvailableSpace < lAggregate) {
                    String sTempSpace = OiixPathOps.getDiskSpaceString(lAggregate - lAvailableSpace, 2);
                    Object[] args = new String[]{sTempLoc, sTempSpace};
                    String sErr = OiixResourceBundle.getString("S_NO_TEMP_MIN_SPACE", args);
                    OiifmAlert.displayError(sErr);
                    return 1;
                }
                OiisVariable oOracleHome = this.m_vo.getVariable("ORACLE_HOME");
                String sHomeLoc = (String)oOracleHome.getValue();
                String sHomeLocVolume = oFS.getVolumeName(sHomeLoc);
                long lHomeLocAvailableSpace = oFS.getVolumeFreeSpace(sHomeLocVolume);
                Integer iMinOracleHomeSpace = new Integer(OiixOraparam.getOraparamProfileString("MIN_ORACLE_HOME_SPACE", "0"));
                if (iMinOracleHomeSpace > 0) {
                    long lMinOracleHomeSpace = (long)((double)iMinOracleHomeSpace.intValue() * 1024.0 * 1024.0);
                    if (lHomeLocAvailableSpace < lMinOracleHomeSpace) {
                        String sTempSpace = OiixPathOps.getDiskSpaceString(lMinOracleHomeSpace - lHomeLocAvailableSpace, 2);
                        Object[] args = new String[]{sHomeLoc, sTempSpace};
                        String sErr = OiixResourceBundle.getString("S_NO_OH_MIN_SPACE", args);
                        OiifmAlert.displayError(sErr);
                        return 1;
                    }
                } else if (lHomeLocAvailableSpace < lAggregate) {
                    String sTempSpace = OiixPathOps.getDiskSpaceString(lAggregate - lHomeLocAvailableSpace, 2);
                    Object[] args = new String[]{sHomeLoc, sTempSpace};
                    String sErr = OiixResourceBundle.getString("S_NO_OH_MIN_SPACE", args);
                    OiifmAlert.displayError(sErr);
                    return 1;
                }
            }
            catch (IOException e) {
                if (!this.m_bIsLangAddonMode) {
                    oInstSess.setLibsSpaceRequired(0L);
                }
                System.err.println(e.getMessage());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.m_vo.getSession().updateSourceConfigs();
        return 0;
    }

    @Override
    public void dispose() {
        this.m_vo = null;
    }

    private boolean validateVariableValues() {
        boolean isValid = this.validateOracleHomeVariables();
        if (isValid && OiixOraparam.isApplTopStage()) {
            isValid = this.validateAppltopVariables();
        }
        if (isValid) {
            isValid = this.validateSourceLocationVariable();
        }
        return isValid;
    }

    private boolean validateLangAddonVariableValues() {
        boolean isValid = this.validateOracleHomeVariables();
        if (isValid) {
            isValid = this.validateHomeExistsLangAddon();
        }
        if (isValid) {
            isValid = this.validateHomeHasTLC();
        }
        if (isValid) {
            isValid = this.validateSourceLocationVariable();
        }
        return isValid;
    }

    private boolean validateHomeExistsLangAddon() {
        String sErr = null;
        boolean bHomeExists = false;
        boolean bl = bHomeExists = this.getHomeIndex() >= 0;
        if (!bHomeExists) {
            sErr = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-25026");
            OiifmAlert.displayError(sErr);
        }
        return bHomeExists;
    }

    private int getHomeIndex() {
        int homeIndex = -1;
        OiisVariable oHomeNameVar = this.m_vo.getVariable("ORACLE_HOME_NAME");
        OiisVariable oHomeLocVar = this.m_vo.getVariable("ORACLE_HOME");
        String sLoc = (String)oHomeLocVar.getValue();
        String sName = (String)oHomeNameVar.getValue();
        OiiiInstallAreaControl oAreaControl = (OiiiInstallAreaControl)OiiiInstallAreaControl.getInventoryAreaControl();
        OiiiInstallInventory oInventory = oAreaControl.getInstallInventory();
        if (null != oInventory) {
            Vector vHomes = oInventory.getHomes();
            int nHomeCount = vHomes.size();
            OiipgFileSystem oFileOps = new OiipgFileSystem();
            String sAbsHomeLoc = OiixPathOps.getAbsolutePath(sLoc);
            for (int i = 0; i < nHomeCount; ++i) {
                OiiiOracleHomeInfo oInfo = (OiiiOracleHomeInfo)vHomes.elementAt(i);
                String sHomeLoc = OiixPathOps.getAbsolutePath(oInfo.getLocation());
                String sHomeName = oInfo.getName();
                boolean bLocsSame = oFileOps.areLocsSame(sHomeLoc, sAbsHomeLoc);
                boolean bSameHomeName = sHomeName.equalsIgnoreCase(sName);
                if (!bLocsSame || !bSameHomeName) continue;
                homeIndex = oInfo.getIndex();
                break;
            }
        }
        return homeIndex;
    }

    private boolean validateHomeHasTLC() {
        String sErr = null;
        boolean bTLCExists = false;
        OiiiInstallAreaControl oAreaControl = (OiiiInstallAreaControl)OiiiInstallAreaControl.getInventoryAreaControl();
        OiiiInstallInventory oInventory = oAreaControl.getInstallInventory();
        if (null != oInventory && this.getHomeIndex() != -1) {
            Vector tlcList = oInventory.getTopLevelComps(this.getHomeIndex());
            if (tlcList.size() > 0) {
                bTLCExists = true;
            } else {
                sErr = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-25027");
                OiifmAlert.displayError(sErr);
                bTLCExists = false;
            }
        }
        return bTLCExists;
    }

    private boolean validateSourceLocationVariable() {
        OiisVariable oSLVar = this.m_vo.getVariable("FROM_LOCATION");
        String val = (String)oSLVar.getValue();
        String sErr = null;
        if (null == val || 0 >= val.trim().length()) {
            sErr = OiixResourceBundle.getString("S_ERROR_EMPTY_FROMLOC");
            OiifmAlert.displayError(sErr);
        } else if ((val = val.toLowerCase()).endsWith(OiifwValidateShipHomeVarsWCCE.STAGED_LOC_JAR)) {
            sErr = OiixResourceBundle.getString("S_ERROR_OLD_FROMLOC");
            OiifmAlert.displayError(sErr);
        }
        return null == sErr;
    }

    private boolean validateOracleHomeVariables() {
        return this.isValidHome("ORACLE_HOME_NAME", "ORACLE_HOME", 0);
    }

    private boolean validateAppltopVariables() {
        return this.isValidHome("APPLTOP_NAME", "APPLTOP", 1);
    }

    private boolean isValidHome(String p_sHomeNameVar, String p_sHomeLocVar, int p_nHomeType) {
        OiisVariable oHomeNameVar = this.m_vo.getVariable(p_sHomeNameVar);
        OiisVariable oHomeLocVar = this.m_vo.getVariable(p_sHomeLocVar);
        boolean retVal = true;
        String sErr = null;
        String sLoc = (String)oHomeLocVar.getValue();
        String sName = (String)oHomeNameVar.getValue();
        if (0 >= sLoc.length()) {
            sErr = OiixResourceBundle.getString("S_EMPTY_TOLOC");
        } else if (0 >= sName.length()) {
            sErr = OiixResourceBundle.getString("S_ERR_NO_HOME_NAME");
        } else if (!this.validateHomeName(sName)) {
            sErr = OiixResourceBundle.getString("S_ERR_BAD_HOME_NAME");
        }
        if (null != sErr) {
            Object[] sArgs = new String[]{OiiiOracleHomeInfo.getHomeTypeString(p_nHomeType)};
            String sErrMsg = MessageFormat.format(sErr, sArgs);
            OiifmAlert.displayError(sErrMsg);
            retVal = false;
        } else if (!this.m_bIsLangAddonMode) {
            try {
                retVal = this.isValidHomeLoc(sLoc);
            }
            catch (IOException e) {
                sErr = e.getMessage();
                OiifmAlert.displayError(sErr);
                retVal = false;
            }
            if (retVal) {
                retVal = this.isConflictingHome(sName, sLoc, p_nHomeType);
            }
        }
        return retVal;
    }

    private boolean isConflictingHome(String sName, String sLoc, int nHomeType) {
        String sErr = null;
        boolean bConflict = false;
        boolean bConflictPossible = false;
        OiiiInstallAreaControl oAreaControl = (OiiiInstallAreaControl)OiiiInstallAreaControl.getInventoryAreaControl();
        OiiiInstallInventory oInventory = oAreaControl.getInstallInventory();
        OiicPullSession pullSession = this.m_vo.getSession();
        Hashtable oOhLocName = pullSession.getOhLocName();
        pullSession.setNewOraclHome(false);
        boolean bNewHomeSelected = true;
        if (null != oInventory) {
            Vector vHomes = oInventory.getHomes();
            int nHomeCount = vHomes.size();
            OiipgFileSystem oFileOps = new OiipgFileSystem();
            String sAbsHomeLoc = OiixPathOps.getAbsolutePath(sLoc);
            Object[] vArgs = new String[4];
            if (nHomeCount == 0) {
                pullSession.setNewOraclHome(true);
            }
            for (int i = 0; i < nHomeCount; ++i) {
                String OHName;
                String[] ohInfo;
                OiiiOracleHomeInfo oInfo = (OiiiOracleHomeInfo)vHomes.elementAt(i);
                String sHomeLoc = OiixPathOps.getAbsolutePath(oInfo.getLocation());
                String sHomeName = oInfo.getName();
                int nExistingHomeType = oInfo.getHomeType();
                vArgs[0] = OiiiOracleHomeInfo.getHomeTypeString(nExistingHomeType);
                boolean bSameHomeType = nExistingHomeType == nHomeType;
                boolean bLocsSame = oFileOps.areLocsSame(sHomeLoc, sAbsHomeLoc);
                boolean bSameHomeName = sHomeName.equalsIgnoreCase(sName);
                boolean bInstalledHomeInInv = true;
                if (oOhLocName.containsKey(sHomeLoc) && (ohInfo = (String[])oOhLocName.get(sHomeLoc)) != null && sHomeName.equals(OHName = ohInfo[1])) {
                    bInstalledHomeInInv = false;
                }
                if (bLocsSame && bSameHomeType && bSameHomeName) {
                    bNewHomeSelected = false;
                    break;
                }
                if (!(!bLocsSame || bSameHomeType && bSameHomeName)) {
                    bConflictPossible = true;
                    vArgs[1] = oInfo.getName();
                    vArgs[2] = sLoc;
                    if (bInstalledHomeInInv) {
                        vArgs[3] = OiiiOracleHomeInfo.getHomeTypeString(nHomeType);
                        sErr = OiixResourceBundle.getString("S_ERR_CONFLICTING_HOME_LOC");
                        sErr = MessageFormat.format(sErr, vArgs);
                        bConflict = true;
                        break;
                    }
                }
                if (!(!bSameHomeName || bSameHomeType && bLocsSame)) {
                    bConflictPossible = true;
                    vArgs[1] = sHomeName;
                    vArgs[2] = oInfo.getLocation();
                    if (bInstalledHomeInInv) {
                        vArgs[3] = OiiiOracleHomeInfo.getHomeTypeString(nHomeType);
                        sErr = OiixResourceBundle.getString("S_ERR_CONFLICTING_HOME_NAME");
                        sErr = MessageFormat.format(sErr, vArgs);
                        bConflict = true;
                        break;
                    }
                }
                if (bInstalledHomeInInv || !bNewHomeSelected) continue;
                pullSession.setNewOraclHome(true);
                oInventory.updateInventory(oInfo, sName, sLoc, nHomeType);
            }
            if (bConflict) {
                OiifmAlert.displayError(sErr);
                return false;
            }
        }
        if (!bConflictPossible && bNewHomeSelected) {
            pullSession.setNewOraclHome(true);
        }
        if (oOhLocName.containsKey(sLoc) && bConflictPossible) {
            String[] ohInfo = (String[])oOhLocName.get(sLoc);
            String OHLoc = ohInfo[0];
            oOhLocName.remove(sLoc);
            if (!OHLoc.equals("")) {
                OHLoc = OiixPathOps.getStandardForm(OHLoc);
                File dir = new File(OHLoc);
                OiixFileOps.recdelete(dir);
            }
        }
        return true;
    }

    private boolean validateHomeName(String name) {
        int length;
        int n = length = name != null ? name.length() : 0;
        if (length <= 0 || length > 128) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            char thisChar = name.charAt(i);
            if (Character.isLetterOrDigit(thisChar) || thisChar == '_') continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isValidHomeLoc(String sLoc) throws IOException {
        OiisVariable oFromLoc;
        boolean bValidLoc = true;
        File fLoc = new File(sLoc);
        if (!fLoc.exists()) return bValidLoc;
        String v_sLocNative = OiixPathOps.getNativeForm(sLoc);
        String v_sLocStandard = OiixPathOps.getStandardForm(sLoc);
        if (fLoc.isFile()) {
            Object[] sArgs = new String[]{v_sLocNative};
            throw new IOException(OiixResourceBundle.getString("S_ERR_FILENAME_SPECIFIED", sArgs));
        }
        if (!fLoc.isDirectory()) return bValidLoc;
        String[] dirList = fLoc.list();
        if (null == dirList) return bValidLoc;
        if (0 >= dirList.length) return bValidLoc;
        OiiiInstallAreaControl oAreaControl = (OiiiInstallAreaControl)OiiiInstallAreaControl.getInventoryAreaControl();
        OiiiInstallInventory oInventory = oAreaControl.getInstallInventory();
        if (null == oInventory) return bValidLoc;
        OiiiOracleHomeInfo oHomeInfo = oInventory.getHomeWithLocation(sLoc);
        if (null == oHomeInfo) {
            String sInvLocation = OiixPathOps.concatPath(v_sLocStandard, "inventory");
            File fInvLocation = new File(OiixPathOps.getNativeForm(sInvLocation));
            if (fInvLocation.exists() && fInvLocation.isDirectory()) {
                Object[] sArgs = new String[]{v_sLocNative};
                if (!this.allowNonEmptyDestination()) throw new IOException(OiixResourceBundle.getString("S_ERR_NONEMPTY_HOME_SPECIFIED", sArgs));
                String warningMsg = OiixResourceBundle.getString("S_WARNING_NONEMPTY_HOME_SPECIFIED", sArgs);
                boolean bProceed = this.warnForcedInstall(sLoc, warningMsg);
                if (bProceed) return bValidLoc;
                return false;
            }
            Object[] sArgs = new String[]{v_sLocNative};
            if (!this.allowNonEmptyDestination()) throw new IOException(OiixResourceBundle.getString("S_ERR_NONEMPTY_HOME_SPECIFIED", sArgs));
            String warningMsg = OiixResourceBundle.getString("S_WARNING_NONEMPTY_HOME_SPECIFIED", sArgs);
            boolean bProceed = this.warnForcedInstall(sLoc, warningMsg);
            if (bProceed) return bValidLoc;
            return false;
        }
        if (!this.m_vo.getSession().isInstallMode()) return bValidLoc;
        String sOHPropLoc = OiiiInstallAreaControl.getOHPropertiesFileLoc(sLoc);
        File f = new File(sOHPropLoc);
        if (f.exists()) return bValidLoc;
        String sSHLoc = "";
        if (this.m_vo != null && (oFromLoc = this.m_vo.getVariable("FROM_LOCATION")) != null) {
            String sLocation = (String)oFromLoc.getValue();
            String sStageDir = OiixPathOps.getParentDir(OiixPathOps.getStandardForm(sLocation));
            sSHLoc = OiixPathOps.concatPath(sStageDir, "shiphomeproperties.xml");
        }
        String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFW1001", new Object[]{sLoc, sSHLoc});
        OiiolTextLogger.appendText(sMsg);
        return bValidLoc;
    }

    private long getLibrariesSize(String sStageDir) {
        long lDirsTotalSize = 0L;
        for (int i = 0; i < OiiiTargetAreaControl.LIBS_LOC.length; ++i) {
            String sLoc = OiixPathOps.concatPath(sStageDir, OiiiTargetAreaControl.LIBS_LOC[i]);
            File fNew = new File(sLoc);
            lDirsTotalSize += OiixFileOps.getTotalFileSize(fNew, true);
        }
        return lDirsTotalSize;
    }

    private long getCompDefnSize(String sStageDir) {
        return OiixFileOps.getTotalFileSize(new File(sStageDir), false);
    }

    private boolean allowNonEmptyDestination() {
        boolean bGUI = !OiicPullSession.isSilentMode();
        boolean bForce = Boolean.getBoolean("oracle.installer.force");
        return bGUI || bForce;
    }

    private boolean warnForcedInstall(String sHomeLoc, String sWarningMsg) {
        int result;
        boolean shouldProceed = true;
        boolean bGUI = !OiicPullSession.isSilentMode();
        boolean bForce = Boolean.getBoolean("oracle.installer.force");
        if (!bForce && bGUI && (result = OiifmAlert.displayAlert(OiixResourceBundle.getString("S_WARNING"), sWarningMsg, 30, 3, 1, 10)) == 2) {
            shouldProceed = false;
        }
        if (bForce) {
            OiiolTextLogger.appendText(OiixResourceBundle.getString("S_LOG_FORCE_OPTION"));
        }
        return shouldProceed;
    }

    public int getNext() {
        return this.m_nextInd;
    }
}

