/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifw;

import java.text.MessageFormat;
import java.util.List;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicInstallSession;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifb.OiifbWizOperation;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiio.oiiod.OiiodDepEngine;
import oracle.sysman.oii.oiio.oiiod.OiiodVolumeInfo;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixDebug;
import oracle.sysman.oii.oiix.OiixInstallUtil;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifwValidateDiskSpaceWCCE
implements OiifbWizOperation {
    private boolean m_bShow = true;
    private OiisVariableOwner m_vo;
    private String m_FullVolName;

    public OiifwValidateDiskSpaceWCCE(OiisVariableOwner vo) {
        this.m_vo = vo;
    }

    @Override
    public void initialize() {
        if (OiicPullSession.isSilentMode()) {
            this.m_bShow = false;
        }
    }

    public boolean isDiskFull() {
        boolean bDiskFull = false;
        OiiodDepEngine depEngine = this.m_vo.getSession().getDepEngine();
        List oVolumeInfo = depEngine.getRequiredSpace(false);
        int nSize = oVolumeInfo.size();
        for (int i = 0; i < nSize; ++i) {
            OiiodVolumeInfo oVolInfo = (OiiodVolumeInfo)oVolumeInfo.get(i);
            if (oVolInfo.getTotalRequiredSpace(true) <= oVolInfo.getAvailableSpace()) continue;
            bDiskFull = true;
            this.m_FullVolName = oVolInfo.getVolumeName();
            oVolInfo.invalidateAvailableSpace();
        }
        return bDiskFull;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int doOperation(boolean isBack) throws OiifbEndIterateException {
        if (isBack) {
            return 1;
        }
        boolean retVal = false;
        OiicInstallSession instSession = (OiicInstallSession)this.m_vo.getSession();
        if (this.isDiskFull()) {
            String sMsg;
            Object[] sArgs;
            if (!this.m_bShow || OiixInstallUtil.isSilent() && OiixInstallUtil.isAPIMode()) {
                sArgs = new String[]{this.m_FullVolName};
                sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_SUMMARY_DISK_FULL");
                sMsg = MessageFormat.format(sMsg, sArgs);
                OiiolTextLogger.writeMessageToConsole(sMsg);
                OiiolTextLogger.appendText(sMsg);
                if (!OiixInstallUtil.isOptionSet("oracle.installer.ignoreDiskWarning")) {
                    String mesg = "Installation cannot continue. To Ignore Disk Warning, please use \"-ignoreDiskWarning\" command line option.\n";
                    OiiolTextLogger.appendText(mesg);
                    throw new OiifbEndIterateException(sMsg);
                }
                String mesg = "Ignoring the Disk Warning and continuing with install as the \"-ignoreDiskWarning\" option was specified on the command line.\n";
                OiiolTextLogger.appendText(mesg);
            } else {
                sArgs = new String[]{this.m_FullVolName};
                sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_SUMMARY_DISK_FULL");
                sMsg = MessageFormat.format(sMsg, sArgs);
                int nResult = OiifmAlert.displayAlert(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CAUTION"), sMsg, 30, 3, 2, 10);
                if (nResult == 2) {
                    return 1;
                }
            }
        }
        if (OiixDebug.PRINT_DISKUSAGE) {
            OiiodDepEngine depEngine = this.m_vo.getSession().getDepEngine();
            List oVolumeInfo = depEngine.getRequiredSpace(false);
            int nSize = oVolumeInfo.size();
            Vector<String> vVolumes = new Vector<String>(nSize);
            for (int i = 0; i < nSize; ++i) {
                OiiodVolumeInfo oVolInfo = (OiiodVolumeInfo)oVolumeInfo.get(i);
                vVolumes.addElement(oVolInfo.getVolumeName());
            }
            instSession.setVolumeInfo(vVolumes);
            OiixDebug.printDiskUsageHdr(vVolumes);
        }
        if (!isBack) return 0;
        return 1;
    }

    @Override
    public void dispose() {
        OiicInstallSession instSession = (OiicInstallSession)this.m_vo.getSession();
        instSession.disposeUnusedCompInstalls();
        this.m_vo = null;
    }
}

