/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifw;

import java.io.IOException;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifb.OiifbWizOperation;
import oracle.sysman.oii.oiif.oiifr.OiifrProgressActionListener;
import oracle.sysman.oii.oiif.oiifw.OiifwActionsPhaseWCDE;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiLibraryID;
import oracle.sysman.oii.oiii.OiiiStageCompInvEntry;
import oracle.sysman.oii.oiii.OiiiStageInventory;
import oracle.sysman.oii.oiis.OiisCompProperties;
import oracle.sysman.oii.oiis.OiisLibDeps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifwUpdateLibrariesWCCE
implements OiifbWizOperation {
    private OiicPullSession m_session;
    private OiifrProgressActionListener m_progressListener;
    private OiifwActionsPhaseWCDE m_actionsPhase;
    private OiicSessionInterfaceManager m_interfaceManager;

    public OiifwUpdateLibrariesWCCE(OiifwActionsPhaseWCDE actionsPhase) {
        this.m_actionsPhase = actionsPhase;
        this.m_session = (OiicPullSession)actionsPhase.getInstallSession();
        this.m_interfaceManager = OiicSessionInterfaceManager.getInterfaceManager();
    }

    @Override
    public void initialize() throws OiifbEndIterateException {
        this.m_progressListener = (OiifrProgressActionListener)this.m_interfaceManager.getProgressListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int doOperation(boolean isBack) throws OiifbEndIterateException {
        Object object = this.m_actionsPhase.getSynchObject();
        synchronized (object) {
            try {
                this.updateLibraries();
                this.m_session.clearLibLoaders(2);
            }
            catch (IOException iOException) {
            }
            catch (OiifbCancelException ie) {
                throw new OiifbEndIterateException(ie.getMessage());
            }
        }
        if (this.m_progressListener != null) {
            this.m_progressListener.setStatus("");
        }
        return 0;
    }

    private void updateLibraries() throws IOException, OiifbCancelException {
        OiiiStageInventory oStageInv = this.m_session.getSourceAccess().getStageInventory();
        this.m_progressListener.setStatus(OiixResourceBundle.getString("S_PROG_LIB_UPDATE"));
        Vector comps = oStageInv.getAllCompsVect(0, OiixPlatform.getCurrentPlatform());
        for (int i = 0; i < comps.size(); ++i) {
            OiiiStageCompInvEntry invEntry = (OiiiStageCompInvEntry)comps.elementAt(i);
            OiiiCompInstallID cid = invEntry.getCompInstallID();
            if (cid.getCompType() == 4) continue;
            int nHomeIndex = this.m_session.getHomeIndex(cid);
            OiisCompProperties props = invEntry.getCompProperties();
            Vector[] libDeps = props.getLibDeps();
            for (int j = 0; j < libDeps.length; ++j) {
                Vector vLibs = libDeps[j];
                for (int n = 0; n < vLibs.size(); ++n) {
                    OiisLibDeps deps = (OiisLibDeps)vLibs.elementAt(n);
                    OiiiLibraryID lid = deps.getLibID();
                    this.m_session.getLibLoader(lid, j, nHomeIndex);
                }
            }
        }
    }

    @Override
    public void dispose() {
        this.m_session = null;
        this.m_progressListener = null;
        this.m_interfaceManager = null;
        this.m_actionsPhase = null;
    }
}

