/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifw;

import java.util.Vector;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicStageSession;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbWizChainDlgElem;
import oracle.sysman.oii.oiif.oiifp.OiifpStgWizLocPanel;
import oracle.sysman.oii.oiig.OiigAuthCategory;
import oracle.sysman.oii.oiig.OiigAuthDetails;
import oracle.sysman.oii.oiig.OiigPubClient;
import oracle.sysman.oii.oiig.OiigServerConfig;
import oracle.sysman.oii.oiig.OiigSourceConfigs;
import oracle.sysman.oii.oiis.OiisDlgInOutElem;
import oracle.sysman.oii.oiis.OiisVarSettingException;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiifwStgLocWCDE
extends OiifbWizChainDlgElem {
    OiisVariableOwner m_vo;
    private boolean m_bNeedLogin = false;
    private int m_loginInd;
    private int m_accSetupInd;

    public OiifwStgLocWCDE(OiisVariableOwner vo, int loginInd, int accSetupInd) {
        super(vo);
        this.m_vo = vo;
        this.m_dlgInOutElems.addElement(new OiisDlgInOutElem("FromLocation", "FROM_LOCATION"));
        this.m_dlgInOutElems.addElement(new OiisDlgInOutElem("ToLocation", "STAGE_TO_LOCATION"));
        this.setHelpKey("OiifwStgLocWCDE");
        this.m_loginInd = loginInd;
        this.m_accSetupInd = accSetupInd;
    }

    @Override
    public void setWizPanel() {
        this.m_wizPanel = new OiifpStgWizLocPanel(this.m_vo);
        ((OiifpStgWizLocPanel)this.m_wizPanel).setWizDialog(((OiicStageSession)this.m_vo.getSession()).getWizardDialog());
    }

    @Override
    protected void setDialogProperties() {
        super.setDialogProperties();
    }

    @Override
    protected void doUnsetOperations() {
        super.doUnsetOperations();
        this.m_vo.getSession().onBackIntoLocations();
    }

    @Override
    public int getNext() {
        return this.m_bNeedLogin ? this.m_loginInd : this.m_accSetupInd;
    }

    @Override
    public boolean onNext() throws OiifbCancelException {
        if (super.onNext()) {
            this.checkNeedForPublisherLogin();
            return true;
        }
        return false;
    }

    private void checkNeedForPublisherLogin() {
        OiisVariable oVar = this.m_vo.getVariable("FROM_LOCATION");
        String sourceLoc = (String)oVar.getValue();
        OiicPullSession pullSession = this.m_vo.getSession();
        this.m_bNeedLogin = false;
        Vector authCats = OiigPubClient.getPubURLAuthCats(sourceLoc);
        if (!authCats.isEmpty()) {
            boolean newConfig = false;
            boolean validConfig = false;
            boolean respValsValid = false;
            pullSession.setPublisherSession(true);
            pullSession.setCurAuthCategories(authCats);
            this.m_bNeedLogin = true;
            OiigSourceConfigs srcCfgs = pullSession.getSourceConfigs();
            OiigServerConfig curSvrConfig = srcCfgs.getSvrConfig(sourceLoc);
            OiigAuthDetails authDets = null;
            if (curSvrConfig == null) {
                curSvrConfig = new OiigServerConfig(sourceLoc, sourceLoc);
                authDets = new OiigAuthDetails();
                curSvrConfig.setAuthDets(authDets);
                newConfig = true;
            } else {
                authDets = curSvrConfig.getAuthDets();
            }
            pullSession.setCurServerConfig(curSvrConfig);
            int numAuthCats = authCats.size();
            String[] authCatNames = new String[numAuthCats];
            for (int i = 0; i < numAuthCats; ++i) {
                authCatNames[i] = ((OiigAuthCategory)authCats.elementAt(i)).getName();
            }
            authDets.setSupCategories(authCatNames);
            if (!newConfig) {
                validConfig = authDets.checkCategory();
            }
            OiisVariable loginTypeVar = this.m_vo.getVariable("ANONYMOUS_LOGIN");
            OiisVariable loginNameVar = this.m_vo.getVariable("LOGIN_NAME");
            OiisVariable loginPwdVar = this.m_vo.getVariable("PASSWORD");
            OiisVariable loginCatVar = this.m_vo.getVariable("LOGIN_CATEGORY");
            if (loginTypeVar.getValue() != null && loginCatVar.getValue() != null) {
                boolean anonLogin = (Boolean)loginTypeVar.getValue();
                String respCat = (String)loginCatVar.getValue();
                boolean bl = respValsValid = anonLogin || OiixVectorOps.strArr2Vect(authCatNames).contains(respCat);
            }
            if (!respValsValid) {
                loginTypeVar.unsetValue();
                loginNameVar.unsetValue();
                loginPwdVar.unsetValue();
                loginCatVar.unsetValue();
            }
            if (validConfig) {
                try {
                    loginTypeVar.setValue(new Boolean(authDets.isAnonLogin()));
                    loginNameVar.setValue(authDets.getUsername());
                    loginPwdVar.setValue(authDets.getPassword());
                    loginCatVar.setValue(authDets.getCategory());
                }
                catch (OiisVarSettingException vse) {
                    vse.printStackTrace();
                }
                catch (OiifbCancelException ce) {
                    ce.printStackTrace();
                }
            }
        }
    }
}

