/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifw;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicAddNodeAPISession;
import oracle.sysman.oii.oiic.OiicCloneAPISession;
import oracle.sysman.oii.oiic.OiicGlobalContext;
import oracle.sysman.oii.oiic.OiicInstallAPISession;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifb.OiifbWizChainDlgElem;
import oracle.sysman.oii.oiif.oiifb.OiifbWizOperation;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiif.oiifm.OiifmRootShInfo;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgActionsPhase;
import oracle.sysman.oii.oiip.oiipg.OiipgAddNodeInstantiate;
import oracle.sysman.oii.oiip.oiipg.OiipgBootstrap;
import oracle.sysman.oii.oiip.oiipg.OiipgBootstrapUnixRootDlg;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterInvSetup;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterOps;
import oracle.sysman.oii.oiip.oiipg.OiipgPropertyLoader;
import oracle.sysman.oii.oiip.oiipg.OiipgRemoteFileOperationException;
import oracle.sysman.oii.oiip.oiipg.OiipgRemoteOpsException;
import oracle.sysman.oii.oiis.OiisRootShVar;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixOraparam;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixUtil;

public class OiifwRootShWCDE
extends OiifbWizChainDlgElem
implements OiifbWizOperation {
    public static String INV_PTR_LOC = "orainstRoot.sh";
    public static final String NODE_LIST_DELIM = ",";
    public static final int ROOTSH_IND = 111;
    private static final String MACHINE_ROOT_UNIX = "/";
    private OiicPullSession m_oSession = null;
    private int m_id = -1;
    private OiipgActionsPhase m_actionsPhase = null;
    private boolean m_bCleanNodeExist = false;
    private boolean m_bRootShExist = false;
    private String m_sInventoryLocation = null;
    private String m_sScriptLoc = null;
    private String m_sRootShLoc = null;
    private boolean m_bCluster = false;
    private boolean m_bAddNodeExist = false;
    private String[] m_asNodeForInvSetup = null;
    List m_rootInfoList = null;
    private boolean m_bRootShBeforeConfig = false;
    private static final String[] rootText = new String[]{" #On nodes "};
    private static String s_lineSeparator = System.getProperty("line.separator");

    public OiifwRootShWCDE(String rootShLocation, OiicPullSession oSession, int id) {
        super(oSession.getContext());
        this.setWizardPageID(111);
        this.setHelpKey("OiipgBootstrapUnixRootDlg");
        this.m_oSession = oSession;
        this.m_id = id;
        this.m_actionsPhase = this.m_oSession.getPgActionsPhase();
        this.m_sRootShLoc = rootShLocation;
    }

    @Override
    public void dispose() {
        if (null != this.m_actionsPhase) {
            this.m_actionsPhase.dispose();
            this.m_actionsPhase = null;
        }
        this.m_oSession = null;
    }

    @Override
    public void initialize() throws OiifbEndIterateException {
        boolean isNoShowDlg;
        if (System.getProperty("oracle.installer.ouiApiMode", "false").equalsIgnoreCase("true")) {
            this.m_rootInfoList = this.getRootInfoList();
            if (this.getSession().isInstallMode()) {
                ((OiicInstallAPISession)this.getSession()).setRootSHInfo(this.m_rootInfoList);
            } else if (this.getSession().isCloneMode()) {
                ((OiicCloneAPISession)this.getSession()).setRootSHInfo(this.m_rootInfoList);
            } else if (this.getSession().isAddNodeMode()) {
                ((OiicAddNodeAPISession)this.getSession()).setRootSHInfo(this.m_rootInfoList);
            }
            return;
        }
        String sRspFile = (String)this.m_oSession.getSessionVarValue("NEXT_SESSION_RESPONSE");
        boolean bl = isNoShowDlg = (Boolean)this.m_oSession.getSessionVarValue("NEXT_SESSION") != false && sRspFile != null && sRspFile.length() > 0;
        if (isNoShowDlg) {
            return;
        }
        this.m_rootInfoList = this.getRootInfoList();
        int scriptListSize = this.m_rootInfoList.size();
        if (scriptListSize == 0) {
            return;
        }
        OiicSessionInterfaceManager sessionMgr = OiicSessionInterfaceManager.getInterfaceManager();
        boolean showRootDlg = OiicSessionContext.isDlgToBeShown("SHOW_ROOTSH_CONFIRMATION");
        OiifwRootShWCDE oiifwRootShWCDE = this;
        if ((oiifwRootShWCDE.m_oSession.isSilentMode() || !showRootDlg) && this.m_bRootShBeforeConfig && !OiixOraparam.alwaysRunConfig()) {
            sessionMgr.setSkipAllConfigTools(true);
            OiiolTextLogger.appendText("Config tools will not be run.", OiiolTextLogger.LOG_DETAILED);
        }
        OiifwRootShWCDE oiifwRootShWCDE2 = this;
        if (!oiifwRootShWCDE2.m_oSession.isSilentMode()) {
            if (showRootDlg) {
                sessionMgr.doWizardPageOperation(this, true);
            } else {
                this.logMessages(this.m_rootInfoList, false);
            }
        } else {
            this.logMessages(this.m_rootInfoList, showRootDlg);
        }
        this.m_sRootShLoc = "";
        String sAddNodeScript = null;
        if (this.m_oSession.isAddNodeMode()) {
            sAddNodeScript = OiipgAddNodeInstantiate.getAddNodeScript();
        }
        for (int index = 0; index < scriptListSize; ++index) {
            String scriptLoc = ((OiifmRootShInfo)this.m_rootInfoList.get(index)).getRootShLocation();
            if (scriptLoc.endsWith(INV_PTR_LOC) || sAddNodeScript != null && scriptLoc.endsWith(sAddNodeScript)) continue;
            this.m_bRootShExist = true;
            if (this.m_sRootShLoc.length() != 0) {
                this.m_sRootShLoc = this.m_sRootShLoc + NODE_LIST_DELIM;
            }
            this.m_sRootShLoc = this.m_sRootShLoc + scriptLoc;
        }
    }

    public void logMessages(List rootInfoList, boolean silent) {
        boolean isCluster = this.m_oSession.isClusterMode() || this.isClusterOperation();
        StringBuffer prompt = new StringBuffer();
        if (this.m_bCleanNodeExist) {
            prompt.append(this.getInventoryMessage(this.m_sScriptLoc, this.m_asNodeForInvSetup, isCluster));
        }
        prompt.append(s_lineSeparator);
        int numRows = rootInfoList.size();
        if (isCluster) {
            prompt.append(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ROOTSH_DLG_CLUSTER_MSG1"));
        } else {
            prompt.append(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ROOTSH_DLG_MSG1"));
        }
        prompt.append(s_lineSeparator);
        for (int index = 0; index < numRows; ++index) {
            String[] nodeList;
            OiifmRootShInfo oRootInfo = (OiifmRootShInfo)rootInfoList.get(index);
            prompt.append(oRootInfo.getRootShLocation());
            if (isCluster && (nodeList = oRootInfo.getNodeList()) != null && nodeList.length > 0) {
                prompt.append(rootText[0]);
                prompt.append(OiixFunctionOps.implodeList(nodeList, NODE_LIST_DELIM));
            }
            prompt.append(s_lineSeparator);
        }
        prompt.append(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ROOTSH_DLG_BOT_LINE1"));
        prompt.append("    ");
        prompt.append(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ROOTSH_DLG_BOT_LINE2"));
        prompt.append("    ");
        prompt.append(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ROOTSH_DLG_BOT_LINE3"));
        if (isCluster) {
            prompt.append("    ");
            prompt.append(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ROOTSH_DLG_CLUSTER_BOT_LINE4"));
        } else {
            prompt.append("    ");
            prompt.append(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ROOTSH_DLG_BOT_LINE4"));
        }
        prompt.append("    ");
        if (!silent) {
            prompt.append(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ROOTSH_DLG_BOT_LINE5"));
        }
        for (int i = 0; i < numRows; ++i) {
            OiifmRootShInfo oRsI = (OiifmRootShInfo)rootInfoList.get(i);
            String sMsg = oRsI.getCustomRootShMessage();
            if (null == sMsg || sMsg.length() <= 0) continue;
            prompt.append(s_lineSeparator);
            prompt.append(sMsg);
        }
        String messageToLog = prompt.toString();
        OiiolTextLogger.appendText(messageToLog, OiiolTextLogger.LOG_WARNING);
        boolean isAPIMode = System.getProperty("oracle.installer.ouiApiMode", "false").equals("true");
        if (silent || isAPIMode) {
            OiiolTextLogger.appendErrorText(messageToLog, false, OiiolTextLogger.LOG_WARNING);
            OiiolTextLogger.writeMessageToConsole(OiifmAlert.formatAlertMessageForLog(10, messageToLog));
        }
    }

    protected String createMessage() {
        String message1 = "";
        String message2 = "";
        if (this.m_bCleanNodeExist) {
            message1 = this.getInventoryMessage(this.m_sScriptLoc, this.m_asNodeForInvSetup, this.m_bCluster);
        }
        if (this.m_bRootShExist) {
            message2 = this.getRootSHMessage(this.m_sRootShLoc, this.m_bCluster);
        }
        if (message1.length() > 0 && message2.length() > 0) {
            message1 = message1 + System.getProperty("line.separator") + System.getProperty("line.separator");
        }
        message1 = message1 + message2;
        return message1;
    }

    @Override
    public int doOperation(boolean isBack) throws OiifbEndIterateException {
        if (isBack && !this.m_bRootShBeforeConfig) {
            return 1;
        }
        return 0;
    }

    public OiicPullSession getSession() {
        return this.m_oSession;
    }

    public String getInventoryMessage(String scriptName, String[] sNodeList, boolean m_bCluster) {
        String v_sKey = null;
        String message = "";
        OiicSessionContext oContext = (OiicSessionContext)this.m_oSession.getContext();
        OiifwRootShWCDE oiifwRootShWCDE = this;
        if (!oiifwRootShWCDE.m_oSession.isSilentMode()) {
            v_sKey = m_bCluster ? "S_BS_EXEC_ROOTSH_CLUSTER" : "S_BS_EXEC_ROOTSH";
        } else {
            String string = v_sKey = m_bCluster ? "S_BS_EXEC_ROOTSH_CLUSTER_SILENT" : "S_BS_EXEC_ROOTSH_SILENT";
        }
        if (v_sKey != null) {
            Object[] arg;
            if (m_bCluster) {
                String cleanNodeList = OiixFunctionOps.implodeList(sNodeList, NODE_LIST_DELIM);
                arg = new Object[]{scriptName, cleanNodeList};
            } else {
                arg = new Object[]{scriptName};
            }
            message = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", v_sKey, arg);
        }
        return message;
    }

    public String getRootSHMessage(String scriptName, boolean m_bCluster) {
        Object[] arg;
        String v_sKey = null;
        String message = "";
        OiifwRootShWCDE oiifwRootShWCDE = this;
        if (oiifwRootShWCDE.m_oSession.isSilentMode()) {
            if (this.m_oSession.isCloneMode()) {
                v_sKey = m_bCluster ? "S_ROOTSH_WARNING_AFTER_SILENT_CLUSTER" : "S_ROOTSH_WARNING_AFTER_SILENT";
            } else {
                String string = v_sKey = m_bCluster ? "S_ROOTSH_CHAININSTALL_WARNING_AFTER_SILENT_CLUSTER" : "S_ROOTSH_CHAININSTALL_WARNING_AFTER_SILENT";
            }
        }
        if (m_bCluster) {
            String[] remoteNodes;
            OiicSessionContext oContext = this.m_oSession.getSessionContext();
            String sNodeList = "";
            if (!this.m_oSession.isAddNodeMode()) {
                sNodeList = (String)oContext.getVarValue("LOCAL_NODE");
            }
            if ((remoteNodes = (String[])oContext.getVarValue("REMOTE_NODES")) != null && remoteNodes.length > 0) {
                if (sNodeList.length() > 0) {
                    sNodeList = sNodeList + NODE_LIST_DELIM;
                }
                sNodeList = sNodeList + OiixFunctionOps.implodeList(remoteNodes, NODE_LIST_DELIM);
            }
            arg = new Object[]{scriptName, sNodeList};
        } else {
            arg = new Object[]{scriptName};
        }
        message = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", v_sKey, arg);
        return message;
    }

    public OiifmRootShInfo setupInv() {
        this.m_sInventoryLocation = (String)this.m_oSession.getSessionVarValue("INVENTORY_LOCATION");
        this.m_sScriptLoc = OiixPathOps.directorify(this.m_sInventoryLocation) + INV_PTR_LOC;
        OiicSessionContext oContext = this.m_oSession.getSessionContext();
        this.m_asNodeForInvSetup = (String[])oContext.getVarValue("REMOTE_CLEAN_MACHINES");
        boolean bLocalNodeClean = this.m_oSession.isInstRootSHNeeded();
        String[] remoteNodes = (String[])oContext.getVarValue("REMOTE_NODES");
        if (bLocalNodeClean || this.m_asNodeForInvSetup != null && this.m_asNodeForInvSetup.length > 0) {
            this.m_bCleanNodeExist = true;
            if (bLocalNodeClean) {
                int nodeLength = this.m_asNodeForInvSetup.length;
                String[] sStr = new String[nodeLength + 1];
                sStr[0] = (String)oContext.getVarValue("LOCAL_NODE");
                if (remoteNodes != null && remoteNodes.length > 0 && this.m_asNodeForInvSetup != null && this.m_asNodeForInvSetup.length > 0) {
                    for (int i = 1; i <= nodeLength; ++i) {
                        sStr[i] = this.m_asNodeForInvSetup[i - 1];
                    }
                }
                this.m_asNodeForInvSetup = sStr;
            }
            OiipgBootstrap oBootStrap = new OiipgBootstrap();
            try {
                oBootStrap.writeRootScript(OiipgPropertyLoader.getUnixPtrFileLoc(), this.m_sInventoryLocation);
            }
            catch (IOException e) {
                OiiolTextLogger.appendException(e);
            }
        }
        if (remoteNodes != null && remoteNodes.length > 0) {
            this.m_bCluster = true;
            if (this.m_bCleanNodeExist && !OiixUtil.isEmpty(this.m_asNodeForInvSetup)) {
                String nodeListStr;
                try {
                    OiipgClusterOps.transferFileToNodes(this.m_asNodeForInvSetup, OiixPathOps.getNativeForm(this.m_sScriptLoc), MACHINE_ROOT_UNIX);
                }
                catch (OiipgRemoteFileOperationException e) {
                    nodeListStr = OiixFunctionOps.implodeList(this.m_asNodeForInvSetup, NODE_LIST_DELIM);
                    Object[] obj = new String[]{this.m_sScriptLoc, nodeListStr, e.getMessage()};
                    String logMsg = OiixResourceBundle.getString("S_ROOT_SCRIPT_COPY_ERROR", obj);
                    obj[2] = e.getBriefMessage();
                    String alertMsg = OiixResourceBundle.getString("S_ROOT_SCRIPT_COPY_ERROR", obj);
                    OiifmAlert.displayAlert(OiixResourceBundle.getString("S_WARNING"), alertMsg, logMsg, 30, 1, 1, 10);
                }
                catch (OiipgRemoteOpsException e) {
                    nodeListStr = OiixFunctionOps.implodeList(this.m_asNodeForInvSetup, NODE_LIST_DELIM);
                    Object[] obj = new String[]{this.m_sScriptLoc, nodeListStr, e.getMessage()};
                    String logMsg = OiixResourceBundle.getString("S_ROOT_SCRIPT_COPY_ERROR", obj);
                    obj[2] = e.getBasicMessage();
                    String alertMsg = OiixResourceBundle.getString("S_ROOT_SCRIPT_COPY_ERROR", obj);
                    OiifmAlert.displayAlert(OiixResourceBundle.getString("S_WARNING"), alertMsg, logMsg, 30, 1, 1, 10);
                }
            }
        }
        if (!this.m_bCleanNodeExist) {
            return null;
        }
        return new OiifmRootShInfo(this.m_sScriptLoc, this.m_asNodeForInvSetup);
    }

    Vector setupInvForPrevSessions() {
        OiicGlobalContext gContext = OiicGlobalContext.getGlobalContext();
        Iterator iter = gContext.getKeys();
        Vector<String> nodes = new Vector<String>();
        while (iter.hasNext()) {
            String alertMsg;
            String logMsg;
            Object[] obj;
            String nodeListStr;
            String sKey = (String)iter.next();
            String sInventoryLocation = gContext.getVariableValue(sKey, "INVENTORY_LOCATION");
            String sScriptLoc = OiixPathOps.directorify(sInventoryLocation) + INV_PTR_LOC;
            String[] asNodeForInvSetup = (String[])gContext.getVarValue(sKey, "REMOTE_CLEAN_MACHINES");
            String[] remoteNodes = (String[])gContext.getVarValue(sKey, "REMOTE_NODES");
            if (asNodeForInvSetup == null || asNodeForInvSetup.length <= 0) continue;
            OiipgBootstrap oBootStrap = new OiipgBootstrap();
            try {
                oBootStrap.writeRootScript(OiipgPropertyLoader.getUnixPtrFileLoc(), sInventoryLocation);
            }
            catch (IOException e) {
                OiiolTextLogger.appendException(e);
            }
            if (remoteNodes == null || remoteNodes.length <= 0) continue;
            try {
                OiipgClusterOps.transferFileToNodes(asNodeForInvSetup, OiixPathOps.getNativeForm(sScriptLoc), MACHINE_ROOT_UNIX);
            }
            catch (OiipgRemoteFileOperationException e) {
                nodeListStr = OiixFunctionOps.implodeList(this.m_asNodeForInvSetup, NODE_LIST_DELIM);
                obj = new String[]{this.m_sScriptLoc, nodeListStr, e.getMessage()};
                logMsg = OiixResourceBundle.getString("S_ROOT_SCRIPT_COPY_ERROR", obj);
                obj[2] = e.getBriefMessage();
                alertMsg = OiixResourceBundle.getString("S_ROOT_SCRIPT_COPY_ERROR", obj);
                OiifmAlert.displayAlert(OiixResourceBundle.getString("S_WARNING"), alertMsg, logMsg, 30, 1, 1, 10);
            }
            catch (OiipgRemoteOpsException e) {
                nodeListStr = OiixFunctionOps.implodeList(this.m_asNodeForInvSetup, NODE_LIST_DELIM);
                obj = new String[]{this.m_sScriptLoc, nodeListStr, e.getMessage()};
                logMsg = OiixResourceBundle.getString("S_ROOT_SCRIPT_COPY_ERROR", obj);
                obj[2] = e.getBasicMessage();
                alertMsg = OiixResourceBundle.getString("S_ROOT_SCRIPT_COPY_ERROR", obj);
                OiifmAlert.displayAlert(OiixResourceBundle.getString("S_WARNING"), alertMsg, logMsg, 30, 1, 1, 10);
            }
            for (int i = 0; i < asNodeForInvSetup.length; ++i) {
                String tmpnode = asNodeForInvSetup[i];
                boolean found = false;
                for (int j = 0; j < nodes.size(); ++j) {
                    if (!nodes.elementAt(j).equals(tmpnode)) continue;
                    found = true;
                }
                if (found) continue;
                nodes.add(tmpnode);
            }
        }
        return nodes;
    }

    private List getRootInfoList() {
        boolean isAPI = System.getProperty("oracle.installer.ouiApiMode", "false").equalsIgnoreCase("true");
        ArrayList<OiifmRootShInfo> oRootShList = new ArrayList<OiifmRootShInfo>();
        int index = 0;
        String varRootLoc = null;
        String varRootShStatus = null;
        Integer iRootStatus = null;
        Integer iLastRootStatus = null;
        OiifmRootShInfo oRootInfoObj = null;
        boolean found = false;
        OiifmRootShInfo oInvScript = this.setupInv();
        String[] currSessList = this.m_asNodeForInvSetup;
        int nCurrSessList = currSessList == null ? 0 : currSessList.length;
        Vector cleannodes = this.setupInvForPrevSessions();
        for (int i = 0; i < nCurrSessList; ++i) {
            String tmpnode = currSessList[i];
            boolean bPresent = false;
            for (int j = 0; j < cleannodes.size(); ++j) {
                if (!cleannodes.elementAt(j).equals(tmpnode)) continue;
                bPresent = true;
            }
            if (bPresent) continue;
            cleannodes.add(tmpnode);
        }
        int numElems = cleannodes.size();
        if (numElems > 0) {
            String[] sarr = new String[numElems];
            for (int i = 0; i < numElems; ++i) {
                sarr[i] = (String)cleannodes.elementAt(i);
            }
            if (!isAPI) {
                oRootShList.add(new OiifmRootShInfo(this.m_sScriptLoc, sarr));
            } else {
                oRootShList.add(new OiifmRootShInfo(this.m_sScriptLoc, sarr));
            }
        }
        OiicSessionContext oSession = this.m_oSession.getSessionContext();
        varRootLoc = (String)oSession.getVarValue("ROOTSH_LOCATION");
        varRootShStatus = oSession.getVariable("ROOTSH_STATUS").getValueAsString();
        iLastRootStatus = new Integer(varRootShStatus);
        OiicGlobalContext gContext = OiicGlobalContext.getGlobalContext();
        Iterator iter = gContext.getKeys();
        if (iter.hasNext()) {
            while (iter.hasNext()) {
                String sKey = (String)iter.next();
                varRootLoc = gContext.getVariableValue(sKey, "ROOTSH_LOCATION");
                varRootShStatus = gContext.getVariableValue(sKey, "ROOTSH_STATUS");
                iRootStatus = new Integer(varRootShStatus);
                if (iRootStatus != 0 && new File(varRootLoc).exists()) {
                    if (!this.m_bRootShExist) {
                        this.m_bRootShExist = true;
                    }
                    oRootInfoObj = new OiifmRootShInfo(gContext, sKey);
                    for (index = 0; index < oRootShList.size(); ++index) {
                        if (!oRootInfoObj.isEqualLocation((OiifmRootShInfo)oRootShList.get(index))) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        if (!isAPI) {
                            oRootShList.add(oRootInfoObj);
                        } else {
                            oRootShList.add(oRootInfoObj);
                        }
                    }
                }
                found = false;
            }
        }
        varRootLoc = (String)oSession.getVarValue("ROOTSH_LOCATION");
        varRootShStatus = oSession.getVariable("ROOTSH_STATUS").getValueAsString();
        iLastRootStatus = new Integer(varRootShStatus);
        if (iLastRootStatus != 0 && new File(varRootLoc).exists()) {
            if (!this.m_bRootShExist) {
                this.m_bRootShExist = true;
            }
            oRootInfoObj = new OiifmRootShInfo(oSession);
            for (index = 0; index < oRootShList.size(); ++index) {
                if (!oRootInfoObj.isEqualLocation((OiifmRootShInfo)oRootShList.get(index))) continue;
                found = true;
                break;
            }
            if (!found) {
                if (isAPI) {
                    oRootShList.add(oRootInfoObj);
                } else {
                    oRootShList.add(oRootInfoObj);
                }
            }
        }
        OiisRootShVar oRootShVar = (OiisRootShVar)oSession.getVariable("ROOTSH_STATUS");
        this.m_bRootShBeforeConfig = oRootShVar.isRootShBeforeConfig();
        return oRootShList;
    }

    public List getRootInfoObjectsList() {
        return this.m_rootInfoList;
    }

    public void validateInvPtrGeneration() {
        boolean bLocalNodeClean;
        OiifwRootShWCDE oiifwRootShWCDE = this;
        boolean b_silentMode = oiifwRootShWCDE.m_oSession.isSilentMode();
        boolean b_cleanAll = true;
        if (this.m_bCluster && !b_silentMode) {
            b_cleanAll = OiipgClusterInvSetup.validateClusterInventorySetup(this.m_sScriptLoc, this.m_asNodeForInvSetup);
        }
        if (((bLocalNodeClean = this.m_oSession.isInstRootSHNeeded()) && !OiipgBootstrapUnixRootDlg.validateInput() || !b_cleanAll) && !b_silentMode) {
            if (!b_cleanAll) {
                if (new OiipgClusterInvSetup().needInvSetup(this.m_asNodeForInvSetup)) {
                    this.m_asNodeForInvSetup = new OiipgClusterInvSetup().getNodesForInvSetup();
                }
            } else {
                this.m_asNodeForInvSetup = null;
            }
            this.displayError();
        }
        if (!b_silentMode && !this.m_oSession.isCloneMode()) {
            this.m_oSession.setInstRootSHNeeded(false);
        }
        if (OiicPullSession.isSilentMode() && this.m_bRootShBeforeConfig && !OiixOraparam.alwaysRunConfig()) {
            OiicSessionInterfaceManager sim = OiicSessionInterfaceManager.getInterfaceManager();
            sim.setSkipAllConfigTools(true);
        }
    }

    public void displayError() {
        Object[] arr1 = new String[]{this.m_sScriptLoc};
        String prompt = OiixResourceBundle.getString("S_BS_ROOTSH_ERR");
        prompt = prompt + System.getProperty("line.separator") + System.getProperty("line.separator") + OiipgBootstrap.getInstRootSHNeededMsg();
        OiifmAlert.displayError(MessageFormat.format(prompt, arr1), OiixResourceBundle.getString("S_ERROR"));
    }

    public boolean isInventoryLocationSetupRequired() {
        return this.m_bCleanNodeExist;
    }

    public boolean isClusterOperation() {
        OiicGlobalContext gContext;
        Iterator iter;
        if (!this.m_bCluster && (iter = (gContext = OiicGlobalContext.getGlobalContext()).getKeys()).hasNext()) {
            while (iter.hasNext()) {
                String sKey = (String)iter.next();
                String ClusterValue = gContext.getVariableValue(sKey, "CLUSTER_NODES");
                if (ClusterValue == null || ClusterValue.length() <= 0) continue;
                return true;
            }
        }
        return this.m_bCluster;
    }

    public boolean isExecuteRootSh() {
        return this.m_bRootShExist;
    }

    public boolean isExecuteAddNodeRootSh() {
        return this.m_bAddNodeExist;
    }
}

