/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifw;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import oracle.sysman.oii.oiic.OiicDeinstallSession;
import oracle.sysman.oii.oiic.OiicDelSession;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicRemoveHome;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiic.OiicSessionPlan;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifb.OiifbWizOperation;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgCFSDriveCheck;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterOps;
import oracle.sysman.oii.oiip.oiipg.OiipgRemoteFileOperationException;
import oracle.sysman.oii.oiip.oiipg.OiipgRemoteOpsException;
import oracle.sysman.oii.oiis.OiisVarSettingException;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiifwRemoveHomesWCCE
implements OiifbWizOperation {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 1024;
    private String[] m_clusterList = null;
    private List m_vRemovedHomes = null;
    private int m_nextInd;
    private OiicDelSession m_session;
    private OiicSessionInterfaceManager m_interfaceManager = OiicSessionInterfaceManager.getInterfaceManager();

    public OiifwRemoveHomesWCCE(OiicDelSession oSession, int nextInd) {
        this.m_nextInd = nextInd;
        this.m_session = oSession;
    }

    @Override
    public void initialize() throws OiifbEndIterateException {
    }

    @Override
    public int doOperation(boolean isBack) throws OiifbEndIterateException {
        OiicSessionPlan oSessionPlan = this.m_session.getSessionPlan();
        List removeHomes = oSessionPlan.getHomesToRemove();
        if (removeHomes != null && removeHomes.size() > 0) {
            this.clusterRemoveHomes(removeHomes);
            this.removeHomes(removeHomes);
            OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
            try {
                iac.saveInstallInventory();
            }
            catch (IOException ioe) {
                throw new OiifbEndIterateException(ioe.getMessage());
            }
            catch (OiifbCancelException cancelException) {
                throw new OiifbEndIterateException(cancelException.getMessage());
            }
            if (this.m_session instanceof OiicDeinstallSession) {
                this.removeHomeDirs(((OiicDeinstallSession)this.m_session).getHomesToDelete());
            }
        }
        return 0;
    }

    private boolean clusterRemoveHomes(List removeHomes) {
        String sRemoveHome = null;
        String sRemoveHomeName = null;
        boolean bRet = true;
        if (removeHomes == null) {
            return bRet;
        }
        for (int i = 0; i < removeHomes.size(); ++i) {
            OiiiOracleHomeInfo oInfo = (OiiiOracleHomeInfo)removeHomes.get(i);
            if (oInfo == null) continue;
            sRemoveHome = oInfo.getLocation();
            sRemoveHomeName = oInfo.getName();
            String[] clusterNodeList = OiixVectorOps.list2StrArr(oInfo.getNodeList());
            String[] remoteNodes = null;
            String localNode = null;
            try {
                this.m_session.getSessionContext().setVarValue("CLUSTER_NODES", clusterNodeList);
                localNode = ((OiicDeinstallSession)this.m_session).setLocalNode(oInfo);
                remoteNodes = ((OiicDeinstallSession)this.m_session).setRemoteNodes();
            }
            catch (OiifbCancelException e) {
                OiiolTextLogger.appendException(e);
            }
            catch (OiisVarSettingException e) {
                OiiolTextLogger.appendException(e);
            }
            if (remoteNodes == null || remoteNodes.length <= 0) continue;
            this.m_interfaceManager.logMessage(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLUSTER_REMOVE_HOMES"));
            if (sRemoveHome == null) continue;
            OiicRemoveHome oRemoveHome = OiicRemoveHome.getOiicRemoveHomeInstance();
            String invLoc = (String)this.m_session.getSessionContext().getVarValue("INVENTORY_LOCATION");
            String sCustomInvPtrLoc = System.getProperty("oracle.installer.invPtrLoc", "");
            if (sCustomInvPtrLoc != null && sCustomInvPtrLoc.trim().length() > 0) {
                this.setupRemoteInvPtrLoc(remoteNodes, sCustomInvPtrLoc);
            }
            boolean bSharedHome = OiipgCFSDriveCheck.getCFSDriveChecker().isDriveOnCFS(sRemoveHome);
            oRemoveHome.clsCmdRemoveHome(remoteNodes, sRemoveHome, sRemoveHomeName, localNode, invLoc, sCustomInvPtrLoc, bSharedHome);
        }
        return bRet;
    }

    private boolean removeHomes(List homes) {
        boolean bRet = true;
        if (homes == null) {
            return bRet;
        }
        OiiiInstallInventory instInv = OiiiInstallAreaControl.getInstallAreaControl().getInstallInventory();
        this.m_vRemovedHomes = new ArrayList(10);
        for (OiiiOracleHomeInfo homeInfo : homes) {
            try {
                instInv.removeHomeForce(homeInfo, true);
                this.m_vRemovedHomes.add(homeInfo);
            }
            catch (Throwable th) {
                bRet = false;
                th.printStackTrace();
                String sMsg = OiixResourceBundle.getString("S_ERR_REMOVE_HOME", new Object[]{homeInfo.getLocation(), th.getMessage()});
                OiiolTextLogger.appendText(sMsg);
                if (!OiicPullSession.isSilentMode()) continue;
                OiiolTextLogger.writeMessageToConsole(sMsg);
            }
        }
        return bRet;
    }

    private void removeHomeDirs(List homesToDelete) {
        int nHomesToDelete = homesToDelete == null ? 0 : homesToDelete.size();
        for (int i = 0; i < nHomesToDelete; ++i) {
            String path = OiixPathOps.getNativeForm((String)homesToDelete.get(i));
            File delFile = new File(path);
            OiixFileOps.cleanupdelete(delFile);
            OiiolTextLogger.appendText("Deleting the directory: " + path);
        }
    }

    @Override
    public void dispose() {
    }

    public int getNext() {
        return this.m_nextInd;
    }

    private String[] setupRemoteInvPtrLoc(String[] asNodes, String sLoc) {
        ArrayList oCleanNodes = new ArrayList();
        try {
            OiipgClusterOps.transferFileToNodes(asNodes, sLoc, new File(sLoc).getParent());
        }
        catch (OiipgRemoteOpsException e) {
            OiiolTextLogger.appendErrorText(e.getErrorMessage());
            return asNodes;
        }
        catch (OiipgRemoteFileOperationException e) {
            OiiolTextLogger.appendErrorText(e.getErrorMessage());
            return asNodes;
        }
        return OiixVectorOps.list2StrArr(oCleanNodes);
    }
}

