/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifw;

import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiif.oiifw.OiifwBaseHomeSetupWCCE;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgCFSDriveCheck;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterOps;
import oracle.sysman.oii.oiip.oiipg.OiipgOracleHomes;
import oracle.sysman.oii.oiip.oiipg.OiipgRemoteFileOperationException;
import oracle.sysman.oii.oiip.oiipg.OiipgRemoteOpsException;
import oracle.sysman.oii.oiip.osd.win32.OiipwClusterWindowsOps;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixOraparam;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;

class OiifwRemoteHomeSetupWCCE
extends OiifwBaseHomeSetupWCCE {
    OiifwRemoteHomeSetupWCCE(OiisVariableOwner oVarOwner) {
        super(oVarOwner);
    }

    private String getPermission() {
        String sUmask = OiixOraparam.getOraparamProfileString("UMASK", "007");
        int mode = Integer.parseInt("777") - Integer.parseInt(sUmask);
        String sPerm = "0" + new Integer(mode).toString();
        return sPerm;
    }

    @Override
    public int doOperation(boolean isBack) throws OiifbEndIterateException {
        int retVal = 0;
        String val = OiixOraparam.getOraparamProfileString("IGNORECLUSTER", "false");
        if (val.equalsIgnoreCase("true")) {
            return retVal;
        }
        if (!isBack) {
            OiisVariable oOracleBaseVar;
            String sOracleBaseLoc;
            String useOracleBase;
            OiipgCFSDriveCheck cfsDriveCheck;
            boolean bCluster;
            String[] asRemoteNodes;
            block21: {
                OiisVariable oRemoteNodesVar = this.m_oVarOwner.getVariable("REMOTE_NODES");
                asRemoteNodes = (String[])oRemoteNodesVar.getValue();
                bCluster = false;
                if (asRemoteNodes != null && asRemoteNodes.length > 0) {
                    bCluster = true;
                }
                if (this.is10gRegistrySetupRequired() && bCluster) {
                    String[] asRegEntries = this.getRegKeys();
                    String[] asRegValues = this.getRegKeyValues();
                    String sHomeKey = this.getHomeKey();
                    OiipgOracleHomes.setup10gStyleRegEntriesOnNodes(sHomeKey, asRegEntries, asRegValues, asRemoteNodes);
                }
                OiisVariable oHomeLocVar = this.m_oVarOwner.getVariable("ORACLE_HOME");
                String sHomeLoc = (String)oHomeLocVar.getValue();
                cfsDriveCheck = OiipgCFSDriveCheck.getCFSDriveChecker();
                if (bCluster && !cfsDriveCheck.isDriveOnCFS(sHomeLoc)) {
                    for (int i = 0; i < asRemoteNodes.length; ++i) {
                        try {
                            if (OiipgClusterOps.fileExistsOnNode(asRemoteNodes[i], sHomeLoc)) continue;
                            if (OiixPlatform.getPlatGroup(OiixPlatform.getCurrentPlatform()) == -3) {
                                OiipgClusterOps.createDirOnNode(asRemoteNodes[i], sHomeLoc);
                                continue;
                            }
                            String mode = this.getPermission();
                            OiipgClusterOps.createDirOnNodeWithPermission(asRemoteNodes[i], sHomeLoc, mode);
                            continue;
                        }
                        catch (OiipgRemoteOpsException oRoe) {
                            OiiolTextLogger.appendText(oRoe.getMessage());
                            continue;
                        }
                        catch (OiipgRemoteFileOperationException oRfe) {
                            OiiolTextLogger.appendText(oRfe.getMessage());
                        }
                    }
                    if (OiixPlatform.getPlatGroup(OiixPlatform.getCurrentPlatform()) == -3) {
                        int iSelect;
                        String sWarning;
                        String sTitle;
                        Object[] args;
                        try {
                            OiipwClusterWindowsOps.setPermissions(asRemoteNodes, sHomeLoc, Boolean.getBoolean("oracle.installer.oh_admin_acl"));
                        }
                        catch (OiipgRemoteOpsException oRoe) {
                            args = new String[]{oRoe.getErrorMessage()};
                            sTitle = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFW1200", args);
                            sWarning = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFW1201", args);
                            iSelect = OiifmAlert.displayAlert(sTitle, sWarning, 10, 5, 4, 10, false);
                            if (iSelect != 1) {
                                throw new OiifbEndIterateException((String)args[0]);
                            }
                        }
                        catch (OiipgRemoteFileOperationException oRfoe) {
                            args = new String[]{oRfoe.getErrorMessage()};
                            sTitle = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFW1200", args);
                            sWarning = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFW1201", args);
                            iSelect = OiifmAlert.displayAlert(sTitle, sWarning, 10, 5, 4, 10, false);
                            if (iSelect == 1) break block21;
                            throw new OiifbEndIterateException((String)args[0]);
                        }
                    }
                }
            }
            if ((useOracleBase = System.getProperty("oracle.installer.useORACLE_BASE")) != null && useOracleBase.equalsIgnoreCase("true") && (sOracleBaseLoc = (String)(oOracleBaseVar = this.m_oVarOwner.getVariable("ORACLE_BASE")).getValue()) != null && sOracleBaseLoc != "" && bCluster && !cfsDriveCheck.isDriveOnCFS(sOracleBaseLoc)) {
                for (int i = 0; i < asRemoteNodes.length; ++i) {
                    try {
                        if (OiipgClusterOps.fileExistsOnNode(asRemoteNodes[i], sOracleBaseLoc)) continue;
                        if (OiixPlatform.getPlatGroup(OiixPlatform.getCurrentPlatform()) == -3) {
                            OiipgClusterOps.createDirOnNode(asRemoteNodes[i], sOracleBaseLoc);
                            continue;
                        }
                        String mode = this.getPermission();
                        OiipgClusterOps.createDirOnNodeWithPermission(asRemoteNodes[i], sOracleBaseLoc, mode);
                        continue;
                    }
                    catch (OiipgRemoteOpsException oRoe) {
                        OiiolTextLogger.appendText(oRoe.getMessage());
                        continue;
                    }
                    catch (OiipgRemoteFileOperationException oRfe) {
                        OiiolTextLogger.appendText(oRfe.getMessage());
                    }
                }
            }
        }
        return retVal;
    }

    @Override
    public void dispose() {
    }
}

