/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifw;

import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifb.OiifbWizChainDlgElem;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiin.OiinNetOps;
import oracle.sysman.oii.oiis.OiisDlgInOutElem;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixOraparam;
import oracle.sysman.oii.oiix.OiixRegistrationComparator;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifwRegistrationWCDE
extends OiifbWizChainDlgElem {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 1024;
    private int m_nextInd;
    private String m_registrationKeyword;
    private OiisVariableOwner m_vo;
    private String m_sProductCode;
    private String m_sProductKey;
    public static final String s_panelClass = "oracle.sysman.oii.oiif.oiifp.OiifpRegistrationPanel";

    public OiifwRegistrationWCDE(OiisVariableOwner vo, int nextInd) {
        super(vo);
        this.m_dlgInOutElems.addElement(new OiisDlgInOutElem("RegistrationKeyword", "REGISTRATION_KEYWORD"));
        this.setHelpKey("OiifwRegistrationWCDE");
        this.setWizPanelClassName(s_panelClass);
        this.m_nextInd = nextInd;
        this.m_vo = vo;
    }

    public String getRegistrationURL() {
        return OiixOraparam.getRegistrationURL();
    }

    public String getRegistrationKeyword() {
        OiisVariable oVar = this.m_vo.getVariable("REGISTRATION_KEYWORD");
        String sRegistrationKeyword = "";
        if (oVar != null) {
            sRegistrationKeyword = (String)oVar.getValue();
        }
        return sRegistrationKeyword;
    }

    @Override
    public int doOperation(boolean isBack) throws OiifbEndIterateException {
        return super.doOperation(isBack);
    }

    @Override
    public String getDisplayName() {
        String sTitle = OiixResourceBundle.getString("S_REGISTRATION_TITLE");
        return sTitle;
    }

    @Override
    public void initialize() throws OiifbEndIterateException {
        super.initialize();
        String sRegKey = null;
        sRegKey = OiixOraparam.isRegisterBeforeUse() ? (this.m_registrationKeyword = this.getProductKey()) : "regKey";
        OiisVariable oVar = this.m_vo.getVariable("REGISTRATION_KEYWORD");
        if (sRegKey != null) {
            try {
                oVar.setValue(sRegKey, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public int getNext() {
        return this.m_nextInd;
    }

    @Override
    public boolean validate() throws OiifbCancelException, OiifbEndIterateException {
        if (OiixOraparam.isRegisterBeforeUse()) {
            boolean bRet;
            String sUserKey = "";
            OiisVariable oVar = this.m_vo.getVariable("REGISTRATION_KEYWORD");
            if (oVar != null) {
                sUserKey = (String)oVar.getValue();
            }
            if (!(bRet = this.m_registrationKeyword.equals(sUserKey))) {
                Object[] args = new String[]{OiixOraparam.getRegistrationURL()};
                String sErr = OiixResourceBundle.getString("S_REGISTRATION_ERROR", args);
                if (OiicPullSession.isSilentMode()) {
                    throw new OiifbEndIterateException(sErr);
                }
                OiifmAlert.displayError(sErr);
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean canShowWCDE() {
        return OiixOraparam.isRegisterBeforeUse() && !OiicPullSession.isSilentMode();
    }

    @Override
    public boolean isPreConditionsSet() {
        return OiixOraparam.isRegisterBeforeUse();
    }

    public String getProductCode() {
        if (this.m_sProductCode == null) {
            String sKeyWord = OiixOraparam.getRegistrationKeyword();
            String sHostName = OiinNetOps.getNetOps().getHostName();
            String sTimeStamp = System.getProperties().getProperty("oracle.installer.timestamp", "time");
            String sKey1 = sHostName + "-" + sTimeStamp + "-" + sKeyWord;
            this.m_sProductCode = sKeyWord + "_" + OiixRegistrationComparator.getKey(sKey1);
        }
        return this.m_sProductCode;
    }

    private String getProductKey() {
        if (this.m_sProductKey == null) {
            this.m_sProductKey = OiixRegistrationComparator.getKey(this.getProductCode());
        }
        return this.m_sProductKey;
    }
}

