/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifw;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiic.OiicSystemPropertyOps;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifb.OiifbWizOperation;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiil.OiilNativeException;
import oracle.sysman.oii.oiio.oiiof.OiiofFileLoader;
import oracle.sysman.oii.oiio.oiiof.OiiofFileLoaderFactory;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;
import oracle.sysman.oii.oiip.osd.unix.OiipuUnixOps;
import oracle.sysman.oii.oiis.OiisVarSettingException;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixJarClassLoader;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oip.oipc.oipcc.OipccEndPrereqSessionException;
import oracle.sysman.oip.oipc.oipcf.OipcfFixUpGenerator;
import oracle.sysman.oip.oipc.oipcl.OipclPrereqLogger;
import oracle.sysman.oip.oipc.oipcp.OipcpIPrereqChecker;
import oracle.sysman.oip.oipc.oipcp.OipcpIPrereqListener;
import oracle.sysman.oip.oipc.oipcp.OipcpIPrereqResultsSummary;
import oracle.sysman.oip.oipc.oipcp.OipcpIProgressUIListener;
import oracle.sysman.oip.oipc.oipcp.OipcpPrereqCheckerFactory;
import oracle.sysman.oip.oipc.oipcp.OipcpPrereqExecException;
import oracle.sysman.oip.oipc.oipcp.OipcpPrereqInputException;
import oracle.sysman.oip.oipc.oipcp.OipcpPrereqProgress;
import oracle.sysman.oip.oipc.oipcp.OipcpPrereqWriter;
import oracle.sysman.oip.oipc.oipcp.OipcpPrerequisiteCheck;
import oracle.sysman.oip.oipc.oipcr.OipcrRulesEngineInitException;
import oracle.sysman.oip.oipc.oipcu.OipcuPrereqProps;
import oracle.sysman.oip.oipf.oipfc.OipfcSilentModePrereqException;

public class OiifwPrereqWCDE
implements OiifbWizOperation {
    private OiicPullSession m_pullSession;
    private int m_nextInd;
    protected transient String m_helpKey;
    private OipcpIPrereqChecker m_oPrereqChecker;
    private OipcpPrereqProgress m_oPrereqProgress;
    private OipcuPrereqProps m_oPrereqProps;
    private Thread m_oPrereqThread;
    private OipcpPrereqExecException m_oPrereqException = null;
    private static final String PREREQ_PROPS_FILENAME = "prerequisite.properties";
    private static final String PREREQ_RESULTS_DIR = "results";
    private static final String S_DEFAULT_DIR_NAME = "prereq";
    private boolean m_bInitializeError = false;
    private boolean m_bExecPrereqs = true;
    private static final String S_INSTALL_MODE = "Install";
    private static final String S_LOCAL_CLUSTER_INSTALL_MODE = "LocalClusterInstall";
    private static final String S_LOCAL_ADD_NODE_MODE = "LocalAddNode";
    public OipcpIPrereqChecker oPrereqChecker = null;
    private Collection listresultFile = null;
    private OiicSessionContext sessionContext = null;
    private boolean m_remotePrereqFlag = false;
    OiisVariable oPrereqRemoteNodes = null;
    private String[] asRemoteNodes = null;
    private static final String WINDOWS_VISTA_OS_NAME = "Windows Vista";
    private static final String DLL = ".dll";

    public OiifwPrereqWCDE(OiisVariableOwner vo, int nextInd) {
        this.m_pullSession = vo.getSession();
        this.m_nextInd = nextInd;
        this.m_helpKey = "OiifwPrereqWCDE";
    }

    public int getNext() {
        return this.m_nextInd;
    }

    public OipcpIProgressUIListener getProgressUIListener() {
        return this.m_oPrereqChecker.getProgressUIListener();
    }

    public OipcpIPrereqResultsSummary getPrereqResultsSummary() {
        return this.m_oPrereqChecker.getResultsSummary();
    }

    private String getDefaultLocation(String sStageLocation) {
        String sFromLoc = OiixPathOps.getParentDir(OiixPathOps.getStandardForm(sStageLocation));
        return OiixPathOps.concatPath(sFromLoc, S_DEFAULT_DIR_NAME);
    }

    public boolean isAPIMode() {
        return System.getProperty("oracle.installer.ouiApiMode", "false").equalsIgnoreCase("true");
    }

    @Override
    public void initialize() throws OiifbEndIterateException {
        if (this.isAPIMode()) {
            OiiolTextLogger.appendText("Doing nothing for API Mode Install");
            return;
        }
        this.sessionContext = this.m_pullSession.getSessionContext();
        OiisVariable oPrereqConfigVar = this.sessionContext.getVariable("PREREQ_CONFIG_LOCATION");
        String sPrereqDir = (String)oPrereqConfigVar.getValue();
        OiisVariable oUsePrereqChecker = this.sessionContext.getVariable("USE_PREREQ_CHECKER");
        this.m_bExecPrereqs = (Boolean)oUsePrereqChecker.getValue();
        if (this.m_bExecPrereqs) {
            if (sPrereqDir == null || sPrereqDir.length() == 0 || !new File(OiixPathOps.concatPath(sPrereqDir, PREREQ_PROPS_FILENAME)).exists()) {
                this.m_bExecPrereqs = false;
                OiisVariable oStageLoc = this.sessionContext.getVariable("FROM_LOCATION");
                String sDefaultPrereqLoc = this.getDefaultLocation((String)oStageLoc.getValue());
                if (!OiipgFileSystem.equalPathStrs(sPrereqDir, sDefaultPrereqLoc)) {
                    sPrereqDir = sDefaultPrereqLoc;
                    try {
                        oPrereqConfigVar.setValue(sPrereqDir, false);
                        System.setProperty("oracle.installer.prereqConfigLoc", sPrereqDir);
                        OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFW1000", new Object[]{sPrereqDir}));
                    }
                    catch (OiifbCancelException oiifbCancelException) {
                    }
                    catch (OiisVarSettingException oiisVarSettingException) {
                        // empty catch block
                    }
                    this.m_bExecPrereqs = true;
                }
                if (!this.m_bExecPrereqs) {
                    String sNoPrereqMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-25006");
                    OiiolTextLogger.appendText(sNoPrereqMsg);
                }
            }
            if (this.m_bExecPrereqs) {
                String sNoPrereqMsg;
                this.logPageName();
                sPrereqDir = sPrereqDir.trim();
                String sPrereqPropsFile = OiixPathOps.concatPath(sPrereqDir, PREREQ_PROPS_FILENAME);
                String sScratchPath = this.getScratchPath();
                OiisVariable oOracleHome = this.sessionContext.getVariable("ORACLE_HOME");
                String sOracleHome = (String)oOracleHome.getValue();
                String sOracleHomePrereqDir = this.getOHPrereqLoc();
                OiiofFileLoader ofl = null;
                try {
                    ofl = OiiofFileLoaderFactory.createFileLoader(sPrereqDir, sScratchPath);
                    sPrereqPropsFile = this.fetchAndSaveFile(ofl, sPrereqDir, PREREQ_PROPS_FILENAME, sScratchPath, sOracleHomePrereqDir);
                    File oPrereqPropsFile = new File(sPrereqPropsFile);
                    if (!oPrereqPropsFile.exists()) {
                        this.m_bExecPrereqs = false;
                    }
                }
                catch (IOException e) {
                    sNoPrereqMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-25006");
                    OiiolTextLogger.appendText(e.getMessage());
                    OiiolTextLogger.appendText(sNoPrereqMsg);
                    this.m_bExecPrereqs = false;
                }
                catch (OiifbCancelException e) {
                    sNoPrereqMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-25006");
                    OiiolTextLogger.appendText(e.getMessage());
                    OiiolTextLogger.appendText(sNoPrereqMsg);
                    this.m_bExecPrereqs = false;
                }
                if (this.m_bExecPrereqs) {
                    String sLogLoc = this.getPrereqLogLoc();
                    String sPrereqResultsLoc = this.getPrereqResultsLoc(sLogLoc);
                    try {
                        this.m_oPrereqProps = new OipcuPrereqProps(sPrereqPropsFile, sScratchPath, sPrereqResultsLoc);
                    }
                    catch (OipccEndPrereqSessionException pe) {
                        this.m_bInitializeError = true;
                        String sNoPrereqMsg2 = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-25004");
                        OiifmAlert.displayError(sNoPrereqMsg2);
                    }
                    try {
                        this.fetchAndSavePrereqFiles(ofl, this.m_oPrereqProps, sPrereqDir, sScratchPath, sOracleHomePrereqDir);
                    }
                    catch (IOException e) {
                        OiifmAlert.displayError(e.getMessage());
                        this.m_bInitializeError = true;
                    }
                    catch (OiifbCancelException e) {
                        OiifmAlert.displayError(e.getMessage());
                        this.m_bInitializeError = true;
                    }
                    OiicSystemPropertyOps.setPrereqLoc(sScratchPath);
                    Iterator oJavaLibs = this.m_oPrereqProps.getFilesListForProperty("javalibs");
                    if (oJavaLibs != null) {
                        while (oJavaLibs.hasNext()) {
                            String sLibrary = (String)oJavaLibs.next();
                            try {
                                OiixJarClassLoader.createLoader(OiixPathOps.concatPath(sScratchPath, sLibrary), true, true);
                            }
                            catch (IOException e) {
                                OiifmAlert.displayError(e.getMessage());
                                this.m_bInitializeError = true;
                                break;
                            }
                        }
                    }
                    if (!this.m_bInitializeError) {
                        this.m_oPrereqChecker = OipcpPrereqCheckerFactory.getPrereqChecker((OipcuPrereqProps)this.m_oPrereqProps);
                        try {
                            this.m_oPrereqChecker.initialize();
                        }
                        catch (OipcrRulesEngineInitException re) {
                            this.m_bInitializeError = true;
                            String sNoPrereqMsg3 = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-25005", new Object[]{re.getMessage()});
                            OiifmAlert.displayError(sNoPrereqMsg3);
                        }
                        if (!this.m_bInitializeError) {
                            OiicSessionInterfaceManager interfaceManager = OiicSessionInterfaceManager.getInterfaceManager();
                            this.m_oPrereqProgress = interfaceManager.getPrereqProgress(this);
                            this.m_oPrereqProgress.setPrereqCheckerObj(this.m_oPrereqChecker);
                            this.m_oPrereqProgress.setGUIMode(0);
                            this.m_oPrereqChecker.addPrereqListener((OipcpIPrereqListener)this.m_oPrereqProgress);
                            OipclPrereqLogger.init();
                            OipclPrereqLogger oLogger = OipclPrereqLogger.getLogger();
                            this.m_oPrereqChecker.addPrereqListener((OipcpIPrereqListener)oLogger);
                            OipcpPrereqWriter oWriter = new OipcpPrereqWriter(this.m_oPrereqProps);
                            this.m_oPrereqChecker.addPrereqListener((OipcpIPrereqListener)oWriter);
                            this.m_oPrereqProgress.initialize(this.m_oPrereqProps);
                            boolean bFixUpEnable = Boolean.getBoolean("oracle.installer.fixUpEnable");
                            if (bFixUpEnable) {
                                OipcfFixUpGenerator oFixUpGenerator = OipcfFixUpGenerator.getFixUpGenerator();
                                this.m_oPrereqChecker.addPrereqListener((OipcpIPrereqListener)oFixUpGenerator);
                                oFixUpGenerator.registerChecker(this.m_oPrereqChecker);
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public int doOperation(boolean isBack) throws OiifbEndIterateException {
        int retVal = 1;
        if (this.isAPIMode()) {
            OiiolTextLogger.appendText("in API mode of OUI execution, we return back with NEXT to next Iterator");
            retVal = 0;
            return retVal;
        }
        OiixJarClassLoader.setEnableMultipleLoading(true);
        if (!isBack) {
            if (this.m_bExecPrereqs && !this.m_bInitializeError) {
                try {
                    String sEntryPoint = this.getEntryPoint();
                    if (sEntryPoint == null) {
                        System.err.println("No checks to execute for entry points. Please check input files");
                        throw new OipcpPrereqExecException("No checks found");
                    }
                    OiiolTextLogger.appendText("Entry point:" + sEntryPoint);
                    this.m_oPrereqThread = this.startPrereqs(sEntryPoint);
                    this.waitForSessionEnd();
                }
                catch (OipfcSilentModePrereqException e) {
                    if (!this.m_pullSession.getSessionContext().ignorePreReqCheck()) {
                        throw new OiifbEndIterateException(e.getErrorMessage());
                    }
                }
                catch (OipcpPrereqExecException pe) {
                    OiiolTextLogger.appendText(pe.getErrorMessage());
                    this.m_bInitializeError = true;
                }
            }
            retVal = this.m_oPrereqProgress != null && !this.m_bInitializeError ? this.m_oPrereqProgress.getNext() : 0;
        } else if (this.m_oPrereqProgress != null) {
            this.m_oPrereqProgress.waitForSessionEnd(isBack);
            retVal = this.m_oPrereqProgress.getNext();
        } else {
            retVal = 1;
        }
        OiixJarClassLoader.setEnableMultipleLoading(false);
        return retVal;
    }

    private String getEntryPoint() throws OipcpPrereqExecException {
        this.sessionContext = this.m_pullSession.getSessionContext();
        OiisVariable oPrereqEntryPoint = this.sessionContext.getVariable("PREREQ_ENTRY_POINT");
        String sEntryPoint = (String)oPrereqEntryPoint.getValue();
        if (sEntryPoint == null || !oPrereqEntryPoint.getAdvice()) {
            OiisVariable oTopLevelVar = this.sessionContext.getVariable("ToplevelComp");
            OiiiCompInstallID oID = (OiiiCompInstallID)oTopLevelVar.getValue();
            String sTopLevel = oID.getName();
            OiisVariable oInstTypeVar = this.sessionContext.getVariable("DEP_MODE");
            String sInstallType = (String)oInstTypeVar.getValue();
            if (OiixFunctionOps.isInstallMode().booleanValue()) {
                sEntryPoint = this.m_pullSession.isClusterMode() ? this.getModeEntryPoint(sTopLevel, sInstallType, this.m_oPrereqProps.getEntryPointSuffixList(S_LOCAL_CLUSTER_INSTALL_MODE)) : this.getModeEntryPoint(sTopLevel, sInstallType, this.m_oPrereqProps.getEntryPointSuffixList(S_INSTALL_MODE));
            } else if (OiixFunctionOps.isAddNodeMode().booleanValue()) {
                sEntryPoint = this.getModeEntryPoint(sTopLevel, sInstallType, this.m_oPrereqProps.getEntryPointSuffixList(S_LOCAL_ADD_NODE_MODE));
            }
        }
        return sEntryPoint;
    }

    private String getModeEntryPoint(String sTopLevel, String sInstallType, Iterator oSuffix) throws OipcpPrereqExecException {
        String sEntryPoint = null;
        String sPrefix = sTopLevel + "_" + sInstallType;
        sEntryPoint = this.getModeEntryPoint(sPrefix, oSuffix);
        if (sEntryPoint == null) {
            return this.getModeEntryPoint(sTopLevel, oSuffix);
        }
        return sEntryPoint;
    }

    private String getModeEntryPoint(String sPrefix, Iterator oSuffix) throws OipcpPrereqExecException {
        if (oSuffix == null) {
            return null;
        }
        while (oSuffix.hasNext()) {
            String sSuffix = (String)oSuffix.next();
            String sEntryPoint = sPrefix + sSuffix;
            try {
                if (!this.m_oPrereqChecker.entryPointExists(sEntryPoint)) continue;
                return sEntryPoint;
            }
            catch (OipcpPrereqInputException pie) {
                throw new OipcpPrereqExecException(pie.getMessage(), (Throwable)pie);
            }
        }
        return null;
    }

    public String getDisplayName() {
        String sTitle = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIX2000");
        return sTitle;
    }

    @Override
    public void dispose() {
        this.m_pullSession = null;
        if (this.m_oPrereqChecker != null) {
            this.m_oPrereqChecker.dispose();
        }
        this.m_oPrereqChecker = null;
    }

    private Thread startPrereqs(final String sEntryPoint) {
        String invLoc;
        boolean nodeNameLen = false;
        String nodeName = "";
        if (this.sessionContext.getVarValue("REMOTE_NODES") != null) {
            this.asRemoteNodes = (String[])this.sessionContext.getVarValue("REMOTE_NODES");
            this.m_oPrereqChecker.setRemoteNodes(this.asRemoteNodes);
        }
        if (System.getProperty("oracle.installer.executeRemotePrereqs") != null) {
            String boolVal;
            this.m_remotePrereqFlag = this.asRemoteNodes != null && this.asRemoteNodes.length != 0 ? (boolVal = System.getProperty("oracle.installer.executeRemotePrereqs")).equalsIgnoreCase("true") : false;
        }
        if (this.m_remotePrereqFlag) {
            OiiolTextLogger.appendText("Execute Remode Nodes Flag Set To False,Not executing install");
        }
        this.m_oPrereqChecker.setExecuteRemotePrereqs(this.m_remotePrereqFlag);
        if (this.sessionContext.getVarValue("INVENTORY_LOCATION") != null && (invLoc = (String)this.sessionContext.getVarValue("INVENTORY_LOCATION")) != null) {
            System.setProperty("oracle.installer.inventory_location", invLoc);
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    OiifwPrereqWCDE.this.m_oPrereqChecker.executePrereqs(sEntryPoint);
                    if (OiifwPrereqWCDE.this.m_remotePrereqFlag && Boolean.getBoolean("oracle.installer.clusterEnabled") && OiifwPrereqWCDE.this.asRemoteNodes != null && OiifwPrereqWCDE.this.asRemoteNodes.length != 0) {
                        OiifwPrereqWCDE.this.m_oPrereqChecker.executeRemotePrereqs(sEntryPoint);
                        if (!System.getProperty("oracle.installer.silent", "false").equalsIgnoreCase("true")) {
                            OiifwPrereqWCDE.this.m_oPrereqProgress.callPaintRemoteUI();
                        }
                        OiifwPrereqWCDE.this.LogResults(OiifwPrereqWCDE.this.m_oPrereqChecker, OiifwPrereqWCDE.this.asRemoteNodes);
                    }
                }
                catch (OipcpPrereqExecException e) {
                    OiifwPrereqWCDE.this.m_oPrereqException = e;
                }
            }
        };
        Thread prereqThread = new Thread(runnable);
        prereqThread.start();
        return prereqThread;
    }

    private void waitForSessionEnd() throws OipcpPrereqExecException, OipfcSilentModePrereqException {
        if (this.m_oPrereqThread.isAlive()) {
            try {
                this.m_oPrereqThread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (this.m_oPrereqException != null) {
            throw this.m_oPrereqException;
        }
        this.m_oPrereqProgress.waitForSessionEnd();
    }

    public String getHelpKey() {
        return this.m_helpKey;
    }

    private void logPageName() {
        Object[] arr = new String[]{this.getDisplayName()};
        String sLogMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_LOG_PAGE", arr);
        OiiolTextLogger.appendText(OiiolTextLogger.NEW_LINE + sLogMsg, OiiolTextLogger.LOG_BASIC);
    }

    private String fetchAndSaveFile(OiiofFileLoader ofl, String sSrcDir, String sSrcFile, String sTempDir, String sDestDir) throws IOException, OiifbCancelException {
        String sDestFilePath;
        File oDestFile;
        int retVal = 0;
        boolean isDLL = false;
        String sLocalFile = OiixPathOps.concatPath(sTempDir, sSrcFile);
        sLocalFile = OiixPathOps.getNativeForm(sLocalFile);
        String sSrcFilePath = OiixPathOps.concatPath(sSrcDir, sSrcFile);
        File oTempFile = new File(sLocalFile);
        try {
            if (sLocalFile.endsWith(DLL)) {
                isDLL = true;
            }
            if (!(oTempFile.exists() && (OiixFileOps.isFileInUse(sLocalFile) || isDLL) || OiipgFileSystem.equalPathStrs(sTempDir, sSrcDir))) {
                sLocalFile = ofl.getLocalCopyToDest(sSrcFile, sLocalFile);
                if (OiixPlatform.getPlatGroup(OiixPlatform.getCurrentPlatform()) == -1) {
                    try {
                        retVal = OiipuUnixOps.changePermission(sLocalFile, 504);
                    }
                    catch (OiilNativeException natEx) {
                        natEx.printStackTrace();
                    }
                }
            }
        }
        catch (OiilNativeException natEx) {
            natEx.printStackTrace();
        }
        if (sDestDir != null && !OiipgFileSystem.equalPathStrs(sDestDir, sSrcDir) && !(oDestFile = new File(sDestFilePath = OiixPathOps.concatPath(sDestDir, sSrcFile))).exists()) {
            OiixFileOps.copyFile(sLocalFile, sDestFilePath, true, true, true, "0770", null, null);
        }
        return sLocalFile;
    }

    private void fetchAndSavePrereqFiles(OiiofFileLoader ofl, OipcuPrereqProps oPrereqProps, String sSrcDir, String sTempDir, String sDestDir) throws IOException, OiifbCancelException {
        Iterator iter = oPrereqProps.getFilesList();
        while (iter.hasNext()) {
            String sSrcFile = (String)iter.next();
            this.fetchAndSaveFile(ofl, sSrcDir, sSrcFile, sTempDir, sDestDir);
        }
    }

    private String getPrereqLogLoc() {
        return OiiolTextLogger.getLogDir();
    }

    private String getPrereqResultsLoc(String sLogLoc) {
        return OiixPathOps.concatPath(sLogLoc, PREREQ_RESULTS_DIR);
    }

    private String getOHPrereqLoc() {
        int iHomeIndex = this.m_pullSession.getOHIndex();
        return this.m_pullSession.getInstallAreaControl().getPrereqsLoc(iHomeIndex);
    }

    public OiicPullSession getInstallSession() {
        return this.m_pullSession;
    }

    private String getScratchPath() {
        return System.getProperty("oracle.installer.scratchPath");
    }

    public void LogResults(OipcpIPrereqChecker oPrereqChecker, String[] nodeNames) {
        String NEW_LINE = System.getProperty("line.separator");
        String S_LINE = "-----------------------------------------------------------------------------";
        String S_ERR_MSG = "Prerequisite Execution Failed.";
        int nodeNameLen = nodeNames.length;
        String nodeName = null;
        for (int i = 0; i < nodeNameLen; ++i) {
            nodeName = nodeNames[i];
            if (oPrereqChecker.getPrereqResultObj(nodeName) != null) {
                OipcpIPrereqResultsSummary resObj = oPrereqChecker.getPrereqResultObj(nodeName);
                Object[] args = new String[]{new Date().toString()};
                String sMsg = OiixResourceBundle.getString("oracle.sysman.oip.oipc.oipcl.resources.OipclRuntimeRes", "13002", args);
                if (Boolean.getBoolean("oracle.installer.silent")) {
                    OiiolTextLogger.writeToLogAndConsole(sMsg);
                    OiiolTextLogger.writeToLogAndConsole(S_LINE);
                    OiiolTextLogger.writeToLogAndConsole("Prerequisite Checks for Remote Node " + nodeName);
                    OiiolTextLogger.writeToLogAndConsole(S_LINE);
                } else {
                    OiiolTextLogger.appendText(sMsg);
                    OiiolTextLogger.appendText(S_LINE);
                    OiiolTextLogger.appendText("Prerequisite Checks for Remote Node " + nodeName);
                    OiiolTextLogger.appendText(S_LINE);
                }
                Vector vList = new Vector();
                int lengthofVector = vList.size();
                int j = 0;
                vList = resObj.getAllPrereqChecks();
                lengthofVector = vList.size();
                for (j = 0; j < lengthofVector; ++j) {
                    args = new String[]{new Date().toString()};
                    sMsg = OiixResourceBundle.getString("oracle.sysman.oip.oipc.oipcl.resources.OipclRuntimeRes", "13002", args);
                    if (Boolean.getBoolean("oracle.installer.silent")) {
                        OiiolTextLogger.writeToLogAndConsole(sMsg);
                    } else {
                        OiiolTextLogger.appendText(sMsg);
                    }
                    args = new String[]{((OipcpPrerequisiteCheck)vList.get(j)).getName(), ((OipcpPrerequisiteCheck)vList.get(j)).getDescription()};
                    sMsg = OiixResourceBundle.getString("oracle.sysman.oip.oipc.oipcl.resources.OipclRuntimeRes", "13004", args);
                    if (Boolean.getBoolean("oracle.installer.silent")) {
                        OiiolTextLogger.writeToLogAndConsole(sMsg);
                        OiiolTextLogger.writeToLogAndConsole(((OipcpPrerequisiteCheck)vList.get(j)).getResult().getFormattedResultText());
                        OiiolTextLogger.writeToLogAndConsole(S_LINE);
                        continue;
                    }
                    OiiolTextLogger.appendText(sMsg);
                    OiiolTextLogger.appendText(((OipcpPrerequisiteCheck)vList.get(j)).getResult().getFormattedResultText());
                    OiiolTextLogger.appendText(S_LINE);
                }
                args = new String[]{new Date().toString()};
                sMsg = OiixResourceBundle.getString("oracle.sysman.oip.oipc.oipcl.resources.OipclRuntimeRes", "13003", args);
                if (Boolean.getBoolean("oracle.installer.silent")) {
                    OiiolTextLogger.writeToLogAndConsole(sMsg);
                    OiiolTextLogger.writeToLogAndConsole(S_LINE);
                    continue;
                }
                OiiolTextLogger.appendText(sMsg);
                OiiolTextLogger.appendText(S_LINE);
                continue;
            }
            if (Boolean.getBoolean("oracle.installer.silent")) {
                OiiolTextLogger.writeToLogAndConsole("Prerequisite Checks for Remote Node " + nodeName);
                OiiolTextLogger.writeToLogAndConsole(S_LINE);
                OiiolTextLogger.writeToLogAndConsole(S_ERR_MSG);
                continue;
            }
            OiiolTextLogger.appendText("Prerequisite Checks for Remote Node " + nodeName);
            OiiolTextLogger.appendText(S_LINE);
            OiiolTextLogger.appendText(S_ERR_MSG);
        }
    }
}

