/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifw;

import java.util.ArrayList;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicClusterInstallInfo;
import oracle.sysman.oii.oiic.OiicClusterNode;
import oracle.sysman.oii.oiic.OiicInstallSession;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifb.OiifbWizChainDlgElem;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiin.OiinNetOps;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgCFSDriveCheck;
import oracle.sysman.oii.oiip.oiipg.OiipgDetectCluster;
import oracle.sysman.oii.oiis.OiisAdvisedValue;
import oracle.sysman.oii.oiis.OiisDlgInElem;
import oracle.sysman.oii.oiis.OiisDlgInOutElem;
import oracle.sysman.oii.oiis.OiisVarSettingException;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixUtilityOps;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiifwNodeSelWCDE
extends OiifbWizChainDlgElem {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 1024;
    private int m_nextInd;
    private String[] m_nodeList = null;
    OiisVariableOwner m_vo;
    public static final String s_panelClass = "oracle.sysman.oii.oiif.oiifp.OiifpNodeSelPanel";
    private OiiiOracleHomeInfo m_oHomeInfo = null;
    private String m_sLocalNode = null;
    private String[] m_asSelectedNodes = null;
    private String[] m_asInvalidNodes = null;
    private boolean m_bCRSVersionKnown = false;
    private boolean m_bSharedHome = false;

    public OiifwNodeSelWCDE(OiisVariableOwner vo, int nextInd) {
        super(vo);
        this.m_vo = vo;
        this.setWizPanelClassName(s_panelClass);
        this.setHelpKey("OiifwNodeSelWCDE");
        String sTitle = OiixResourceBundle.getString("S_NODE_SELECTION_TITLE");
        this.setTitle(sTitle);
        this.m_nextInd = nextInd;
    }

    @Override
    public void initialize() throws OiifbEndIterateException {
        String sClusterInstallDesc = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_NODE_SEL_DESC");
        String sStandAloneInstallDesc = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_NON_CLUSTER_DESC");
        this.m_oHomeInfo = this.getHomeInfo();
        Vector oNodeList = this.m_oHomeInfo.getNodeList();
        OiipgDetectCluster detectCluster = OiipgDetectCluster.getDetectCluster();
        OiicInstallSession oSession = (OiicInstallSession)this.m_vo.getSession();
        OiisVariable oRemoteNodesVar = oSession.getSessionContext().getVariable("REMOTE_NODES");
        OiisVariable oClusterNodesVar = oSession.getSessionContext().getVariable("CLUSTER_NODES");
        if (!this.isNewHome()) {
            this.m_nodeList = OiixVectorOps.list2StrArr(oNodeList);
            try {
                oClusterNodesVar.setValue(this.m_nodeList);
            }
            catch (OiisVarSettingException e) {
                OiiolTextLogger.appendException(e);
            }
            catch (OiifbCancelException e) {
                OiiolTextLogger.appendException(e);
            }
            OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFW1023", new String[]{OiixFunctionOps.implodeList(this.m_nodeList, ",")}));
        } else {
            this.m_vo.getSession();
            if (OiicPullSession.isSilentMode() && !oClusterNodesVar.getAdvice()) {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFW1037"));
                oClusterNodesVar.setAdvice(true);
            }
            if (oClusterNodesVar.getAdvice()) {
                this.m_nodeList = (String[])oClusterNodesVar.getValue();
            } else {
                this.m_nodeList = detectCluster.getNodeNames();
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFW1022", new String[]{OiixFunctionOps.implodeList(this.m_nodeList, ",")}));
            }
        }
        OiisVariable oLocalNodeVar = oSession.getSessionContext().getVariable("LOCAL_NODE");
        if (oLocalNodeVar.isValueSetByUser()) {
            this.m_sLocalNode = (String)oLocalNodeVar.getValue();
            OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFW1020", new String[]{this.m_sLocalNode}));
        } else {
            if (!this.isNewHome() && oNodeList != null) {
                this.m_sLocalNode = this.m_oHomeInfo.getLocalNode();
            }
            if (this.m_sLocalNode == null) {
                this.m_sLocalNode = detectCluster.getLocalNodeName();
                if (this.m_sLocalNode == null) {
                    this.computeLocalNode();
                    if (this.m_sLocalNode == null) {
                        this.m_sLocalNode = this.m_nodeList.length > 0 ? this.m_nodeList[0] : null;
                        OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFW1021", new String[]{this.m_sLocalNode}));
                    }
                } else {
                    OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFW1024", new String[]{this.m_sLocalNode}));
                }
            } else {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFW1025", new String[]{this.m_sLocalNode}));
            }
            if (this.m_sLocalNode != null) {
                try {
                    oLocalNodeVar.setValue(this.m_sLocalNode);
                }
                catch (OiifbCancelException e) {
                    OiiolTextLogger.appendException(e);
                }
                catch (OiisVarSettingException e) {
                    OiiolTextLogger.appendException(e);
                }
            }
        }
        this.addInOutElem(new OiisDlgInOutElem("LocalNode", "LOCAL_NODE", this.m_sLocalNode));
        OiicClusterInstallInfo clusterInfo = OiicClusterInstallInfo.getClusterInstallInfo();
        clusterInfo.setClusterNodes(this.m_nodeList);
        if (this.m_sLocalNode != null) {
            clusterInfo.setLocalNode(this.m_sLocalNode, true);
        }
        String sOHLocation = this.m_oHomeInfo.getLocation();
        String sInvOHLoc = OiixPathOps.getNativeForm(OiixPathOps.concatPath(sOHLocation, "inventory"));
        this.m_bSharedHome = this.isLocalOnly() ? this.isCFS() : OiipgCFSDriveCheck.isDriveOnCFS(this.m_nodeList, this.m_sLocalNode, sInvOHLoc);
        boolean bShowCRSVersion = Boolean.getBoolean("oracle.installer.showClusterSoftwareVersion");
        if (!bShowCRSVersion) {
            this.m_bCRSVersionKnown = false;
        }
        if (this.isNewHome()) {
            if (this.m_bSharedHome) {
                this.m_asSelectedNodes = new String[this.m_nodeList.length];
                System.arraycopy(this.m_nodeList, 0, this.m_asSelectedNodes, 0, this.m_nodeList.length);
            } else {
                this.m_asSelectedNodes = new String[]{this.m_sLocalNode};
            }
            this.m_asInvalidNodes = null;
        } else if (this.isRollingUpgradeEnabled()) {
            if (this.m_bSharedHome) {
                System.setProperty("oracle.installer.enableRollingUpgrade", "false");
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFW1027", new String[]{sOHLocation}));
            } else {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("OIIFW1026"));
            }
            if (this.isClusterInstall() && bShowCRSVersion) {
                OiiiCompInstallID cid = (OiiiCompInstallID)oSession.getSessionContext().getVariable("ToplevelComp").getValue();
                OiiiVersion oSelectedVersion = cid.getVersion();
                ArrayList<String> oSelectedNodes = new ArrayList<String>();
                ArrayList<String> oInvalidNodes = new ArrayList<String>();
                for (int i = 0; i < this.m_nodeList.length; ++i) {
                    OiicClusterNode oNode = clusterInfo.getClusterNode(this.m_nodeList[i]);
                    String sVersion = detectCluster.getSoftwareVersion(this.m_nodeList[i]);
                    oNode.setVersion(sVersion);
                    OiiiVersion oVersion = sVersion != null ? new OiiiVersion(sVersion) : null;
                    this.m_bCRSVersionKnown |= oVersion != null;
                    if (this.isValidNode(oVersion, oSelectedVersion)) {
                        oSelectedNodes.add(this.m_nodeList[i]);
                        continue;
                    }
                    oInvalidNodes.add(this.m_nodeList[i]);
                }
                this.m_asSelectedNodes = OiixVectorOps.list2StrArr(oSelectedNodes);
                this.m_asInvalidNodes = OiixVectorOps.list2StrArr(oInvalidNodes);
            } else {
                this.m_asSelectedNodes = new String[this.m_nodeList.length];
                System.arraycopy(this.m_nodeList, 0, this.m_asSelectedNodes, 0, this.m_nodeList.length);
                this.m_asInvalidNodes = null;
            }
        } else {
            this.m_asSelectedNodes = new String[this.m_nodeList.length];
            System.arraycopy(this.m_nodeList, 0, this.m_asSelectedNodes, 0, this.m_nodeList.length);
            this.m_asInvalidNodes = null;
        }
        boolean bLocalOnly = this.isLocalOnly();
        if (bLocalOnly) {
            OiiolTextLogger.appendText(OiixResourceBundle.getString("OIIFW1028"));
            this.m_asSelectedNodes = new String[0];
        }
        try {
            if (!oRemoteNodesVar.isValueSetByUser() || bLocalOnly) {
                oRemoteNodesVar.setValue(this.m_asSelectedNodes);
            }
        }
        catch (OiifbCancelException e) {
            OiiolTextLogger.appendException(e);
        }
        catch (OiisVarSettingException e) {
            OiiolTextLogger.appendException(e);
        }
        this.addInOutElem(new OiisDlgInOutElem("RemoteNodes", "REMOTE_NODES", this.m_asSelectedNodes));
        this.addInElem(new OiisDlgInElem("ClusterInstallDescription", sClusterInstallDesc));
        this.addInElem(new OiisDlgInElem("SingleInstanceDescription", sStandAloneInstallDesc));
        this.addInElem(new OiisDlgInElem("InvalidNodes", this.m_asInvalidNodes));
        this.addInElem(new OiisDlgInElem("AllowRemoteNodeSelection", OiixUtilityOps.booleanValueOf(!bLocalOnly && (this.isRollingUpgradeEnabled() || this.isNewHome()))));
        this.addInElem(new OiisDlgInElem("ShowCRSSoftwareVersion", OiixUtilityOps.booleanValueOf(this.m_bCRSVersionKnown && this.isClusterInstall() && !this.isNewHome())));
        this.addInElem(new OiisDlgInElem("NewHome", OiixUtilityOps.booleanValueOf(this.isNewHome())));
    }

    private boolean isValidNode(OiiiVersion oVersion, OiiiVersion oSelectedVersion) {
        if (this.m_session.isInstallMode()) {
            return oVersion == null || oSelectedVersion.laterThan(oVersion);
        }
        OiifwNodeSelWCDE oiifwNodeSelWCDE = this;
        if (oiifwNodeSelWCDE.m_session.isLangAddonMode()) {
            return oVersion == null || oVersion.laterThan(oSelectedVersion) || oVersion.equals(oSelectedVersion);
        }
        return true;
    }

    private boolean isLocalOnly() {
        return Boolean.getBoolean("oracle.installer.local");
    }

    private boolean isCFS() {
        return Boolean.getBoolean("oracle.installer.cfs");
    }

    @Override
    public int getNext() {
        return this.m_nextInd;
    }

    @Override
    public int doOperation(boolean bBack) throws OiifbEndIterateException {
        int retval = super.doOperation(bBack);
        if (retval == 1) {
            System.setProperty("oracle.installer.clusterswitch", "OFF");
            System.setProperty("oracle.installer.clusterlist", "");
        } else {
            OiicInstallSession oSession = (OiicInstallSession)this.m_vo.getSession();
            OiisVariable oRemoteNodes = oSession.getSessionContext().getVariable("REMOTE_NODES");
            OiisVariable oLocalNode = oSession.getSessionContext().getVariable("LOCAL_NODE");
            OiisVariable oClusterNodes = oSession.getSessionContext().getVariable("CLUSTER_NODES");
            String[] asClusterNodes = (String[])oClusterNodes.getValue();
            if (asClusterNodes != null && asClusterNodes.length > 0) {
                boolean bSetLocalNodeInOracleHomeInfo;
                if (!oRemoteNodes.isValueSetByUser()) {
                    String[] asRemoteNodes = null;
                    asRemoteNodes = this.isLocalOnly() ? new String[]{} : OiixFunctionOps.subtractStr(asClusterNodes, this.m_sLocalNode, false);
                    try {
                        oRemoteNodes.setValue(asRemoteNodes);
                    }
                    catch (OiifbCancelException e) {
                        OiiolTextLogger.appendException(e);
                    }
                    catch (OiisVarSettingException e) {
                        OiiolTextLogger.appendException(e);
                    }
                }
                if (bSetLocalNodeInOracleHomeInfo = this.m_bSharedHome) {
                    this.m_oHomeInfo.setLocalNode(null);
                } else {
                    this.m_oHomeInfo.setLocalNode(this.m_sLocalNode);
                }
                if (this.isNewHome()) {
                    this.m_oHomeInfo.setNodeList(asClusterNodes);
                    if (!oLocalNode.isValueSetByUser()) {
                        try {
                            oLocalNode.setValue(new OiisAdvisedValue(this.m_sLocalNode), true);
                        }
                        catch (OiifbCancelException e) {
                            OiiolTextLogger.appendException(e);
                        }
                        catch (OiisVarSettingException e) {
                            OiiolTextLogger.appendException(e);
                        }
                    }
                }
            } else {
                try {
                    oRemoteNodes.setValue(new OiisAdvisedValue(new String[0]), true);
                    oLocalNode.setValue(new OiisAdvisedValue(""), true);
                    this.m_oHomeInfo.setLocalNode(null);
                    String[] oNodeList = new String[]{};
                    this.m_oHomeInfo.setNodeList(oNodeList);
                }
                catch (OiifbCancelException e) {
                    OiiolTextLogger.appendException(e);
                }
                catch (OiisVarSettingException e) {
                    OiiolTextLogger.appendException(e);
                }
            }
        }
        return retval;
    }

    public String[] getAllClusterNodes() {
        return this.m_nodeList;
    }

    public boolean showStatus() {
        OiicClusterInstallInfo clusterInfo = OiicClusterInstallInfo.getClusterInstallInfo();
        boolean bShowStatus = !clusterInfo.isAvailable() || this.isClusterInstall() && this.m_bCRSVersionKnown;
        return bShowStatus;
    }

    public boolean isClusterInstall() {
        return !this.isNewHome() && this.m_oHomeInfo.isCRSHome();
    }

    private OiiiOracleHomeInfo getHomeInfo() {
        OiicInstallSession oSession = (OiicInstallSession)this.m_vo.getSession();
        String sHome = (String)oSession.getSessionContext().getVarValue("ORACLE_HOME");
        OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
        OiiiInstallInventory inv = iac.getInstallInventory();
        return inv.getHomeWithLocation(sHome);
    }

    public boolean isNewHome() {
        return this.m_oHomeInfo.wasCreatedInThisSession();
    }

    @Override
    protected boolean canShowWCDE() {
        OiicInstallSession oSession = (OiicInstallSession)this.m_vo.getSession();
        Boolean oShowPage = (Boolean)oSession.getSessionContext().getVarValue("SHOW_NODE_SELECTION_PAGE");
        if (this.isNewHome()) {
            OiisVariable oClusterNodes = oSession.getSessionContext().getVariable("CLUSTER_NODES");
            return !oClusterNodes.getAdvice();
        }
        OiisVariable oRemoteNodes = oSession.getSessionContext().getVariable("REMOTE_NODES");
        return oShowPage != false || this.isRollingUpgradeEnabled() && !oRemoteNodes.getAdvice();
    }

    private boolean isRollingUpgradeEnabled() {
        OiiolTextLogger.appendText("isRollingUpgradeEnabled():" + Boolean.getBoolean("oracle.installer.enableRollingUpgrade"));
        return Boolean.getBoolean("oracle.installer.enableRollingUpgrade");
    }

    private void computeLocalNode() {
        OiicInstallSession oSession = (OiicInstallSession)this.m_vo.getSession();
        OiisVariable oClusterNodes = oSession.getSessionContext().getVariable("CLUSTER_NODES");
        String[] asClusterNodes = (String[])oClusterNodes.getValue();
        int m_Length = 0;
        if (asClusterNodes != null && asClusterNodes.length > 0) {
            try {
                String hostIP = OiinNetOps.getNetOps().getHostAddress();
                int clusterLength = asClusterNodes.length;
                for (m_Length = 0; m_Length < clusterLength; ++m_Length) {
                    if (!hostIP.equalsIgnoreCase(OiinNetOps.getNetOps().ping(asClusterNodes[m_Length]))) continue;
                    this.m_sLocalNode = asClusterNodes[m_Length];
                    break;
                }
            }
            catch (Exception e) {
                OiiolTextLogger.appendException(e);
            }
        }
    }
}

