/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifw;

import java.util.Vector;
import oracle.sysman.oii.oiic.OiicInstallSession;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbWizChainDlgElem;
import oracle.sysman.oii.oiif.oiifp.OiifpMultiDepModesPanel;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiis.OiisCompInstallation;
import oracle.sysman.oii.oiis.OiisDepMode;
import oracle.sysman.oii.oiis.OiisDlgInOutElem;
import oracle.sysman.oii.oiis.OiisVarSettingException;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixHelp;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiifwMultiDepModesWCDE
extends OiifbWizChainDlgElem {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 1024;
    private OiicInstallSession m_instSession;
    private OiiiInstallInventory m_installInv;
    private OiisVariableOwner m_vo;
    private OiiiCompInstallID[] m_comps;
    private int m_nextInd;

    public OiifwMultiDepModesWCDE(OiisVariableOwner vo, int nextInd) {
        super(vo);
        this.m_vo = vo;
        this.m_dlgInOutElems.addElement(new OiisDlgInOutElem("TLDepModes", "TLDepModes"));
        this.m_instSession = (OiicInstallSession)vo.getSession();
        this.setHelpKey("OiicDepModesWCDE");
        this.m_nextInd = nextInd;
    }

    @Override
    public int getNext() {
        return this.m_nextInd;
    }

    @Override
    public boolean onNext() throws OiifbCancelException {
        return super.onNext();
    }

    @Override
    public void initialize() {
        OiiiCompInstallID[] ids = this.m_instSession.getSelTopLevelCompIDs();
        if (this.m_comps == null || !OiixVectorOps.arraysEqual(this.m_comps, ids)) {
            this.m_comps = ids;
            this.m_wizPanel = null;
        }
        this.updateDepMode();
    }

    private void updateDepMode() {
        OiisVariable oDepModes = this.m_varOwner.getVariable("TLDepModes");
        OiisVariable oRespDepMode = this.m_varOwner.getVariable("INSTALL_TYPE");
        int numComps = this.m_comps.length;
        String[] nModes = new String[numComps];
        boolean bAdvice = true;
        if (!oDepModes.getAdvice()) {
            for (int i = 0; i < numComps; ++i) {
                Vector dModes = null;
                String nMode = null;
                if (this.m_comps[i].getCompType() == 4 || this.m_comps[i].getCompType() == 2) {
                    dModes = new Vector();
                } else {
                    try {
                        oRespDepMode.setVariable(this.m_comps[i]);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    OiisCompInstallation ci = this.m_instSession.getCompInstall(this.m_comps[i]);
                    dModes = ci.getDepInfo().getDeps().getDepModes();
                    nMode = this.getDepModeValue(ci, oRespDepMode.getValue());
                }
                if (nMode == null) {
                    if (dModes.isEmpty()) {
                        nMode = "Custom";
                    } else if (dModes.size() == 1) {
                        OiisDepMode oMode = (OiisDepMode)dModes.elementAt(0);
                        nMode = oMode.getInternalName();
                    } else {
                        bAdvice = false;
                    }
                } else {
                    bAdvice = bAdvice && oRespDepMode.getAdvice();
                }
                nModes[i] = nMode;
            }
            try {
                oDepModes.setValue(nModes, false);
                oDepModes.setAdvice(bAdvice);
            }
            catch (OiisVarSettingException oiisVarSettingException) {
            }
            catch (OiifbCancelException oiifbCancelException) {
                // empty catch block
            }
        }
    }

    private String getDepModeValue(OiisCompInstallation ci, Object typedValue) {
        String origVal = null;
        Vector dModes = ci.getDepInfo().getDeps().getDepModes();
        if (typedValue instanceof String) {
            origVal = (String)typedValue;
            int nSize = dModes.size();
            if (nSize > 0) {
                for (int i = 0; i < nSize; ++i) {
                    OiisDepMode oMode = (OiisDepMode)dModes.elementAt(i);
                    if (!origVal.equalsIgnoreCase(oMode.getName()) && !origVal.equalsIgnoreCase(oMode.getNameID()) && !origVal.equalsIgnoreCase(oMode.getInternalName())) continue;
                    return oMode.getInternalName();
                }
            }
        }
        return null;
    }

    @Override
    public void setWizPanel() {
        if (this.m_wizPanel == null) {
            this.m_wizPanel = new OiifpMultiDepModesPanel(this.m_instSession);
            ((OiifpMultiDepModesPanel)this.m_wizPanel).init();
        }
    }

    @Override
    public String getDisplayName() {
        String sTitle = OiixResourceBundle.getString("S_INSTALL_TYPE");
        return sTitle;
    }

    @Override
    protected void setDialogProperties() {
        super.setDialogProperties();
    }

    @Override
    public void onHelp() {
        OiiiCompInstallID[] cids = this.m_instSession.getSelTopLevelCompIDs();
        int compInd = ((OiifpMultiDepModesPanel)this.m_wizPanel).getLastSelectedRow();
        if (cids != null && cids.length > compInd) {
            OiixHelp.displayCompHelp(this.m_vo, cids[compInd], "CompInstallTypeHelp", "OiicDepModesWCDE");
        } else {
            super.onHelp();
        }
    }
}

