/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifw;

import java.util.Locale;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicCompLangInfo;
import oracle.sysman.oii.oiic.OiicInstallSession;
import oracle.sysman.oii.oiic.OiicLangAddonSession;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifb.OiifbWizChainDlgElem;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiis.OiisDlgInOutElem;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixLanguage;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifwLanguageSelectionWCDE
extends OiifbWizChainDlgElem {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 1024;
    private boolean m_bErrorOccurred = false;
    private static final String s_panelClass = "oracle.sysman.oii.oiif.oiifp.OiifpWizLangsPanel";
    private static final String SELECTED_LANGUAGES = "SelectedLanguages";
    OiisVariableOwner m_vo;
    private int m_iNextIndex;

    public OiifwLanguageSelectionWCDE(OiisVariableOwner vo, int iNextIndex) {
        super(vo);
        this.m_vo = vo;
        this.m_dlgInOutElems.addElement(new OiisDlgInOutElem(SELECTED_LANGUAGES, "SELECTED_LANGUAGES"));
        this.setWizPanelClassName(s_panelClass);
        this.setHelpKey("OiifpLangsSelWCDE");
        this.m_iNextIndex = iNextIndex;
    }

    @Override
    public int doOperation(boolean isBack) throws OiifbEndIterateException {
        return super.doOperation(isBack);
    }

    public Vector getUpgradableLangs() {
        OiicPullSession m_session = this.m_vo.getSession();
        OiicSessionContext oContext = m_session.getSessionContext();
        OiisVariable oLangs = oContext.getVariable("SELECTED_LANGUAGES");
        Object oLangsValue = oLangs.getValue();
        Vector upgradableLangsVector = new Vector();
        Vector userSelectedLangs = OiixLanguage.getLangsVector(oLangsValue);
        Vector compLangInfoVector = ((OiicLangAddonSession)m_session).getCompLangInfoVector();
        upgradableLangsVector = this.getUpgradableLangsVector(compLangInfoVector, userSelectedLangs);
        return upgradableLangsVector;
    }

    private Vector getUpgradableLangsVector(Vector compLangInfoVector, Vector userSelectedLangs) {
        Vector<Vector> upgradableLangsVector = new Vector<Vector>();
        for (int i = 0; i < compLangInfoVector.size(); ++i) {
            Object oTemp = compLangInfoVector.elementAt(i);
            if (!(oTemp instanceof OiicCompLangInfo)) continue;
            Vector currentUpgradableLangs = ((OiicCompLangInfo)oTemp).getUpgradableLanguages(userSelectedLangs);
            upgradableLangsVector.add(currentUpgradableLangs);
        }
        return upgradableLangsVector;
    }

    @Override
    public boolean validate() throws OiifbCancelException, OiifbEndIterateException {
        OiicPullSession m_session = this.m_vo.getSession();
        OiicSessionContext oContext = m_session.getSessionContext();
        OiisVariable oLangs = oContext.getVariable("SELECTED_LANGUAGES");
        Object oLangsValue = oLangs.getValue();
        if (oLangsValue == null) {
            OiifmAlert.displayError(OiixResourceBundle.getString("S_NUM_LANGS_ERR"));
            if (OiicPullSession.isSilentMode()) {
                throw new OiifbEndIterateException("No languages found in response file");
            }
            return false;
        }
        Vector userSelectedLangs = OiixLanguage.getLangsVector(oLangsValue);
        if (userSelectedLangs.size() == 0) {
            OiifmAlert.displayError(OiixResourceBundle.getString("S_NUM_LANGS_ERR"));
            if (OiicPullSession.isSilentMode()) {
                throw new OiifbEndIterateException("No languages found in response file");
            }
            return false;
        }
        if (OiicPullSession.isLangAddonMode()) {
            String[] oLangsString = OiixLanguage.getStringArray(userSelectedLangs);
            Vector availLangs = ((OiicLangAddonSession)m_session).getAvailableLangs();
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("Available langs in validate() of LanguageSelectionWCDE :" + availLangs, OiiolTextLogger.LOG_DETAILED);
                OiiolTextLogger.appendText("User selected langs in validate() LanguageSelectionWCDE :" + userSelectedLangs, OiiolTextLogger.LOG_DETAILED);
            }
            boolean bFoundSpanish = false;
            boolean bFoundFrench = false;
            String sFrench = OiixLanguage.FRENCH.toString();
            String sFrenchCA = OiixLanguage.CA_FRENCH.toString();
            String sSpanish = OiixLanguage.SPANISH.toString();
            String sSpanishAR = OiixLanguage.AR_SPANISH.toString();
            for (int i = 0; i < oLangsString.length; ++i) {
                String currLang = oLangsString[i];
                if (currLang.equals(sFrenchCA) || currLang.equals(sFrench)) {
                    bFoundFrench = true;
                }
                if (!currLang.equals(sSpanish) && !currLang.equals(sSpanishAR)) continue;
                bFoundSpanish = true;
            }
            if (bFoundFrench) {
                userSelectedLangs.remove(OiixLanguage.CA_FRENCH);
                userSelectedLangs.remove(OiixLanguage.FR_FRENCH);
                userSelectedLangs.remove(OiixLanguage.FRENCH);
            }
            if (bFoundSpanish) {
                userSelectedLangs.remove(OiixLanguage.AR_SPANISH);
                userSelectedLangs.remove(OiixLanguage.SPANISH);
            }
            userSelectedLangs.removeAll(availLangs);
            if (userSelectedLangs.size() > 0) {
                int i;
                StringBuffer sb = new StringBuffer();
                sb.append("OUI-25029:");
                sb.append(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-25029") + " { ");
                Locale[] allSupportedLangs = OiixLanguage.getSupportedLanguages();
                boolean isSupportedLang = false;
                for (i = 0; i < userSelectedLangs.size(); ++i) {
                    isSupportedLang = false;
                    Locale currInvalidLang = (Locale)userSelectedLangs.elementAt(i);
                    for (int j = 0; j < allSupportedLangs.length; ++j) {
                        if (!allSupportedLangs[j].equals(currInvalidLang)) continue;
                        isSupportedLang = true;
                    }
                    if (isSupportedLang) {
                        sb.append(OiixLanguage.getDisplayName(currInvalidLang) + " ");
                        continue;
                    }
                    sb.append(currInvalidLang.getDisplayName() + " ");
                }
                sb.append("}.");
                if (OiicPullSession.isSilentMode()) {
                    sb.append(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-25030") + " { ");
                    for (i = 0; i < availLangs.size(); ++i) {
                        sb.append(OiixLanguage.getDisplayName((Locale)availLangs.elementAt(i)) + " ");
                    }
                    sb.append("}.");
                }
                OiifmAlert.displayError(sb.toString());
                if (OiicPullSession.isSilentMode()) {
                    throw new OiifbEndIterateException("Invalid language found in response file");
                }
            }
        }
        return true;
    }

    @Override
    public String getDisplayName() {
        String sTitle = OiixResourceBundle.getString("S_LANG_SEL");
        return sTitle;
    }

    @Override
    public boolean canShowWCDE() {
        boolean bShowWCDE = super.canShowWCDE();
        if (bShowWCDE) {
            if (OiicPullSession.isLangAddonMode()) {
                return true;
            }
            OiiiCompInstallID oid = this.m_vo.getSession().getSelTopLevelCompID();
            if (oid != null) {
                if (oid.getCompType() == 4) {
                    bShowWCDE = false;
                } else {
                    OiicInstallSession oSession = (OiicInstallSession)this.m_vo.getSession();
                    Vector compLangs = oSession.getStgCompLangs(oid);
                    if (compLangs.size() <= 1) {
                        bShowWCDE = false;
                    }
                }
            }
        }
        return bShowWCDE;
    }

    @Override
    public int getNext() {
        return this.m_iNextIndex;
    }
}

