/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifw;

import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.TreeSet;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicCompLangInfo;
import oracle.sysman.oii.oiic.OiicLangAddonSession;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifb.OiifbWizOperation;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiInstallPatchInvEntry;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiii.OiiiSourceAccess;
import oracle.sysman.oii.oiii.OiiiStageCompInvEntry;
import oracle.sysman.oii.oiii.OiiiStageInventory;
import oracle.sysman.oii.oiii.OiiiStagePatchInvEntry;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifwLangAddonSetupWCCE
implements OiifbWizOperation {
    private boolean m_bShow = true;
    private OiisVariableOwner m_vo;
    private int m_nextInd;
    private boolean m_bErrorOccurred = false;

    public OiifwLangAddonSetupWCCE(OiisVariableOwner vo, int nextInd) {
        this.m_vo = vo;
        this.m_nextInd = nextInd;
    }

    @Override
    public void initialize() {
        this.m_bShow = !OiicPullSession.isSilentMode();
    }

    public int getNext() {
        return this.m_nextInd;
    }

    @Override
    public void dispose() {
        this.m_vo = null;
    }

    @Override
    public int doOperation(boolean isBack) throws OiifbEndIterateException {
        this.m_bErrorOccurred = false;
        if (isBack) {
            return 1;
        }
        try {
            Vector tlcIntersectionVector = this.getTLCIntersection();
            Vector compLangInfoVector = this.getCompLangInfoVector(tlcIntersectionVector);
            Vector availableLangs = this.getAvailableLangs(compLangInfoVector);
            if (availableLangs.size() != 0) {
                TreeSet noDuplicatesLangsTreeSet = new TreeSet(new LocaleComparator());
                noDuplicatesLangsTreeSet.addAll(availableLangs);
                availableLangs.removeAllElements();
                availableLangs.addAll(noDuplicatesLangsTreeSet);
                OiicPullSession currSession = this.m_vo.getSession();
                if (OiicPullSession.isLangAddonMode()) {
                    ((OiicLangAddonSession)currSession).setAvailableLangs(availableLangs);
                    if (compLangInfoVector.size() > 0) {
                        ((OiicLangAddonSession)currSession).setCompLangInfoVector(compLangInfoVector);
                    }
                    if (tlcIntersectionVector != null) {
                        ((OiicLangAddonSession)currSession).setTopLevelComponentIntersection(tlcIntersectionVector);
                    }
                    ((OiicLangAddonSession)currSession).computeAllPatchesOfPatchSets();
                }
            } else {
                String msg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-25028");
                OiifmAlert.displayError(msg, OiixResourceBundle.getString("S_ERROR"), "OUI-25028");
                this.m_bErrorOccurred = true;
            }
        }
        catch (Exception e) {
            throw new OiifbEndIterateException(e.getMessage());
        }
        return this.m_bErrorOccurred ? 1 : 0;
    }

    private Vector getCompLangInfoVector(Vector tlcIntersectionVector) {
        Vector<OiicCompLangInfo> compLangInfoVector = new Vector<OiicCompLangInfo>();
        OiicPullSession pSession = this.m_vo.getSession();
        OiiiInstallAreaControl iac = pSession.getInstallAreaControl();
        OiiiSourceAccess srcAccess = pSession.getSourceAccess();
        OiiiStageInventory osi = srcAccess.getStageInventory();
        OiiiInstallInventory oInventory = iac.getInstallInventory();
        for (int i = 0; i < tlcIntersectionVector.size(); ++i) {
            if (!(tlcIntersectionVector.elementAt(i) instanceof OiiiCompInstallID)) continue;
            OiiiCompInstallID compID = (OiiiCompInstallID)tlcIntersectionVector.elementAt(i);
            OiiiInstallCompInvEntry installCompInvEntry = oInventory.getInstallCompInvEntry(compID, this.getHomeIndex());
            Vector installedLangs = installCompInvEntry.getLanguages();
            OiiiStageCompInvEntry stageCompInvEntry = osi.getStageCompInvEntry(compID);
            Vector supportedLangs = stageCompInvEntry.getLanguages();
            Vector sLangs = new Vector();
            Vector iLangs = new Vector();
            sLangs.addAll(supportedLangs);
            iLangs.addAll(installedLangs);
            OiicCompLangInfo cli = new OiicCompLangInfo(sLangs, iLangs);
            compLangInfoVector.add(cli);
        }
        return compLangInfoVector;
    }

    private int getHomeIndex() {
        int homeIndex = -1;
        OiisVariable oHomeNameVar = this.m_vo.getVariable("ORACLE_HOME_NAME");
        OiisVariable oHomeLocVar = this.m_vo.getVariable("ORACLE_HOME");
        String sLoc = (String)oHomeLocVar.getValue();
        String sName = (String)oHomeNameVar.getValue();
        OiiiInstallAreaControl oAreaControl = (OiiiInstallAreaControl)OiiiInstallAreaControl.getInventoryAreaControl();
        OiiiInstallInventory oInventory = oAreaControl.getInstallInventory();
        if (null != oInventory) {
            Vector vHomes = oInventory.getHomes();
            int nHomeCount = vHomes.size();
            for (int i = 0; i < nHomeCount; ++i) {
                OiiiOracleHomeInfo oInfo = (OiiiOracleHomeInfo)vHomes.elementAt(i);
                String sHomeName = oInfo.getName();
                boolean bSameHomeName = sHomeName.equalsIgnoreCase(sName);
                if (!bSameHomeName) continue;
                homeIndex = oInfo.getIndex();
                break;
            }
        }
        return homeIndex;
    }

    private Vector getTLCIntersection() {
        OiicPullSession pSession = this.m_vo.getSession();
        OiiiInstallAreaControl iac = pSession.getInstallAreaControl();
        OiiiSourceAccess srcAccess = pSession.getSourceAccess();
        OiiiStageInventory osi = srcAccess.getStageInventory();
        Vector stageTLCVector = osi.getTopLevelComps(0);
        OiiiInstallInventory oInventory = iac.getInstallInventory();
        Vector oHTLCVector = oInventory.getTopLevelComps(this.getHomeIndex());
        Vector tlcIntersectionVector = new Vector();
        tlcIntersectionVector.addAll(stageTLCVector);
        tlcIntersectionVector.retainAll(oHTLCVector);
        return tlcIntersectionVector;
    }

    public Vector getAvailableLangs(Vector tlcLangsInfo) throws OiifbEndIterateException {
        Vector availableLangs = new Vector();
        if (tlcLangsInfo != null) {
            for (int i = 0; i < tlcLangsInfo.size(); ++i) {
                Vector currentSupportedButNotInstalledLangs = new Vector();
                if (!(tlcLangsInfo.elementAt(i) instanceof OiicCompLangInfo)) continue;
                OiicCompLangInfo currentCompLangInfo = (OiicCompLangInfo)tlcLangsInfo.elementAt(i);
                currentSupportedButNotInstalledLangs = currentCompLangInfo.getNotInstalledLangs();
                availableLangs.addAll(currentSupportedButNotInstalledLangs);
            }
            availableLangs.addAll(this.getAvailableLangsForPatches());
            return availableLangs;
        }
        if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
            OiiolTextLogger.appendText("Exception in getAvailableLangs", OiiolTextLogger.LOG_DETAILED);
        }
        throw new OiifbEndIterateException("No top level components availableto find available languages in lang addon session");
    }

    public Vector getAvailableLangsForPatches() {
        OiicPullSession pSession = this.m_vo.getSession();
        OiiiInstallAreaControl iac = pSession.getInstallAreaControl();
        OiiiSourceAccess srcAccess = pSession.getSourceAccess();
        OiiiStageInventory osi = srcAccess.getStageInventory();
        Vector stagePatches = osi.getAllPatches(OiixPlatform.getCurrentPlatform());
        int stagePatchesCount = stagePatches.size();
        OiiiInstallInventory oInventory = iac.getInstallInventory();
        Hashtable<Locale, Locale> hLangs = new Hashtable<Locale, Locale>(5);
        for (int i = 0; i < stagePatchesCount; ++i) {
            OiiiStageCompInvEntry scie = (OiiiStageCompInvEntry)stagePatches.elementAt(i);
            OiiiCompInvEntry spie = null;
            if (scie instanceof OiiiStagePatchInvEntry) {
                spie = (OiiiStagePatchInvEntry)scie;
            }
            OiiiCompInstallID id = spie.getCompInstallID();
            OiiiInstallCompInvEntry icie = oInventory.getInstallCompInvEntry(id, this.getHomeIndex());
            Vector patchAvailableLangs = new Vector();
            if (icie != null && icie instanceof OiiiInstallPatchInvEntry) {
                OiiiInstallPatchInvEntry ipie = (OiiiInstallPatchInvEntry)icie;
                OiiiCompInstallID baseID = ipie.getBaseID();
                OiiiInstallCompInvEntry baseInvEntry = oInventory.getInstallCompInvEntry(baseID, this.getHomeIndex());
                Vector baseInstalledLangs = baseInvEntry.getLanguages();
                Vector patchInstalledLangs = ipie.getLanguages();
                Vector patchSuppLangs = spie.getLanguages();
                patchAvailableLangs.addAll(patchSuppLangs);
                patchAvailableLangs.removeAll(patchInstalledLangs);
                patchAvailableLangs.retainAll(baseInstalledLangs);
            }
            int iLangs = patchAvailableLangs.size();
            for (int j = 0; j < iLangs; ++j) {
                Locale l = (Locale)patchAvailableLangs.elementAt(j);
                if (hLangs.get(l) != null) continue;
                hLangs.put(l, l);
            }
        }
        Vector retVect = new Vector(hLangs.size());
        Enumeration eLangs = hLangs.keys();
        while (eLangs.hasMoreElements()) {
            retVect.addElement(eLangs.nextElement());
        }
        return retVect;
    }

    private class LocaleComparator
    implements Comparator {
        private LocaleComparator() {
        }

        public int compare(Object o1, Object o2) {
            try {
                int retVal = 0;
                int country1AfterCountry2 = 0;
                int lang1AfterLang2 = 0;
                int lang1AfterCountry2 = 0;
                int country1AfterLang2 = 0;
                Locale l1 = (Locale)o1;
                Locale l2 = (Locale)o2;
                String lang1 = l1.getDisplayLanguage();
                String lang2 = l2.getDisplayLanguage();
                String country1 = l1.getDisplayCountry();
                String country2 = l2.getDisplayCountry();
                lang1AfterLang2 = lang1.compareToIgnoreCase(lang2);
                if (lang1AfterLang2 != 0) {
                    retVal = lang1AfterLang2;
                    return retVal;
                }
                if (country1 != "" && country2 != "") {
                    retVal = country1AfterCountry2 = country1.compareToIgnoreCase(country2);
                } else if (country1 == "" && country2 != "") {
                    retVal = lang1AfterCountry2 = lang1.compareToIgnoreCase(country2);
                } else if (country1 != "" && country2 == "") {
                    retVal = country1AfterLang2 = country1.compareToIgnoreCase(lang2);
                }
                return retVal;
            }
            catch (Exception e) {
                throw new ClassCastException(e.getMessage());
            }
        }
    }
}

