/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifw;

import java.util.HashMap;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicCompLangInfo;
import oracle.sysman.oii.oiic.OiicLangAddonSession;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiic.OiicSessionPlan;
import oracle.sysman.oii.oiif.oiifb.OiifbCondWizOperation;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiInstallCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiInstallPatchInvEntry;
import oracle.sysman.oii.oiii.OiiiPatchInstallID;
import oracle.sysman.oii.oiii.OiiiPatchSetInstallID;
import oracle.sysman.oii.oiii.OiiiStageCompInvEntry;
import oracle.sysman.oii.oiii.OiiiStageInventory;
import oracle.sysman.oii.oiio.oiiod.OiiodDepEngine;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiis.OiisCompContext;
import oracle.sysman.oii.oiis.OiisCompInstallation;
import oracle.sysman.oii.oiis.OiisPatchContext;
import oracle.sysman.oii.oiis.OiisPatchInstallation;
import oracle.sysman.oii.oiis.OiisVarSettingException;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixLanguage;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiifwLangAddonDepCalcWCCE
implements OiifbCondWizOperation {
    private OiisVariableOwner m_vo = null;
    private int m_nextInd;
    private OiicPullSession m_pullSession;
    private Vector m_vComps;
    private Vector m_vPatches;
    private Vector m_vSelList;
    private boolean m_bErrorOccurred = false;
    private Vector m_vTopLevelCompsActuallyUpgraded = null;

    public OiifwLangAddonDepCalcWCCE(OiisVariableOwner vo, int nextInd) {
        this.m_vo = vo;
        this.m_nextInd = nextInd;
    }

    @Override
    public void initialize() throws OiifbEndIterateException {
        this.m_pullSession = this.m_vo.getSession();
    }

    @Override
    public int doOperation(boolean back) throws OiifbEndIterateException {
        if (back) {
            return 1;
        }
        this.m_bErrorOccurred = false;
        OiicSessionPlan sessPlan = this.m_pullSession.getSessionPlan();
        sessPlan.clearPlan();
        OiiodDepEngine depEngine = this.m_pullSession.getDepEngine();
        OiiiStageInventory stageInv = this.m_pullSession.getSourceAccess().getStageInventory();
        depEngine.setInventories(stageInv, this.m_pullSession.getInstallAreaControl().getInstallInventory());
        this.calculateLangAddonComps(this.m_pullSession.getInstallAreaControl().getInstallInventory(), stageInv);
        this.checkInconsistencies();
        this.matchStageInvOrder();
        this.setContext();
        this.updatePlan(this.m_vSelList);
        return this.m_bErrorOccurred ? 1 : 0;
    }

    private void setContext() {
        int ohIndex = this.m_pullSession.getOHIndex();
        int nSize = this.m_vSelList.size();
        for (int i = 0; i < nSize; ++i) {
            OiiiInstallCompInvEntry oEntry = (OiiiInstallCompInvEntry)this.m_vSelList.elementAt(i);
            OiisCompInstallation oCompInstall = null;
            OiisPatchInstallation oPatchInstall = null;
            OiisCompInstallation oInstall = this.m_pullSession.getCompInstall(oEntry.getCompInstallID());
            OiisCompContext oCompContext = null;
            if (oInstall instanceof OiisPatchInstallation) {
                oPatchInstall = (OiisPatchInstallation)oInstall;
                oCompContext = OiisPatchContext.createContextFromInstallInv(oEntry, ohIndex);
                oCompContext.setCompID(oEntry.getCompInstallID());
            } else if (oInstall instanceof OiisCompInstallation) {
                oCompInstall = oInstall;
                oCompContext = OiisCompContext.createContextFromInstallInv(oEntry, ohIndex);
                oCompContext.setCompID(oEntry.getCompInstallID());
            }
            if (oCompInstall != null) {
                oCompInstall.setUpgradeLangs(oEntry.getUpgradeLangs());
            } else {
                oPatchInstall.setUpgradeLangs(oEntry.getUpgradeLangs());
            }
            OiisVariable selLangsVar = new OiisVariable(this.m_vo, "SELECTED_LANGUAGES");
            Vector upgradeLangs = oEntry.getUpgradeLangs();
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("OiifwlangAddonDepCalcWCCE : Langs from getUpgradeLangs() of OiiiInstallCompInvEntry" + upgradeLangs, OiiolTextLogger.LOG_DETAILED);
            }
            try {
                selLangsVar.setVariableValue(upgradeLangs);
            }
            catch (OiisVarSettingException e) {
                OiiolTextLogger.appendText("Exception in setting the upgraded langs as SELECTED_LANGUAGES variable", OiiolTextLogger.LOG_DETAILED);
            }
            oCompContext.setPullSession(this.m_pullSession);
            if (oCompInstall != null) {
                oCompInstall.setContext(oCompContext);
                continue;
            }
            oPatchInstall.setPatchContextFromCompContext(oCompContext);
        }
    }

    private void calculateLangAddonComps(OiiiInstallInventory installInv, OiiiStageInventory stageInv) {
        boolean bLog = OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED;
        this.m_vComps = new Vector(5, 5);
        this.m_vPatches = new Vector(5, 5);
        this.m_vSelList = new Vector(5, 5);
        this.m_vTopLevelCompsActuallyUpgraded = new Vector();
        int ohIndex = this.m_pullSession.getOHIndex();
        Vector vOHComps = installInv.getAllCompsVect(ohIndex);
        int nComps = vOHComps.size();
        if (bLog) {
            OiiolTextLogger.appendText("LangAddon, DepCALC Number of OH COMPS = " + nComps, OiiolTextLogger.LOG_DETAILED);
        }
        for (int i = 0; i < nComps; ++i) {
            OiiiInstallCompInvEntry oInsEntry = (OiiiInstallCompInvEntry)vOHComps.elementAt(i);
            OiiiCompInstallID oID = oInsEntry.getCompInstallID();
            OiiiStageCompInvEntry oStageEntry = (OiiiStageCompInvEntry)stageInv.getCompInvEntry(oInsEntry.getCompInstallID());
            if (oStageEntry == null) {
                if (!bLog) continue;
                OiiolTextLogger.appendText("LangAddon, DepCALC : Discarding  component :" + oInsEntry.toString(), OiiolTextLogger.LOG_DETAILED);
                continue;
            }
            if (oID.getCompType() == 4) {
                if (OiiolTextLogger.getLogLevel() < OiiolTextLogger.LOG_DETAILED) continue;
                OiiolTextLogger.appendText("Found patchset in Lang Addon Session, ignoring thepatchset because it does not have languages", OiiolTextLogger.LOG_DETAILED);
                continue;
            }
            boolean bUpgradableLangsExist = false;
            OiicSessionContext context = this.m_pullSession.getSessionContext();
            OiisVariable selLangs = context.getVariable("SELECTED_LANGUAGES");
            Object oValue = selLangs.getValue();
            Vector vSelLangs = OiixLanguage.getLangsVector(oValue);
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("OiifwlangAddonDepCalcWCCE : In calculateLangAddonComps() user selectedLangs " + vSelLangs, OiiolTextLogger.LOG_DETAILED);
            }
            Vector vInstalledLangs = oInsEntry.getLanguages();
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("OiifwlangAddonDepCalcWCCE : In calculateLangAddonComps() installedLangs for current component :" + vInstalledLangs, OiiolTextLogger.LOG_DETAILED);
            }
            Vector vSupportedLangs = oStageEntry.getLanguages();
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("OiifwlangAddonDepCalcWCCE : In calculateLangAddonComps() supportedLangs for current component :" + vSupportedLangs, OiiolTextLogger.LOG_DETAILED);
            }
            OiicCompLangInfo compLangInfo = new OiicCompLangInfo(vSupportedLangs, vInstalledLangs);
            Vector vUpgradedLangs = compLangInfo.getUpgradableLanguages(vSelLangs);
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("OiifwlangAddonDepCalcWCCE : In calculateLangAddonComps() upgradableLangs for current component :" + vUpgradedLangs, OiiolTextLogger.LOG_DETAILED);
            }
            boolean bl = bUpgradableLangsExist = vUpgradedLangs.size() > 0;
            if (!bUpgradableLangsExist) continue;
            oInsEntry.setUpgradeLangs(vUpgradedLangs);
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("OiifwlangAddonDepCalcWCCE : In calculateLangAddonComps() :Currently adding component :" + oID.getName() + " to comp vector", OiiolTextLogger.LOG_DETAILED);
            }
            OiiiCompInstallID parentPatchSet = null;
            switch (oID.getCompType()) {
                case 1: {
                    this.m_vComps.add(oInsEntry);
                    if (!oInsEntry.isTopLevel()) break;
                    this.updateActuallyUpgradedTLCList(oID);
                    break;
                }
                case 2: {
                    this.m_vPatches.add(oInsEntry);
                    parentPatchSet = this.getParentPatchSetOfPatch(oID);
                    if (parentPatchSet == null) break;
                    this.updateActuallyUpgradedTLCList(parentPatchSet);
                }
            }
            if (!bLog) continue;
            OiiolTextLogger.appendText("LangAddon, Adding component :" + oInsEntry.toString(), OiiolTextLogger.LOG_DETAILED);
        }
        ((OiicLangAddonSession)this.m_pullSession).setTopLevelComponentsUpgraded(this.m_vTopLevelCompsActuallyUpgraded);
        if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
            OiiolTextLogger.appendText("top level components actually upgraded" + this.m_vTopLevelCompsActuallyUpgraded, OiiolTextLogger.LOG_DETAILED);
        }
    }

    private void checkInconsistencies() throws OiifbEndIterateException {
        boolean bAllPatchesSelectedForLangUpgrade = true;
        block4: for (int i = 0; i < this.m_vComps.size() && bAllPatchesSelectedForLangUpgrade; ++i) {
            OiiiInstallCompInvEntry oicie = (OiiiInstallCompInvEntry)this.m_vComps.elementAt(i);
            OiiiCompInstallID compID = oicie.getCompInstallID();
            OiiiInstallPatchInvEntry oipie = oicie.getPatchInvEntry();
            if (oipie == null) continue;
            bAllPatchesSelectedForLangUpgrade = false;
            for (int j = 0; j < this.m_vPatches.size(); ++j) {
                OiiiCompInstallID baseID;
                Object o = this.m_vPatches.elementAt(j);
                if (!(o instanceof OiiiInstallPatchInvEntry) || !(baseID = ((OiiiInstallPatchInvEntry)o).getBaseID()).equals(compID)) continue;
                bAllPatchesSelectedForLangUpgrade = true;
                continue block4;
            }
        }
        if (!bAllPatchesSelectedForLangUpgrade) {
            String message = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-25031");
            int userChoice = OiifmAlert.displayAlert(OiixResourceBundle.getString("S_WARNING"), message, 30, 3, 1, 10);
            switch (userChoice) {
                case 1: {
                    break;
                }
                case 2: {
                    if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                        OiiolTextLogger.appendText("User selected to cancel LanguageUpgrade due to inconsistences", OiiolTextLogger.LOG_DETAILED);
                    }
                    this.m_bErrorOccurred = true;
                }
            }
        }
    }

    @Override
    public void dispose() {
    }

    public void finalize() {
        this.dispose();
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public int getNext() {
        return this.m_nextInd;
    }

    private void matchStageInvOrder() {
        OiiiStageInventory stageInv = this.m_pullSession.getSourceAccess().getStageInventory();
        boolean bLog = OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED;
        Vector<OiiiInstallCompInvEntry> vOrderedComps = new Vector<OiiiInstallCompInvEntry>(this.m_vComps.size() + this.m_vPatches.size());
        Vector vComps = (Vector)this.m_vComps.clone();
        Vector vPatches = (Vector)this.m_vPatches.clone();
        vComps.addAll(vPatches);
        Vector vInvEntries = stageInv.getAllCompsVect(0);
        if (bLog) {
            OiiolTextLogger.appendText("LangDepCALC, #Comps in Stage Inventory :" + vInvEntries.size(), OiiolTextLogger.LOG_DETAILED);
            OiiolTextLogger.appendText("LangDepCALC #Comps processed :" + vComps.size(), OiiolTextLogger.LOG_DETAILED);
        }
        int stgIdx = 0;
        int depIdx = 0;
        while (depIdx < vComps.size() && stgIdx < vInvEntries.size()) {
            OiiiStageCompInvEntry invEntry;
            OiiiInstallCompInvEntry depNode = (OiiiInstallCompInvEntry)vComps.elementAt(depIdx);
            if (depNode == null) {
                ++depIdx;
                continue;
            }
            OiiiCompInstallID cid = depNode.getCompInstallID();
            if (cid.equals((invEntry = (OiiiStageCompInvEntry)vInvEntries.elementAt(stgIdx)).getCompInstallID(), false)) {
                vOrderedComps.addElement(depNode);
                vComps.setElementAt(null, depIdx);
                ++stgIdx;
                ++depIdx;
                continue;
            }
            OiiiCompInstallID stageCompID = invEntry.getCompInstallID();
            int idx = OiixVectorOps.vectIndexOf(vComps, (Object)stageCompID, depIdx);
            if (idx != -1) {
                OiiiInstallCompInvEntry stageDepNode = (OiiiInstallCompInvEntry)vComps.elementAt(idx);
                vOrderedComps.addElement(stageDepNode);
                vComps.setElementAt(null, idx);
            }
            ++stgIdx;
        }
        if (vOrderedComps.size() < vComps.size()) {
            for (int j = vOrderedComps.size(); j < vComps.size(); ++j) {
                OiiiInstallCompInvEntry depNode = (OiiiInstallCompInvEntry)vComps.elementAt(j);
                if (depNode == null) continue;
                vOrderedComps.addElement((OiiiInstallCompInvEntry)vComps.elementAt(j));
            }
        }
        if (bLog) {
            OiiolTextLogger.appendText("LangDepCALC, #ORDEREDComps :" + vOrderedComps.size(), OiiolTextLogger.LOG_DETAILED);
            OiiolTextLogger.appendText("LangDepCALC, ORDEREDComps LIST:", OiiolTextLogger.LOG_DETAILED);
            int nSize = vOrderedComps.size();
            for (int k = 0; k < nSize; ++k) {
                OiiolTextLogger.appendText(vOrderedComps.elementAt(k).toString(), OiiolTextLogger.LOG_DETAILED);
            }
        }
        this.m_vSelList = vOrderedComps;
    }

    private void updatePlan(Vector vOrderedIEs) {
        OiicSessionPlan plan = this.m_pullSession.getSessionPlan();
        for (int i = 0; i < vOrderedIEs.size(); ++i) {
            OiiiInstallCompInvEntry invEntry = (OiiiInstallCompInvEntry)vOrderedIEs.elementAt(i);
            OiiiCompInstallID cid = invEntry.getCompInstallID();
            if (cid.getCompType() == 4) {
                plan.addPatchSet((OiiiPatchSetInstallID)cid, invEntry);
                continue;
            }
            plan.addAddition(cid, invEntry);
            plan.setAdditionPhase(cid, 10);
            if (!invEntry.isTopLevel()) continue;
            plan.addToTopLevelList(cid);
        }
    }

    private OiiiCompInstallID[] vectToCompIDArray(Vector vCompIDs) {
        OiiiCompInstallID[] aCompIDs = new OiiiCompInstallID[vCompIDs.size()];
        for (int i = 0; i < vCompIDs.size(); ++i) {
            aCompIDs[i] = (OiiiCompInstallID)vCompIDs.elementAt(i);
        }
        return aCompIDs;
    }

    public OiiiCompInstallID getParentPatchSetOfPatch(OiiiCompInstallID patchCompID) {
        OiiiPatchInstallID patchID = null;
        if (!(patchCompID instanceof OiiiPatchInstallID)) {
            return null;
        }
        patchID = (OiiiPatchInstallID)patchCompID;
        HashMap patchToPatchSetMapping = ((OiicLangAddonSession)this.m_pullSession).getPatchToPatchSetMapping();
        OiiiCompInstallID value = (OiiiCompInstallID)patchToPatchSetMapping.get(patchID);
        OiiiCompInstallID parentPatchSet = value == null ? null : value;
        return parentPatchSet;
    }

    public void updateActuallyUpgradedTLCList(OiiiCompInstallID tlcID) {
        int size = this.m_vTopLevelCompsActuallyUpgraded.size();
        boolean alreadyPresent = false;
        for (int i = 0; i < size; ++i) {
            OiiiCompInstallID cid = (OiiiCompInstallID)this.m_vTopLevelCompsActuallyUpgraded.elementAt(i);
            if (!cid.equals(tlcID)) continue;
            alreadyPresent = true;
        }
        if (!alreadyPresent) {
            this.m_vTopLevelCompsActuallyUpgraded.add(tlcID);
        }
    }
}

