/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifw;

import java.util.Enumeration;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifb.OiifbWizOperation;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifwLangAddonChecksWCCE
implements OiifbWizOperation {
    private OiisVariableOwner m_vo;
    private int m_nextInd;
    private boolean m_bErrorOccurred = false;

    public OiifwLangAddonChecksWCCE(OiisVariableOwner vo, int nextInd) {
        this.m_vo = vo;
        this.m_nextInd = nextInd;
    }

    @Override
    public void initialize() {
    }

    public int getNext() {
        return this.m_nextInd;
    }

    @Override
    public void dispose() {
        this.m_vo = null;
    }

    @Override
    public int doOperation(boolean isBack) throws OiifbEndIterateException {
        this.m_bErrorOccurred = false;
        if (isBack) {
            return 1;
        }
        try {
            this.checkAtLeastOneHomePresent();
        }
        catch (Exception e) {
            throw new OiifbEndIterateException(e.getMessage());
        }
        return this.m_bErrorOccurred ? 1 : 0;
    }

    private void checkAtLeastOneHomePresent() throws OiifbEndIterateException {
        OiicPullSession pSession = this.m_vo.getSession();
        OiiiInstallAreaControl iac = pSession.getInstallAreaControl();
        OiiiInstallInventory oInventory = iac.getInstallInventory();
        Vector vHomes = oInventory.getHomes();
        if (vHomes.size() < 1) {
            String msg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-25032");
            OiifmAlert.displayError(msg, OiixResourceBundle.getString("S_ERROR"), "OUI-25032");
            throw new OiifbEndIterateException(msg);
        }
    }

    private void checkAtLeastOneNonEmptyHomePresent() throws OiifbEndIterateException {
        OiicPullSession pSession = this.m_vo.getSession();
        OiiiInstallAreaControl iac = pSession.getInstallAreaControl();
        OiiiInstallInventory oInventory = iac.getInstallInventory();
        Vector vHomes = oInventory.getHomes();
        int nHomes = vHomes.size();
        boolean atLeastOneNonEmptyHome = false;
        for (int i = 0; i < nHomes && !atLeastOneNonEmptyHome; ++i) {
            OiiiOracleHomeInfo oInfo = (OiiiOracleHomeInfo)vHomes.elementAt(i);
            int ohIndex = oInfo.getIndex();
            Enumeration eAllComps = oInventory.getAllComps(ohIndex);
            if (!eAllComps.hasMoreElements()) continue;
            atLeastOneNonEmptyHome = true;
            break;
        }
        if (!atLeastOneNonEmptyHome) {
            String msg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-25033");
            OiifmAlert.displayError(msg, OiixResourceBundle.getString("S_ERROR"), "OUI-25033");
            throw new OiifbEndIterateException(msg);
        }
    }
}

