/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifw;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import oracle.sysman.oii.oiic.OiicInstallSession;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbCondWizOperation;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiil.OiilNativeException;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgBootstrap;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;
import oracle.sysman.oii.oiip.oiipg.OiipgOracleHomes;
import oracle.sysman.oii.oiis.OiisVarSettingException;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixInstallUtil;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixUtil;

public class OiifwInvLocWCCE
implements OiifbCondWizOperation {
    private OiisVariableOwner m_vo = null;
    private int m_nextIndInvSetupUser = -1;
    private int m_nextIndInvSetup = -1;
    private boolean m_bErrorOccured = false;
    private boolean m_bInvLocSet = false;
    private boolean m_bNewInventory = false;
    private String m_strNewInvLoc = null;
    private boolean m_bErrorInvalidInvPtrLoc = false;

    public OiifwInvLocWCCE(OiisVariableOwner vo, int nextIndInvSetupUser, int nextIndInvSetup) {
        this.m_vo = vo;
        this.m_nextIndInvSetupUser = nextIndInvSetupUser;
        this.m_nextIndInvSetup = nextIndInvSetup;
    }

    @Override
    public void initialize() {
        File invFileLoc;
        String invPtrLoc = System.getProperty("oracle.installer.invPtrLoc");
        if (OiiiInstallAreaControl.isCleanMachine()) {
            if (!OiixUtil.isNullOrBlank(invPtrLoc, true)) {
                this.m_bErrorInvalidInvPtrLoc = true;
            }
            if (OiicPullSession.isLangAddonMode()) {
                this.m_bErrorOccured = true;
                return;
            }
        }
        OiisVariable oInvLoc = this.m_vo.getVariable("INVENTORY_LOCATION");
        String sInvLoc = oInvLoc.getValueAsString();
        this.m_bInvLocSet = oInvLoc.getAdvice();
        if (this.m_strNewInvLoc != null && this.m_strNewInvLoc.equals(sInvLoc)) {
            return;
        }
        OiisVariable oUnixGrpName = this.m_vo.getVariable("UNIX_GROUP_NAME");
        String sUnixGrpName = oUnixGrpName.getValueAsString();
        if (OiixInstallUtil.isUnix() && (sUnixGrpName == null || sUnixGrpName.trim().length() <= 0)) {
            this.m_bNewInventory = true;
        }
        boolean isValidLocation = true;
        if (sInvLoc == null || sInvLoc.trim().length() <= 0) {
            isValidLocation = false;
        }
        if (!(invFileLoc = new File(OiixPathOps.getNativeForm(sInvLoc))).exists()) {
            isValidLocation = false;
        }
        if (isValidLocation || !OiiiInstallAreaControl.isCleanMachine()) {
            return;
        }
        if (!this.hasWritePermissions(sInvLoc)) {
            if (!OiicPullSession.isSilentMode()) {
                oInvLoc.setAdvice(false);
            } else {
                isValidLocation = false;
            }
        }
        this.m_strNewInvLoc = null;
        try {
            boolean b;
            if (sInvLoc != null && this.m_bInvLocSet && !OiiiInstallAreaControl.isCleanMachine()) {
                String[] sHomes = new String[]{};
                try {
                    sHomes = OiipgOracleHomes.getAllHomes();
                }
                catch (OiilNativeException oiilNativeException) {
                    // empty catch block
                }
                if (sHomes.length <= 0) {
                    return;
                }
                File fCentralInvLoc = null;
                try {
                    fCentralInvLoc = new File(sInvLoc).getCanonicalFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                for (int i = 0; i < sHomes.length; ++i) {
                    String sHomeLoc = sHomes[i];
                    File fHomeLoc = null;
                    try {
                        fHomeLoc = new File(sHomeLoc).getCanonicalFile();
                    }
                    catch (IOException e) {
                        this.m_bErrorOccured = true;
                        e.printStackTrace();
                        String sMsg = null;
                        if (OiixInstallUtil.isWindows()) {
                            String[] regHomeLocs = OiipgOracleHomes.getHomesFromRegistry();
                            int len = regHomeLocs == null ? 0 : regHomeLocs.length;
                            for (int j = 0; j < len; ++j) {
                                if (!sHomeLoc.equals(regHomeLocs[j])) continue;
                                sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFW1038", new Object[]{sHomeLoc});
                                break;
                            }
                        }
                        if (sMsg == null) {
                            sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFW1039", new Object[]{sHomeLoc});
                        }
                        OiifmAlert.displayError(sMsg);
                        return;
                    }
                    if (!OiipgFileSystem.isParentDirOf(fHomeLoc, fCentralInvLoc)) continue;
                    String sHomeInventory = OiixPathOps.concatPath(fHomeLoc.getAbsolutePath(), "inventory");
                    if (!fCentralInvLoc.equals(new File(sHomeInventory))) break;
                    String sNewInvLoc = this.getAvailableName(sHomeLoc, "central_inventory");
                    String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_INV_LOC_MOVE", new Object[]{sNewInvLoc});
                    OiiolTextLogger.appendText(sMsg);
                    this.closeStreams();
                    OiiolTextLogger.closeLog();
                    if (fCentralInvLoc.renameTo(new File(sNewInvLoc))) {
                        oInvLoc.setValue(sNewInvLoc, true);
                        this.m_strNewInvLoc = sNewInvLoc;
                    }
                    OiicInstallSession instSession = (OiicInstallSession)this.m_vo.getSession();
                    instSession.setAreaControls(sNewInvLoc);
                    instSession.setupDuplicateStreams();
                    break;
                }
            }
            if (!(b = this.setupInventoryLocation()) && !this.m_bNewInventory) {
                this.m_bErrorOccured = true;
                if (this.m_vo instanceof OiicSessionContext) {
                    OiicSessionContext.unsetResponseFile();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int doOperation(boolean isBack) throws OiifbEndIterateException {
        if (OiicPullSession.isLangAddonMode()) {
            if (isBack) {
                return 1;
            }
            if (this.m_bErrorOccured) {
                OiifmAlert.displayError(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-25025"));
                throw new OiifbEndIterateException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-25025"));
            }
            return 0;
        }
        String invPtrLoc = System.getProperty("oracle.installer.invPtrLoc");
        if (OiicPullSession.isSilentMode() && this.m_bErrorInvalidInvPtrLoc) {
            OiifmAlert.displayError(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_INVALID_INVPTRLOC", new String[]{invPtrLoc}));
            throw new OiifbEndIterateException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_INVALID_INVPTRLOC", new String[]{invPtrLoc}));
        }
        if (isBack) {
            if (this.m_bNewInventory) {
                OiisVariable oInvLoc = this.m_vo.getVariable("INVENTORY_LOCATION");
                oInvLoc.setAdvice(false);
            }
            OiisVariable unixGrpName = this.m_vo.getVariable("UNIX_GROUP_NAME");
            unixGrpName.setAdvice(false);
            return 1;
        }
        return this.m_bErrorOccured ? 1 : 0;
    }

    @Override
    public void dispose() {
    }

    @Override
    public int getNext() {
        return this.m_bNewInventory ? this.m_nextIndInvSetupUser : this.m_nextIndInvSetup;
    }

    @Override
    public String getName() {
        return OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_INVENTORY_LOC");
    }

    private boolean setupInventoryLocation() throws OiifbCancelException {
        boolean bUserChoice;
        OiisVariable oInvLoc = this.m_vo.getVariable("INVENTORY_LOCATION");
        String sInvLocation = oInvLoc.getValueAsString();
        this.m_bInvLocSet = oInvLoc.getAdvice();
        if (!this.m_bInvLocSet) {
            if (sInvLocation == null || sInvLocation.length() == 0) {
                this.setDefaultInvLocVar(oInvLoc);
            }
            this.m_bNewInventory = true;
        }
        String sInvLoc = (String)oInvLoc.getValue();
        if (OiicPullSession.isSilentMode()) {
            String sPath = OiixPathOps.concatPath(sInvLoc, "ContentsXML");
            File fContentsXML = new File(sPath);
            String useExistingInventory = System.getProperty("oracle.installer.useExistingInventory");
            if (!OiixInstallUtil.isWindows() && fContentsXML.exists() && fContentsXML.isDirectory() && !useExistingInventory.equalsIgnoreCase("true")) {
                this.m_bErrorOccured = true;
                return false;
            }
        }
        if (!(this.hasWritePermissions(sInvLoc) || (bUserChoice = this.askUserToSetPermissions(sInvLoc)) && this.hasWritePermissions(sInvLoc))) {
            if (!OiicPullSession.isSilentMode()) {
                this.setDefaultInvLocVar(oInvLoc);
                oInvLoc.setAdvice(false);
            }
            return false;
        }
        return this.m_bInvLocSet;
    }

    private void setDefaultInvLocVar(OiisVariable oInvLoc) throws OiifbCancelException {
        OiipgBootstrap pg = new OiipgBootstrap();
        String locationFileLoc = pg.getDefaultLocationFileLoc();
        try {
            locationFileLoc = OiixPathOps.getUnexpandedCanonicalPath(locationFileLoc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            oInvLoc.setValue(locationFileLoc, true);
            oInvLoc.setAdvice(true);
        }
        catch (OiisVarSettingException e) {
            e.printStackTrace();
        }
    }

    private boolean askUserToSetPermissions(String locationFile) {
        Object[] obj = new String[]{locationFile};
        String errString = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_INV_LOC_CREATE_ERR");
        errString = MessageFormat.format(errString, obj);
        String sTitle = OiixResourceBundle.getString("S_ERROR");
        int nRet = OiifmAlert.displayAlert(sTitle, errString, 50, 5, 4, 20);
        return nRet == 1;
    }

    private String getAvailableName(String sParentDir, String sProposedLoc) {
        String sLoc = OiixPathOps.concatPath(sParentDir, sProposedLoc);
        File f = new File(sLoc = OiixPathOps.getNativeForm(sLoc));
        if (f.exists()) {
            int i = 0;
            boolean bFound = false;
            String s = sLoc;
            while (!bFound) {
                s = sLoc + i;
                f = new File(s);
                if (!f.exists()) {
                    bFound = true;
                    continue;
                }
                ++i;
            }
            sLoc = s;
        }
        return sLoc;
    }

    private void closeStreams() {
        OiicInstallSession instSession = (OiicInstallSession)this.m_vo.getSession();
        instSession.resetStreams();
    }

    private boolean hasWritePermissions(String sLoc) {
        try {
            OiipgFileSystem.checkWritablePath(sLoc);
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }
}

