/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifw;

import java.text.MessageFormat;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicAPIInstaller;
import oracle.sysman.oii.oiic.OiicBaseApp;
import oracle.sysman.oii.oiic.OiicInstPostActionsPhase;
import oracle.sysman.oii.oiic.OiicInstallSession;
import oracle.sysman.oii.oiic.OiicInstaller;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifb.OiifbWizChainDlgElem;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixCFOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifwInstEndSessionWCDE
extends OiifbWizChainDlgElem {
    private OiicPullSession m_session = null;
    private OiicInstPostActionsPhase m_phase = null;
    private String[] m_readmeNames = null;
    private Vector m_toolNames = null;
    private boolean m_hasALtools = false;
    private boolean m_bSuccess = false;
    private boolean m_bToolSuccess = false;
    private boolean m_bRecToolSuccess = false;
    private String m_sDisplayName = null;
    public static final String s_panelClass = "oracle.sysman.oii.oiif.oiifp.OiifpWizEndPanel";

    public OiifwInstEndSessionWCDE(OiisVariableOwner vo, OiicInstPostActionsPhase phase, String[] readmeNames, Vector toolNames, boolean compHasALtools) {
        super(vo);
        this.m_session = vo.getSession();
        this.m_phase = phase;
        this.m_toolNames = toolNames;
        this.m_hasALtools = compHasALtools;
        this.setDisplayControlVariable("SHOW_END_SESSION_PAGE");
        if (this.m_session.isAddNodeMode()) {
            this.setHelpKey("S_OIIFW_ADDNODE_ENDPAGE_WCDE");
        } else {
            this.setHelpKey("OiifwInstEndSessionWCDE");
        }
        this.setWizPanelClassName(s_panelClass);
        this.setWizardPageID(OiicInstallSession.EXIT_SESSION_IND);
        OiisVariable v = this.m_session.getSessionContext().getVariable("SHOW_RELEASE_NOTES");
        Boolean bVal = (Boolean)v.getValue();
        this.m_readmeNames = bVal == null || bVal == false ? null : readmeNames;
        this.m_bSuccess = this.m_session.isSuccessfullInstallation();
        this.m_bToolSuccess = this.m_session.isSuccessfulOptionalTools();
        this.m_bRecToolSuccess = this.m_session.isSuccessfulRecommendedTools();
    }

    @Override
    public void setWizPanel() {
    }

    @Override
    public String getDisplayName() {
        if (this.m_sDisplayName == null) {
            String sSessionStr = null;
            if (this.m_session.isCloneMode()) {
                sSessionStr = OiixResourceBundle.getString("S_CLONING_CAP");
            }
            if (this.m_session.isAddNodeMode()) {
                sSessionStr = OiixResourceBundle.getString("S_ADDNODE");
            }
            OiifwInstEndSessionWCDE oiifwInstEndSessionWCDE = this;
            sSessionStr = oiifwInstEndSessionWCDE.m_session.isLangAddonMode() ? OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFW1016") : OiixResourceBundle.getString("S_INSTALLATION_CAP");
            this.m_sDisplayName = OiixResourceBundle.getString("S_END_SESSION", new Object[]{sSessionStr});
        }
        return this.m_sDisplayName;
    }

    @Override
    public void initialize() throws OiifbEndIterateException {
        super.initialize();
        OiisVariable oVar = this.m_varOwner.getVariable("NEXT_SESSION");
        Boolean bVal = (Boolean)oVar.getValue();
        this.m_bSuccess = this.m_session.isSuccessfullInstallation();
        this.m_bToolSuccess = this.m_session.isSuccessfulOptionalTools();
        this.m_bRecToolSuccess = this.m_session.isSuccessfulRecommendedTools();
        this.logStatus();
    }

    @Override
    public int doOperation(boolean isBack) throws OiifbEndIterateException {
        int retVal = super.doOperation(isBack);
        if (retVal != 1) {
            if (System.getProperty("oracle.installer.ouiApiMode", "false").equalsIgnoreCase("false")) {
                if (!this.m_session.isRebootInfoSet() && this.m_session.isSuccessfullInstallation() && this.m_session.isInstallMode()) {
                    ((OiicInstallSession)this.m_session).runOuica(true);
                }
                OiixCFOps.disconnectCfwClients();
                this.m_phase.saveConfigToolsXMLToNodes();
                this.doRebootOperations();
            }
            if (!OiicBaseApp.getAltInstallProps()) {
                OiicBaseApp o_oiicInstaller = null;
                o_oiicInstaller = System.getProperty("oracle.installer.ouiApiMode", "false").equalsIgnoreCase("true") ? OiicAPIInstaller.getHandleToAPIInstaller() : OiicInstaller.getOiicInstallerInstance();
                o_oiicInstaller.resetInstallProps();
            }
        }
        return retVal;
    }

    protected void logStatus() {
        String status = "";
        boolean isAPIMode = System.getProperty("oracle.installer.ouiApiMode", "false").equalsIgnoreCase("true");
        status = isAPIMode ? this.getAPISessionResultMessage() : this.getSessionResultMessage();
        boolean isGenSilentLogs = System.getProperty("oracle.installer.silentLogs", "false").equalsIgnoreCase("true");
        if (OiicPullSession.isSilentMode() || isGenSilentLogs) {
            OiiolTextLogger.writeMessageToConsole(status);
            OiiolTextLogger.appendErrorText(status, false);
            String sDet = OiixResourceBundle.getString("S_SILENT_INSTALL_DETAILS");
            Object[] objs = new String[]{this.m_session.isCloneMode() ? OiiolTextLogger.getCurLogFileName() : OiiolTextLogger.getErrorLogFileName()};
            sDet = MessageFormat.format(sDet, objs);
            OiiolTextLogger.writeMessageToConsole(sDet);
        }
        OiiolTextLogger.appendText(status, OiiolTextLogger.LOG_WITHOUT_LEVEL);
    }

    public Vector getToolNames() {
        return this.m_toolNames;
    }

    public String[] getReadmeNames() {
        return this.m_readmeNames;
    }

    public OiicInstPostActionsPhase getPostActionPhase() {
        return this.m_phase;
    }

    public boolean isInstallSuccess() {
        return this.m_bSuccess;
    }

    public boolean isToolSuccess() {
        return this.m_bToolSuccess;
    }

    public boolean isRecommendedToolSuccess() {
        return this.m_bRecToolSuccess;
    }

    public boolean hasALTools() {
        return this.m_hasALtools;
    }

    public String getAPISessionResultMessage() {
        OiisVariable homeNameVar;
        String sessionStr = null;
        String targetStr = null;
        if (this.m_session.isCloneMode()) {
            sessionStr = OiixResourceBundle.getString("S_CLONING");
            homeNameVar = this.m_session.getSessionContext().getVariable("ORACLE_HOME_NAME");
            targetStr = (String)homeNameVar.getValue();
        } else if (this.m_session.isAddNodeMode()) {
            sessionStr = OiixResourceBundle.getString("S_ADDNODE");
            homeNameVar = this.m_session.getSessionContext().getVariable("ORACLE_HOME");
            targetStr = (String)homeNameVar.getValue();
            this.m_bSuccess = this.m_session.isRemoteOperationSuccessful();
        } else {
            OiifwInstEndSessionWCDE oiifwInstEndSessionWCDE = this;
            if (oiifwInstEndSessionWCDE.m_session.isLangAddonMode()) {
                sessionStr = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFW1016");
                targetStr = OiixResourceBundle.getString("S_SEL_PRODS");
                this.m_bSuccess = true;
            } else {
                sessionStr = OiixResourceBundle.getString("S_INSTALLATION");
                OiiiCompInstallID[] cids = this.m_session.getSelTopLevelCompIDs();
                targetStr = cids.length > 1 ? OiixResourceBundle.getString("S_SEL_PRODS") : this.m_session.getStgCompName(cids[0]);
            }
        }
        String status = null;
        status = this.m_bSuccess ? (!this.m_session.isRemoteOperationSuccessful() ? OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFW1203") : OiixResourceBundle.getString("S_SESSION_SUCCESS")) : OiixResourceBundle.getString("S_SESSION_FAILURE");
        Object[] arr = new String[]{sessionStr, targetStr};
        status = MessageFormat.format(status, arr);
        return status;
    }

    public String getSessionResultMessage() {
        OiisVariable homeNameVar;
        String sessionStr = null;
        String targetStr = null;
        if (this.m_session.isCloneMode()) {
            sessionStr = OiixResourceBundle.getString("S_CLONING");
            homeNameVar = this.m_session.getSessionContext().getVariable("ORACLE_HOME_NAME");
            targetStr = (String)homeNameVar.getValue();
        } else if (this.m_session.isAddNodeMode()) {
            sessionStr = OiixResourceBundle.getString("S_ADDNODE");
            homeNameVar = this.m_session.getSessionContext().getVariable("ORACLE_HOME");
            targetStr = (String)homeNameVar.getValue();
            this.m_bSuccess = this.m_session.isRemoteOperationSuccessful();
            this.m_bToolSuccess = true;
            this.m_bRecToolSuccess = true;
        } else {
            OiifwInstEndSessionWCDE oiifwInstEndSessionWCDE = this;
            if (oiifwInstEndSessionWCDE.m_session.isLangAddonMode()) {
                sessionStr = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFW1016");
                targetStr = OiixResourceBundle.getString("S_SEL_PRODS");
                this.m_bSuccess = true;
                this.m_bToolSuccess = true;
                this.m_bRecToolSuccess = true;
            } else {
                sessionStr = OiixResourceBundle.getString("S_INSTALLATION");
                OiiiCompInstallID[] cids = this.m_session.getSelTopLevelCompIDs();
                targetStr = cids.length > 1 ? OiixResourceBundle.getString("S_SEL_PRODS") : this.m_session.getStgCompName(cids[0]);
            }
        }
        String status = null;
        if (this.m_bSuccess) {
            if (!this.m_session.isRemoteOperationSuccessful()) {
                status = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFW1203");
            } else if (this.m_bToolSuccess && this.m_bRecToolSuccess) {
                status = OiixResourceBundle.getString("S_SESSION_SUCCESS");
            } else if (!this.m_bToolSuccess || !this.m_bRecToolSuccess) {
                status = OiixResourceBundle.getString("S_SESSION_SUCCESS_MINUS_CONFIGTOOLS");
            }
        } else {
            status = OiixResourceBundle.getString("S_SESSION_FAILURE");
        }
        Object[] arr = new String[]{sessionStr, targetStr};
        status = MessageFormat.format(status, arr);
        return status;
    }

    private void doRebootOperations() {
        if (this.m_session.isRebootInfoSet()) {
            OiicSessionInterfaceManager osim = OiicSessionInterfaceManager.getInterfaceManager();
            osim.doRebootOperations();
        }
    }
}

