/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifw;

import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiif.oiifw.OiifwBaseHomeSetupWCCE;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiil.OiilNativeException;
import oracle.sysman.oii.oiin.OiinNetOps;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgOracleHomes;
import oracle.sysman.oii.oiip.oiipg.OiipgRegistryException;
import oracle.sysman.oii.oiis.OiisVarSettingException;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixInstallUtil;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixUtil;
import oracle.sysman.oii.oiix.OiixWinSecurityOps;

class OiifwHomeSetupWCCE
extends OiifwBaseHomeSetupWCCE {
    OiifwHomeSetupWCCE(OiisVariableOwner oVarOwner) {
        super(oVarOwner);
    }

    @Override
    public int doOperation(boolean isBack) throws OiifbEndIterateException {
        int retVal = 0;
        if (!isBack) {
            if (OiixInstallUtil.isOptionSet("oracle.installer.addLangs")) {
                return retVal;
            }
            OiiolTextLogger.appendText("HomeSetup JRE files in Scratch :" + OiixFileOps.countFiles(System.getProperties().getProperty("oracle.installer.scratchPath") + "/jre"));
            OiisVariable ohVar = this.m_oVarOwner.getVariable("ORACLE_HOME");
            String oracleHomeString = (String)ohVar.getValue();
            if (!OiixInstallUtil.isOptionSet("oracle.installer.skipACLSetting")) {
                try {
                    String oh = OiixPathOps.getNativeForm(oracleHomeString);
                    boolean isAdmin = OiixInstallUtil.isOptionSet("oracle.installer.oh_admin_acl");
                    OiixWinSecurityOps.setPermissions(oh, isAdmin);
                }
                catch (OiilNativeException err) {
                    OiiolTextLogger.appendException(err);
                }
            }
            OiicPullSession instSession = this.m_oVarOwner.getSession();
            instSession.getPgActionsPhase().initialize();
            OiiiInstallInventory inv = instSession.getInstallAreaControl().getInstallInventory();
            OiiiOracleHomeInfo oldOHInfo = inv.getHomeWithLocation(oracleHomeString);
            String oldGUIDVal = oldOHInfo.getGUID();
            if (this.requireGUIDRecalculation(instSession, oldGUIDVal)) {
                String newGUIDVal = this.calculateGUIDValue(instSession, oracleHomeString);
                oldOHInfo.setGUID(newGUIDVal);
                oldOHInfo.setGUIDValueResetRequired(true);
            }
            if (this.is10gRegistrySetupRequired()) {
                try {
                    OiipgOracleHomes.setup10gStyleRegEntries(this.getHomeKey(), this.getRegKeys(), this.getRegKeyValues());
                }
                catch (OiipgRegistryException e) {
                    OiifmAlert.displayError(e.getErrorMessage());
                }
            }
            OiisVariable oRootShLoc = this.m_oVarOwner.getVariable("ROOTSH_LOCATION");
            try {
                oRootShLoc.setValue(OiixPathOps.getNativeForm(OiixPathOps.concatPath(oracleHomeString, "root.sh")));
            }
            catch (OiisVarSettingException e) {
                OiiolTextLogger.appendException(e);
            }
            catch (OiifbCancelException e) {
                OiiolTextLogger.appendException(e);
            }
        }
        return retVal;
    }

    @Override
    public void dispose() {
    }

    public boolean requireGUIDRecalculation(OiicPullSession psession, String oldGUIDVal) {
        boolean isGUIDEmpty = OiixUtil.isNullOrBlank(oldGUIDVal, true);
        boolean isClone = psession.isCloneMode();
        if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
            OiiolTextLogger.appendText("OiifwHomeSetupWCCE : GUID : values of recalculation parameters  :oldGUIDVal:" + oldGUIDVal + ":" + isGUIDEmpty + isClone, OiiolTextLogger.LOG_DETAILED);
        }
        return isGUIDEmpty || isClone;
    }

    public String calculateGUIDValue(OiicPullSession psession, String homeloc) {
        String ip = OiinNetOps.getNetOps().getHostAddress();
        String sLocalNode = null;
        OiisVariable localNode = psession.getSessionContext().getVariable("LOCAL_NODE");
        Object oLocalNode = localNode.getValue();
        sLocalNode = oLocalNode != null && oLocalNode instanceof String ? (String)oLocalNode : " ";
        String sGUID = OiiiOracleHomeInfo.calculateGUIDValue(ip, homeloc, sLocalNode);
        return sGUID;
    }
}

