/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifw;

import java.io.IOException;
import java.util.List;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.InvalidNodeListException;
import oracle.ops.mgmt.cluster.SharedDeviceException;
import oracle.sysman.oii.oiic.OiicClusterInstallInfo;
import oracle.sysman.oii.oiic.OiicIClusterNode;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifb.OiifbWizOperation;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgCFSDriveCheck;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterInvSetup;
import oracle.sysman.oii.oiip.oiipg.OiipgDetectCluster;
import oracle.sysman.oii.oiip.oiipg.OiipgPropertyLoader;
import oracle.sysman.oii.oiip.oiipg.OiipgRemoteOpsException;
import oracle.sysman.oii.oiis.OiisAdvisedValue;
import oracle.sysman.oii.oiis.OiisVarSettingException;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixOraparam;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifwClusterSessionVarWCCE
implements OiifbWizOperation {
    private static final boolean s_debug = false;
    private OiisVariableOwner m_vo;
    private OiicSessionInterfaceManager m_interfaceManager = null;
    private final String m_sLineSeparator = System.getProperty("line.separator", "\n");

    public OiifwClusterSessionVarWCCE(OiisVariableOwner vo) {
        this.m_vo = vo;
    }

    @Override
    public void initialize() {
        this.m_interfaceManager = OiicSessionInterfaceManager.getInterfaceManager();
    }

    @Override
    public int doOperation(boolean isBack) throws OiifbEndIterateException {
        block44: {
            String boolVal;
            boolean ignoreSharedInventory = false;
            if (System.getProperty("oracle.installer.ignoreSharedInventory") != null && (boolVal = System.getProperty("oracle.installer.ignoreSharedInventory")).equalsIgnoreCase("true")) {
                ignoreSharedInventory = true;
            }
            String metalink_loc = null;
            if (OiixOraparam.getOraparamProfileString("METALINK_NOTE_FOR_SHARED_INVENTORY", null) != null) {
                metalink_loc = OiixOraparam.getOraparamProfileString("METALINK_NOTE_FOR_SHARED_INVENTORY", null);
            }
            if (isBack) {
                if (Boolean.getBoolean("oracle.srvm.formCluster")) {
                    try {
                        String[] oEmptyArray = new String[]{};
                        OiisVariable oNodeNames = this.m_vo.getVariable("CLUSTER_NODES");
                        oNodeNames.setValue(oEmptyArray);
                        OiicClusterInstallInfo clusterInfo = OiicClusterInstallInfo.getClusterInstallInfo();
                        clusterInfo.setClusterNodes(oEmptyArray);
                        OiisVariable oLocalNodeVar = this.m_vo.getVariable("LOCAL_NODE");
                        oLocalNodeVar.setValue("");
                        OiisVariable oRemoteNodesVar = this.m_vo.getVariable("REMOTE_NODES");
                        oRemoteNodesVar.setValue(oEmptyArray);
                        OiisVariable oRemoteCleanMachinesVar = this.m_vo.getVariable("REMOTE_CLEAN_MACHINES");
                        oRemoteCleanMachinesVar.setValue(oEmptyArray);
                    }
                    catch (OiisVarSettingException oOvse) {
                        OiiolTextLogger.appendException(oOvse);
                    }
                    catch (OiifbCancelException oOce) {
                        OiiolTextLogger.appendException(oOce);
                    }
                }
                return 1;
            }
            boolean bIsClone = false;
            if (OiixFunctionOps.isCloneMode().booleanValue()) {
                bIsClone = true;
            }
            boolean isAPI = System.getProperty("oracle.installer.ouiApiMode", "false").equalsIgnoreCase("true");
            OiiolTextLogger.appendText("oracle.srvm.formCluster:" + Boolean.getBoolean("oracle.srvm.formCluster"));
            if (!(Boolean.getBoolean("oracle.srvm.formCluster") || bIsClone && isAPI)) {
                return 0;
            }
            try {
                OiisVariable oNodeNames = this.m_vo.getVariable("CLUSTER_NODES");
                String clusterNodes = System.getProperty("oracle.installer.clusterlist");
                if (clusterNodes == null && oNodeNames != null && oNodeNames.getValue() != null) {
                    String[] cNodes = (String[])oNodeNames.getValue();
                    clusterNodes = OiixFunctionOps.implodeList(cNodes, "|");
                    if (cNodes.length > 0) {
                        System.setProperty("oracle.installer.clusterlist", clusterNodes);
                    }
                }
                if (clusterNodes == null || clusterNodes.trim().length() <= 0) break block44;
                if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_TRACE) {
                    OiiolTextLogger.appendText("clusterlist = " + clusterNodes + "\n", OiiolTextLogger.LOG_TRACE);
                }
                String[] clusterNodesArr = OiixFunctionOps.explodeString(clusterNodes, "|");
                oNodeNames.setValue(clusterNodesArr);
                OiipgDetectCluster detectCluster = OiipgDetectCluster.getDetectCluster();
                detectCluster.setLocalNodeName(clusterNodesArr[0]);
                OiisVariable oLocalNodeVar = this.m_vo.getVariable("LOCAL_NODE");
                oLocalNodeVar.setValue(clusterNodesArr[0], true);
                String[] allNodes = clusterNodesArr;
                String[] asRemoteNodes = OiixFunctionOps.subtractStr(clusterNodesArr, clusterNodesArr[0], false);
                OiisVariable oRemoteNodesVar = this.m_vo.getVariable("REMOTE_NODES");
                if (!bIsClone) {
                    oRemoteNodesVar.setValue(asRemoteNodes, true);
                } else {
                    String[] oEmptyArray = new String[]{};
                    oRemoteNodesVar.setValue(oEmptyArray);
                }
                String sInvLoc = (String)this.m_vo.getVariable("INVENTORY_LOCATION").getValue();
                OiicClusterInstallInfo clusterInfo = OiicClusterInstallInfo.getClusterInstallInfo();
                clusterInfo.setClusterNodes(clusterNodesArr);
                OiisVariable ohNameVar = this.m_vo.getVariable("ORACLE_HOME");
                String sOhPath = (String)ohNameVar.getValue();
                if ((sInvLoc == null || sInvLoc.equalsIgnoreCase("")) && System.getProperty("oracle.installer.invPtrLoc") != null) {
                    String InvLoc = System.getProperty("oracle.installer.invPtrLoc");
                    OiipgPropertyLoader iPropLoad = new OiipgPropertyLoader();
                    try {
                        sInvLoc = OiipgPropertyLoader.getLocationFileLoc(InvLoc);
                    }
                    catch (IOException e) {
                        System.err.println(e.getMessage());
                    }
                }
                if (!(ignoreSharedInventory || allNodes.length <= 1 || sInvLoc == null && sInvLoc.equalsIgnoreCase(""))) {
                    try {
                        String sLocalNode = (String)oLocalNodeVar.getValue();
                        if (Cluster.isSharedPath((String)sInvLoc, (String[])allNodes, (String)sLocalNode)) {
                            String sTitle = OiixResourceBundle.getString("OIIFW1002");
                            Object[] args1 = new String[2];
                            args1[0] = sInvLoc;
                            Object[] args2 = new String[1];
                            args1[0] = sInvLoc;
                            if (metalink_loc != null) {
                                args2[0] = metalink_loc;
                            }
                            StringBuffer sb = new StringBuffer("");
                            sb.append(OiixResourceBundle.getString("S_INVENTORY_SHARED_ERROR_DESCRIPTION", args1));
                            if (metalink_loc != null) {
                                sb.append(OiixResourceBundle.getString("S_INVENTORY_SHARED_ERROR_DESCRIPTION2", args2));
                            }
                            if (!OiicPullSession.isSilentMode()) {
                                sb.append(OiixResourceBundle.getString("S_CONTINUE"));
                            }
                            int result = OiifmAlert.displayAlert(sTitle, sb.toString(), 30, 3, 2, 10);
                            OiiolTextLogger.appendText(sb.toString());
                            if (result == 2) {
                                return 1;
                            }
                        }
                    }
                    catch (SharedDeviceException e) {
                        OiiolTextLogger.appendException(e);
                    }
                    catch (InvalidNodeListException e) {
                        OiiolTextLogger.appendException(e);
                    }
                }
                if (sOhPath != null) {
                    OiiiInstallAreaControl oAreaControl;
                    OiiiInstallInventory oInventory;
                    OiipgCFSDriveCheck oCFSDriveCheck = OiipgCFSDriveCheck.getCFSDriveChecker();
                    boolean bOHOnCFS = false;
                    if (bIsClone) {
                        if (Boolean.getBoolean("oracle.installer.cfs")) {
                            bOHOnCFS = true;
                        }
                    } else {
                        bOHOnCFS = oCFSDriveCheck.isDriveOnCFS(sOhPath);
                    }
                    if ((oInventory = (oAreaControl = OiiiInstallAreaControl.getInstallAreaControl()).getInstallInventory()) != null) {
                        OiiiOracleHomeInfo oInfo = oInventory.getHomeWithLocation(sOhPath);
                        oInfo.setNodeList(clusterNodesArr);
                        if (!bOHOnCFS) {
                            oInfo.setLocalNode(clusterNodesArr[0]);
                        }
                    }
                }
                String[] asCleanMachines = OiipgClusterInvSetup.getCleanMachines(asRemoteNodes);
                try {
                    String[] oEmptyArray;
                    OiisVariable oRemoteCleanMachinesVar = this.m_vo.getVariable("REMOTE_CLEAN_MACHINES");
                    if (asCleanMachines != null && asCleanMachines.length > 0) {
                        if (!bIsClone) {
                            oRemoteCleanMachinesVar.setValue(new OiisAdvisedValue(asCleanMachines, true));
                        } else {
                            oEmptyArray = new String[]{};
                            oRemoteCleanMachinesVar.setValue(oEmptyArray);
                        }
                    } else {
                        oEmptyArray = new String[]{};
                        oRemoteCleanMachinesVar.setValue(oEmptyArray);
                    }
                }
                catch (OiifbCancelException e) {
                    OiiolTextLogger.appendException(e);
                }
                catch (OiisVarSettingException e) {
                    OiiolTextLogger.appendException(e);
                }
                if (asRemoteNodes.length > 0) {
                    StringBuffer sb = new StringBuffer(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFW1014"));
                    sb.append(this.m_sLineSeparator);
                    sb.append(this.getNodeStatus(clusterInfo, asRemoteNodes));
                    sb.append(this.m_sLineSeparator);
                    sb.append(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFW1013"));
                    sb.append(this.m_sLineSeparator);
                    OiiolTextLogger.appendText(sb.toString());
                    String[] asNodesWithErrors = clusterInfo.getNodesWithErrors(asRemoteNodes);
                    if (asNodesWithErrors != null && asNodesWithErrors.length > 0) {
                        Object[] args = new String[]{OiixFunctionOps.implodeList(asNodesWithErrors, ",")};
                        String sNodesErrorMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLUSTER_NODES_INV_CHECK_DESC", args);
                        int iAlertType = 20;
                        int iButtons = 1;
                        int iDefaultBtn = 1;
                        String sTitle = OiixResourceBundle.getString("OIIFW1002");
                        OiifmAlert.displayAlert(sTitle, sNodesErrorMsg, iAlertType, iButtons, iDefaultBtn);
                        return 1;
                    }
                }
            }
            catch (OiisVarSettingException oiisVarSettingException) {
            }
            catch (OiifbCancelException oiifbCancelException) {
                // empty catch block
            }
        }
        return 0;
    }

    private void checkInventoryPermissions(String sInvLoc, OiicClusterInstallInfo clusterInfo, String[] asNodes) throws OiipgRemoteOpsException {
        String sLogMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFW1010");
        OiiolTextLogger.appendText(sLogMsg);
        OiipgClusterInvSetup.performInventoryPermissionsTestOnNodes(sInvLoc, clusterInfo, asNodes);
    }

    private String getNodeStatus(OiicClusterInstallInfo clusterInfo, String[] nodes) {
        StringBuffer sb = new StringBuffer("");
        if (nodes != null && nodes.length > 0) {
            for (int i = 0; i < nodes.length; ++i) {
                sb.append(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFW1011", new String[]{nodes[i]}));
                sb.append(this.m_sLineSeparator);
                OiicIClusterNode oNode = clusterInfo.getNode(nodes[i]);
                if (!oNode.isAvailable()) {
                    List oErrList = oNode.getAvailabilityErrorList();
                    int iSize = oErrList.size();
                    for (int j = 0; j < iSize; ++j) {
                        sb.append(oErrList.get(j));
                        sb.append(this.m_sLineSeparator);
                    }
                    continue;
                }
                sb.append(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFW1012"));
                sb.append(this.m_sLineSeparator);
            }
        }
        return sb.toString();
    }

    @Override
    public void dispose() {
    }
}

