/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifw;

import java.io.IOException;
import java.util.ArrayList;
import oracle.sysman.oii.oiic.OiicAttachHome;
import oracle.sysman.oii.oiic.OiicExitCode;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiic.OiicUpdateNodeList;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifb.OiifbWizOperation;
import oracle.sysman.oii.oiif.oiifr.OiifrProgressActionListener;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgCFSDriveCheck;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterOps;
import oracle.sysman.oii.oiip.oiipg.OiipgRemoteOpsException;
import oracle.sysman.oii.oiis.OiisVarSettingException;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiifwClusterSaveInventoryWCCE
implements OiifbWizOperation {
    private int m_nextInd;
    private OiicSessionInterfaceManager m_interfaceManager = OiicSessionInterfaceManager.getInterfaceManager();
    private OiicPullSession m_session;

    public OiifwClusterSaveInventoryWCCE(OiicPullSession oSession, int nextInd) {
        this.m_nextInd = nextInd;
        this.m_session = oSession;
    }

    @Override
    public void initialize() throws OiifbEndIterateException {
    }

    @Override
    public int doOperation(boolean isBack) throws OiifbEndIterateException {
        OiicSessionContext sc = this.m_session.getSessionContext();
        String[] remoteList = (String[])sc.getVarValue("REMOTE_NODES");
        String localNode = (String)sc.getVarValue("LOCAL_NODE");
        if (remoteList != null && remoteList.length > 0 && localNode != null) {
            String progMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLUSTER_SAVE_INV");
            OiiolTextLogger.appendText(progMessage);
            OiifrProgressActionListener progressListener = (OiifrProgressActionListener)this.m_interfaceManager.getProgressListener();
            if (progressListener != null) {
                progressListener.onStartPhase(1024);
                progressListener.setStatus(progMessage);
            }
            OiiiInstallAreaControl oAreaControl = (OiiiInstallAreaControl)OiiiInstallAreaControl.getInventoryAreaControl();
            try {
                OiicSessionInterfaceManager osim;
                OiipgCFSDriveCheck cfsDriveCheck = OiipgCFSDriveCheck.getCFSDriveChecker();
                boolean bCFS = cfsDriveCheck.isDriveOnCFS(oAreaControl.getAreaRoot());
                if (!bCFS && (osim = OiicSessionInterfaceManager.getInterfaceManager()) != null) {
                    this.addNodeAndSaveInventory(remoteList, localNode, oAreaControl, cfsDriveCheck);
                }
            }
            catch (IOException e) {
                OiicExitCode.setExitCode(-1);
                this.m_session.setSuccessfullInstallation(false);
                OiiolTextLogger.appendException(e);
            }
            catch (OiifbCancelException e) {
                OiicExitCode.setExitCode(-1);
                this.m_session.setSuccessfullInstallation(false);
                OiiolTextLogger.appendException(e);
            }
            if (progressListener != null) {
                progressListener.addPercentage(1);
                progressListener.onDonePhase(1024);
            }
        }
        return 0;
    }

    private void addNodeAndSaveInventory(String[] remoteList, String localNode, OiiiInstallAreaControl oAreaControl, OiipgCFSDriveCheck cfsDriveCheck) throws OiifbCancelException, IOException {
        OiicSessionContext sc = this.m_session.getSessionContext();
        String sOracleHome = (String)sc.getVarValue("ORACLE_HOME");
        String sOracleHomeName = (String)sc.getVarValue("ORACLE_HOME_NAME");
        boolean mbCRS = false;
        OiiiInstallInventory oInventory = oAreaControl.getInstallInventory();
        OiiiOracleHomeInfo oInfo = oInventory.getHomeWithLocation(sOracleHome);
        if (oInfo.isCRSHome()) {
            mbCRS = true;
        }
        String sCustomInvPtrLoc = this.setupRemoteCleanMachine(sc);
        OiicUpdateNodeList updateNL = OiicUpdateNodeList.getOiicUpdateNodeListInstance();
        OiicAttachHome oAttachHome = OiicAttachHome.getOiicAttachHomeInstance();
        OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
        boolean bSharedHome = cfsDriveCheck.isDriveOnCFS(sOracleHome);
        boolean bGenerateGUID = Boolean.getBoolean("oracle.installer.generateGUID");
        String[] clusterList = (String[])sc.getVarValue("CLUSTER_NODES");
        String invLoc = (String)sc.getVarValue("INVENTORY_LOCATION");
        if (this.m_session.isInstallMode()) {
            if (oInfo.wasCreatedInThisSession()) {
                if (bSharedHome) {
                    bGenerateGUID = false;
                }
                oAttachHome.clsCmdAttachHome(clusterList, remoteList, sOracleHome, sOracleHomeName, mbCRS, localNode, invLoc, sCustomInvPtrLoc, bSharedHome, bGenerateGUID);
            } else if (!bSharedHome && oInfo.isDirty(256L)) {
                updateNL.clsCmdUpdateNodeList(clusterList, remoteList, sOracleHome, sOracleHomeName, mbCRS, localNode, invLoc, sCustomInvPtrLoc, bSharedHome, true);
            }
        } else if (this.m_session.isAddNodeMode()) {
            OiicExitCode.setExitCode(0);
            if (bSharedHome) {
                bGenerateGUID = false;
            }
            oAttachHome.clsCmdAttachHome(clusterList, remoteList, sOracleHome, sOracleHomeName, mbCRS, localNode, invLoc, sCustomInvPtrLoc, bSharedHome, bGenerateGUID);
            oInfo.setDirty(true);
            oInfo.setNodeList(clusterList);
            if (bSharedHome) {
                oInfo.setLocalNode(null);
            }
            iac.saveInstallInventory();
            if (this.m_session.isSuccessDefaulted()) {
                this.m_session.setSuccessfullInstallation(true);
            }
            if (this.m_session.isAddNodeMode()) {
                iac.releaseWriterLock();
                iac.releaseReaderLock();
            }
        }
    }

    private String setupRemoteCleanMachine(OiicSessionContext sc) throws OiifbCancelException {
        OiisVariable oRemoteCleanMachines = sc.getVariable("REMOTE_CLEAN_MACHINES");
        String[] rcm = (String[])oRemoteCleanMachines.getValue();
        String sCustomInvPtrLoc = null;
        if (rcm != null && rcm.length > 0 && (sCustomInvPtrLoc = System.getProperty("oracle.installer.invPtrLoc", "")) != null && sCustomInvPtrLoc.trim().length() > 0) {
            rcm = this.setupRemoteInvPtrLoc(rcm, sCustomInvPtrLoc);
            try {
                if (!this.m_session.isAddNodeMode()) {
                    oRemoteCleanMachines.setValue(rcm, true);
                }
            }
            catch (OiisVarSettingException e) {
                OiiolTextLogger.appendException(e);
            }
        }
        return sCustomInvPtrLoc;
    }

    @Override
    public void dispose() {
    }

    public int getNext() {
        return this.m_nextInd;
    }

    private String[] setupRemoteInvPtrLoc(String[] asNodes, String sLoc) {
        ArrayList<String> oCleanNodes = new ArrayList<String>();
        for (int i = 0; i < asNodes.length; ++i) {
            try {
                OiipgClusterOps.transferFileToNode(sLoc, asNodes[i], sLoc);
                continue;
            }
            catch (OiipgRemoteOpsException e) {
                OiiolTextLogger.appendText(e.getErrorMessage());
                oCleanNodes.add(asNodes[i]);
            }
        }
        return OiixVectorOps.list2StrArr(oCleanNodes);
    }
}

