/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifw;

import oracle.sysman.oii.oiic.OiicInstallTimeSession;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifb.OiifbWizOperation;
import oracle.sysman.oii.oiif.oiifr.OiifrProgressActionListener;
import oracle.sysman.oii.oiif.oiifw.OiifwActionsPhaseWCDE;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterExecution;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterRunCmd;
import oracle.sysman.oii.oiip.oiipg.OiipgRemoteOpsException;
import oracle.sysman.oii.oiix.OiixDebug;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixOraparam;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixUtilityOps;

public class OiifwClusterRemoteOpsWCCE
implements OiifbWizOperation {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 1024;
    private String[] m_clusterList = null;
    private OiifwActionsPhaseWCDE actionsPhase;
    private OiifrProgressActionListener m_progressListener;
    private OiicSessionInterfaceManager m_interfaceManager;
    private OiicInstallTimeSession m_instSession;
    private int m_nextInd;

    public OiifwClusterRemoteOpsWCCE(OiifwActionsPhaseWCDE actionsPhase) {
        this.m_instSession = actionsPhase.getInstallSession();
        this.m_interfaceManager = OiicSessionInterfaceManager.getInterfaceManager();
    }

    public OiifwClusterRemoteOpsWCCE(int nextInd) {
        this.m_interfaceManager = OiicSessionInterfaceManager.getInterfaceManager();
        this.m_instSession = this.m_interfaceManager.getSession();
        this.m_nextInd = nextInd;
    }

    @Override
    public void initialize() throws OiifbEndIterateException {
    }

    @Override
    public int doOperation(boolean isBack) throws OiifbEndIterateException {
        int curPlatId;
        int curPlatGroup;
        String[] clusterList;
        this.m_progressListener = (OiifrProgressActionListener)this.m_interfaceManager.getProgressListener();
        if (this.m_instSession.isAddNodeMode()) {
            this.m_progressListener.onStartPhase(512);
        }
        if ((clusterList = (String[])this.m_instSession.getSessionContext().getVarValue("REMOTE_NODES")) != null && clusterList.length > 0 && (curPlatGroup = OiixPlatform.getPlatGroup(curPlatId = OiixPlatform.getCurrentPlatform())) == -3) {
            this.isVC8Installed(clusterList);
        }
        if (clusterList != null && clusterList.length > 0) {
            String sNodeList = OiixFunctionOps.implodeList(clusterList, ",");
            Object[] saArgs = new String[]{sNodeList};
            String str = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_START_REMOTE_OPERATIONS", saArgs);
            OiiolTextLogger.appendText(str, OiiolTextLogger.LOG_BASIC);
            OiipgClusterExecution clusterPlatExec = OiipgClusterExecution.getClusterExecutionObj(this.m_instSession, this.m_progressListener);
            if (OiixDebug.PRINT_MEMORY) {
                OiixDebug.printMemory("Remote operations start. : ", System.currentTimeMillis());
            }
            clusterPlatExec.executeClusterActions(clusterList);
            if (OiixDebug.PRINT_MEMORY) {
                OiixDebug.printMemory("Remote operations end. : ", System.currentTimeMillis());
            }
        }
        if (this.m_instSession.isAddNodeMode()) {
            this.m_progressListener.onDonePhase(512);
        }
        return 0;
    }

    @Override
    public void dispose() {
    }

    private void isVC8Installed(String[] clusterList) {
        String MSVCREDIST_INSTALL = OiixOraparam.getOraparamProfileString("MSVCREDIST_INSTALL", "false");
        String serviceNameIfWindows = "OracleOUIVC8Service";
        String cmdToRun = "";
        if (MSVCREDIST_INSTALL.equalsIgnoreCase("true")) {
            if (OiixUtilityOps.geVC8CommandLine() == null) {
                OiiolTextLogger.appendText("OUI not installing VC8 as commandline is not available for VC8 runtime");
                return;
            }
            cmdToRun = OiixUtilityOps.geVC8CommandLine();
            OiiolTextLogger.appendText("OUI using runAnyCmdOnNodes functionality from srvm to install VC8 runtime on this cluster.");
            OiiolTextLogger.appendText("command to run is  " + cmdToRun);
            try {
                new OiipgClusterRunCmd().runAnyCmdOnNodes(cmdToRun, clusterList, serviceNameIfWindows);
            }
            catch (OiipgRemoteOpsException e) {
                OiiolTextLogger.appendException(e);
            }
        } else {
            OiiolTextLogger.appendText("MSVCREDIST_INSTALL is not set to true from oraparam.ini. Not installing VC8 runtime now.");
        }
    }
}

