/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifw;

import java.util.Vector;
import oracle.sysman.oii.oiif.oiifb.OiifbCondWizOperation;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgDetectCluster;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiifwClusterHostNameCheckWCCE
implements OiifbCondWizOperation {
    private int m_nextInd;
    private OiisVariableOwner m_vo;
    private String[] m_nodeList;
    private String m_oracleHome;

    public OiifwClusterHostNameCheckWCCE(OiisVariableOwner vo, int nextInd) {
        this.m_vo = vo;
        this.m_nextInd = nextInd;
    }

    @Override
    public void initialize() throws OiifbEndIterateException {
    }

    @Override
    public void dispose() {
    }

    @Override
    public int doOperation(boolean back) throws OiifbEndIterateException {
        if (back) {
            return 1;
        }
        OiisVariable oOhPath = this.m_vo.getVariable("ORACLE_HOME");
        this.m_oracleHome = (String)oOhPath.getValue();
        OiiiInstallAreaControl oAreaControl = OiiiInstallAreaControl.getInstallAreaControl();
        OiiiInstallInventory oInventory = oAreaControl.getInstallInventory();
        OiiiOracleHomeInfo oInfo = oInventory.getHomeWithLocation(this.m_oracleHome);
        if (oInfo != null) {
            Vector nodeList;
            if (oInfo.isCRSHome() && (nodeList = oInfo.getNodeList()) != null && nodeList.size() > 0) {
                this.m_nodeList = new String[nodeList.size()];
                this.m_nodeList = OiixVectorOps.vect2StrArr(nodeList);
                OiipgDetectCluster detectCluster = OiipgDetectCluster.getDetectCluster();
                this.m_nodeList = detectCluster.orderNodes(this.m_nodeList);
            }
            if ((nodeList = oInfo.getNodeList()) != null && nodeList.size() > 0) {
                OiisVariable oNewNodes = this.m_vo.getVariable("CLUSTER_NEW_NODES");
                String[] newNodes = (String[])oNewNodes.getValue();
                boolean newNodesCheck = true;
                String failedNewNodes = null;
                for (int i = 0; i < newNodes.length; ++i) {
                    if (nodeList.indexOf(newNodes[i]) <= -1) continue;
                    if (newNodesCheck) {
                        failedNewNodes = newNodes[i];
                        newNodesCheck = false;
                        continue;
                    }
                    failedNewNodes = failedNewNodes + "," + newNodes[i];
                    newNodesCheck = false;
                }
                if (!newNodesCheck) {
                    String logMsg = null;
                    logMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_VALIDATE_CLUSTER_NEW_NODES_ERROR", new String[]{failedNewNodes});
                    OiiolTextLogger.appendText(logMsg);
                    OiifmAlert.displayError(logMsg);
                    return 1;
                }
            }
        }
        return 0;
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public int getNext() {
        return this.m_nextInd;
    }
}

