/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifw;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import oracle.sysman.oii.oiic.OiicDeinstallSession;
import oracle.sysman.oii.oiic.OiicInstallCancelHandler;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbCondWizOperation;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifb.OiifbIRetry;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiif.oiifr.OiifrProgressActionListener;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgCFSDriveCheck;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterOps;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterRunCmd;
import oracle.sysman.oii.oiip.oiipg.OiipgRemoteFileOperationException;
import oracle.sysman.oii.oiip.oiipg.OiipgRemoteOpsException;
import oracle.sysman.oii.oiip.oiipg.OiipgRemoveListedFilesException;
import oracle.sysman.oii.oiis.OiisVarSettingException;
import oracle.sysman.oii.oiix.OiixDebug;
import oracle.sysman.oii.oiix.OiixEnvironmentOps;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixOraparam;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixProgressComputorFactory;
import oracle.sysman.oii.oiix.OiixProgressUpdator;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifwClusterCopyWCCE
implements OiifbCondWizOperation {
    private static final boolean s_debug = false;
    boolean m_bErrorOccured = false;
    OiicSessionContext m_sessionCtx;
    private boolean m_bDeinstall;
    private boolean m_bAddNode = false;
    private OiicDeinstallSession m_oDeinstallSession = null;
    private int m_nextInd;
    private OiicSessionInterfaceManager m_interfaceManager;
    private static final long S_MIN_REMOTE_COPY_TIME_MILLIS = 300000L;
    private int m_iProgressRange = 0;
    private static final String S_DEFAULT_ADDNODE_EXCLUDE_FILE_LIST_FILE = "install/excludeFileList.txt";
    private static final String S_DEFAULT_INSTALL_EXCLUDE_FILE_LIST_FILE = "install/excludeFileList.txt";
    private long m_lLocalInstallStartTime = 0L;
    private static final String S_PAUSE_BEFORE_REMOTE_COPY = "oracle.installer.pauseBeforeRemoteCopy";
    private final boolean m_bPauseBeforeRemoteCopy = Boolean.getBoolean("oracle.installer.pauseBeforeRemoteCopy");

    public OiifwClusterCopyWCCE(OiicSessionContext sessionCtx, int nextInd, boolean bDeinstall, boolean bAddNode) {
        this(sessionCtx, nextInd, bDeinstall);
        this.m_bAddNode = bAddNode;
    }

    public OiifwClusterCopyWCCE(OiicSessionContext sessionCtx, int nextInd, boolean bDeinstall, OiicDeinstallSession oDeinstallSession) {
        this(sessionCtx, nextInd, bDeinstall);
        this.m_oDeinstallSession = oDeinstallSession;
    }

    public OiifwClusterCopyWCCE(OiicSessionContext sessionCtx, int nextInd, boolean bDeinstall) {
        this.m_sessionCtx = sessionCtx;
        this.m_nextInd = nextInd;
        this.m_bDeinstall = bDeinstall;
    }

    void setProgressRange(int iProgressRange) {
        this.m_iProgressRange = iProgressRange;
    }

    void setLocalInstallStartTime(long millis) {
        this.m_lLocalInstallStartTime = millis;
    }

    @Override
    public void initialize() {
        this.m_interfaceManager = OiicSessionInterfaceManager.getInterfaceManager();
    }

    private long computeInitialFrequency(int nNodes, long lLocalInstallTime, int range) {
        return lLocalInstallTime / (long)range;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int doOperation(boolean isBack) throws OiifbEndIterateException {
        block123: {
            performRemoteCopyFlag = System.getProperty("oracle.installer.performRemoteCopyInAPIMode");
            if (performRemoteCopyFlag != null && performRemoteCopyFlag.equals("false")) {
                return 0;
            }
            if (isBack) {
                return 1;
            }
            val = OiixOraparam.getOraparamProfileString("IGNORECLUSTER", "false");
            if (val.equalsIgnoreCase("true")) {
                return 0;
            }
            if (this.m_bPauseBeforeRemoteCopy) {
                OiifmAlert.displayError("Remote Copy to be performed next");
            }
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("Current working dir before remoteops:" + OiixEnvironmentOps.getCurrentWorkingDir(), OiiolTextLogger.LOG_DETAILED);
            }
            homeLoc = (String)this.m_sessionCtx.getVarValue("ORACLE_HOME");
            cfsDriveCheck = OiipgCFSDriveCheck.getCFSDriveChecker();
            clusterLogger = OiipgClusterLogger.getClusterLogger();
            remoteNodes = (String[])this.m_sessionCtx.getVarValue("REMOTE_NODES");
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_TRACE) {
                OiiolTextLogger.appendText("remoteNodes:" + (remoteNodes == null ? "null" : "" + remoteNodes.length), OiiolTextLogger.LOG_TRACE);
                if (homeLoc != null) {
                    OiiolTextLogger.appendText("OH on CFS:" + cfsDriveCheck.isDriveOnCFS(homeLoc), OiiolTextLogger.LOG_TRACE);
                }
            }
            progressListener = this.m_interfaceManager.getProgressListener();
            if (remoteNodes == null || remoteNodes.length == 0 || cfsDriveCheck.isDriveOnCFS(homeLoc)) {
                clusterLogger.resetListFiles();
                if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_BASIC) {
                    OiiolTextLogger.appendText("This is a shared oracle home or remote nodes are null. No copy required.", OiiolTextLogger.LOG_BASIC);
                }
                return 0;
            }
            obj = new String[2];
            clusterListStr = OiixFunctionOps.implodeList(remoteNodes, ",");
            obj[0] = homeLoc;
            obj[1] = clusterListStr;
            msg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFW1015", obj);
            OiiolTextLogger.appendText(msg);
            bRemoveAll = this.m_bDeinstall;
            if (bRemoveAll && ((homesToDelete = this.m_oDeinstallSession.getHomesToDelete()) == null || homesToDelete.size() == 0)) {
                bRemoveAll = false;
            }
            if (bRemoveAll) {
                clusterLogger.resetListFiles();
                OiipgClusterLogger.logRmdirCommands(homeLoc);
            }
            sExcludeFileListFile = null;
            iPhase = 0;
            if (this.m_bAddNode) {
                iPhase = 256;
                sExcludeFileListFile = System.getProperty("oracle.installer.addnode.excludeFileListFile", "install/excludeFileList.txt");
                ((OiifrProgressActionListener)progressListener).onStartPhase(iPhase);
            } else if (!this.m_bDeinstall) {
                iPhase = 32;
                ((OiifrProgressActionListener)progressListener).onStartPhase(iPhase);
                sExcludeFileListFile = System.getProperty("oracle.installer.install.excludeFileListFile", "install/excludeFileList.txt");
            }
            iAreaControl = OiiiInstallAreaControl.getInstallAreaControl();
            instinv = iAreaControl.getInstallInventory();
            oHomeInfo = instinv.getHomeWithLocation(homeLoc);
            OiiolTextLogger.appendText("List of files to be excluded from:" + sExcludeFileListFile);
            if (!this.m_bDeinstall) {
                sExcludeFileListFile = OiixPathOps.concatPath(homeLoc, sExcludeFileListFile);
                try {
                    clusterLogger.updateExcludeListFromFile(sExcludeFileListFile);
                }
                catch (IOException e) {
                    OiiolTextLogger.appendException(e);
                }
            }
            if (!oHomeInfo.wasCreatedInThisSession() && !this.m_bAddNode) {
                clusterLogger.updateExcludeListFileForHomeInv(homeLoc);
            }
            clusterLogger.updateExcludeListFileForConfig(homeLoc);
            numRemoteNodes = remoteNodes.length;
            file = null;
            if (OiixDebug.PRINT_MEMORY) {
                OiixDebug.printMemory("Number of remote nodes:" + numRemoteNodes + " Before updating list files : ", System.currentTimeMillis());
            }
            if (OiixDebug.PRINT_TIME) {
                OiixDebug.printTime("OiifwClusterCopyWCCE", "Number of remote nodes:" + numRemoteNodes + " Before updating list files : ");
            }
            isUpgrade = instinv.isUpgradeOHScenario(homeLoc);
            clusterLogger.updateListFiles(homeLoc);
            if (this.m_bDeinstall || OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                clusterLogger.copyFilesToCentralInv();
            }
            if (OiixDebug.PRINT_MEMORY) {
                OiixDebug.printMemory("After updating list files : ", System.currentTimeMillis());
            }
            if (OiixDebug.PRINT_TIME) {
                OiixDebug.printTime("OiifwClusterCopyWCCE", "Number of remote nodes:" + numRemoteNodes + " After updating list files : ");
            }
            oProgressUpdator = null;
            if (progressListener != null) {
                if (progressListener != null && !this.m_bDeinstall && this.m_iProgressRange != 0) {
                    lEstimatedTime = this.computeEstimatedTimeForNode(Math.max(System.currentTimeMillis() - this.m_lLocalInstallStartTime, 300000L), remoteNodes.length);
                    lInitFrequency = this.computeInitialFrequency(remoteNodes.length, lEstimatedTime, this.m_iProgressRange);
                    oComputor = OiixProgressComputorFactory.getProgressComputor(System.getProperty("oracle.installer.progress.progressComputorClass", "oracle.sysman.oii.oiix.OiixArithmaticProgressionProgress"), lInitFrequency);
                    if (oComputor != null) {
                        oProgressUpdator = new OiixProgressUpdator(progressListener, oComputor, this.m_iProgressRange);
                    }
                }
                progressListener.setStatus(msg);
            }
            if (!this.m_bDeinstall && !this.m_bAddNode) {
                this.runPreCopyScriptOnNodes(remoteNodes);
            }
            if (!(isUpgrade && !this.m_bAddNode || this.m_bDeinstall)) {
                msg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFW1029", obj);
                if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                    OiiolTextLogger.appendText(msg, OiiolTextLogger.LOG_DETAILED);
                }
                if (progressListener != null) {
                    progressListener.setStatus(msg);
                    if (oProgressUpdator != null) {
                        oProgressUpdator.start();
                    }
                }
                try {
                    if (OiixDebug.PRINT_MEMORY) {
                        OiixDebug.printMemory("Before bulk copying OH : ", System.currentTimeMillis());
                    }
                    if (OiixDebug.PRINT_TIME) {
                        OiixDebug.printTime("OiifwClusterCopyWCCE", "Number of remote nodes:" + numRemoteNodes + " Before bulk copying OH : ");
                    }
                    remoteLocations = new String[remoteNodes.length];
                    for (i = 0; i < remoteNodes.length; ++i) {
                        remoteLocations[i] = homeLoc;
                    }
                    tempLocation = System.getProperty("oracle.installer.scratchPath");
                    OiipgClusterOps.transferDirStructureToNodes(homeLoc, remoteNodes, homeLoc, null, true, clusterLogger.getExcludeListFile(), true, System.getProperty("java.io.tmpdir"), remoteLocations);
                    if (OiixDebug.PRINT_MEMORY) {
                        OiixDebug.printMemory("After bulk copying OH : ", System.currentTimeMillis());
                    }
                    if (!OiixDebug.PRINT_TIME) ** GOTO lbl306
                    OiixDebug.printTime("OiifwClusterCopyWCCE", "Number of remote nodes:" + numRemoteNodes + " After bulk copying OH : ");
                }
                catch (OiipgRemoteFileOperationException e) {
                    if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                        OiiolTextLogger.appendException(e);
                    }
                    if (this.warnUserWithAlert(e.getBriefMessage(), e.getMessage())) ** GOTO lbl306
                    if (!this.m_bDeinstall) {
                        ((OiifrProgressActionListener)progressListener).onDonePhase(iPhase);
                        if (oProgressUpdator != null) {
                            oProgressUpdator.stop();
                        }
                    }
                    return 0;
                }
                catch (OiipgRemoteOpsException e) {
                    if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                        OiiolTextLogger.appendException(e);
                    }
                    argsErr = new String[]{homeLoc, clusterLogger.getExcludeListFile()};
                    errMes = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-35003", argsErr);
                    if (this.warnUserWithAlert(e.getBasicMessage(), null)) ** GOTO lbl306
                    if (!this.m_bDeinstall) {
                        ((OiifrProgressActionListener)progressListener).onDonePhase(iPhase);
                        if (oProgressUpdator != null) {
                            oProgressUpdator.stop();
                        }
                    }
                    return 0;
                }
            } else {
                block122: {
                    block121: {
                        block120: {
                            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                                OiiolTextLogger.appendText("Copy mechanism will use RAC files lists to copy oracle home to remote nodes.", OiiolTextLogger.LOG_DETAILED);
                            }
                            if (oProgressUpdator != null) {
                                oProgressUpdator.start();
                            }
                            if ((file = new File(rmFile = clusterLogger.getRemoveListFile())).length() > 0L) {
                                block119: {
                                    if (OiixDebug.PRINT_MEMORY) {
                                        OiixDebug.printMemory("Before removing listed files from nodes : ", System.currentTimeMillis());
                                    }
                                    if (OiixDebug.PRINT_TIME) {
                                        OiixDebug.printTime("OiifwClusterCopyWCCE", "Number of remote nodes:" + numRemoteNodes + " Before  removing listed files from nodes :: ");
                                    }
                                    msg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFW1030", obj);
                                    if (progressListener != null) {
                                        progressListener.setStatus(msg);
                                    }
                                    try {
                                        OiipgClusterOps.removeListedFilesFromNodes(remoteNodes, rmFile);
                                    }
                                    catch (OiipgRemoveListedFilesException e) {
                                        OiiolTextLogger.appendException(e);
                                        if (this.warnUserWithAlert(e.getBasicMessage(), e.getBriefMessage())) break block119;
                                        if (!this.m_bDeinstall) {
                                            ((OiifrProgressActionListener)progressListener).onDonePhase(iPhase);
                                            if (oProgressUpdator != null) {
                                                oProgressUpdator.start();
                                            }
                                        }
                                        return 0;
                                    }
                                }
                                if (OiixDebug.PRINT_MEMORY) {
                                    OiixDebug.printMemory("After removing listed files from nodes : ", System.currentTimeMillis());
                                }
                                if (OiixDebug.PRINT_TIME) {
                                    OiixDebug.printTime("OiifwClusterCopyWCCE", "Number of remote nodes:" + numRemoteNodes + " After removing listed files from nodes :: ");
                                }
                            }
                            try {
                                rmFile = clusterLogger.getRmdirListFile();
                                file = new File(rmFile);
                                if (file.length() > 0L) {
                                    if (OiixDebug.PRINT_MEMORY) {
                                        OiixDebug.printMemory("Before removing listed dirs from nodes : ", System.currentTimeMillis());
                                    }
                                    if (OiixDebug.PRINT_TIME) {
                                        OiixDebug.printTime("OiifwClusterCopyWCCE", "Number of remote nodes:" + numRemoteNodes + " Before removing listed dirs from nodes :: ");
                                    }
                                    msg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFW1031", obj);
                                    if (progressListener != null) {
                                        progressListener.setStatus(msg);
                                    }
                                    OiipgClusterOps.removeListedDirsFromNodes(remoteNodes, rmFile);
                                    if (OiixDebug.PRINT_MEMORY) {
                                        OiixDebug.printMemory("After removing listed dirs from nodes : ", System.currentTimeMillis());
                                    }
                                    if (OiixDebug.PRINT_TIME) {
                                        OiixDebug.printTime("OiifwClusterCopyWCCE", "Number of remote nodes:" + numRemoteNodes + " After removing listed dirs from nodes :: ");
                                    }
                                }
                            }
                            catch (OiipgRemoteFileOperationException e) {
                                OiiolTextLogger.appendException(e);
                                if (!this.warnUserWithAlert(e.getBriefMessage(), e.getMessage())) {
                                    if (!this.m_bDeinstall) {
                                        ((OiifrProgressActionListener)progressListener).onDonePhase(iPhase);
                                        if (oProgressUpdator != null) {
                                            oProgressUpdator.stop();
                                        }
                                    }
                                    return 0;
                                }
                            }
                            catch (OiipgRemoteOpsException e) {
                                OiiolTextLogger.appendException(e);
                                if (this.warnUserWithAlert(e.getBasicMessage(), null)) break block120;
                                if (!this.m_bDeinstall) {
                                    ((OiifrProgressActionListener)progressListener).onDonePhase(iPhase);
                                    if (oProgressUpdator != null) {
                                        oProgressUpdator.stop();
                                    }
                                }
                                return 0;
                            }
                        }
                        try {
                            dirFile = clusterLogger.getDirListFile();
                            file = new File(dirFile);
                            if (file.length() > 0L) {
                                if (OiixDebug.PRINT_MEMORY) {
                                    OiixDebug.printMemory("Before transferring listed dirs to nodes : ", System.currentTimeMillis());
                                }
                                if (OiixDebug.PRINT_TIME) {
                                    OiixDebug.printTime("OiifwClusterCopyWCCE", "Number of remote nodes:" + numRemoteNodes + " Before transferring listed dirs to nodes :");
                                }
                                msg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFW1032", obj);
                                if (progressListener != null) {
                                    progressListener.setStatus(msg);
                                }
                                OiipgClusterOps.transferListedDirsToNodes(remoteNodes, homeLoc, dirFile, clusterLogger.getExcludeListFile());
                                if (OiixDebug.PRINT_MEMORY) {
                                    OiixDebug.printMemory("After transferring listed dirs to nodes : ", System.currentTimeMillis());
                                }
                                if (OiixDebug.PRINT_TIME) {
                                    OiixDebug.printTime("OiifwClusterCopyWCCE", "Number of remote nodes:" + numRemoteNodes + " After transferring listed dirs to nodes :");
                                }
                            }
                        }
                        catch (OiipgRemoteFileOperationException e) {
                            OiiolTextLogger.appendException(e);
                            if (!this.warnUserWithAlert(e.getBriefMessage(), e.getMessage())) {
                                if (!this.m_bDeinstall) {
                                    ((OiifrProgressActionListener)progressListener).onDonePhase(iPhase);
                                    if (oProgressUpdator != null) {
                                        oProgressUpdator.stop();
                                    }
                                }
                                return 0;
                            }
                        }
                        catch (OiipgRemoteOpsException e) {
                            OiiolTextLogger.appendException(e);
                            if (this.warnUserWithAlert(e.getBasicMessage(), null)) break block121;
                            if (!this.m_bDeinstall) {
                                ((OiifrProgressActionListener)progressListener).onDonePhase(iPhase);
                                if (oProgressUpdator != null) {
                                    oProgressUpdator.stop();
                                }
                            }
                            return 0;
                        }
                    }
                    try {
                        copyFile = clusterLogger.getCopyListFile();
                        file = new File(copyFile);
                        if (file.length() > 0L) {
                            if (OiixDebug.PRINT_MEMORY) {
                                OiixDebug.printMemory("Before transferring listed files to nodes : ", System.currentTimeMillis());
                            }
                            if (OiixDebug.PRINT_TIME) {
                                OiixDebug.printTime("OiifwClusterCopyWCCE", "Number of remote nodes:" + numRemoteNodes + " Before transferring listed files to nodes :");
                            }
                            msg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFW1033", obj);
                            if (progressListener != null) {
                                progressListener.setStatus(msg);
                            }
                            OiipgClusterOps.transferListedFilesToNodes(remoteNodes, homeLoc, copyFile);
                            if (OiixDebug.PRINT_MEMORY) {
                                OiixDebug.printMemory("After transferring listed files to nodes : ", System.currentTimeMillis());
                            }
                            if (OiixDebug.PRINT_TIME) {
                                OiixDebug.printTime("OiifwClusterCopyWCCE", "Number of remote nodes:" + numRemoteNodes + " After transferring listed files to nodes :");
                            }
                        }
                    }
                    catch (OiipgRemoteFileOperationException e) {
                        OiiolTextLogger.appendException(e);
                        if (!this.warnUserWithAlert(e.getBriefMessage(), e.getMessage())) {
                            if (!this.m_bDeinstall) {
                                ((OiifrProgressActionListener)progressListener).onDonePhase(iPhase);
                                if (oProgressUpdator != null) {
                                    oProgressUpdator.stop();
                                }
                            }
                            return 0;
                        }
                    }
                    catch (OiipgRemoteOpsException e) {
                        OiiolTextLogger.appendException(e);
                        if (this.warnUserWithAlert(e.getBasicMessage(), null)) break block122;
                        if (!this.m_bDeinstall) {
                            ((OiifrProgressActionListener)progressListener).onDonePhase(iPhase);
                            if (oProgressUpdator != null) {
                                oProgressUpdator.stop();
                            }
                        }
                        return 0;
                    }
                }
                try {
                    if (!bRemoveAll) {
                        homeInfo = instinv.getHomeWithLocation(homeLoc);
                        homeIndex = homeInfo.getIndex();
                        invDir = iAreaControl.getInventoryLocForHome(homeIndex);
                        invDirFile = new File(invDir = OiixPathOps.getNativeForm(invDir));
                        if (invDirFile.isDirectory()) {
                            if (OiixDebug.PRINT_MEMORY) {
                                OiixDebug.printMemory("Before copying OH/inventory to nodes : ", System.currentTimeMillis());
                            }
                            if (OiixDebug.PRINT_TIME) {
                                OiixDebug.printTime("OiifwClusterCopyWCCE", "Number of remote nodes:" + numRemoteNodes + "  Before copying OH/inventory to nodes :");
                            }
                            msg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFW1034", obj);
                            if (progressListener != null) {
                                progressListener.setStatus(msg);
                            }
                            OiipgClusterOps.transferDirToNodes(remoteNodes, invDir, clusterLogger.getExcludeListFile());
                            if (OiixDebug.PRINT_MEMORY) {
                                OiixDebug.printMemory("After copying OH/inventory to nodes : ", System.currentTimeMillis());
                            }
                            if (OiixDebug.PRINT_TIME) {
                                OiixDebug.printTime("OiifwClusterCopyWCCE", "Number of remote nodes:" + numRemoteNodes + "  After copying OH/inventory to nodes :");
                            }
                        }
                    }
                }
                catch (OiipgRemoteFileOperationException e) {
                    OiiolTextLogger.appendException(e);
                    if (!this.warnUserWithAlert(e.getBriefMessage(), e.getMessage())) {
                        if (!this.m_bDeinstall) {
                            ((OiifrProgressActionListener)progressListener).onDonePhase(iPhase);
                            if (oProgressUpdator != null) {
                                oProgressUpdator.stop();
                            }
                        }
                        return 0;
                    }
                }
                catch (OiipgRemoteOpsException e) {
                    OiiolTextLogger.appendException(e);
                    if (this.warnUserWithAlert(e.getBasicMessage(), null)) break block123;
                    if (!this.m_bDeinstall) {
                        ((OiifrProgressActionListener)progressListener).onDonePhase(iPhase);
                        if (oProgressUpdator != null) {
                            oProgressUpdator.stop();
                        }
                    }
                    return 0;
                }
            }
        }
        clusterLogger.resetListFiles();
        if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
            if (!this.m_bDeinstall) {
                OiiolTextLogger.appendText("Done copying oracle home to remote nodes.", OiiolTextLogger.LOG_DETAILED);
            } else {
                OiiolTextLogger.appendText("Done removing oracle home files from remote nodes.", OiiolTextLogger.LOG_DETAILED);
            }
        }
        if (oProgressUpdator != null) {
            oProgressUpdator.stop();
        }
        if (!this.m_bDeinstall) {
            ((OiifrProgressActionListener)progressListener).onDonePhase(iPhase);
        }
        return 0;
    }

    private boolean warnUserWithAlert(String exceptionMessage, String logMsg) {
        int userChoice;
        String logFileName = OiiolTextLogger.getCurLogFileName();
        Object[] args = new String[]{logFileName};
        String warningMessage = "";
        String logMessage = null;
        warningMessage = !OiicPullSession.isSilentMode() ? exceptionMessage + "\n" + OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFW1202", args) : exceptionMessage + "\n" + OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFW12021", args);
        if (logMsg != null) {
            logMessage = !OiicPullSession.isSilentMode() ? logMsg + "\n" + OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFW1202", args) : logMsg + "\n" + OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFW12021", args);
        }
        if ((userChoice = OiifmAlert.displayAlert(OiixResourceBundle.getString("S_WARNING"), warningMessage, logMessage, 30, 3, 2, 10)) == 2) {
            String[] remoteNodes = new String[]{};
            try {
                this.m_sessionCtx.setVarValue("REMOTE_NODES", remoteNodes);
                Integer rootShStatus = new Integer(0);
                this.m_sessionCtx.setVarValue("ROOTSH_STATUS", rootShStatus);
            }
            catch (OiifbCancelException e) {
                OiiolTextLogger.appendException(e);
            }
            catch (OiisVarSettingException e) {
                OiiolTextLogger.appendException(e);
            }
            OiicPullSession oSession = this.m_sessionCtx.getSession();
            if (oSession != null) {
                OiicPullSession.setRemoteOperationSuccess(false);
            }
            return false;
        }
        return true;
    }

    private void runPreCopyScriptOnNodes(String[] nodes) throws OiifbEndIterateException {
        if (Boolean.getBoolean("oracle.installer.suppressPreCopyScript")) {
            return;
        }
        String sPreCopyScriptLoc = System.getProperty("preCopyScript.install.loc");
        if (null != sPreCopyScriptLoc && !sPreCopyScriptLoc.trim().equals("")) {
            if (!new File(sPreCopyScriptLoc).exists()) {
                return;
            }
            String tempLoc = System.getProperty("oracle.installer.scratchPath");
            String sDest = OiixPathOps.concatPath(tempLoc, OiixPathOps.getFileName(sPreCopyScriptLoc));
            try {
                for (int i = 0; i < nodes.length; ++i) {
                    if (!OiipgClusterOps.fileExistsOnNode(nodes[i], tempLoc)) {
                        OiipgClusterOps.createDirInNode(nodes[i], tempLoc);
                    }
                    OiipgClusterOps.copyFileToNode(sPreCopyScriptLoc, nodes[i], sDest);
                }
            }
            catch (OiipgRemoteOpsException e) {
                OiiolTextLogger.appendException(e);
                return;
            }
            if (Boolean.getBoolean("preCopyScript.install.runAsRoot")) {
                if (OiicPullSession.isSilentMode()) {
                    OiiolTextLogger.appendText("Run the script as root in the remote nodes and run Installer againwith -suppressPreCopyScript option ");
                    OiiolTextLogger.appendText("Exiting");
                    throw new OiifbEndIterateException("Run Installer after executing the precopyScript");
                }
                String sNodes = OiixFunctionOps.implodeList(nodes, ",");
                Object[] args = new String[]{sPreCopyScriptLoc, sNodes};
                String msg = MessageFormat.format(OiixResourceBundle.getString("S_PRECOPY_RAC_ROOT_MSG"), args);
                int retVal = OiifmAlert.displayAlert(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_WARNING"), msg, 10, 5, 1, 10);
                if (1 == retVal) {
                    return;
                }
                int buttons = 0;
                buttons |= 4;
                OiicInstallCancelHandler cancel = OiicSessionInterfaceManager.getInterfaceManager().getInstallCancelHandler(buttons |= 1, "", 0);
                int retval = cancel.doCancelOperation();
                switch (retval) {
                    case 4: {
                        return;
                    }
                    case 1: {
                        OiiolTextLogger.appendText("Run installer with -suppressPreCopyScript option tosuppress the script execution");
                        throw new OiifbEndIterateException("Installation cancelled by the user");
                    }
                }
            }
            OiipgClusterRunCmd cmd = new OiipgClusterRunCmd(nodes);
            String sShellPath = System.getProperty("preCopyScript.install.shellPath");
            String sPreCopyScriptCmd = sShellPath != null && sShellPath.trim().length() > 0 ? sShellPath + " " + sPreCopyScriptLoc : sPreCopyScriptLoc;
            String sOHName = (String)this.m_sessionCtx.getVarValue("ORACLE_HOME_NAME");
            if (null == sOHName) {
                sOHName = "";
            }
            String serviceName = "OracleOUI_" + sOHName + "_service";
            boolean retry = false;
            do {
                try {
                    cmd.runAnyCmdOnNodes(sPreCopyScriptCmd, nodes, serviceName);
                }
                catch (Exception re) {
                    retry = false;
                    String errorMsg = "Error in executing script: Cluster exception";
                    OiiolTextLogger.appendException(re);
                    if (OiicPullSession.isSilentMode()) {
                        OiiolTextLogger.appendText(errorMsg);
                        OiiolTextLogger.appendText("Exiting");
                        throw new OiifbEndIterateException("Execution of precopy script failed on remote nodes");
                    }
                    int buttonOps = 0;
                    buttonOps = 0;
                    buttonOps |= 2;
                    buttonOps |= 4;
                    String prompt = errorMsg;
                    int userInput = 0;
                    try {
                        OiifbIRetry actionDlg = OiicSessionInterfaceManager.getInterfaceManager().getRetryHandler(prompt, buttonOps, 1);
                        userInput = actionDlg.doModal();
                        actionDlg = null;
                        Thread.yield();
                    }
                    catch (Exception e) {
                        OiiolTextLogger.appendException(e);
                    }
                    switch (userInput) {
                        case 2: {
                            retry = true;
                            break;
                        }
                        case 4: {
                            retry = false;
                            break;
                        }
                        case 32: {
                            throw new OiifbEndIterateException(prompt);
                        }
                        case 16: {
                            throw new OiifbEndIterateException(prompt);
                        }
                    }
                }
            } while (retry);
        }
    }

    @Override
    public int getNext() {
        return this.m_nextInd;
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public void dispose() {
    }

    private long computeEstimatedTimeForNode(long lLocalInstallTime, int nNodes) {
        String sEstimatedRemoteFileCopyNodeFactor = System.getProperty("oracle.installer.remote.fileCopyTimeEstimateNodeFactor", "1");
        double dFactor = Math.min((double)Float.parseFloat(sEstimatedRemoteFileCopyNodeFactor), 1.0);
        return (long)Math.ceil((double)Long.getLong("oracle.installer.remote.fileCopyTimeEstimate", lLocalInstallTime).longValue() * dFactor);
    }
}

