/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifw;

import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionPlan;
import oracle.sysman.oii.oiif.oiifb.OiifbCondWizOperation;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiPatchSetInstallID;
import oracle.sysman.oii.oiii.OiiiStageInventory;
import oracle.sysman.oii.oiio.oiiod.OiiodDepEngine;
import oracle.sysman.oii.oiio.oiiod.OiiodDepException;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiis.OiisCompInstallation;
import oracle.sysman.oii.oiis.OiisDepInfo;
import oracle.sysman.oii.oiis.OiisDepMode;
import oracle.sysman.oii.oiis.OiisPatchSetInstallation;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifwCloneDepCalcWCCE
implements OiifbCondWizOperation {
    private OiisVariableOwner m_vo = null;
    private int m_nextInd;
    private OiicPullSession m_pullSession;
    private String m_installType;

    public OiifwCloneDepCalcWCCE(OiisVariableOwner vo, int nextInd) {
        this.m_vo = vo;
        this.m_nextInd = nextInd;
    }

    @Override
    public void initialize() throws OiifbEndIterateException {
        this.m_pullSession = this.m_vo.getSession();
    }

    @Override
    public int doOperation(boolean back) throws OiifbEndIterateException {
        if (back) {
            return 1;
        }
        OiiodDepEngine depEngine = this.m_pullSession.getDepEngine();
        OiiiStageInventory stageInv = this.m_pullSession.getSourceAccess().getStageInventory();
        depEngine.setInventories(stageInv, this.m_pullSession.getInstallAreaControl().getInstallInventory());
        this.updateTopLevels();
        try {
            depEngine.buildCompArray();
        }
        catch (OiiodDepException exp) {
            exp.printStackTrace();
        }
        Vector vOrderedIEs = this.getOrderedIEs();
        if (!this.m_pullSession.isAddNodeMode()) {
            this.checkPreReqs(vOrderedIEs);
        }
        this.updatePlan(vOrderedIEs);
        return 0;
    }

    private void loadInstallPropertiesFile(String sTopLevelCompName, String sInstallType) {
        try {
            OiiiInstallAreaControl iac = this.m_pullSession.getInstallAreaControl();
            String destdir = iac.getScriptsLoc(this.m_pullSession.getOHIndex());
            String name = sTopLevelCompName + "_" + sInstallType;
            name = name + ".properties";
            name = OiixPathOps.concatPath(destdir, name);
            OiiolTextLogger.appendText("loading install properties filename: " + name);
            Properties props = new Properties();
            FileInputStream fs = new FileInputStream(name);
            props.load(fs);
            Properties sysProps = System.getProperties();
            Enumeration<?> propNames = props.propertyNames();
            while (propNames.hasMoreElements()) {
                String propName = (String)propNames.nextElement();
                String propValue = (String)props.get(propName);
                OiiolTextLogger.appendText("Set " + propName + " to " + propValue, OiiolTextLogger.LOG_DETAILED);
                sysProps.put(propName, propValue);
            }
            fs.close();
        }
        catch (Exception error) {
            OiiolTextLogger.appendText(error.toString(), OiiolTextLogger.LOG_DETAILED);
        }
    }

    @Override
    public void dispose() {
    }

    public void finalize() {
        this.dispose();
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public int getNext() {
        return this.m_nextInd;
    }

    private void updateTopLevels() {
        OiiodDepEngine depEngine = this.m_pullSession.getDepEngine();
        OiiiStageInventory stageInv = this.m_pullSession.getSourceAccess().getStageInventory();
        Vector vtlIDs = stageInv.getTopLevelComps(0, OiixPlatform.getCurrentPlatform());
        OiiiCompInstallID[] atlIDs = this.vectToCompIDArray(vtlIDs);
        try {
            OiisVariable tlCompsVar = this.m_pullSession.getSessionContext().getVariable("ToplevelComps");
            tlCompsVar.setValue(atlIDs, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        depEngine.setCurrentTLIDs(atlIDs);
        boolean bTLVarSet = false;
        for (int i = 0; i < atlIDs.length; ++i) {
            OiiiCompInstallID cid = atlIDs[i];
            if (!(cid instanceof OiiiCompInstallID)) continue;
            try {
                String sInstallType;
                OiisDepMode depMode;
                if (!bTLVarSet) {
                    OiisVariable tlVar = this.m_pullSession.getSessionContext().getVariable("ToplevelComp");
                    tlVar.setValue(cid, true);
                    bTLVarSet = true;
                }
                OiiiInstallInventory instInv = this.m_pullSession.getInstallAreaControl().getInstallInventory();
                OiiiInstallCompInvEntry invEntry = instInv.getInstallCompInvEntry(cid, this.m_pullSession.getOHIndex());
                OiisCompInstallation compInstall = this.m_pullSession.getCompInstall(cid);
                if (compInstall != null) {
                    OiisDepInfo depInfo = compInstall.getDepInfo();
                    if (invEntry.getDepInfo() == null || (depMode = invEntry.getDepInfo().getDepMode()) == null) continue;
                    sInstallType = depMode.getInternalName();
                    depInfo.setDepModeName(sInstallType);
                    OiiolTextLogger.appendText("Trying to load the properties file for " + cid.getName() + " with install type " + sInstallType);
                    this.loadInstallPropertiesFile(cid.getName(), sInstallType);
                    continue;
                }
                if (cid.getCompType() != 4) continue;
                OiisPatchSetInstallation pInstall = this.m_pullSession.getPSetInstall((OiiiPatchSetInstallID)cid);
                if (invEntry.getDepInfo() == null || (depMode = invEntry.getDepInfo().getDepMode()) == null) continue;
                sInstallType = depMode.getInternalName();
                OiiolTextLogger.appendText("Trying to load the properties file for " + cid.getName() + " with install type " + sInstallType);
                this.loadInstallPropertiesFile(cid.getName(), sInstallType);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private Vector getOrderedIEs() {
        OiiodDepEngine depEngine = this.m_pullSession.getDepEngine();
        int homeIndex = this.m_pullSession.getOHIndex();
        Vector vOrderedIDs = depEngine.getOrderedComps();
        OiiiInstallInventory instInv = this.m_pullSession.getInstallAreaControl().getInstallInventory();
        Vector<OiiiInstallCompInvEntry> vOrderedIEs = new Vector<OiiiInstallCompInvEntry>(vOrderedIDs.size());
        for (int i = 0; i < vOrderedIDs.size(); ++i) {
            OiiiInstallCompInvEntry invEntry;
            OiiiCompInstallID cid = (OiiiCompInstallID)vOrderedIDs.elementAt(i);
            if (cid.isNOHComp() || (invEntry = instInv.getInstallCompInvEntry(cid, homeIndex)) == null) continue;
            vOrderedIEs.addElement(invEntry);
        }
        return vOrderedIEs;
    }

    private void updatePlan(Vector vOrderedIEs) {
        OiicSessionPlan plan = this.m_pullSession.getSessionPlan();
        for (int i = 0; i < vOrderedIEs.size(); ++i) {
            OiiiInstallCompInvEntry invEntry = (OiiiInstallCompInvEntry)vOrderedIEs.elementAt(i);
            OiiiCompInstallID cid = invEntry.getCompInstallID();
            if (cid.getCompType() == 4) {
                plan.addPatchSet((OiiiPatchSetInstallID)cid, invEntry);
                continue;
            }
            plan.addAddition(cid, invEntry);
            plan.setAdditionPhase(cid, 5);
            if (!invEntry.isTopLevel()) continue;
            plan.addToTopLevelList(cid);
        }
    }

    private OiiiCompInstallID[] vectToCompIDArray(Vector vCompIDs) {
        OiiiCompInstallID[] aCompIDs = new OiiiCompInstallID[vCompIDs.size()];
        for (int i = 0; i < vCompIDs.size(); ++i) {
            aCompIDs[i] = (OiiiCompInstallID)vCompIDs.elementAt(i);
        }
        return aCompIDs;
    }

    private void checkPreReqs(Vector vOrderedIEs) throws OiifbEndIterateException {
        OiiodDepEngine depEngine = this.m_pullSession.getDepEngine();
        for (int j = 0; j < vOrderedIEs.size(); ++j) {
            OiiiInstallCompInvEntry invEntry = (OiiiInstallCompInvEntry)vOrderedIEs.elementAt(j);
            OiiiCompInstallID cid = invEntry.getCompInstallID();
            if (cid.getCompType() == 4 || cid.getCompType() == 2) continue;
            try {
                OiisCompInstallation oCompInstall = this.m_pullSession.getCompInstall(cid);
                int nPreReq = depEngine.checkPreReq(oCompInstall);
                if (0 == nPreReq) continue;
                String sMsg = depEngine.getPreReqErrorMessage(cid);
                OiiolTextLogger.writeToLogAndConsole(sMsg);
                if (this.m_pullSession.getSessionContext().ignorePreReqCheck()) {
                    String sLogMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_IGNORE_PREREQ_FAIL");
                    OiiolTextLogger.writeToLogAndConsole(sLogMsg);
                    continue;
                }
                throw new OiifbEndIterateException(sMsg);
            }
            catch (OiifbEndIterateException e) {
                throw e;
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw new OiifbEndIterateException("" + e);
            }
        }
    }
}

