/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifw;

import java.io.File;
import java.text.MessageFormat;
import java.util.List;
import oracle.sysman.oii.oiic.OiicAddNodeSummaryInformation;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifb.OiifbWizChainDlgElem;
import oracle.sysman.oii.oiii.OiiiInstallCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifwAddNodeSummaryWCDE
extends OiifbWizChainDlgElem {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 1024;
    OiicPullSession m_instSession = null;
    boolean m_bRecord = false;
    public static final String s_panelClass = "oracle.sysman.oii.oiif.oiifp.OiifpAddNodeSummaryPanel";
    private OiicSessionInterfaceManager m_interfaceManager = null;
    private OiiiInstallInventory m_inventory = null;
    private int m_nextInd = -1;
    private static final String s_sSpace = "   ";
    private static final String s_sDelim = "-----------------------------------------------------------------------------";
    private OiicAddNodeSummaryInformation m_oSummaryInfo = null;

    public OiifwAddNodeSummaryWCDE(OiisVariableOwner vo, int nextInd) {
        super(vo);
        this.m_nextInd = nextInd;
        this.m_instSession = vo.getSession();
        this.setDisplayControlVariable("SHOW_SUMMARY_PAGE");
        this.setHelpKey("S_OIIFW_ADDNODE_SUMMARY_WCDE");
        this.setWizPanelClassName(s_panelClass);
        this.m_wizardPageID = 101;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public void setWizPanel() {
    }

    @Override
    public int getNext() {
        return this.m_nextInd;
    }

    @Override
    public int doOperation(boolean isBack) throws OiifbEndIterateException {
        this.m_interfaceManager = OiicSessionInterfaceManager.getInterfaceManager();
        this.m_inventory = this.m_instSession.getInstallAreaControl().getInstallInventory();
        int retVal = super.doOperation(isBack);
        return retVal;
    }

    @Override
    public String getDisplayName() {
        String sTitle = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ADDNODE_SUMMARY");
        return sTitle;
    }

    @Override
    protected void logDialog() {
        super.logDialog();
        this.writeSummaryInformation(OiicPullSession.isSilentMode());
    }

    private void writeSummaryInformation(boolean bSilent) {
        this.m_oSummaryInfo = new OiicAddNodeSummaryInformation(this.m_instSession);
        this.logMessage("");
        this.logMessage(s_sDelim);
        this.logMessage(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ADDNODE_SUMMARY"));
        this.writeAddNodeGlobalInfo();
        this.writeAddNodeSpaceInfo();
        this.writeHomeComponentsInfo();
        this.logMessage(s_sDelim);
    }

    private void writeAddNodeSpaceInfo() {
        this.logMessage(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_SUMMARY_TREE_SPACE"));
        boolean bCFS = false;
        String sOHPath = this.m_oSummaryInfo.getSourceHomeLocation();
        String[] msgArr1 = new String[]{sOHPath};
        OiipgFileSystem fSystem = new OiipgFileSystem();
        String sVolume = fSystem.getVolumeName(sOHPath);
        String[] nodeMsgArr = this.m_oSummaryInfo.getNewClusterNodes();
        bCFS = this.m_oSummaryInfo.isVolumeOnCFS(sOHPath);
        if (!bCFS) {
            String newNodes = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_NEW_NODES");
            StringBuffer sb = new StringBuffer(s_sSpace);
            sb.append(newNodes);
            this.logMessage(sb);
            String sClusterLabel = null;
            long lAvailSpaceCluster = 0L;
            Object sAvailSpaceCluster = null;
            for (int i = 0; i < nodeMsgArr.length; ++i) {
                sb = new StringBuffer(s_sSpace);
                sb.append(s_sSpace);
                sb.append(nodeMsgArr[i]);
                this.logMessage(sb);
                String[] spaceInfo = this.m_oSummaryInfo.getRemoteVolumeDetails(nodeMsgArr[i]);
                Object[] clusterobj = new String[]{sVolume, spaceInfo[1], spaceInfo[0]};
                sClusterLabel = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLUSTER_SUMMARY_INFO_SPACE");
                sClusterLabel = MessageFormat.format(sClusterLabel, clusterobj);
                sb = new StringBuffer(s_sSpace);
                sb.append(s_sSpace);
                sb.append(s_sSpace);
                sb.append(sClusterLabel);
                this.logMessage(sb);
            }
        }
    }

    private void writeAddNodeGlobalInfo() {
        this.logMessage(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_SUMMARY_TREE_GS"));
        Object[] msgArr = new String[]{this.m_oSummaryInfo.getSourceHomeLocation()};
        String sHomeLabel = MessageFormat.format(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_SUMMARY_INFO_STAGE"), msgArr);
        StringBuffer sb = new StringBuffer(s_sSpace);
        sb.append(sHomeLabel);
        this.logMessage(sb);
        String[] sNewNodesArr = this.m_oSummaryInfo.getNewClusterNodes();
        Object[] msgArr1 = new String[]{OiixFunctionOps.implodeList(sNewNodesArr, ",")};
        String sNewNodesLabel = MessageFormat.format(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_NEW_NODES"), msgArr1);
        sb = new StringBuffer(s_sSpace);
        sb.append(sNewNodesLabel);
        this.logMessage(sb);
    }

    private void writeHomeComponentsInfo() {
        this.logMessage(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_SUMMARY_TREE_COMPONENTS"));
        String components = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_SUMMARY_INSTALLED_PRODUCTS");
        StringBuffer sb = new StringBuffer(s_sSpace);
        sb.append(components);
        this.logMessage(sb);
        List oInstalledComps = this.m_oSummaryInfo.getInstalledComponents();
        boolean bNoComps = oInstalledComps.size() == 0;
        for (int i = 0; i < oInstalledComps.size(); ++i) {
            OiiiInstallCompInvEntry icie = (OiiiInstallCompInvEntry)oInstalledComps.get(i);
            sb = new StringBuffer(s_sSpace);
            sb.append(s_sSpace);
            sb.append(icie.getFullDisplayName());
            this.logMessage(sb);
        }
        if (bNoComps) {
            sb = new StringBuffer(s_sSpace);
            sb.append(s_sSpace);
            sb.append(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_NO_INST_PRODS_PROMPT"));
            this.logMessage(sb);
        }
    }

    private void logMessage(String sMessage) {
        this.m_interfaceManager.logMessage(sMessage);
    }

    private void logMessage(StringBuffer sMessage) {
        this.m_interfaceManager.logMessage(sMessage.toString());
    }

    private long getDiskSpaceOccupied(String path) {
        long lTotalBytes = 0L;
        File fPath = new File(path);
        if (fPath.isDirectory()) {
            String[] dirContents = fPath.list();
            if (dirContents != null) {
                for (int i = 0; i < dirContents.length; ++i) {
                    dirContents[i] = path + File.separatorChar + dirContents[i];
                    File content = new File(dirContents[i]);
                    if (content.isDirectory()) {
                        lTotalBytes += this.getDiskSpaceOccupied(dirContents[i]);
                        continue;
                    }
                    lTotalBytes += content.length();
                }
            }
        } else {
            lTotalBytes += fPath.length();
        }
        return lTotalBytes;
    }
}

