/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifw;

import java.util.Vector;
import oracle.sysman.oii.oiic.OiicConfigInitializeWCCE;
import oracle.sysman.oii.oiic.OiicInstPostActionsPhase;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiif.oiifb.OiifbCondIterator;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifb.OiifbWizOperation;
import oracle.sysman.oii.oiif.oiifw.OiifwAddNodeInstantiateWCCE;
import oracle.sysman.oii.oiif.oiifw.OiifwAddNodeRootShWCCE;
import oracle.sysman.oii.oiif.oiifw.OiifwClusterCopyWCCE;
import oracle.sysman.oii.oiif.oiifw.OiifwClusterRemoteOpsWCCE;
import oracle.sysman.oii.oiif.oiifw.OiifwClusterSaveInventoryWCCE;
import oracle.sysman.oii.oiif.oiifw.OiifwRemoteHomeSetupWCCE;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifwAddNodePhaseWCDE
implements OiifbWizOperation {
    private String[] m_nodeList = null;
    private OiisVariableOwner m_vo;
    private OiifbCondIterator iter;
    private static String[] m_saPhases = null;
    private int m_iProgressPhases = 0;
    private int m_iLastPhase = 0;
    private static int NUM_PHASES = 0;
    private static String[] m_saUNIXPhases = new String[]{"S_INSTANTIATE_SCRIPTS", "S_HOME_COPY", "S_RUN_ROOTSH", "S_CLUSTER_SAVE_INV"};
    private static int NUM_UNIX_PHASES = 5;
    private static String[] m_saWINDOWSPhases = new String[]{OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_INSTANTIATE_SCRIPTS"), "S_HOME_COPY", "S_ADDNODE_SETUP", "S_CLUSTER_SAVE_INV"};
    private static int NUM_WINDOWS_PHASES = 4;

    public OiifwAddNodePhaseWCDE(OiisVariableOwner vo) {
        this.m_vo = vo;
    }

    @Override
    public void initialize() throws OiifbEndIterateException {
        int next = 0;
        int platGroup = OiixPlatform.getPlatGroup(OiixPlatform.getCurrentPlatform());
        OiicSessionContext vo = this.m_vo.getSession().getSessionContext();
        if (platGroup == -1) {
            m_saPhases = new String[m_saUNIXPhases.length];
            m_saPhases = m_saUNIXPhases;
            NUM_PHASES = NUM_UNIX_PHASES;
        } else {
            m_saPhases = new String[m_saWINDOWSPhases.length];
            m_saPhases = m_saWINDOWSPhases;
            NUM_PHASES = NUM_WINDOWS_PHASES;
        }
        Vector<OiifbWizOperation> iterEls = new Vector<OiifbWizOperation>(NUM_PHASES);
        OiifwAddNodeInstantiateWCCE inst = new OiifwAddNodeInstantiateWCCE(vo, ++next);
        iterEls.addElement(inst);
        this.m_iProgressPhases |= 0x80;
        ++next;
        iterEls.addElement(new OiifwRemoteHomeSetupWCCE(vo));
        if (!OiifwAddNodePhaseWCDE.isAPIMode()) {
            ++next;
            iterEls.addElement(new OiicConfigInitializeWCCE(this.m_vo.getSession()));
        }
        if (Boolean.getBoolean("oracle.installer.copy")) {
            OiifwClusterCopyWCCE hCopy = new OiifwClusterCopyWCCE(this.m_vo.getSession().getSessionContext(), ++next, false, true);
            hCopy.setProgressRange(100 - NUM_PHASES);
            hCopy.setLocalInstallStartTime(System.currentTimeMillis());
            iterEls.addElement(hCopy);
            this.m_iProgressPhases |= 0x100;
        }
        if (platGroup == -3) {
            OiifwClusterRemoteOpsWCCE clsInstallPhase = new OiifwClusterRemoteOpsWCCE(++next);
            iterEls.addElement(clsInstallPhase);
            this.m_iProgressPhases |= 0x200;
        }
        ++next;
        if (OiifwAddNodePhaseWCDE.isAPIMode() && platGroup == -3) {
            next = -1;
        }
        iterEls.addElement(new OiifwClusterSaveInventoryWCCE(this.m_vo.getSession(), next));
        this.m_iProgressPhases |= 0x400;
        this.m_iLastPhase = 1024;
        if (platGroup == -1) {
            ++next;
            if (OiifwAddNodePhaseWCDE.isAPIMode()) {
                next = -1;
            }
            OiifwAddNodeRootShWCCE rootsh = new OiifwAddNodeRootShWCCE(this.m_vo.getSession(), next);
            iterEls.addElement(rootsh);
            this.m_iProgressPhases |= 0x800;
        }
        if (!OiifwAddNodePhaseWCDE.isAPIMode()) {
            OiicInstPostActionsPhase instPostActionsPhase = new OiicInstPostActionsPhase(this.m_vo.getSession());
            iterEls.addElement(instPostActionsPhase);
        }
        this.iter = new OiifbCondIterator(iterEls);
    }

    public int getNext() {
        return -1;
    }

    @Override
    public int doOperation(boolean bBack) throws OiifbEndIterateException {
        if (bBack) {
            return 1;
        }
        OiicSessionInterfaceManager interfaceManager = OiicSessionInterfaceManager.getInterfaceManager();
        this.m_vo.getSession().registerCopyLogInfo();
        interfaceManager.setupAddNodeProgress(this, this.m_iProgressPhases, this.m_iLastPhase);
        interfaceManager.getProgressListener().setTotalBytes(100L);
        String clusterListStr = OiixFunctionOps.implodeList(this.m_nodeList, ",");
        String[] obj = new String[]{clusterListStr};
        this.iter.iterate(bBack);
        return 0;
    }

    public String[] getAllClusterNodes() {
        return this.m_nodeList;
    }

    @Override
    public void dispose() {
    }

    public static int getNumPhases() {
        return NUM_PHASES - 1;
    }

    public static String[] getPhaseNames() {
        return m_saPhases;
    }

    public static boolean isAPIMode() {
        return System.getProperty("oracle.installer.ouiApiMode", "false").equalsIgnoreCase("true");
    }
}

