/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiift;

import java.awt.Image;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Vector;
import oracle.ewt.dTree.DTreeDeferringParent;
import oracle.ewt.dTree.DTreeItem;
import oracle.ewt.dTree.DTreeItemFactory;
import oracle.ewt.dataSource.OneDDataSource;
import oracle.ewt.dataSource.OneDDataSourceEvent;
import oracle.ewt.dataSource.OneDDataSourceListener;
import oracle.ewt.event.ListenerManager;
import oracle.sysman.oii.oiif.oiift.OiiftDataDrivenTree;

public abstract class OiiftTreeDataSource
implements OneDDataSource,
DTreeItemFactory {
    private ListenerManager m_oneDManager;
    private OiiftTreeDataSource[] m_dsList;
    private DTreeItem m_node;
    private Image[] m_imageList;
    private OiiftDataDrivenTree m_tree = null;

    public OiiftTreeDataSource(OiiftDataDrivenTree tree) {
        this.m_tree = tree;
        this.init();
    }

    protected OiiftTreeDataSource() {
    }

    public void setTree(OiiftDataDrivenTree tree) {
        this.m_tree = tree;
        this.init();
    }

    public void resetTree(OiiftDataDrivenTree tree) {
        this.m_tree = tree;
    }

    protected void init() {
    }

    protected abstract DTreeItem internal_createItem(DTreeDeferringParent var1, int var2);

    protected abstract int internal_getItemCount();

    protected abstract Object internal_getData(int var1);

    protected abstract void internal_setData(int var1, Object var2);

    protected abstract void internal_clearData();

    protected abstract void internal_refreshData();

    protected void setImageList(Image[] imgList) {
        this.m_imageList = imgList;
    }

    protected Image[] getImageList() {
        return this.m_imageList;
    }

    public DTreeItem getNode() {
        return this.m_node;
    }

    protected void setNode(DTreeItem node) {
        this.m_node = node;
    }

    protected OiiftDataDrivenTree getTree() {
        return this.m_tree;
    }

    protected void processEvent(OneDDataSourceEvent evt) {
        Enumeration listeners;
        if (this.m_oneDManager == null || (listeners = this.m_oneDManager.getListeners()) == null) {
            return;
        }
        int evtid = evt.getID();
        block5: while (listeners.hasMoreElements()) {
            OneDDataSourceListener l = (OneDDataSourceListener)listeners.nextElement();
            switch (evtid) {
                case 2001: {
                    l.itemsAdded(evt);
                    continue block5;
                }
                case 2002: {
                    l.itemsRemoved(evt);
                    continue block5;
                }
                case 2003: {
                    l.invalidateItems(evt);
                    continue block5;
                }
            }
        }
    }

    public final int getItemCount() {
        if (this.m_dsList == null) {
            this._loadDataSources();
        }
        int numItems = this.m_dsList[0].internal_getItemCount();
        return numItems;
    }

    public final Object getData(int index) {
        DSHelper helper = this._locate(index);
        if (helper == null) {
            return null;
        }
        return this.m_dsList[helper.dsIndex].internal_getData(helper.itemIndex);
    }

    public final void setData(int index, Object data) {
        DSHelper helper = this._locate(index);
        if (helper == null) {
            return;
        }
        this.m_dsList[helper.dsIndex].internal_setData(helper.itemIndex, data);
    }

    public final void addDataSourceListener(OneDDataSourceListener listener) {
        if (this.m_oneDManager == null) {
            this.m_oneDManager = new ListenerManager();
        }
        this.m_oneDManager.addListener((EventListener)listener);
    }

    public final void removeDataSourceListener(OneDDataSourceListener listener) {
        if (this.m_oneDManager != null) {
            this.m_oneDManager.removeListener((EventListener)listener);
        }
    }

    public final DTreeItem createItem(DTreeDeferringParent parent, int index) {
        DSHelper helper = this._locate(index);
        if (helper == null) {
            return null;
        }
        return this.m_dsList[helper.dsIndex].internal_createItem(parent, helper.itemIndex);
    }

    public final void clearData() {
        if (this.m_dsList == null) {
            this._loadDataSources();
        }
        this.m_dsList[0].internal_clearData();
    }

    public final void refreshData() {
        if (this.m_dsList == null) {
            this._loadDataSources();
        }
        this.m_dsList[0].internal_refreshData();
    }

    public boolean isNodeExpandable() {
        if (this.m_dsList == null) {
            this._loadDataSources();
        }
        return true;
    }

    private DSHelper _locate(int index) {
        for (int i = 0; i < this.m_dsList.length; ++i) {
            int count = this.m_dsList[i].internal_getItemCount();
            if (index < count) {
                return new DSHelper(i, index);
            }
            index -= count;
        }
        return null;
    }

    private void _loadDataSources() {
        Vector dsList_temp = null;
        int dsCount = 0;
        this.m_dsList = new OiiftTreeDataSource[dsCount + 1];
        this.m_dsList[0] = this;
        for (int i = 0; i < dsCount; ++i) {
            this.m_dsList[i + 1] = (OiiftTreeDataSource)dsList_temp.elementAt(i);
            this.m_dsList[i + 1].m_node = this.m_node;
            this.m_dsList[i + 1].m_oneDManager = this.m_oneDManager;
        }
    }

    class DSHelper {
        int dsIndex;
        int itemIndex;

        DSHelper(int ds, int item) {
            this.dsIndex = ds;
            this.itemIndex = item;
        }
    }
}

