/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifr;

import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifrProgressPhases {
    public static final int DEINSTALL = 1;
    public static final int INSTALL = 2;
    public static final int LINK = 4;
    public static final int INSTALLPHASE2 = 8;
    public static final int SAVE_INVENTORY = 16;
    public static final int CLUSTER = 32;
    public static final int POSTINSTALLPHASE = 64;
    public static final int ADD_NODE_INSTANTIATE = 128;
    public static final int ADD_NODE_COPY = 256;
    public static final int ADD_NODE_HOME_SETUP = 512;
    public static final int ADD_NODE_SAVE_INV = 1024;
    public static final int ADD_NODE_ROOT_SH = 2048;
    public static int NUM_PHASES = 0;
    public static final int DEINSTALL_PHASE = NUM_PHASES++;
    public static final int INSTALL_PHASE = NUM_PHASES++;
    public static final int LINK_PHASE = NUM_PHASES++;
    public static final int INSTALL_PHASE2 = NUM_PHASES++;
    public static final int CLUSTER_PHASE = NUM_PHASES++;
    public static final int POSTINSTALL_PHASE = NUM_PHASES++;
    public static final int ADD_NODE_INSTANTIATE_PHASE = NUM_PHASES++;
    public static final int ADD_NODE_COPY_PHASE = NUM_PHASES++;
    public static final int ADD_NODE_HOME_SETUP_PHASE = NUM_PHASES++;
    public static final int ADD_NODE_SAVE_INV_PHASE = NUM_PHASES++;
    public static final int ADD_NODE_ROOT_SH_PHASE = NUM_PHASES++;
    public static final int SAVE_INVENTORY_PHASE = NUM_PHASES++;
    private static String[] s_asPhaseSuffix = new String[]{"DEINSTALL", "INSTALL", "LINK", "SETUP", "CLUSTER", "POSTINSTALL", "ADD_NODE_INSTANTIATE", "ADD_NODE_COPY", "ADD_NODE_HOME_SETUP", "ADD_NODE_SAVE_INV", "ADD_NODE_ROOT_SH", "SAVE_INVENTORY"};
    private static final String S_PHASE_PENDING = "S_PHASE_PENDING_";
    private static final String S_PHASE_INPROGRESS = "S_PHASE_INPROGRESS_";
    private static final String S_PHASE_DONE = "S_PHASE_DONE_";
    private static final String S_COMP_INPROGRESS = "S_COMP_INPROGRESS_";

    public static int getPhaseIndex(int phase) {
        int iPhaseIdx = 0;
        switch (phase) {
            case 1: {
                iPhaseIdx = DEINSTALL_PHASE;
                break;
            }
            case 2: {
                iPhaseIdx = INSTALL_PHASE;
                break;
            }
            case 4: {
                iPhaseIdx = LINK_PHASE;
                break;
            }
            case 8: {
                iPhaseIdx = INSTALL_PHASE2;
                break;
            }
            case 64: {
                iPhaseIdx = POSTINSTALL_PHASE;
                break;
            }
            case 32: {
                iPhaseIdx = CLUSTER_PHASE;
                break;
            }
            case 128: {
                iPhaseIdx = ADD_NODE_INSTANTIATE_PHASE;
                break;
            }
            case 256: {
                iPhaseIdx = ADD_NODE_COPY_PHASE;
                break;
            }
            case 512: {
                iPhaseIdx = ADD_NODE_HOME_SETUP_PHASE;
                break;
            }
            case 1024: {
                iPhaseIdx = ADD_NODE_SAVE_INV_PHASE;
                break;
            }
            case 2048: {
                iPhaseIdx = ADD_NODE_ROOT_SH_PHASE;
                break;
            }
            case 16: {
                iPhaseIdx = SAVE_INVENTORY_PHASE;
            }
        }
        return iPhaseIdx;
    }

    public static String getPhasePendingString(int phase) {
        return OiixResourceBundle.getString(S_PHASE_PENDING + s_asPhaseSuffix[OiifrProgressPhases.getPhaseIndex(phase)]);
    }

    public static String getPhaseInProgressString(int phase) {
        return OiixResourceBundle.getString(S_PHASE_INPROGRESS + s_asPhaseSuffix[OiifrProgressPhases.getPhaseIndex(phase)]);
    }

    public static String getPhaseDoneString(int phase) {
        return OiixResourceBundle.getString(S_PHASE_DONE + s_asPhaseSuffix[OiifrProgressPhases.getPhaseIndex(phase)]);
    }

    public static String getComponentInProgressString(int phase, Object[] arr) {
        return OiixResourceBundle.getString(S_COMP_INPROGRESS + s_asPhaseSuffix[OiifrProgressPhases.getPhaseIndex(phase)], arr);
    }
}

