/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifp;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.MessageFormat;
import java.util.Locale;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.lwAWT.lwText.LWTextArea;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.painter.NullPainter;
import oracle.ewt.painter.Painter;
import oracle.ewt.textWrapper.TextWrapper;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.sysman.oii.oiic.OiicExitOps;
import oracle.sysman.oii.oiic.OiicGlobalContext;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiif.oiifb.OiifbStackLayout;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiif.oiifp.OiifpWizPanel;
import oracle.sysman.oii.oiif.oiifr.OiifrAdvertisementPanel;
import oracle.sysman.oii.oiif.oiifr.OiifrAnimationPanel;
import oracle.sysman.oii.oiif.oiifr.OiifrProgressActionListener;
import oracle.sysman.oii.oiif.oiifr.OiifrProgressPanel;
import oracle.sysman.oii.oiif.oiifr.OiifrProgressUIListener;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiio.oiiod.OiiodDepEngine;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifpWizInstallPanel
extends OiifpWizPanel
implements ActionListener,
KeyListener {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 256;
    private LWButton m_button = null;
    private OiifrProgressUIListener m_listener = null;
    private OiifrProgressPanel m_progressPanel = null;
    private OiicPullSession m_oSession = null;
    private int m_displayedAdIndex = -1;
    private LWTextArea m_logPrompt = null;
    private boolean m_cancelDlgIsShowing = false;

    public OiifpWizInstallPanel(OiicPullSession oSession, int phases) {
        super(OiixResourceBundle.getString("S_INSTALL_HEADING"));
        OiicSessionContext oContext;
        this.m_oSession = oSession;
        this.m_displayedAdIndex = 0;
        this.m_cancelDlgIsShowing = false;
        String lbl = OiixResourceBundle.getString("S_STOP_INSTALL_BUTTON");
        this.m_button = new LWButton(lbl);
        this.m_button.setFocusable(true);
        this.m_button.addActionListener((ActionListener)this);
        this.m_button.setRightmost(true);
        this.m_button.setLeftmost(true);
        OiiodDepEngine depEngine = this.m_oSession.getDepEngine();
        long totalSize = depEngine != null ? depEngine.getTotalRequiredSpace() : 0L;
        this.m_progressPanel = new OiifrProgressPanel(phases, totalSize);
        this.dlgPanel.setLayout((LayoutManager)new BorderLayout());
        GridBagLayout gridbag = new GridBagLayout();
        LWContainer pSide = new LWContainer((LayoutManager)gridbag);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, 0, 5, 30);
        c.fill = 1;
        c.anchor = 18;
        c.weightx = 1.0;
        c.weighty = 0.1;
        c.gridwidth = 0;
        int numPrevSessions = 0;
        if (Boolean.getBoolean("oracle.installer.install.showinstalledproducts")) {
            OiicGlobalContext oGlobalContext = OiicGlobalContext.getGlobalContext();
            numPrevSessions = oGlobalContext != null ? oGlobalContext.getSize() : 0;
            OiiiInstallAreaControl invAreaControl = (OiiiInstallAreaControl)OiiiInstallAreaControl.getInventoryAreaControl();
            OiiiInstallInventory inventory = null;
            if (invAreaControl != null) {
                inventory = invAreaControl.getInstallInventory();
            }
            if (numPrevSessions > 0) {
                c.gridheight = numPrevSessions;
                LWContainer cont2 = new LWContainer((LayoutManager)new GridLayout(numPrevSessions, 1, 0, 0));
                Font plainFont = new Font("Dialog", 0, 11);
                TextWrapper twrap = WordWrapper.getTextWrapper();
                LWContainer homePanel = null;
                MultiLineLabel[] t = new MultiLineLabel[numPrevSessions];
                for (int k = 0; k < numPrevSessions; ++k) {
                    String compLabel = null;
                    try {
                        String sKey = oGlobalContext.getKey(k);
                        String sOHName = oGlobalContext.getOracleHome(k);
                        OiiiCompInstallID currComp = (OiiiCompInstallID)oGlobalContext.getVarValue(sKey, "ToplevelComp");
                        OiiiOracleHomeInfo ohInfo = inventory.getHomeWithName(sOHName);
                        OiiiCompInvEntry entry = inventory.getCompInvEntry(currComp, ohInfo.getIndex());
                        if (Boolean.getBoolean("oracle.installer.install.showproductversion")) {
                            compLabel = entry.getFullDisplayName();
                        }
                        if (compLabel == null) {
                            compLabel = entry.getName();
                        }
                    }
                    catch (Exception err) {
                        OiiolTextLogger.appendText(err.toString(), OiiolTextLogger.LOG_DETAILED);
                    }
                    homePanel = new LWContainer((LayoutManager)new BorderLayout(5, 5));
                    compLabel = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CHAIN_INSTALLED_PRODUCTS", new String[]{compLabel});
                    t[k] = new MultiLineLabel(twrap, compLabel);
                    t[k].setPreferredAspectRatio(0.0f);
                    t[k].setFont(plainFont);
                    homePanel.add((Component)t[k], (Object)"Center");
                    OiifrAnimationPanel mycheckMark = new OiifrAnimationPanel();
                    homePanel.add((Component)((Object)mycheckMark), (Object)"West");
                    cont2.add((Component)homePanel);
                    mycheckMark.setProgressVisible(true);
                    mycheckMark.stopAnimation();
                }
                gridbag.setConstraints((Component)cont2, c);
                pSide.add((Component)cont2);
            }
        }
        c.insets = new Insets(5, 0, 5, 30);
        if (numPrevSessions == 0) {
            c.weighty = 0.5;
            boolean isReduceInset = this.m_progressPanel.isReduceInset();
            c.insets = isReduceInset ? new Insets(5, 0, 10, 0) : new Insets(5, 0, 10, 30);
        }
        gridbag.setConstraints((Component)((Object)this.m_progressPanel), c);
        pSide.add((Component)((Object)this.m_progressPanel));
        c.weighty = 0.8;
        if (numPrevSessions == 0) {
            c.weighty = 0.5;
        }
        c.fill = 0;
        gridbag.setConstraints((Component)this.m_button, c);
        pSide.add((Component)this.m_button);
        this.dlgPanel.add((Component)pSide, (Object)"Center");
        LWContainer cont = new LWContainer((LayoutManager)new OiifbStackLayout());
        OiifrAdvertisementPanel adImagePanel = new OiifrAdvertisementPanel();
        cont.add("Right".toUpperCase(Locale.ENGLISH), (Component)((Object)adImagePanel));
        this.dlgPanel.add((Component)cont, (Object)"East");
        this.m_progressPanel.setAdImagePanel(adImagePanel);
        if (Boolean.getBoolean("oracle.installer.install.showproductname") && (oContext = this.m_oSession.getSessionContext()) != null) {
            String sOHName = (String)oContext.getVarValue("ORACLE_HOME_NAME");
            OiiiCompInstallID currComp = (OiiiCompInstallID)oContext.getVarValue("ToplevelComp");
            String compLabel = null;
            if (Boolean.getBoolean("oracle.installer.install.showproductversion")) {
                compLabel = this.m_oSession.getStgCompDisplayName(currComp);
            }
            if (compLabel == null) {
                compLabel = currComp.getName();
            }
            this.m_progressPanel.setCurProduct(compLabel);
        }
        if (this.m_descLabel.getParent() == this.mainPanel) {
            this.mainPanel.remove((Component)this.m_descLabel);
        }
        String logStr = OiixResourceBundle.getString("S_LOG_LOC_PROMPT");
        String curLogFile = OiiolTextLogger.getCurLogFileName();
        if (curLogFile == null) {
            curLogFile = "";
        }
        Object[] arr = new String[]{curLogFile};
        this.m_logPrompt = new LWTextArea(MessageFormat.format(logStr, arr));
        this.m_logPrompt.addKeyListener((KeyListener)this);
        this.m_logPrompt.setFocusable(true);
        this.m_logPrompt.setEditable(false);
        this.m_logPrompt.setRows(4);
        this.m_logPrompt.setTextWrapper(WordWrapper.getTextWrapper());
        this.m_logPrompt.setBorderPainter(NullPainter.getPainter());
        this.m_logPrompt.setFill((Painter)NullPainter.getPainter());
        this.m_logPrompt.setFont(new Font("SansSerif", 0, 11));
        this.mainPanel.add((Component)this.m_logPrompt, (Object)"South");
        this.m_button.requestFocus();
        this.m_progressPanel.setStopButton(this.m_button);
    }

    public OiifpWizInstallPanel(OiicPullSession oSession) {
        this(oSession, 3);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.m_button) {
            this.onCancel();
        }
    }

    public void startProgressStatusPainter() {
        this.m_progressPanel.startProgressPainter();
    }

    private void onCancel() {
        this.m_listener.onCancel();
        if (!this.m_cancelDlgIsShowing) {
            this.m_cancelDlgIsShowing = true;
            this.m_button.setEnabled(false);
            this.m_progressPanel.onSuspend();
            int flags = 5;
            String title = OiixResourceBundle.getString("S_EXIT_TITLE");
            String message = OiixResourceBundle.getString("S_CANCEL_ALL_EXIT_WARNING");
            int cancelVal = 1;
            cancelVal = OiifmAlert.displayAlert(title, message, 30, 3, 2, 10);
            switch (cancelVal) {
                case 1: {
                    if (null != this.m_listener) {
                        this.m_listener.onCancelConfirm(true);
                    }
                    this.m_progressPanel.setStatus(OiixResourceBundle.getString("S_WAIT_ON_CANCEL"));
                    OiicExitOps.getExitOps().exit();
                    break;
                }
                case 2: {
                    if (this.m_listener != null) {
                        this.m_listener.onResume();
                    }
                    this.m_progressPanel.onResume();
                }
            }
            this.m_cancelDlgIsShowing = false;
            this.m_button.setEnabled(true);
            this.m_button.requestFocus();
        }
    }

    private void enableCancel(boolean bEnable) {
        this.m_button.setEnabled(bEnable);
    }

    public void addProgressUIListener(OiifrProgressUIListener plistener) {
        this.m_listener = plistener;
    }

    public OiifrProgressActionListener getProgressActionListener() {
        return this.m_progressPanel;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyChar() == '\t') {
            this.m_logPrompt.setFocusable(false);
            this.m_logPrompt.setFocusable(true);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

