/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifp;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.bali.share.sort.Comparator;
import oracle.bali.share.sort.LexiComparator;
import oracle.bali.share.sort.Sort;
import oracle.ewt.dTree.DTreeItem;
import oracle.ewt.dTree.DTreeSimpleParent;
import oracle.ewt.dTree.DTreeSimpleRoot;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.lwAWT.lwText.LWTextArea;
import oracle.ewt.scrolling.scrollBox.ScrollBox;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.sysman.oii.oiic.OiicInstallSession;
import oracle.sysman.oii.oiic.OiicLangAddonSession;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiif.oiifm.OiifmImage;
import oracle.sysman.oii.oiif.oiifm.OiifmTree;
import oracle.sysman.oii.oiif.oiifm.OiifmTreeItem;
import oracle.sysman.oii.oiif.oiifp.OiifpWizPanel;
import oracle.sysman.oii.oiif.oiifw.OiifwSummaryWCDE;
import oracle.sysman.oii.oiii.OiiiCompIdOhPair;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiOneoffIdOhPair;
import oracle.sysman.oii.oiii.OiiiOneoffInstallID;
import oracle.sysman.oii.oiii.OiiiStageCompInvEntry;
import oracle.sysman.oii.oiii.OiiiStageInventory;
import oracle.sysman.oii.oiio.oiiod.OiiodDepEngine;
import oracle.sysman.oii.oiio.oiiod.OiiodVolumeInfo;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiis.OiisCompInstallation;
import oracle.sysman.oii.oiis.OiisDepInfo;
import oracle.sysman.oii.oiis.OiisDepMode;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixLanguage;
import oracle.sysman.oii.oiix.OiixOraparam;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiifpSummaryPanel
extends OiifpWizPanel {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 256;
    private static final int LIST_BUTTON_GAP = 5;
    private static final String DELIM = ", ";
    private final int BORDER_VGAP = 5;
    private final int BORDER_HGAP = 5;
    private OiicInstallSession m_pullSession;
    private OiiiInstallInventory m_inventory;
    private OiiiStageInventory m_stageInventory;
    private OiiiCompInstallID m_tlComp;
    private OiifmTree m_oSummaryTree;
    private ScrollBox scrollbox;
    private ScrollBox summaryScrollbox;
    private LWContainer compPanel;
    private LWContainer summaryPanel;
    private LWTextArea m_textArea;
    private Font m_tBoldFont;
    private boolean m_diskFull;
    private Boolean m_bSummary = Boolean.TRUE;
    private static long s_lStartTime;
    private boolean[] m_bNodes = new boolean[10];
    private final int NUM_NODES = 10;
    private static final int GLOBAL = 0;
    private static final int LANGS = 1;
    private static final int UPGRADELANGS = 1;
    private static final int SPACE = 2;
    private static final int NEWINSTALLS = 3;
    private static final int LANGUPGRADECOMPS = 3;
    private static final int REINSTALLS = 4;
    private static final int DEINSTALLS = 5;
    private static final int EXISTINGINSTALLS = 6;
    private static final int UPGRADES = 7;
    private static final int DOWNGRADES = 8;
    private static final int NEWLANGS = 9;
    private static final String s_global = "Global";
    private static final String s_langs = "Langs";
    private static final String s_space = "Space";
    private static final String s_newInstalls = "NewInstalls";
    private static final String s_reinstalls = "Reinstalls";
    private static final String s_deinstalls = "Deinstalls";
    private static final String s_existingInstalls = "ExistingInstalls";
    private static final String s_upgrades = "Upgrades";
    private static final String s_downgrades = "Downgrades";
    private static final String s_newLangs = "NewLangs";
    private String m_sSummaryFile = null;
    private static final String s_sLineSeparator;

    public OiifpSummaryPanel() {
        super(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_SUMMARY"));
    }

    @Override
    public void createPanelElements() {
        this.m_pullSession = (OiicInstallSession)this.m_wcde.getVarOwner().getSession();
        this.m_sSummaryFile = System.getProperty("oracle.installer.shsummary");
        this.compPanel = new LWContainer();
        this.compPanel.setLayout((LayoutManager)new BorderLayout(5, 5));
        this.m_oSummaryTree = new OiifmTree();
        this.scrollbox = new ScrollBox((Component)((Object)this.m_oSummaryTree), 0, 0);
        this.compPanel.add((Component)this.scrollbox, (Object)"Center");
        if (this.m_sSummaryFile == null || this.m_sSummaryFile.length() == 0) {
            this.m_sSummaryFile = null;
            this.dlgPanel.setLayout((LayoutManager)new GridLayout(1, 1));
            this.dlgPanel.add((Component)this.compPanel);
        } else {
            this.dlgPanel.setLayout((LayoutManager)new GridLayout(2, 1));
            this.summaryPanel = new LWContainer();
            this.summaryPanel.setLayout((LayoutManager)new BorderLayout(5, 5));
            this.summaryPanel.setBackground(Color.white);
            this.m_textArea = new LWTextArea();
            this.m_textArea.setTextWrapper(WordWrapper.getTextWrapper());
            this.m_textArea.setFill(null);
            this.m_textArea.setEditable(false);
            this.summaryScrollbox = new ScrollBox((Component)this.m_textArea, 0, 0);
            this.summaryPanel.add((Component)this.summaryScrollbox, (Object)"Center");
            this.dlgPanel.add((Component)this.compPanel);
            this.dlgPanel.add((Component)this.summaryPanel);
        }
        this.init();
        this.validate();
    }

    @Override
    public void dispose() {
        if (this.scrollbox != null) {
            this.scrollbox.removeAll();
        }
        if (this.m_oSummaryTree != null) {
            this.m_oSummaryTree.dispose();
        }
        if (this.compPanel != null) {
            this.compPanel.removeAll();
        }
        if (this.dlgPanel != null) {
            this.dlgPanel.removeAll();
        }
        if (this.mainPanel != null) {
            this.mainPanel.removeAll();
        }
        this.removeAll();
        this.dlgPanel = null;
        this.compPanel = null;
        this.scrollbox = null;
        this.mainPanel = null;
        this.m_oSummaryTree = null;
        this.m_pullSession = null;
        this.m_inventory = null;
        this.m_stageInventory = null;
    }

    public Boolean getShowSummary() {
        return this.m_bSummary;
    }

    public void setShowSummary(Boolean bShow) {
        this.m_bSummary = bShow;
    }

    public void init() {
        this.m_inventory = this.m_pullSession.getInstallAreaControl().getInstallInventory();
        this.m_stageInventory = this.m_pullSession.getSourceAccess().getStageInventory();
        if (!OiicPullSession.isLangAddonMode()) {
            OiiiCompInstallID[] cids = this.m_pullSession.getSelTopLevelCompIDs();
            this.m_tlComp = cids[0];
            if (cids.length == 1) {
                String[] arr = new String[]{!OiixOraparam.canShowSummaryVersion() ? this.getCompInvEntry(this.m_tlComp).getName() : this.getCompInvEntry(this.m_tlComp).getFullDisplayName(OiixOraparam.canIgnoreBuildNumber())};
                this.setSubTitleLabel(arr[0]);
            }
        }
        this.populateTree();
        if (this.m_sSummaryFile != null) {
            this.displaySummaryText();
        }
        this.scrollbox.validate();
        this.validate();
    }

    private OiiiCompInvEntry getCompInvEntry(OiiiCompInstallID cid) {
        OiiiStageInventory stageInv = this.m_pullSession.getSourceAccess().getStageInventory();
        OiiiStageCompInvEntry entry = stageInv.getStageCompInvEntry(cid);
        return entry;
    }

    public void populateTree() {
        if (this.m_tBoldFont == null) {
            this.m_tBoldFont = new Font(OiixResourceBundle.getFont(), OiixLanguage.getFontStyle(1), 12);
        }
        this.m_oSummaryTree.removeAll();
        for (int i = 0; i < this.m_bNodes.length; ++i) {
            this.m_bNodes[i] = false;
        }
        String sList = System.getProperty("oracle.installer.summary_expand_nodes");
        OiiolTextLogger.appendText("oracle.installer.summary_expand_nodes = " + sList, OiiolTextLogger.LOG_DETAILED);
        if (sList != null) {
            StringTokenizer tokenizer = new StringTokenizer(sList, DELIM);
            while (tokenizer.hasMoreTokens()) {
                String sNode = tokenizer.nextToken();
                if (sNode.equalsIgnoreCase(s_global)) {
                    this.m_bNodes[0] = true;
                    continue;
                }
                if (sNode.equalsIgnoreCase(s_langs)) {
                    this.m_bNodes[1] = true;
                    continue;
                }
                if (sNode.equalsIgnoreCase(s_space)) {
                    this.m_bNodes[2] = true;
                    continue;
                }
                if (sNode.equalsIgnoreCase(s_newInstalls)) {
                    this.m_bNodes[3] = true;
                    continue;
                }
                if (sNode.equalsIgnoreCase(s_reinstalls)) {
                    this.m_bNodes[4] = true;
                    continue;
                }
                if (sNode.equalsIgnoreCase(s_deinstalls)) {
                    this.m_bNodes[5] = true;
                    continue;
                }
                if (sNode.equalsIgnoreCase(s_existingInstalls)) {
                    this.m_bNodes[6] = true;
                    continue;
                }
                if (sNode.equalsIgnoreCase(s_upgrades)) {
                    this.m_bNodes[7] = true;
                    continue;
                }
                if (sNode.equalsIgnoreCase(s_downgrades)) {
                    this.m_bNodes[8] = true;
                    continue;
                }
                if (!sNode.equalsIgnoreCase(s_newLangs)) continue;
                this.m_bNodes[9] = true;
            }
        }
        this.addGlobalInfos();
        if (OiicPullSession.isLangAddonMode()) {
            this.addSpaceInfos();
            this.addUpgradedLangsInfo();
            this.addLangAddonProductInfos();
        } else {
            this.addSpaceInfos();
            this.addLangInfo();
            this.addProductInfos();
        }
    }

    public void displaySummaryText() {
        if (this.m_wcde != null && this.m_wcde instanceof OiifwSummaryWCDE) {
            OiifwSummaryWCDE summaryWCDE = (OiifwSummaryWCDE)this.m_wcde;
            Vector oSummaryText = summaryWCDE.getSummaryText();
            if (oSummaryText == null) {
                summaryWCDE.processSummaryFile();
                oSummaryText = summaryWCDE.getSummaryText();
            }
            if (oSummaryText != null) {
                int numLines = oSummaryText.size();
                String text = "";
                for (int i = 0; i < numLines; ++i) {
                    text = text + oSummaryText.elementAt(i) + s_sLineSeparator;
                }
                this.m_textArea.setText(text);
            }
        }
    }

    public void logSummaryInfo() {
        if (this.m_oSummaryTree != null) {
            this.m_oSummaryTree.logTree(null, "", OiiolTextLogger.LOG_BASIC);
        }
    }

    private String getDisplayName(OiiiCompIdOhPair coh, boolean bStageInv) {
        OiiiCompInstallID cid = coh.getCompID();
        OiiiCompInvEntry entry = bStageInv ? this.m_stageInventory.getStageCompInvEntry(cid) : this.m_inventory.getCompInvEntry(cid, this.m_pullSession.getHomeIndex(cid));
        return entry.getFullDisplayName();
    }

    private void sortCompListByName(Vector v, boolean bStageInv) {
        int vectSize = v.size();
        Object[] asNames = new String[vectSize];
        for (int i = 0; i < vectSize; ++i) {
            OiiiCompIdOhPair earlEl = (OiiiCompIdOhPair)v.elementAt(i);
            asNames[i] = this.getDisplayName(earlEl, bStageInv);
        }
        int[] aiSortIndex = Sort.indirectQSort((Object[])asNames, (int)asNames.length, (Comparator)LexiComparator.getComparator());
        Object[] aoVectElems = new Object[vectSize];
        v.toArray(aoVectElems);
        for (int i = 0; i < vectSize; ++i) {
            v.setElementAt(aoVectElems[aiSortIndex[i]], i);
        }
    }

    private void sortLangListByName(Vector v) {
        int vectSize = v.size();
        Object[] asNames = new String[vectSize];
        for (int i = 0; i < vectSize; ++i) {
            asNames[i] = (String)v.elementAt(i);
        }
        int[] aiSortIndex = Sort.indirectQSort((Object[])asNames, (int)asNames.length, (Comparator)LexiComparator.getComparator());
        Object[] aoVectElems = new Object[vectSize];
        v.toArray(aoVectElems);
        for (int i = 0; i < vectSize; ++i) {
            v.setElementAt(aoVectElems[aiSortIndex[i]], i);
        }
    }

    private void addProductInfos() {
        OiifmTreeItem oCompItem;
        OiiiCompInstallID cid;
        OiiiCompIdOhPair coh;
        int i;
        DTreeSimpleRoot root = this.m_oSummaryTree.getSimpleRoot();
        OiifmTreeItem oDeinstallOneoffs = new OiifmTreeItem(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ONEOFF_DEINSTALL_STRING"), null, null);
        oDeinstallOneoffs.setFont(this.m_tBoldFont);
        boolean bAddOneoffDeinsNode = false;
        if (this.m_inventory != null) {
            Vector oMiniPatchsets;
            Vector oOneoffs;
            OiiiOneoffInstallID oID;
            Map oConflictingOneoffs = this.m_pullSession.getDepEngine().getConflictingOneoffs();
            Set oOneOffsList = oConflictingOneoffs.keySet();
            int iSize = oOneOffsList.size();
            if (iSize > 0) {
                bAddOneoffDeinsNode = true;
                for (OiiiOneoffIdOhPair oOneoffIdOhPair : oOneOffsList) {
                    oID = oOneoffIdOhPair.getOneoffID();
                    String resString = "";
                    String displayString = "";
                    if (oOneoffIdOhPair.isOneoff()) {
                        resString = "S_CONFLICTING_ONE_OFF";
                        displayString = oID.getDisplayString();
                    } else {
                        resString = "S_CONFLICTING_MINIPS";
                        displayString = oID.getDisplayStringForMiniPatchset();
                    }
                    OiifmImage imgBundle = new OiifmImage(null, "Oiir");
                    Image image = imgBundle.getImage("5000");
                    OiifmTreeItem oOneoffItem = new OiifmTreeItem(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", resString, new String[]{displayString}), image, oID);
                    oOneoffItem.setToolTipText(oID.getID());
                    oOneoffItem.setForeground(Color.black);
                    oDeinstallOneoffs.addItem((DTreeItem)oOneoffItem);
                }
            }
            if ((iSize = (oOneoffs = this.m_pullSession.getDepEngine().getOneoffsToDeinstall()).size()) > 0) {
                bAddOneoffDeinsNode = true;
                for (int ij = 0; ij < iSize; ++ij) {
                    oID = (OiiiOneoffInstallID)oOneoffs.get(ij);
                    OiifmTreeItem oOneoffItem = new OiifmTreeItem(oID.getDisplayString(), null, oID);
                    oOneoffItem.setToolTipText(oID.getID());
                    oDeinstallOneoffs.addItem((DTreeItem)oOneoffItem);
                }
            }
            if ((iSize = (oMiniPatchsets = this.m_pullSession.getDepEngine().getMiniPatchsetsToDeinstall()).size()) > 0) {
                bAddOneoffDeinsNode = true;
                for (int ij = 0; ij < iSize; ++ij) {
                    OiiiOneoffInstallID oID2 = (OiiiOneoffInstallID)oMiniPatchsets.get(ij);
                    OiifmTreeItem oOneoffItem = new OiifmTreeItem(oID2.getDisplayStringForMiniPatchset(), null, oID2);
                    oOneoffItem.setToolTipText(oID2.getID());
                    oDeinstallOneoffs.addItem((DTreeItem)oOneoffItem);
                }
            }
        }
        if (bAddOneoffDeinsNode) {
            root.addItem((DTreeItem)oDeinstallOneoffs);
            oDeinstallOneoffs.setExpanded(this.m_bNodes[5]);
        }
        String reinstallStr = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_REINSTALL");
        OiifmTreeItem oReinstallsItem = new OiifmTreeItem(reinstallStr, null, null);
        oReinstallsItem.setFont(this.m_tBoldFont);
        root.addItem((DTreeItem)oReinstallsItem);
        String downgradeStr = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_DOWNGRADES");
        OiifmTreeItem oDowngradeItem = new OiifmTreeItem(downgradeStr, null, null);
        oDowngradeItem.setFont(this.m_tBoldFont);
        root.addItem((DTreeItem)oDowngradeItem);
        String upgradeStr = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_UPGRADES");
        OiifmTreeItem oUpgradeItem = new OiifmTreeItem(upgradeStr, null, null);
        oUpgradeItem.setFont(this.m_tBoldFont);
        root.addItem((DTreeItem)oUpgradeItem);
        String newStr = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_NEW_INSTALL");
        OiifmTreeItem oNewInstallItem = new OiifmTreeItem(newStr, null, null);
        oNewInstallItem.setFont(this.m_tBoldFont);
        root.addItem((DTreeItem)oNewInstallItem);
        String inMachine = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_INMACHINE");
        OiifmTreeItem oInMachineItem = new OiifmTreeItem(inMachine, null, null);
        oInMachineItem.setFont(this.m_tBoldFont);
        root.addItem((DTreeItem)oInMachineItem);
        Vector installIEs = this.m_pullSession.getSessionPlan().getSuccessfulAdditions(10);
        Vector comps = this.m_pullSession.getDepEngine().getCompsToInstallAsOhVector();
        Vector vPatchSets = this.m_pullSession.getDepEngine().getSelectedPatchSetsAsOhVector();
        OiixVectorOps.unionInPlace(comps, vPatchSets);
        this.sortCompListByName(comps, true);
        int numElems = comps.size();
        block9: for (i = 0; i < numElems; ++i) {
            coh = (OiiiCompIdOhPair)comps.elementAt(i);
            cid = coh.getCompID();
            if (cid.getCompType() != 4 && OiixVectorOps.vectIndexOf(installIEs, (Object)cid) == -1) continue;
            oCompItem = this.constructSingleItem(cid, true);
            switch (coh.getCompInstallType()) {
                case 0: {
                    oNewInstallItem.addItem((DTreeItem)oCompItem);
                    continue block9;
                }
                case 2: {
                    OiiodDepEngine depEngine = this.m_pullSession.getDepEngine();
                    if (depEngine != null && depEngine.isTopLevelSelComp(cid)) {
                        System.setProperty("oracle.installer.fastcopy", "false");
                    }
                    oReinstallsItem.addItem((DTreeItem)oCompItem);
                    continue block9;
                }
                case 1: {
                    oUpgradeItem.addItem((DTreeItem)oCompItem);
                    continue block9;
                }
                case 3: {
                    oDowngradeItem.addItem((DTreeItem)oCompItem);
                }
            }
        }
        if (this.m_inventory != null) {
            comps = this.m_pullSession.getDepEngine().getAlreadyIntalledCompsAsOhVector();
            this.sortCompListByName(comps, false);
            numElems = comps.size();
            for (i = 0; i < numElems; ++i) {
                coh = (OiiiCompIdOhPair)comps.elementAt(i);
                cid = coh.getCompID();
                oCompItem = this.constructSingleItem(cid, false);
                oInMachineItem.addItem((DTreeItem)oCompItem);
            }
        }
        boolean bExpanded = false;
        if (this.setInitPositions(oNewInstallItem, newStr)) {
            bExpanded = this.m_bNodes[3];
            oNewInstallItem.setExpanded(bExpanded);
        }
        if (this.setInitPositions(oUpgradeItem, upgradeStr) && !bExpanded) {
            bExpanded = this.m_bNodes[7];
            oUpgradeItem.setExpanded(bExpanded);
        }
        this.setInitPositions(oDowngradeItem, downgradeStr);
        oDowngradeItem.setExpanded(this.m_bNodes[8]);
        if (this.setInitPositions(oReinstallsItem, reinstallStr) && !bExpanded) {
            bExpanded = this.m_bNodes[4];
            oReinstallsItem.setExpanded(bExpanded);
        }
        this.setInitPositions(oInMachineItem, inMachine);
        oInMachineItem.setExpanded(this.m_bNodes[6]);
    }

    private void addLangAddonProductInfos() {
        DTreeSimpleRoot root = this.m_oSummaryTree.getSimpleRoot();
        OiifmTreeItem oLangAddonProductItem = new OiifmTreeItem(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFP1001"), null, null);
        oLangAddonProductItem.setFont(this.m_tBoldFont);
        root.addItem((DTreeItem)oLangAddonProductItem);
        Vector installIEs = this.m_pullSession.getSessionPlan().getSuccessfulAdditions(10);
        for (int i = 0; i < installIEs.size(); ++i) {
            OiiiCompInstallID compID = ((OiiiCompInvEntry)installIEs.elementAt(i)).getCompInstallID();
            OiifmTreeItem currentCompItem = this.constructSingleItem(compID, true);
            oLangAddonProductItem.addItem((DTreeItem)currentCompItem);
        }
        oLangAddonProductItem.setExpanded(this.m_bNodes[3]);
    }

    private boolean setInitPositions(OiifmTreeItem item, String title) {
        boolean bRemains = true;
        int childCount = item.getItemCount();
        item.setLabel(title + this.getProductCountStr(childCount));
        if (childCount > 0) {
            item.setExpanded(false);
        } else {
            DTreeSimpleParent root = (DTreeSimpleParent)item.getParent();
            root.removeItems(item.getIndex(), 1);
            bRemains = false;
        }
        return bRemains;
    }

    private OiifmTreeItem constructSingleItem(OiiiCompInstallID cid, boolean bStageInv) {
        OiiiCompInvEntry entry = bStageInv ? this.m_stageInventory.getStageCompInvEntry(cid) : this.m_inventory.getCompInvEntry(cid, this.m_pullSession.getHomeIndex(cid));
        String compName = entry.getFullDisplayName();
        String description = entry.getDescription();
        if (description == null) {
            description = compName;
        }
        if (description.length() == 0) {
            description = compName;
        }
        OiifmTreeItem oCompItem = new OiifmTreeItem(compName, null, cid);
        oCompItem.setToolTipText(description);
        return oCompItem;
    }

    private String getProductCountStr(int prodCount) {
        if (prodCount == 1) {
            return OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_PRODUCT");
        }
        String pcountStr = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_PRODUCTS");
        Object[] arr = new String[]{"" + prodCount};
        return MessageFormat.format(pcountStr, arr);
    }

    private void addGlobalInfos() {
        DTreeSimpleRoot root = this.m_oSummaryTree.getSimpleRoot();
        OiifmTreeItem oSettingsItem = new OiifmTreeItem(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_SUMMARY_TREE_GS"), null, null);
        oSettingsItem.setFont(this.m_tBoldFont);
        root.addItem((DTreeItem)oSettingsItem);
        OiicSessionContext oContext = this.m_pullSession.getSessionContext();
        OiisVariable oSource = oContext.getVariable("FROM_LOCATION");
        Object[] msgArr = new String[]{(String)oSource.getValue()};
        String sStgLabel = MessageFormat.format(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_SUMMARY_INFO_STAGE"), msgArr);
        OiifmTreeItem oStagingAreaItem = new OiifmTreeItem(sStgLabel, null, null);
        oSettingsItem.addItem((DTreeItem)oStagingAreaItem);
        String s = System.getProperty("oracle.installer.useORACLE_BASE");
        if (s != null && s.equalsIgnoreCase("true")) {
            OiisVariable ob = oContext.getVariable("ORACLE_BASE");
            Object[] msgArr1 = new String[2];
            msgArr1[0] = (String)ob.getValue();
            String sOBLabel = MessageFormat.format(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_SUMMARY_INFO_OB"), msgArr1);
            OiifmTreeItem oBaseItem = new OiifmTreeItem(sOBLabel, null, null);
            oSettingsItem.addItem((DTreeItem)oBaseItem);
        }
        OiisVariable oOH = oContext.getVariable("ORACLE_HOME");
        OiisVariable oOHNameVar = oContext.getVariable("ORACLE_HOME_NAME");
        Object[] msgArr1 = new String[]{(String)oOH.getValue(), (String)oOHNameVar.getValue()};
        String sOHLabel = MessageFormat.format(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_SUMMARY_INFO_OH"), msgArr1);
        OiifmTreeItem oOHItem = new OiifmTreeItem(sOHLabel, null, null);
        oSettingsItem.addItem((DTreeItem)oOHItem);
        if (OiixOraparam.isApplTopStage()) {
            OiisVariable oAppltopVar = oContext.getVariable("APPLTOP");
            OiisVariable oAppltopNameVar = oContext.getVariable("APPLTOP_NAME");
            msgArr1[0] = (String)oAppltopVar.getValue();
            msgArr1[1] = (String)oAppltopNameVar.getValue();
            String sAppltopLabel = MessageFormat.format(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_SUMMARY_INFO_APPLTOP"), msgArr1);
            OiifmTreeItem oAppltopItem = new OiifmTreeItem(sAppltopLabel, null, null);
            oSettingsItem.addItem((DTreeItem)oAppltopItem);
        }
        String[] remoteNodes = (String[])oContext.getVarValue("REMOTE_NODES");
        String localNode = (String)oContext.getVarValue("LOCAL_NODE");
        if (localNode != null && localNode.trim().length() > 0 || remoteNodes != null && remoteNodes.length > 0) {
            String[] nodeMsgArr = OiixFunctionOps.unionStr(localNode, remoteNodes);
            String sNodeNamesLabel = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_SUMMARY_CLUSTER_NODES");
            OiifmTreeItem oClusterNodesItem = new OiifmTreeItem(sNodeNamesLabel, null, null);
            for (int i = 0; i < nodeMsgArr.length; ++i) {
                String sNodeMsg = nodeMsgArr[i];
                OiifmTreeItem oNodeItem = new OiifmTreeItem(sNodeMsg, null, null);
                oClusterNodesItem.addItem((DTreeItem)oNodeItem);
            }
            oClusterNodesItem.setExpanded(false);
            oSettingsItem.addItem((DTreeItem)oClusterNodesItem);
        }
        if (!OiicPullSession.isLangAddonMode() && this.m_tlComp.getCompType() == 1) {
            OiiiStageCompInvEntry entry = this.m_stageInventory.getStageCompInvEntry(this.m_tlComp);
            OiisVariable oDepMode = oContext.getVariable("DEP_MODE");
            String nMode = (String)oDepMode.getValue();
            OiisDepInfo depInfo = entry.getDepInfo();
            OiisDepMode oMode = depInfo.getDepMode(nMode);
            Object[] msgArr2 = new String[]{oMode.getName()};
            String sModeLabel = MessageFormat.format(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_SUMMARY_INFO_IT"), msgArr2);
            OiifmTreeItem oTypeItem = new OiifmTreeItem(sModeLabel, null, null);
            oSettingsItem.addItem((DTreeItem)oTypeItem);
        }
        oSettingsItem.setExpanded(this.m_bNodes[0]);
    }

    private void addSpaceInfos() {
        DTreeSimpleRoot root = this.m_oSummaryTree.getSimpleRoot();
        OiifmTreeItem oSpaceTopItem = new OiifmTreeItem(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_SUMMARY_TREE_SPACE"), null, null);
        oSpaceTopItem.setFont(this.m_tBoldFont);
        root.addItem((DTreeItem)oSpaceTopItem);
        this.addDiskInfo(oSpaceTopItem);
    }

    private void addDiskInfo(OiifmTreeItem oSpaceTopItem) {
        Image image;
        OiifmImage imgBundle;
        this.m_diskFull = false;
        OiiodDepEngine depEngine = this.m_pullSession.getDepEngine();
        List oVolumeInfo = null;
        if (OiicPullSession.isLangAddonMode()) {
            Vector installIEs = this.m_pullSession.getSessionPlan().getSuccessfulAdditions(10);
            oVolumeInfo = depEngine.getLangAddonRequiredSpace(installIEs);
        } else {
            oVolumeInfo = depEngine.getRequiredSpace(false);
        }
        int nSize = oVolumeInfo.size();
        boolean bDisplayClusterSpace = false;
        OiicInstallSession instSession = this.m_pullSession;
        OiicSessionContext oContext = this.m_pullSession.getSessionContext();
        String[] remoteNodes = (String[])oContext.getVarValue("REMOTE_NODES");
        if (remoteNodes != null && remoteNodes.length > 0) {
            bDisplayClusterSpace = true;
        }
        for (int i = 0; i < nSize; ++i) {
            String sLabel;
            Object[] obj;
            OiiodVolumeInfo oVolInfo = (OiiodVolumeInfo)oVolumeInfo.get(i);
            String sVolume = oVolInfo.getVolumeName();
            long lReqSize = oVolInfo.getRequiredSpace();
            long lTempSize = oVolInfo.getTempSpace();
            long lNISize = oVolInfo.getPostInstallSpace();
            long lSpacePerDrive = oVolInfo.getTotalRequiredSpace(true);
            String sReqSpace = OiixPathOps.getDiskSpaceString(lSpacePerDrive, 1);
            String sTempSpace = OiixPathOps.getDiskSpaceString(lTempSize, 2);
            long lAvailSpace = oVolInfo.getAvailableSpace();
            String sAvailSpace = OiixPathOps.getDiskSpaceString(lAvailSpace, 1);
            if (lSpacePerDrive > lAvailSpace) {
                sAvailSpace = OiixPathOps.getDiskSpaceString(lAvailSpace, 2);
            }
            if (lTempSize > 0L) {
                obj = new String[]{sVolume, sReqSpace, sTempSpace, sAvailSpace};
                if (lSpacePerDrive > lTempSize) {
                    sLabel = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_SUMMARY_INFO_SPACE2");
                    sLabel = MessageFormat.format(sLabel, obj);
                } else {
                    obj[1] = sTempSpace;
                    sLabel = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_SUMMARY_INFO_SPACE3");
                    sLabel = MessageFormat.format(sLabel, obj);
                }
            } else {
                obj = new String[]{sVolume, sReqSpace, sAvailSpace};
                sLabel = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_SUMMARY_INFO_SPACE");
                sLabel = MessageFormat.format(sLabel, obj);
            }
            if (lSpacePerDrive <= 0L) continue;
            OiifmTreeItem oSpaceItem = new OiifmTreeItem(sLabel, null, null);
            oSpaceItem.setExpanded(true);
            oSpaceTopItem.addItem((DTreeItem)oSpaceItem);
            if (lSpacePerDrive > lAvailSpace) {
                imgBundle = new OiifmImage(null, "Oiir");
                image = imgBundle.getImage("5000");
                oSpaceItem.setIcon(image);
                oSpaceItem.setForeground(Color.black);
                this.m_diskFull = true;
                continue;
            }
            oSpaceItem.setForeground(Color.black);
        }
        if (bDisplayClusterSpace) {
            String[] sVolume = new String[nSize];
            long[] lReqSize = new long[nSize];
            String[] sReqSpace = new String[nSize];
            boolean[] bCFS = new boolean[nSize];
            OiiodVolumeInfo[] oVolInfo = new OiiodVolumeInfo[nSize];
            boolean bAllVolsShared = true;
            for (int i = 0; i < nSize; ++i) {
                oVolInfo[i] = (OiiodVolumeInfo)oVolumeInfo.get(i);
                sVolume[i] = oVolInfo[i].getVolumeName();
                lReqSize[i] = oVolInfo[i].getTotalRequiredSpace(false);
                sReqSpace[i] = OiixPathOps.getDiskSpaceString(lReqSize[i], 1);
                bCFS[i] = oVolInfo[i].isCFS();
                if (bCFS[i]) continue;
                bAllVolsShared = false;
            }
            if (!bAllVolsShared) {
                String clusterNodes = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_REMOTE_NODES");
                OiifmTreeItem clusterSpaceItem = new OiifmTreeItem(clusterNodes, null, null);
                clusterSpaceItem.setForeground(Color.black);
                clusterSpaceItem.setExpanded(false);
                String sClusterLabel = null;
                long lAvailSpaceCluster = 0L;
                String sAvailSpaceCluster = null;
                for (int j = 0; j < remoteNodes.length; ++j) {
                    boolean expand = false;
                    OiifmTreeItem RemoteNodeItem = new OiifmTreeItem(remoteNodes[j], null, null);
                    clusterSpaceItem.addItem((DTreeItem)RemoteNodeItem);
                    for (int k = 0; k < nSize; ++k) {
                        if (!bCFS[k]) {
                            lAvailSpaceCluster = oVolInfo[k].getAvailableSpace(remoteNodes[j]);
                            sAvailSpaceCluster = OiixPathOps.getDiskSpaceString(lAvailSpaceCluster, 1);
                            sAvailSpaceCluster = lReqSize[k] > lAvailSpaceCluster ? OiixPathOps.getDiskSpaceString(lAvailSpaceCluster, 2) : OiixPathOps.getDiskSpaceString(lAvailSpaceCluster, 1);
                            Object[] clusterobj = new String[4];
                            clusterobj[0] = sVolume[k];
                            clusterobj[1] = sReqSpace[k];
                            clusterobj[2] = sAvailSpaceCluster;
                            sClusterLabel = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CLUSTER_SUMMARY_INFO_SPACE");
                            sClusterLabel = MessageFormat.format(sClusterLabel, clusterobj);
                            OiifmTreeItem clusterNodesSpaceItem = new OiifmTreeItem(sClusterLabel, null, null);
                            RemoteNodeItem.addItem((DTreeItem)clusterNodesSpaceItem);
                            if (lReqSize[k] > lAvailSpaceCluster) {
                                expand = true;
                                imgBundle = new OiifmImage(null, "Oiir");
                                image = imgBundle.getImage("5000");
                                clusterNodesSpaceItem.setIcon(image);
                                clusterNodesSpaceItem.setForeground(Color.black);
                            } else {
                                clusterNodesSpaceItem.setForeground(Color.black);
                            }
                        }
                        if (!expand) continue;
                        RemoteNodeItem.setExpanded(true);
                        clusterSpaceItem.setForeground(Color.black);
                        clusterSpaceItem.setExpanded(true);
                    }
                }
                oSpaceTopItem.addItem((DTreeItem)clusterSpaceItem);
            }
        }
        oSpaceTopItem.setExpanded(this.m_bNodes[2]);
    }

    private void addLangInfo() {
        int i;
        DTreeSimpleRoot root = this.m_oSummaryTree.getSimpleRoot();
        OiifmTreeItem oSpaceItem = this.findLabeledRoot(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_SUMMARY_TREE_SPACE"));
        OiifmTreeItem oLangTopItem = this.findLabeledRoot(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_SUMMARY_TREE_LANG"));
        if (oLangTopItem != null) {
            DTreeSimpleParent parent = (DTreeSimpleParent)oLangTopItem.getParent();
            parent.removeItems(oLangTopItem.getIndex(), 1);
        }
        oLangTopItem = new OiifmTreeItem(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_SUMMARY_TREE_LANG"), null, null);
        oLangTopItem.setFont(this.m_tBoldFont);
        root.addItem((DTreeItem)oLangTopItem, oSpaceItem.getIndex());
        OiicSessionContext oContext = this.m_pullSession.getSessionContext();
        Vector sLangs = null;
        if (this.m_pullSession.getSelTopLevelCompID().getCompType() == 4) {
            OiifwSummaryWCDE summaryWCDE = (OiifwSummaryWCDE)this.m_wcde;
            sLangs = summaryWCDE.getPatchsetLangs();
        } else {
            OiisVariable oLangs = oContext.getVariable("SELECTED_LANGUAGES");
            String[] strLangs = (String[])oLangs.getValue();
            sLangs = OiixLanguage.getLangsVector(strLangs);
        }
        Vector<String> langNames = new Vector<String>();
        for (i = 0; i < sLangs.size(); ++i) {
            Locale l = (Locale)sLangs.elementAt(i);
            String displayString = OiixLanguage.getDisplayName(l);
            if (displayString == null) {
                displayString = l.getDisplayLanguage();
            }
            langNames.add(displayString);
        }
        this.sortLangListByName(langNames);
        for (i = 0; i < langNames.size(); ++i) {
            String displayString = (String)langNames.elementAt(i);
            OiifmTreeItem oLangItem = new OiifmTreeItem(displayString, null, null);
            oLangTopItem.addItem((DTreeItem)oLangItem);
        }
        oLangTopItem.setExpanded(this.m_bNodes[1]);
    }

    private void addUpgradedLangsInfo() {
        DTreeSimpleRoot root = this.m_oSummaryTree.getSimpleRoot();
        OiifmTreeItem oSpaceItem = this.findLabeledRoot(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_SUMMARY_TREE_SPACE"));
        OiifmTreeItem oLangUpgradesItem = this.findLabeledRoot(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFP1000"));
        if (oLangUpgradesItem != null) {
            DTreeSimpleParent parent = (DTreeSimpleParent)oLangUpgradesItem.getParent();
            parent.removeItems(oLangUpgradesItem.getIndex(), 1);
        }
        oLangUpgradesItem = new OiifmTreeItem(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFP1000"), null, null);
        oLangUpgradesItem.setFont(this.m_tBoldFont);
        root.addItem((DTreeItem)oLangUpgradesItem, oSpaceItem.getIndex());
        OiicSessionContext oContext = this.m_pullSession.getSessionContext();
        Vector tlcActuallyUpgraded = ((OiicLangAddonSession)this.m_pullSession).getTopLevelComponentsUpgraded();
        for (int i = 0; i < tlcActuallyUpgraded.size(); ++i) {
            OiiiCompInstallID compInstallID = (OiiiCompInstallID)tlcActuallyUpgraded.elementAt(i);
            if (compInstallID.getCompType() == 4 && tlcActuallyUpgraded.size() > 1) continue;
            OiifmTreeItem oTLCLangItem = this.constructSingleItem(compInstallID, true);
            oLangUpgradesItem.addItem((DTreeItem)oTLCLangItem);
            Vector upgradedLangs = null;
            if (compInstallID.getCompType() == 4) {
                OiisVariable oLangs = oContext.getVariable("SELECTED_LANGUAGES");
                String[] strLangs = (String[])oLangs.getValue();
                upgradedLangs = OiixLanguage.getLangsVector(strLangs);
            } else {
                OiisCompInstallation oCompInstall = this.m_pullSession.getCompInstall(compInstallID);
                upgradedLangs = oCompInstall.getUpgradeLangs();
            }
            Vector<String> upgradedLangsNames = new Vector<String>();
            if (upgradedLangs != null) {
                for (int j = 0; j < upgradedLangs.size(); ++j) {
                    Locale l = (Locale)upgradedLangs.elementAt(j);
                    String displayString = OiixLanguage.getDisplayName(l);
                    if (displayString == null) {
                        displayString = l.getDisplayLanguage();
                    }
                    upgradedLangsNames.add(displayString);
                }
                this.sortLangListByName(upgradedLangsNames);
                for (int k = 0; k < upgradedLangsNames.size(); ++k) {
                    String displayString = (String)upgradedLangsNames.elementAt(k);
                    OiifmTreeItem oLangItem = new OiifmTreeItem(displayString, null, null);
                    oTLCLangItem.addItem((DTreeItem)oLangItem);
                }
            }
            oTLCLangItem.setExpanded(true);
        }
        oLangUpgradesItem.setExpanded(this.m_bNodes[1]);
    }

    private OiifmTreeItem findLabeledRoot(String sLabel) {
        DTreeSimpleRoot root = this.m_oSummaryTree.getSimpleRoot();
        for (int i = 0; i < root.getItemCount(); ++i) {
            OiifmTreeItem item = (OiifmTreeItem)root.getItem(i);
            if (!item.getLabel().equals(sLabel)) continue;
            return item;
        }
        return null;
    }

    static {
        s_sLineSeparator = System.getProperty("line.separator", "\n");
    }
}

