/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifp;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Vector;
import oracle.ewt.button.PushButton;
import oracle.ewt.comboBox.ComboBox;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.textWrapper.TextWrapper;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.ewt.util.WindowUtils;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiif.oiifd.OiifdDriverDlg;
import oracle.sysman.oii.oiif.oiifj.OiifjDirectoryDlg;
import oracle.sysman.oii.oiif.oiifm.OiifmCursorUtil;
import oracle.sysman.oii.oiif.oiifp.OiifpWizPanel;
import oracle.sysman.oii.oiif.oiifw.OiifwWizDialog;
import oracle.sysman.oii.oiii.OiiiAreaInventory;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiii.OiiiTargetAreaControl;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifpStgWizLocPanel
extends OiifpWizPanel
implements ActionListener,
FilenameFilter {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 256;
    private final int CONTENT_GAP = 3;
    private final int PANEL_GAP = 10;
    private final int BUTTON_VGAP = 10;
    private PushButton m_fromBrowse = null;
    private LWTextField m_fromText = null;
    private PushButton m_toBrowse = null;
    private ComboBox m_toCombo = null;
    private transient OiifwWizDialog m_wd;
    private OiiiInstallInventory m_inventory = null;
    private OiifdDriverDlg m_dDlg = null;
    private Font font_bold = null;
    private TextWrapper twrap = null;

    public OiifpStgWizLocPanel(String from, String to, OiisVariableOwner vo) {
        super(OiixResourceBundle.getString("S_FILE_LOC"));
        OiiiAreaInventory tmp;
        OiiiTargetAreaControl invAreaControl;
        OiisVariable invLoc = vo.getVariable("INVENTORY_LOCATION");
        if (invLoc.getAdvice() && (invAreaControl = OiiiInstallAreaControl.getInventoryAreaControl()) != null && (tmp = invAreaControl.getAreaInventory()) instanceof OiiiInstallInventory) {
            this.m_inventory = (OiiiInstallInventory)tmp;
        }
        this.twrap = WordWrapper.getTextWrapper();
        this.font_bold = new Font(OiixResourceBundle.getFont(), 1, 14);
        this.dlgPanel.setLayout((LayoutManager)new BorderLayout(10, 10));
        this.dlgPanel.add((Component)this.createOptionsPanel(), (Object)"East");
        LWContainer locPanel = new LWContainer();
        locPanel.setLayout((LayoutManager)new GridLayout(2, 1));
        locPanel.add((Component)this.createFromPanel(from));
        locPanel.add((Component)this.createToPanel(to));
        this.dlgPanel.add((Component)locPanel);
        this.m_aboutButton = null;
        this.validate();
    }

    public OiifpStgWizLocPanel(OiisVariableOwner vo) {
        this("", "", vo);
    }

    private LWContainer createFromPanel(String from) {
        LWContainer aPanel = new LWContainer();
        aPanel.setLayout((LayoutManager)new BorderLayout(3, 3));
        String prompt = OiixResourceBundle.getString("S_FROM");
        LWLabel bodyLabel1 = new LWLabel(prompt);
        bodyLabel1.setFont(this.font_bold);
        aPanel.add((Component)bodyLabel1, (Object)"North");
        LWContainer pPanel = new LWContainer();
        pPanel.setLayout((LayoutManager)new BorderLayout(3, 3));
        String sPromptTag = OiicPullSession.isLangAddonMode() ? "OIIFP1009" : "S_FROM_PROMPT";
        prompt = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", sPromptTag);
        MultiLineLabel bodyLabel2 = new MultiLineLabel(this.twrap, prompt);
        bodyLabel2.setPreferredAspectRatio(0.0f);
        pPanel.add((Component)bodyLabel2, (Object)"North");
        LWContainer bPanel = new LWContainer();
        bPanel.setLayout((LayoutManager)new BorderLayout(3, 3));
        this.m_fromBrowse = new PushButton(OiixResourceBundle.getString("S_BROWSE_BUTTON"));
        this.m_fromBrowse.setEnabled(true);
        this.m_fromBrowse.addActionListener((ActionListener)this);
        this.m_fromBrowse.setRightmost(true);
        this.m_fromBrowse.setVisible(true);
        bPanel.add((Component)this.m_fromBrowse, (Object)"East");
        LWContainer iPanel = new LWContainer();
        iPanel.setLayout((LayoutManager)new BorderLayout(3, 3));
        this.m_fromText = new LWTextField(from);
        iPanel.add((Component)this.m_fromText, (Object)"South");
        bPanel.add((Component)iPanel, (Object)"Center");
        LWContainer xPanel = new LWContainer();
        xPanel.setLayout((LayoutManager)new BorderLayout(3, 3));
        xPanel.add((Component)bPanel, (Object)"North");
        pPanel.add((Component)xPanel, (Object)"Center");
        aPanel.add((Component)pPanel, (Object)"Center");
        return aPanel;
    }

    private LWContainer createToPanel(String to) {
        LWContainer aPanel = new LWContainer();
        aPanel.setLayout((LayoutManager)new BorderLayout(3, 3));
        String prompt = OiixResourceBundle.getString("S_TO");
        LWLabel bodyLabel3 = new LWLabel(prompt);
        bodyLabel3.setFont(this.font_bold);
        aPanel.add((Component)bodyLabel3, (Object)"North");
        LWContainer pPanel = new LWContainer();
        pPanel.setLayout((LayoutManager)new BorderLayout(3, 3));
        String sPromptTag = OiicPullSession.isLangAddonMode() ? "OIIFP1010" : "S_TO_PROMPT";
        prompt = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", sPromptTag);
        MultiLineLabel bodyLabel4 = new MultiLineLabel(this.twrap, prompt);
        bodyLabel4.setPreferredAspectRatio(0.0f);
        pPanel.add((Component)bodyLabel4, (Object)"North");
        LWContainer iPanel = new LWContainer();
        iPanel.setLayout((LayoutManager)new BorderLayout(3, 3));
        this.m_toCombo = new ComboBox(true);
        iPanel.add((Component)this.m_toCombo, (Object)"South");
        LWContainer bPanel = new LWContainer();
        bPanel.setLayout((LayoutManager)new BorderLayout(3, 3));
        this.m_toBrowse = new PushButton(OiixResourceBundle.getString("S_BROWSE_BUTTON"));
        this.m_toBrowse.addActionListener((ActionListener)this);
        this.m_toBrowse.setRightmost(true);
        bPanel.add((Component)this.m_toBrowse, (Object)"East");
        bPanel.add((Component)iPanel, (Object)"Center");
        LWContainer xPanel = new LWContainer();
        xPanel.setLayout((LayoutManager)new BorderLayout(3, 3));
        xPanel.add((Component)bPanel, (Object)"North");
        pPanel.add((Component)xPanel, (Object)"Center");
        aPanel.add((Component)pPanel, (Object)"Center");
        return aPanel;
    }

    private LWContainer createOptionsPanel() {
        LWContainer bPanel = new LWContainer();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.insets.bottom = 10;
        c.weightx = 1.0;
        c.fill = 2;
        c.gridwidth = 0;
        bPanel.setLayout((LayoutManager)gridbag);
        String str = OiixResourceBundle.getString("S_ABOUT_BUTTON");
        this.m_aboutButton = new PushButton(str);
        this.m_aboutButton.setEnabled(true);
        this.m_aboutButton.setFocusable(true);
        this.m_aboutButton.setLeftmost(true);
        this.m_aboutButton.setRightmost(true);
        c.weighty = 0.9;
        c.anchor = 16;
        gridbag.setConstraints((Component)this.m_aboutButton, c);
        this.m_aboutButton.addActionListener((ActionListener)this);
        this.m_aboutButton.setVisible(true);
        bPanel.add((Component)this.m_aboutButton);
        return bPanel;
    }

    public void setWizDialog(OiifwWizDialog wd) {
        this.m_wd = wd;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (this.m_wd != null) {
            OiifmCursorUtil.setCursor(this.waitCursor, (Component)((Object)this));
        }
        if (source == this.m_fromBrowse) {
            this.m_fromBrowse.setEnabled(false);
            this.onFromBrowse();
            this.m_fromBrowse.setEnabled(true);
        } else if (source == this.m_toBrowse) {
            this.m_toBrowse.setEnabled(false);
            this.onToBrowse();
            this.m_toBrowse.setEnabled(true);
        } else if (source == this.m_aboutButton) {
            this.m_aboutButton.setEnabled(false);
            this.m_wd.onAbout(false);
            this.m_aboutButton.setEnabled(true);
        }
        if (this.m_wd != null) {
            OiifmCursorUtil.setCursor(this.defCursor, (Component)((Object)this));
        }
        if (source instanceof Component) {
            ((Component)source).requestFocus();
        }
    }

    private void onFromBrowse() {
        FileDialog fd = new FileDialog(WindowUtils.parentFrame((Component)((Object)this)), OiixResourceBundle.getString("S_FROM"), 0);
        WindowUtils.centerWindow((Window)fd, (Component)WindowUtils.parentFrame((Component)((Object)this)));
        fd.setFilenameFilter(this);
        fd.setFile("products.xml");
        File curFile = new File(this.m_fromText.getText());
        String dirLoc = null;
        dirLoc = curFile.isDirectory() ? curFile.getPath() : curFile.getParent();
        if (dirLoc != null) {
            fd.setDirectory(dirLoc);
        }
        if (this.m_wd != null) {
            OiifmCursorUtil.setCursor(this.defCursor, (Component)((Object)this));
        }
        fd.show();
        if (fd.getDirectory() != null && fd.getFile() != null) {
            this.m_fromText.setText(fd.getDirectory() + fd.getFile());
        }
        fd.dispose();
    }

    private void onToBrowse() {
        File chosenDir;
        OiipgFileSystem pgFS = new OiipgFileSystem();
        OiifjDirectoryDlg dirDlg = new OiifjDirectoryDlg(WindowUtils.parentFrame((Component)((Object)this)), OiixResourceBundle.getString("S_CHOOSE_DIR"));
        String selItem = this.m_toCombo.getSelectedItem();
        selItem = null != selItem ? selItem.trim() : "";
        File curDir = null;
        if (0 < selItem.length()) {
            curDir = new File(selItem);
        }
        if (null == curDir || !curDir.exists()) {
            curDir = new File(System.getProperty("user.dir"));
        }
        if (this.m_wd != null) {
            OiifmCursorUtil.setCursor(this.defCursor, (Component)((Object)this));
        }
        if ((chosenDir = dirDlg.runDialog(curDir)) != null) {
            String dirStr = chosenDir.getAbsolutePath();
            String[] oHomes = this.m_toCombo.getItems();
            for (int i = 0; i < oHomes.length; ++i) {
                if (!oHomes[i].equals(dirStr)) continue;
                this.m_toCombo.select(i);
            }
            String selectedStr = this.m_toCombo.getSelectedItem();
            String string = selectedStr = selectedStr == null ? "" : selectedStr;
            if (!selectedStr.equals(dirStr)) {
                this.m_toCombo.insert(dirStr, oHomes.length);
                this.m_toCombo.select(dirStr);
            }
        }
    }

    @Override
    public boolean accept(File dir, String name) {
        return name.equals("products.xml");
    }

    public String getFromLocation() {
        return this.m_fromText.getText();
    }

    public String getToLocation() {
        String toDir = this.m_toCombo.getSelectedItem();
        toDir = null != toDir ? toDir.trim() : "";
        return toDir.endsWith(".xml") ? toDir : new File(toDir, "products.xml").getPath();
    }

    public int getToLocationIndex() {
        Vector OHs;
        if (this.m_inventory != null && (OHs = this.m_inventory.getHomes()) != null) {
            return OiiiOracleHomeInfo.getOHIndex(OHs, this.m_toCombo.getSelectedItem());
        }
        return -1;
    }

    public void setFromLocation(String from) {
        this.m_fromText.setText(from);
        this.m_fromText.repaint();
    }

    public void setToLocation(String newLoc) {
        if (newLoc != null) {
            this.m_toCombo.select(newLoc);
        }
    }
}

