/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifp;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import oracle.ewt.button.PushButton;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextArea;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.painter.NullPainter;
import oracle.ewt.painter.Painter;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiif.oiifm.OiifmGraphicInterfaceManager;
import oracle.sysman.oii.oiif.oiifp.OiifpWizPanel;
import oracle.sysman.oii.oiif.oiifw.OiifwRegistrationWCDE;
import oracle.sysman.oii.oiip.osd.win32.OiipwWin32NativeCalls;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixSpawner;

public class OiifpRegistrationPanel
extends OiifpWizPanel
implements ActionListener {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 256;
    private static String BROWSER_REGKEY_ROOT = "HKEY_CLASSES_ROOT";
    private static String BROWSER_REGKEY_HTML = ".html";
    private static String BROWSER_REGKEY_COMMAND = "shell\\open\\command";
    private PushButton m_launchButton;
    private LWTextField m_textField;
    private String m_registrationURL;
    private String m_browser;

    public OiifpRegistrationPanel() {
        super(OiixResourceBundle.getString("S_REGISTRATION_TITLE"));
    }

    @Override
    public void createPanelElements() {
        OiifwRegistrationWCDE rwcde = (OiifwRegistrationWCDE)this.m_wcde;
        this.m_registrationURL = rwcde.getRegistrationURL();
        if (this.isBrowserRequired()) {
            this.m_browser = this.getWin32BrowserCommand();
        }
        this.dlgPanel.setLayout((LayoutManager)new GridLayout(2, 0));
        LWContainer textPanel = this.getTextPanel();
        LWContainer launchPanel = this.getLaunchPanel(this.m_registrationURL, rwcde.getProductCode());
        this.dlgPanel.add((Component)launchPanel);
        this.dlgPanel.add((Component)textPanel);
        OiifmGraphicInterfaceManager ogim = (OiifmGraphicInterfaceManager)OiicSessionInterfaceManager.getInterfaceManager();
        ogim.getWizardDialog().setViewOnly(false);
        this.dlgPanel.doLayout();
        this.dlgPanel.validate();
        this.validate();
    }

    private LWContainer getTextPanel() {
        LWContainer textPanel = new LWContainer();
        GridBagLayout gridbag = new GridBagLayout();
        textPanel.setLayout((LayoutManager)gridbag);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 18;
        c.weighty = 1.0;
        c.weightx = 0.0;
        c.gridwidth = -1;
        LWLabel textLabel = new LWLabel(OiixResourceBundle.getString("S_REGISTRATION_KEYWORD_LABEL"));
        gridbag.setConstraints((Component)textLabel, c);
        textPanel.add((Component)textLabel);
        c.weightx = 1.0;
        c.gridwidth = 0;
        this.m_textField = new LWTextField(OiixResourceBundle.getString("S_REGISTRATION_DEFAULT_VALUE"));
        gridbag.setConstraints((Component)this.m_textField, c);
        textPanel.add((Component)this.m_textField);
        return textPanel;
    }

    private LWContainer getLaunchPanel(String registrationURL, String sProductCode) {
        LWContainer bPanel = new LWContainer();
        bPanel.setLayout((LayoutManager)new BorderLayout(5, 5));
        Object[] sArgs = new String[]{sProductCode};
        String urlStr = OiixResourceBundle.getString("S_REGISTRATION_PROMPT", sArgs);
        LWTextArea textArea = new LWTextArea(urlStr);
        textArea.setTextWrapper(WordWrapper.getTextWrapper());
        textArea.setEditable(false);
        textArea.setBorderPainter(NullPainter.getPainter());
        textArea.setFill((Painter)NullPainter.getPainter());
        bPanel.add((Component)textArea, (Object)"Center");
        if (this.isBrowserRequired()) {
            LWContainer browsePanel = new LWContainer();
            browsePanel.setLayout((LayoutManager)new BorderLayout());
            String str = OiixResourceBundle.getString("S_LAUNCH_BROWSER");
            this.m_launchButton = new PushButton(str);
            this.m_launchButton.setLeftmost(true);
            this.m_launchButton.setRightmost(true);
            this.m_launchButton.addActionListener((ActionListener)this);
            browsePanel.add((Component)this.m_launchButton, (Object)"North");
            bPanel.add((Component)browsePanel, (Object)"East");
        }
        return bPanel;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.m_launchButton) {
            try {
                OiixSpawner oSpawner = new OiixSpawner();
                String[] args = new String[]{this.m_registrationURL};
                oSpawner.beginExecute(this.m_browser, args, null);
            }
            catch (Exception e) {
                System.err.println("Exception in spawning the registration URL :" + e.getMessage());
            }
        }
    }

    public String getRegistrationKeyword() {
        return this.m_textField.getText();
    }

    private String getWin32BrowserCommand() {
        try {
            String sHtmlKey = OiipwWin32NativeCalls.RegGetValue(BROWSER_REGKEY_ROOT, BROWSER_REGKEY_HTML, "");
            if (sHtmlKey.equals("")) {
                return "";
            }
            String sCommandKeyName = sHtmlKey + "\\" + BROWSER_REGKEY_COMMAND;
            String sCommand = OiipwWin32NativeCalls.RegGetValue(BROWSER_REGKEY_ROOT, sCommandKeyName, "");
            if (sCommand.equals("")) {
                return sCommand;
            }
            int index = sCommand.indexOf("\"%1\"");
            if (index != -1) {
                sCommand = sCommand.substring(0, index);
            }
            return sCommand;
        }
        catch (Exception exception) {
            return "";
        }
    }

    private boolean isBrowserRequired() {
        int curPlat = OiixPlatform.getCurrentPlatform();
        boolean bRet = curPlat == 615 || curPlat == 50 || curPlat == 912 || curPlat == 208 || curPlat == 233;
        return bRet && this.m_registrationURL.length() > 0;
    }

    public static void main(String[] args) {
    }
}

