/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifp;

import java.awt.Color;
import java.awt.Container;
import java.awt.Image;
import java.util.ArrayList;
import java.util.List;
import oracle.ewt.dTree.DTreeExpansionListener;
import oracle.ewt.dTree.DTreeItem;
import oracle.ewt.dTree.DTreeItemEvent;
import oracle.ewt.dTree.DTreeSelectionEvent;
import oracle.ewt.dTree.DTreeSimpleParent;
import oracle.ewt.dTree.DTreeSimpleRoot;
import oracle.sysman.oii.oiif.oiifm.OiifmCheckListener;
import oracle.sysman.oii.oiif.oiifm.OiifmCheckTreeItem;
import oracle.sysman.oii.oiif.oiifm.OiifmImage;
import oracle.sysman.oii.oiif.oiifm.OiifmInfo;
import oracle.sysman.oii.oiif.oiifm.OiifmTree;
import oracle.sysman.oii.oiif.oiifm.OiifmTreeItem;
import oracle.sysman.oii.oiif.oiifp.OiifpContentsTabPanel;
import oracle.sysman.oii.oiii.OiiiCompIdOhPair;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;

public class OiifpInventoryTree
extends OiifmTree
implements OiifmCheckListener,
DTreeExpansionListener {
    private static final int NUM_STATES = 4;
    private Image[] m_images = null;
    private ArrayList m_alItemsToRemove = new ArrayList();
    private transient OiifpContentsTabPanel m_contentsTab = null;

    public OiifpInventoryTree() {
        this.m_images = new Image[4];
        OiifmImage imgBundle = new OiifmImage((Container)((Object)this), "Oiir");
        this.m_images[0] = imgBundle.getImage("2300");
        this.m_images[1] = imgBundle.getImage("2301");
        this.m_images[2] = imgBundle.getImage("2302");
        this.m_images[3] = imgBundle.getImage("2303");
        this.setBackground(Color.white);
        this.addExpansionListener(this);
    }

    public void toggleSelection() {
        DTreeItem selected = this.getHilightedItem();
        if (selected != null && selected instanceof OiifmCheckTreeItem) {
            OiifmCheckTreeItem item = (OiifmCheckTreeItem)selected;
            switch (item.getState()) {
                case 0: {
                    this.setCheckItemState(item, 1);
                    break;
                }
                case 1: {
                    this.setCheckItemState(item, 0);
                }
            }
        }
    }

    public Image[] getStateIcons() {
        return this.m_images;
    }

    public void cleanupTree() {
        DTreeSimpleRoot root = this.getSimpleRoot();
        if (null != root) {
            int i = 0;
            while (i < root.getItemCount()) {
                DTreeSimpleParent child = (DTreeSimpleParent)root.getItem(i);
                if (null == child) continue;
                int j = 0;
                while (j < child.getItemCount()) {
                    OiifmTreeItem oHomeNode = (OiifmTreeItem)child.getItem(j);
                    if (null == oHomeNode) continue;
                    Object oNodeData = oHomeNode.getID();
                    if (!(oNodeData instanceof OiiiOracleHomeInfo)) break;
                    if (0 == oHomeNode.getItemCount()) {
                        child.removeItems(oHomeNode.getIndex(), 1);
                        continue;
                    }
                    ++j;
                }
                if (0 == child.getItemCount()) {
                    root.removeItems(child.getIndex(), 1);
                    continue;
                }
                ++i;
            }
        }
    }

    public void setCheckItemState(OiifmCheckTreeItem item, int state) {
        this.setCheckItemState(null, item, state);
    }

    private void setCheckItemState(OiifmTreeItem oTopItem, OiifmCheckTreeItem oFindItem, int state) {
        OiifmTreeItem curRoot = null != oTopItem ? oTopItem : this.getSimpleRoot();
        int v_iCurRootSize = null != curRoot ? curRoot.getItemCount() : 0;
        for (int i = 0; i < v_iCurRootSize; ++i) {
            OiifmTreeItem curItem = (OiifmTreeItem)curRoot.getItem(i);
            if (curItem instanceof OiifmCheckTreeItem) {
                Object targetID = oFindItem.getID();
                if (curItem.getID().equals(targetID)) {
                    this.onCheckStateChanging((OiifmCheckTreeItem)curItem, state);
                    ((OiifmCheckTreeItem)curItem).setState(state);
                }
            }
            this.setCheckItemState(curItem, oFindItem, state);
        }
    }

    public List getItemsToRemove() {
        return this.m_alItemsToRemove;
    }

    @Override
    public boolean onCheckStateChanging(OiifmCheckTreeItem item, int state) {
        if (state == 0) {
            this.m_alItemsToRemove.remove((Object)item);
        } else if (!this.m_alItemsToRemove.contains((Object)item)) {
            this.m_alItemsToRemove.add(item);
        }
        if (this.m_contentsTab != null) {
            this.m_contentsTab.setRemoveEnabled(this.m_alItemsToRemove.size() > 0);
        }
        return true;
    }

    @Override
    public void removeAll() {
        this.m_alItemsToRemove.clear();
        super.removeAll();
    }

    public void setInvDlg(OiifpContentsTabPanel tab) {
        this.m_contentsTab = tab;
    }

    protected void processSelectionEvent(DTreeSelectionEvent evt) {
        super.processSelectionEvent(evt);
        DTreeSimpleParent selectedItem = (DTreeSimpleParent)this.getHilightedItem();
        if (selectedItem != null && selectedItem instanceof OiifmTreeItem && this.m_contentsTab != null) {
            Object id = ((OiifmTreeItem)selectedItem).getID();
            if (id instanceof OiiiCompIdOhPair) {
                this.m_contentsTab.setCompInfoDisplay((OiiiCompIdOhPair)id);
                this.m_contentsTab.setCurrentSelectedComponent((OiiiCompIdOhPair)id);
                this.m_contentsTab.setCurrentComponentIsHome(false);
                this.m_contentsTab.enableDetailsButton(true);
            } else {
                OiifmInfo info = new OiifmInfo();
                if (id instanceof OiiiOracleHomeInfo) {
                    info.loc = ((OiiiOracleHomeInfo)id).getLocation();
                    this.m_contentsTab.setCurrentComponentIsHome(true);
                    this.m_contentsTab.setCurrentSelectedComponent(null);
                    this.m_contentsTab.enableDetailsButton(false);
                } else {
                    this.m_contentsTab.enableDetailsButton(false);
                }
                this.m_contentsTab.setInfo(info);
            }
        }
    }

    public OiifmTreeItem findRootWithLabel(String sLabel) {
        DTreeSimpleRoot root = this.getSimpleRoot();
        OiifmTreeItem v_retOiifmTreeItem = null;
        int v_iRootSize = null != root ? root.getItemCount() : 0;
        for (int i = 0; i < v_iRootSize; ++i) {
            OiifmTreeItem currRoot = (OiifmTreeItem)root.getItem(i);
            if (!currRoot.getLabel().equals(sLabel)) continue;
            v_retOiifmTreeItem = currRoot;
            break;
        }
        return v_retOiifmTreeItem;
    }

    public OiifmTreeItem findChildWithLabel(OiifmTreeItem oParent, String sLabel) {
        OiifmTreeItem v_retOiifmTreeItem = null;
        int nItemCount = null != oParent ? oParent.getItemCount() : 0;
        for (int i = 0; i < nItemCount; ++i) {
            OiifmTreeItem oChildNode = (OiifmTreeItem)oParent.getItem(i);
            if (!oChildNode.getLabel().equals(sLabel)) continue;
            v_retOiifmTreeItem = oChildNode;
            break;
        }
        return v_retOiifmTreeItem;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.m_contentsTab = null;
        this.m_images = null;
    }

    public void dTreeItemCollapsed(DTreeItemEvent evt) {
    }

    public void dTreeItemCollapsing(DTreeItemEvent evt) {
    }

    public void dTreeItemExpanded(DTreeItemEvent evt) {
    }

    public void dTreeItemExpanding(DTreeItemEvent evt) {
        if (this.m_contentsTab != null && evt.getItem() instanceof OiifmCheckTreeItem) {
            this.m_contentsTab.addChildren((OiifmCheckTreeItem)evt.getItem(), 2);
        }
    }
}

