/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifp;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.MessageFormat;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.scrolling.scrollBox.ScrollBox;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.sysman.oii.oiic.OiicInstallSession;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiif.oiifc.OiifcCTTwoDDataSource;
import oracle.sysman.oii.oiif.oiifc.OiifcCTUtils;
import oracle.sysman.oii.oiif.oiifc.OiifcCompTree;
import oracle.sysman.oii.oiif.oiifc.OiifcCompTreeObject;
import oracle.sysman.oii.oiif.oiifj.OiifjLangsDlg;
import oracle.sysman.oii.oiif.oiifm.OiifmCursorUtil;
import oracle.sysman.oii.oiif.oiifp.OiifpWizPanel;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifpDepTopLevelPanel
extends OiifpWizPanel
implements ActionListener,
ItemListener,
KeyListener {
    private final int LEFT_GAP = 50;
    private final int WIDTH = 500;
    private final int TOP_GAP = 10;
    private final int LABEL_HEIGHT = 20;
    private final int BUTTON_HEIGHT = 30;
    private final int PANEL_WIDTH = 500;
    private final int PANEL_HEIGHT = 180;
    private final int PANEL_TOP_GAP = 70;
    private final int BORDER_VGAP = 5;
    private final int BORDER_HGAP = 5;
    private MultiLineLabel m_promptLabel;
    private Dimension m_preferredSize;
    private LWButton m_buttonLang;
    private LWButton m_Expand;
    private LWButton m_Collapse;
    private LWButton m_SelectAll;
    private LWButton m_DeSelectAll;
    private ScrollBox m_scrollbox;
    private LWCheckbox m_showAll;
    private boolean m_bMessageDisplayed = false;
    private OiifcCompTree cmpTree;
    private OiicInstallSession m_instSession;
    private Boolean m_bShowTree;
    private boolean m_bshowAll;

    public OiifpDepTopLevelPanel() {
        super("");
    }

    @Override
    public void createPanelElements() {
        this.m_instSession = (OiicInstallSession)this.m_wcde.getVarOwner().getSession();
        this.m_preferredSize = new Dimension(10, 10);
        this.m_buttonLang = new LWButton(OiixResourceBundle.getString("S_CHANGE_LANGUAGES_BUTTON"));
        this.m_buttonLang.addActionListener((ActionListener)this);
        this.m_buttonLang.setRightmost(true);
        this.m_buttonLang.setLeftmost(true);
        this.m_Expand = new LWButton(OiixResourceBundle.getString("S_EXPAND_ALL"));
        this.m_Expand.addActionListener((ActionListener)this);
        this.m_Expand.setRightmost(true);
        this.m_Expand.setLeftmost(true);
        this.m_Collapse = new LWButton(OiixResourceBundle.getString("S_COLLAPSE_ALL"));
        this.m_Collapse.addActionListener((ActionListener)this);
        this.m_Collapse.setRightmost(true);
        this.m_Collapse.setLeftmost(true);
        this.m_SelectAll = new LWButton(OiixResourceBundle.getString("S_SELECT_ALL"));
        this.m_SelectAll.addActionListener((ActionListener)this);
        this.m_SelectAll.setRightmost(true);
        this.m_SelectAll.setLeftmost(true);
        this.m_DeSelectAll = new LWButton(OiixResourceBundle.getString("S_DESELECT_ALL"));
        this.m_DeSelectAll.addActionListener((ActionListener)this);
        this.m_DeSelectAll.setRightmost(true);
        this.m_DeSelectAll.setLeftmost(true);
        this.m_bShowTree = new Boolean(true);
        this.m_bshowAll = false;
        this.init();
    }

    public void init() {
        String prompt;
        OiisVariable oLangs;
        ((BorderLayout)this.mainPanel.getLayout()).setVgap(5);
        this.mainPanel.removeAll();
        this.dlgPanel.removeAll();
        this.dlgPanel.setLayout((LayoutManager)new BorderLayout(5, 5));
        this.mainPanel.add((Component)this.dlgPanel, (Object)"Center");
        OiicSessionContext sessionContext = this.m_instSession.getSessionContext();
        if (this.m_instSession.getDepEngine().isPatchSetReinstall()) {
            this.m_bshowAll = true;
        }
        this.cmpTree = new OiifcCompTree(this.m_instSession.getDepEngine(), this.m_bshowAll);
        if (!this.cmpTree.hasItems()) {
            return;
        }
        this.m_scrollbox = new ScrollBox((Component)((Object)this.cmpTree), 0, 0);
        this.dlgPanel.add((Component)this.m_scrollbox, (Object)"Center");
        LWContainer bottomPanel = new LWContainer();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 5, 5);
        c.weightx = 1.0;
        c.fill = 2;
        c.anchor = 18;
        bottomPanel.setLayout((LayoutManager)gridbag);
        c.gridx = 0;
        c.gridy = 0;
        bottomPanel.add((Component)this.m_Expand, (Object)c);
        c.gridx = 1;
        c.gridy = 0;
        bottomPanel.add((Component)this.m_Collapse, (Object)c);
        c.gridx = 2;
        c.gridy = 0;
        bottomPanel.add((Component)this.m_SelectAll, (Object)c);
        c.gridx = 3;
        c.gridy = 0;
        bottomPanel.add((Component)this.m_DeSelectAll, (Object)c);
        OiisVariable oDepModeVar = sessionContext.getVariable("DEP_MODE");
        String depMode = (String)oDepModeVar.getValue();
        if (depMode.equalsIgnoreCase("Custom") && !this.m_instSession.getDepEngine().isPatchSetReinstall()) {
            this.m_showAll = new LWCheckbox(OiixResourceBundle.getString("S_SHOWALL_DEPS"));
            this.m_showAll.addItemListener((ItemListener)this);
            this.m_showAll.addKeyListener((KeyListener)this);
            this.m_showAll.setFocusable(true);
            this.m_showAll.setMnemonicChar('w');
            c.gridx = 0;
            c.gridy = 1;
            c.gridwidth = 3;
            bottomPanel.add((Component)this.m_showAll, (Object)c);
            this.m_showAll.setState(this.m_bshowAll);
        }
        if (!(oLangs = sessionContext.getVariable("SELECTED_LANGUAGES")).getAdvice() && !this.m_instSession.getDepEngine().isPatchSetReinstall()) {
            c.gridx = 3;
            c.gridy = 1;
            bottomPanel.add((Component)this.m_buttonLang, (Object)c);
        }
        this.dlgPanel.add((Component)bottomPanel, (Object)"South");
        OiiiCompInstallID[] compIDs = this.m_instSession.getSelTopLevelCompIDs();
        this.setTitleLabel(OiixResourceBundle.getString("S_DEPENDENCIES"));
        if (compIDs.length > 1) {
            prompt = OiixResourceBundle.getString("S_DEPS_PROMPT");
        } else {
            Object[] arr = new String[]{this.m_instSession.getStgCompName(compIDs[0])};
            this.setSubTitleLabel(arr[0]);
            prompt = OiixResourceBundle.getString("S_DEP_PROMPT");
            prompt = MessageFormat.format(prompt, arr);
        }
        this.m_promptLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), prompt);
        this.m_promptLabel.setPreferredAspectRatio(0.0f);
        this.mainPanel.add((Component)this.m_promptLabel, (Object)"North");
        this.validate();
    }

    public Dimension getPreferredSize() {
        return this.m_preferredSize;
    }

    public OiiiCompInstallID getSelectedCompID() {
        return this.cmpTree.getHilightedCompID();
    }

    public void setShowCustomTree(Boolean bVal) {
        this.m_bShowTree = bVal;
    }

    public Boolean getShowCustomTree() {
        return this.m_bShowTree;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        OiifcCompTreeObject ctobj;
        int i;
        int nRows;
        OiifcCTTwoDDataSource ds;
        if (e.getSource() == this.m_buttonLang) {
            OiifjLangsDlg dlg = new OiifjLangsDlg((Frame)((Object)this.m_instSession.getMainFrame()), this.m_instSession);
            dlg.doModal();
        }
        if (e.getSource() == this.m_Expand) {
            ds = this.cmpTree.getDataSource();
            nRows = ds.getExpandedRowCount();
            for (i = 0; i < nRows; ++i) {
                ds.expandExpandedRow(i);
            }
        }
        if (e.getSource() == this.m_Collapse) {
            ds = this.cmpTree.getDataSource();
            nRows = ds.getExpandedRowCount();
            for (i = 0; i < nRows; ++i) {
                ds.collapseExpandedRow(i);
            }
        }
        if (e.getSource() == this.m_SelectAll) {
            ds = this.cmpTree.getDataSource();
            nRows = ds.getExpandedRowCount();
            for (i = 0; i < nRows; ++i) {
                ctobj = OiifcCTUtils.getExpandedCTObjectFromHGrid(this.cmpTree.getGrid(), 0, i);
                if (!ctobj.isEnabled()) continue;
                ctobj.setSelected(true);
            }
        }
        if (e.getSource() == this.m_DeSelectAll) {
            ds = this.cmpTree.getDataSource();
            nRows = ds.getExpandedRowCount();
            for (i = 0; i < nRows; ++i) {
                ctobj = OiifcCTUtils.getExpandedCTObjectFromHGrid(this.cmpTree.getGrid(), 0, i);
                if (!ctobj.isEnabled()) continue;
                ctobj.setSelected(false);
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.m_showAll) {
            OiifmCursorUtil.setCursor(3, (Component)((Object)this));
            this.doShowAll();
            OiifmCursorUtil.setCursor(0, (Component)((Object)this));
        }
    }

    public void doShowAll() {
        this.m_bshowAll = this.m_showAll.getState();
        OiifcCompTree cmpTree1 = new OiifcCompTree(this.m_instSession.getDepEngine(), this.m_bshowAll);
        this.dlgPanel.remove((Component)this.m_scrollbox);
        this.m_scrollbox = new ScrollBox((Component)((Object)cmpTree1), 0, 0);
        this.dlgPanel.add((Component)this.m_scrollbox, (Object)"Center");
        this.cmpTree = cmpTree1;
        this.validate();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (Character.toUpperCase(e.getKeyChar()) == 'W') {
            this.m_showAll.setFocusable(false);
            this.doShowAll();
            this.m_showAll.setFocusable(true);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

