/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifp;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Vector;
import oracle.ewt.button.ButtonBar;
import oracle.ewt.dataSource.ArrayOneDDataSource;
import oracle.ewt.dataSource.ArrayTwoDDataSource;
import oracle.ewt.dataSource.OneDDataSource;
import oracle.ewt.dataSource.TwoDDataSource;
import oracle.ewt.grid.Grid;
import oracle.ewt.grid.GridEditListener;
import oracle.ewt.grid.GridEvent;
import oracle.ewt.grid.GridRowSelectListener;
import oracle.ewt.grid.GridSelection;
import oracle.ewt.grid.SingleRowSelection;
import oracle.ewt.header.Header;
import oracle.ewt.header.NullItemSelection;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.lwAWT.lwText.LWTextArea;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.painter.NullPainter;
import oracle.ewt.painter.Painter;
import oracle.ewt.scrolling.scrollBox.ScrollBox;
import oracle.ewt.table.TableScrollBox;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiif.oiifb.OiifbConfigController;
import oracle.sysman.oii.oiif.oiifb.OiifbConfigLauncher;
import oracle.sysman.oii.oiif.oiifb.OiifbConfigResultListener;
import oracle.sysman.oii.oiif.oiifb.OiifbConfigToolInfo;
import oracle.sysman.oii.oiif.oiifb.OiifbConfigToolInfoPerSession;
import oracle.sysman.oii.oiif.oiifb.OiifbStackLayout;
import oracle.sysman.oii.oiif.oiifm.OiifmSpreadTable;
import oracle.sysman.oii.oiif.oiifm.OiifmStreamTextAreaListener;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixBufferOutputStream;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixWorkNotifiable;

public class OiifpConfigTablePanel
extends LWContainer
implements GridRowSelectListener,
GridEditListener,
OiixWorkNotifiable {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 256;
    private static final String LINE = "================================================================================================================";
    public static final String COMMAND_RUN = "Run";
    public static final int RUN_BTN = 1;
    public static final String COMMAND_STOP = "Stop";
    public static final int STOP_BTN = 2;
    private final int HGAP = 10;
    private final int VGAP = 5;
    private OiifbConfigLauncher m_configLauncher = null;
    private ArrayTwoDDataSource m_dataSource = null;
    private ArrayOneDDataSource m_headerSource = null;
    private OiifmSpreadTable m_table = null;
    private LWButton m_run = null;
    private LWButton m_stop = null;
    private Vector m_recTools = null;
    private Vector m_optTools = null;
    private String[] m_results = null;
    private boolean m_runAllowed = true;
    private boolean m_stopAllowed = false;
    private OiifbConfigResultListener m_cResultListener = null;
    private DetailsTextArea m_detailsArea = null;
    private LWTextField m_detailsField = null;
    private OiifmStreamTextAreaListener m_stl = null;
    private OiixBufferOutputStream m_output = null;
    private OiixWorkNotifiable m_workNotifiable = null;
    private int m_iOldTableRowIndex = -1;
    private Vector m_vConfigTools = null;
    private int[] toolindexes;
    private OiifbConfigController m_configHandler;
    private OiifbConfigController m_configListener;

    public OiifpConfigTablePanel(Vector recTools, Vector optTools) {
        this.setLayout(new BorderLayout(10, 5));
        this.m_recTools = recTools;
        this.m_optTools = optTools;
        this.m_results = new String[this.m_recTools.size() + this.m_optTools.size()];
        for (int i = 0; i < this.m_results.length; ++i) {
            this.m_results[i] = "";
        }
        this.toolindexes = new int[this.m_results.length];
        this.add((Component)this.createToolPanel(), "Center");
        this.add((Component)this.createDetailsPanel(), "South");
        this.setRunAllowed(true);
        this.setStopAllowed(false);
        this.validate();
    }

    public OiifpConfigTablePanel(Vector configTools) {
        this.setLayout(new BorderLayout(10, 5));
        this.m_vConfigTools = configTools;
        if (this.m_vConfigTools.size() > 0) {
            int count = 0;
            for (int i = 0; i < this.m_vConfigTools.size(); ++i) {
                OiifbConfigToolInfoPerSession oConfigToolWrapper = (OiifbConfigToolInfoPerSession)this.m_vConfigTools.elementAt(i);
                if (null != oConfigToolWrapper.getRecPluginList()) {
                    count += oConfigToolWrapper.getRecPluginList().size();
                }
                if (null == oConfigToolWrapper.getOptPluginList()) continue;
                count += oConfigToolWrapper.getOptPluginList().size();
            }
            this.m_results = new String[count];
        } else {
            this.m_results = new String[0];
        }
        for (int i = 0; i < this.m_results.length; ++i) {
            this.m_results[i] = "";
        }
        this.toolindexes = new int[this.m_results.length];
        this.add((Component)this.createToolPanel(), "Center");
        this.add((Component)this.createDetailsPanel(), "South");
        this.setRunAllowed(true);
        this.setStopAllowed(false);
        this.validate();
    }

    public void setActionListener(ActionListener actionListener) {
        this.m_run.addActionListener(actionListener);
        this.m_stop.addActionListener(actionListener);
    }

    private LWContainer createToolPanel() {
        LWContainer panel = new LWContainer();
        if (null == this.m_vConfigTools) {
            this.createDataSources();
        } else {
            this.createDataSourcesForCfw();
        }
        this.m_table = OiifmSpreadTable.createSpreadTable((TwoDDataSource)this.m_dataSource, (OneDDataSource)this.m_headerSource, null, 1);
        this.m_table.setScrollByRow(true);
        this.m_table.setScrollByColumn(false);
        Grid grid = this.m_table.getGrid();
        grid.addRowSelectListener((GridRowSelectListener)this);
        grid.addEditListener((GridEditListener)this);
        SingleRowSelection rowSelObj = new SingleRowSelection();
        rowSelObj.setParent(grid);
        grid.setGridSelection((GridSelection)rowSelObj);
        this.m_table.setColumnWidth(0, 20);
        this.m_table.setColumnWidth(1, 315);
        this.m_table.setColumnWidth(2, 125);
        this.m_table.setColumnWidth(3, 125);
        Header header = this.m_table.getColumnHeader();
        header.setHeaderSelection(NullItemSelection.getHeaderSelection());
        header.setCanMoveItems(false);
        header.setCanResizeItems(true);
        this.m_run = new LWButton(OiixResourceBundle.getString("S_RUN_BUTTON"));
        this.m_run.setRightmost(true);
        this.m_run.setActionCommand(COMMAND_RUN);
        this.m_stop = new LWButton(OiixResourceBundle.getString("S_STOP_BUTTON"));
        this.m_stop.setLeftmost(true);
        this.m_stop.setActionCommand(COMMAND_STOP);
        ButtonBar bBar = new ButtonBar();
        bBar.add((Component)this.m_run);
        bBar.add((Component)this.m_stop);
        panel.setLayout((LayoutManager)new BorderLayout());
        LWContainer tmpPanel = new LWContainer((LayoutManager)new OiifbStackLayout(1));
        panel.add((Component)tmpPanel, (Object)"Center");
        TableScrollBox tableScroll = new TableScrollBox((Component)((Object)this.m_table), 0, 0);
        tmpPanel.add("Top Left Wide Tall".toUpperCase(Locale.ENGLISH), (Component)tableScroll);
        tmpPanel.add("Top Right".toUpperCase(Locale.ENGLISH), (Component)bBar);
        return panel;
    }

    private LWContainer createDetailsPanel() {
        LWContainer panel = new LWContainer((LayoutManager)new BorderLayout());
        String prompt = OiixResourceBundle.getString("S_GENERIC_DETAILS_LABEL");
        prompt = MessageFormat.format(prompt, OiiolTextLogger.getCurLogFileName());
        this.m_detailsField = new LWTextField(prompt);
        this.m_detailsField.setBorderPainter(NullPainter.getPainter());
        this.m_detailsField.setFill((Painter)NullPainter.getPainter());
        this.m_detailsField.setEditable(false);
        panel.add((Component)this.m_detailsField, (Object)"North");
        this.m_detailsArea = new DetailsTextArea("");
        this.m_detailsArea.setRows(5);
        this.m_detailsArea.setTextWrapper(WordWrapper.getTextWrapper());
        this.m_detailsArea.setEditable(false);
        ScrollBox scroll = new ScrollBox((Component)((Object)this.m_detailsArea), 2, 1);
        this.m_detailsArea.setScrollBox(scroll);
        panel.add((Component)scroll, (Object)"Center");
        return panel;
    }

    private void createDataSources() {
        OiifbConfigToolInfo toolInfo;
        int i;
        Object[] headerItems = new String[]{"", OiixResourceBundle.getString("S_TOOL_NAME"), OiixResourceBundle.getString("S_STATUS"), OiixResourceBundle.getString("S_TOOL_TYPE")};
        this.m_headerSource = new ArrayOneDDataSource(headerItems);
        this.m_dataSource = new ArrayTwoDDataSource(4, this.m_results.length);
        int nRecToolsCount = this.m_recTools.size();
        for (i = 0; i < nRecToolsCount; ++i) {
            toolInfo = (OiifbConfigToolInfo)this.m_recTools.elementAt(i);
            this.m_dataSource.setData(1, i, (Object)toolInfo);
            this.m_dataSource.setData(2, i, (Object)toolInfo);
            this.m_dataSource.setData(3, i, (Object)toolInfo);
            this.m_dataSource.setData(0, i, (Object)Boolean.TRUE);
            this.toolindexes[i] = i;
        }
        for (i = 0; i < this.m_optTools.size(); ++i) {
            toolInfo = (OiifbConfigToolInfo)this.m_optTools.elementAt(i);
            this.m_dataSource.setData(1, nRecToolsCount + i, (Object)toolInfo);
            this.m_dataSource.setData(2, nRecToolsCount + i, (Object)toolInfo);
            this.m_dataSource.setData(3, nRecToolsCount + i, (Object)toolInfo);
            this.m_dataSource.setData(0, nRecToolsCount + i, (Object)Boolean.TRUE);
            this.toolindexes[nRecToolsCount + i] = nRecToolsCount + i;
        }
    }

    private void createDataSourcesForCfw() {
        Object[] headerItems = new String[]{"", OiixResourceBundle.getString("S_TOOL_NAME"), OiixResourceBundle.getString("S_STATUS"), OiixResourceBundle.getString("S_TOOL_TYPE")};
        this.m_headerSource = new ArrayOneDDataSource(headerItems);
        int dataSourceCount = this.m_results.length + this.m_vConfigTools.size();
        this.m_dataSource = new ArrayTwoDDataSource(4, dataSourceCount);
        int p = 0;
        int drow = 0;
        for (int i = 0; i < this.m_vConfigTools.size(); ++i) {
            int j;
            OiifbConfigToolInfoPerSession wrapper = (OiifbConfigToolInfoPerSession)this.m_vConfigTools.elementAt(i);
            this.m_dataSource.setData(1, drow, (Object)wrapper);
            this.m_dataSource.setData(2, drow, null);
            this.m_dataSource.setData(0, drow, null);
            this.m_dataSource.setData(3, drow, null);
            int iRecToolCount = 0;
            if (null != wrapper.getRecPluginList()) {
                Vector reclist = wrapper.getRecPluginList();
                ++drow;
                iRecToolCount = reclist.size();
                for (j = 0; j < reclist.size(); ++j) {
                    this.m_dataSource.setData(1, drow, (Object)((OiifbConfigToolInfo)reclist.elementAt(j)));
                    this.m_dataSource.setData(2, drow, (Object)((OiifbConfigToolInfo)reclist.elementAt(j)));
                    this.m_dataSource.setData(0, drow, (Object)Boolean.TRUE);
                    this.m_dataSource.setData(3, drow, (Object)((OiifbConfigToolInfo)reclist.elementAt(j)));
                    this.toolindexes[p++] = drow++;
                }
            }
            if (null == wrapper.getOptPluginList()) continue;
            Vector optlist = wrapper.getOptPluginList();
            for (j = 0; j < optlist.size(); ++j) {
                this.m_dataSource.setData(1, drow, (Object)((OiifbConfigToolInfo)optlist.elementAt(j)));
                this.m_dataSource.setData(2, drow, (Object)((OiifbConfigToolInfo)optlist.elementAt(j)));
                this.m_dataSource.setData(0, drow, (Object)Boolean.TRUE);
                this.m_dataSource.setData(3, drow, (Object)((OiifbConfigToolInfo)optlist.elementAt(j)));
                this.toolindexes[p++] = drow++;
            }
        }
    }

    public DetailsTextArea getDetailsArea() {
        return this.m_detailsArea;
    }

    public void setRunAllowed(boolean enabled) {
        this.m_runAllowed = enabled;
        this.setEnabledButton(1, enabled);
    }

    public final boolean getRunAllowed() {
        return this.m_runAllowed;
    }

    public void setStopAllowed(boolean enabled) {
        this.m_stopAllowed = enabled;
        this.setEnabledButton(2, enabled);
    }

    private void setEnabledButton(int p_iButton, boolean p_bEnabled) {
        switch (p_iButton) {
            case 1: {
                this.m_run.setEnabled(p_bEnabled);
                break;
            }
            case 2: {
                this.m_stop.setEnabled(p_bEnabled);
                break;
            }
            default: {
                new Exception("No Such Button ID (" + p_iButton + ")");
            }
        }
    }

    public void setStatus(String toolname, String oraHomeName, String toplevelName, String compName, String actionName, String stepIdx, String microStepIdx, int status, String details, String sMsg) {
        boolean changeDetails = false;
        if (status == 2) {
            String[] stringArray = new String[]{details};
        } else if (status == 4 || status == 5 || status == 3) {
            changeDetails = true;
        } else if (status == 1) {
            int toolIdx = this.getToolIndex(toolname, oraHomeName, toplevelName, compName, actionName, stepIdx, microStepIdx);
            this.m_detailsArea.startToolOutput(toolIdx, sMsg);
        }
        for (int row = 0; row < this.m_dataSource.getRowCount(); ++row) {
            OiifbConfigToolInfo toolInfo;
            if (!(this.m_dataSource.getData(1, row) instanceof OiifbConfigToolInfo) || !toolname.equals((toolInfo = (OiifbConfigToolInfo)this.m_dataSource.getData(1, row)).getToolName()) || !oraHomeName.equals(toolInfo.getOraHome()) || !compName.equals(toolInfo.getAggrName()) || !actionName.equals(toolInfo.getActionID()) || !stepIdx.equals(toolInfo.getStepIndex()) || !microStepIdx.equals(toolInfo.getMicroStepIndex())) continue;
            toolInfo.setToolStatus(status);
            toolInfo.setToolCommand(sMsg);
            this.m_dataSource.setData(2, row, (Object)toolInfo);
            this.updateSelectionState(row);
            if (status == 1) {
                GridSelection gridSelection = this.m_table.getGrid().getGridSelection();
                gridSelection.setRowSelected(row, true);
                this.m_table.getGrid().scrollRowIntoView(row);
            }
            if (!changeDetails) break;
            this.m_results[this.mapToolindexToToolCount((int)row)] = this.formatDetails(details);
            break;
        }
        this.paintImmediate();
    }

    public void setStatus(String toolname, int status, String details) {
        boolean changeDetails = false;
        if (status == 2) {
            String[] stringArray = new String[]{details};
        } else if (status == 4 || status == 5 || status == 3) {
            changeDetails = true;
            int toolIndex = this.getToolIndex(toolname);
            this.m_detailsArea.startToolOutput(toolIndex);
        } else if (status == 1) {
            // empty if block
        }
        for (int row = 0; row < this.m_dataSource.getRowCount(); ++row) {
            OiifbConfigToolInfo toolInfo;
            if (!(this.m_dataSource.getData(1, row) instanceof OiifbConfigToolInfo) || !toolname.equals((toolInfo = (OiifbConfigToolInfo)this.m_dataSource.getData(1, row)).getToolName())) continue;
            toolInfo.setToolStatus(status);
            this.m_dataSource.setData(2, row, (Object)toolInfo);
            this.updateSelectionState(row);
            if (status == 1) {
                GridSelection gridSelection = this.m_table.getGrid().getGridSelection();
                gridSelection.setRowSelected(row, true);
                this.m_table.getGrid().scrollRowIntoView(row);
            }
            if (!changeDetails) break;
            this.m_results[this.mapToolindexToToolCount((int)row)] = this.formatDetails(details);
            break;
        }
        this.paintImmediate();
    }

    private void updateSelectionState(int toolIndex) {
        Boolean bSelected = Boolean.FALSE;
        int nStatus = this.getToolStatus(toolIndex);
        if (nStatus == 5 || nStatus == 4 || nStatus == 6 || nStatus == 0) {
            bSelected = Boolean.TRUE;
        }
        this.m_dataSource.setData(0, toolIndex, (Object)bSelected);
    }

    public void repaint() {
        super.repaint();
    }

    public void setConfigListener(OiifbConfigLauncher cLauncher) {
        this.m_configLauncher = cLauncher;
    }

    public void setConfigListener(OiifbConfigController cHandler) {
        this.m_configHandler = cHandler;
    }

    public void setConfigResultListener(OiifbConfigController cListener) {
        this.m_configListener = cListener;
    }

    public OiifbConfigLauncher getConfigListener() {
        return this.m_configLauncher;
    }

    public void setConfigResultListener(OiifbConfigResultListener cResultListener) {
        this.m_cResultListener = cResultListener;
    }

    int getSelectedToolIndex() {
        GridSelection sel = this.m_table.getGrid().getGridSelection();
        int[] selRows = sel.getSelectedRows();
        return selRows != null && 0 < selRows.length ? selRows[0] : -1;
    }

    OiifbConfigToolInfo getToolInfo(int toolIndex) {
        OiifbConfigToolInfo toolInfo = null;
        if (this.m_dataSource.getData(1, toolIndex = this.getCorrectIndex(toolIndex)) instanceof OiifbConfigToolInfo) {
            toolInfo = (OiifbConfigToolInfo)this.m_dataSource.getData(1, toolIndex);
        }
        return toolInfo;
    }

    int getToolIndex(String toolName, String oraHomeName, String toplevelName, String compName, String actionName, String stepIdx, String microStepIdx) {
        int nIndex = 0;
        for (int row = 0; row < this.m_dataSource.getRowCount(); ++row) {
            OiifbConfigToolInfo toolInfo;
            if (!(this.m_dataSource.getData(1, row) instanceof OiifbConfigToolInfo) || !toolName.equals((toolInfo = (OiifbConfigToolInfo)this.m_dataSource.getData(1, row)).getToolName()) || !oraHomeName.equals(toolInfo.getOraHome()) || !compName.equals(toolInfo.getAggrName()) || !actionName.equals(toolInfo.getActionID()) || !stepIdx.equals(toolInfo.getStepIndex()) || !microStepIdx.equals(toolInfo.getMicroStepIndex())) continue;
            nIndex = row;
        }
        return this.mapToolindexToToolCount(nIndex);
    }

    int getToolIndex(String toolName) {
        int nIndex = 0;
        for (int row = 0; row < this.m_dataSource.getRowCount(); ++row) {
            OiifbConfigToolInfo toolInfo;
            if (!(this.m_dataSource.getData(1, row) instanceof OiifbConfigToolInfo) || !toolName.equals((toolInfo = (OiifbConfigToolInfo)this.m_dataSource.getData(1, row)).getToolName())) continue;
            nIndex = row;
        }
        return this.mapToolindexToToolCount(nIndex);
    }

    private int mapToolindexToToolCount(int index) {
        for (int i = 0; i < this.toolindexes.length; ++i) {
            if (this.toolindexes[i] != index) continue;
            return i;
        }
        return -1;
    }

    boolean isToolSelected(int toolIndex) {
        Boolean oSelected = (Boolean)this.m_dataSource.getData(0, toolIndex);
        if (null != oSelected) {
            return oSelected;
        }
        return false;
    }

    public void setWorkNotifiable(OiixWorkNotifiable workNotifiable) {
        this.m_workNotifiable = workNotifiable;
    }

    @Override
    public void workStarted(Object o) {
        this.m_workNotifiable.workStarted(o);
    }

    @Override
    public void workCompleted(Object o) {
        if (o == this.m_configLauncher) {
            int index = this.getSelectedToolIndex();
            OiifbConfigToolInfo toolInfo = this.getToolInfo(index);
            if (index >= 0 && this.m_configLauncher != null) {
                String name = toolInfo.getToolName();
                this.m_stl.stopListening();
                this.setStopAllowed(false);
                int result = this.m_configLauncher.getResultFromLastTool();
                String str = "";
                if (this.m_output != null) {
                    str = this.formatDetails(this.m_output.getContents());
                }
                if (result == 0) {
                    this.setStatus(name, 3, str);
                    this.checkAllToolsSuccessful();
                } else {
                    if (OiicPullSession.isSilentMode() && str != null) {
                        OiiolTextLogger.appendErrorText(str);
                    }
                    if (result == 1) {
                        this.setStatus(name, 4, str);
                    } else if (result == -1) {
                        this.setStatus(name, 5, str);
                    }
                }
            }
            this.m_configLauncher.clearClient();
            this.setEnabledButton(1, true);
            this.m_workNotifiable.workCompleted(o);
        }
    }

    private String formatDetails(String s) {
        if (null != s) {
            StringBuffer sBuff = new StringBuffer(s.length());
            try {
                for (int i = 0; i < s.length(); ++i) {
                    char c = s.charAt(i);
                    if (c != '\r') {
                        sBuff.append(c);
                        continue;
                    }
                    if (i + 1 < s.length() && s.charAt(i + 1) == '\n') continue;
                    sBuff.append('\n');
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return sBuff.toString();
        }
        return "";
    }

    private void showDetails() {
        int index = this.getSelectedToolIndex();
        this.m_detailsArea.scrollToTool(index);
    }

    private int getToolStatus(int index) {
        OiifbConfigToolInfo toolInfo = (OiifbConfigToolInfo)this.m_dataSource.getData(2, index);
        return toolInfo.getToolStatus();
    }

    private void checkAllToolsSuccessful() {
        if (this.m_cResultListener != null) {
            int nSize = this.m_dataSource.getRowCount();
            for (int i = 0; i < nSize; ++i) {
                if (this.m_dataSource.getData(2, i) == null || this.getToolStatus(i) == 3) continue;
                return;
            }
            this.m_cResultListener.onAllToolsSucceeded();
        }
    }

    private int getCorrectIndex(int indexorig) {
        return this.toolindexes[indexorig];
    }

    public void rowSelected(GridEvent e) {
        int v_iNewTableRowIndex;
        if (this.m_table.isEnabled() && (v_iNewTableRowIndex = this.getSelectedToolIndex()) != this.m_iOldTableRowIndex) {
            this.m_iOldTableRowIndex = v_iNewTableRowIndex;
            this.setEnabledButton(1, this.m_runAllowed);
            this.setEnabledButton(2, this.m_stopAllowed);
            this.showDetails();
        }
    }

    public void rowSelecting(GridEvent e) {
    }

    public void rowDeselecting(GridEvent e) {
    }

    public void rowDeselected(GridEvent e) {
    }

    public void cellEditing(GridEvent e) {
    }

    public void cellEdited(GridEvent e) {
        if (this.m_table.isEnabled()) {
            boolean v_bRetryButtonStatus = false;
            for (int i = 0; i < this.m_results.length + this.m_vConfigTools.size() && !v_bRetryButtonStatus; ++i) {
                v_bRetryButtonStatus = this.isToolSelected(i);
            }
            this.setRunAllowed(v_bRetryButtonStatus);
        }
    }

    public class DetailsTextArea
    extends LWTextArea {
        private ScrollBox m_scrollBox;
        private Vector m_scrollPoints;
        private Object m_lock;

        DetailsTextArea(String sText) {
            super(sText);
            this.m_lock = new Object();
            this.m_scrollPoints = new Vector(OiifpConfigTablePanel.this.m_dataSource.getRowCount());
            this.m_scrollPoints.setSize(OiifpConfigTablePanel.this.m_dataSource.getRowCount());
        }

        public DetailsTextArea(String sText, int rows, int columns) {
            super(sText, rows, columns);
            this.m_lock = new Object();
            this.m_scrollPoints = new Vector(OiifpConfigTablePanel.this.m_dataSource.getRowCount());
            this.m_scrollPoints.setSize(OiifpConfigTablePanel.this.m_dataSource.getRowCount());
        }

        public Object getLock() {
            return this.m_lock;
        }

        void setScrollBox(ScrollBox scrollBox) {
            this.m_scrollBox = scrollBox;
        }

        public void updateOutputForConfig(int toolIndex, String sToolMsg) {
            OiifbConfigToolInfo toolInfo = OiifpConfigTablePanel.this.getToolInfo(toolIndex);
            if (null != toolInfo) {
                this.append(sToolMsg + "\n" + "-----------------------------------------------------------------------------");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void startToolOutput(int toolIndex) {
            OiifbConfigToolInfo toolInfo = OiifpConfigTablePanel.this.getToolInfo(toolIndex);
            String sMsg = null;
            if (toolInfo.getAttempts() > 1) {
                sMsg = OiixResourceBundle.getString("S_START_TOOL_OUTPUT_MULTI_ATTEMPTS");
                sMsg = MessageFormat.format(sMsg, toolInfo.getExternalName(), new Integer(toolInfo.getAttempts()));
            } else {
                sMsg = OiixResourceBundle.getString("S_START_TOOL_OUTPUT");
                sMsg = MessageFormat.format(sMsg, toolInfo.getExternalName());
            }
            Object object = this.getLock();
            synchronized (object) {
                this.append(sMsg + "\n");
            }
            this.updateScrollPointForTool(toolIndex);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void startToolOutput(int toolIndex, String sCmdArg) {
            OiifbConfigToolInfo toolInfo = OiifpConfigTablePanel.this.getToolInfo(toolIndex);
            String sMsg = null;
            if (toolInfo.getAttempts() > 1) {
                sMsg = OiixResourceBundle.getString("S_START_TOOL_OUTPUT_MULTI_ATTEMPTS");
                sMsg = MessageFormat.format(sMsg, toolInfo.getExternalName(), new Integer(toolInfo.getAttempts()));
            } else {
                sMsg = OiixResourceBundle.getString("S_START_TOOL_OUTPUT");
                sMsg = MessageFormat.format(sMsg, toolInfo.getExternalName());
            }
            Object object = this.getLock();
            synchronized (object) {
                this.append(sMsg);
            }
            this.updateScrollPointForTool(toolIndex);
            Object object2 = this.getLock();
            synchronized (object2) {
                this.append("\n" + sCmdArg);
            }
        }

        private void updateScrollPointForTool(int toolIndex) {
            Point p = this.m_scrollBox.getScrollPosition();
            this.m_scrollPoints.setElementAt(p, toolIndex);
        }

        void scrollToTool(int toolIndex) {
            Point p = (Point)this.m_scrollPoints.elementAt(toolIndex = OiifpConfigTablePanel.this.mapToolindexToToolCount(toolIndex));
            if (p != null) {
                this.m_scrollBox.setScrollPosition(p);
            }
        }
    }
}

