/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifp;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.io.File;
import java.text.MessageFormat;
import java.util.List;
import java.util.Vector;
import oracle.ewt.dTree.DTreeItem;
import oracle.ewt.dTree.DTreeSimpleRoot;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.scrolling.scrollBox.ScrollBox;
import oracle.sysman.oii.oiic.OiicAddNodeSummaryInformation;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiif.oiifm.OiifmTree;
import oracle.sysman.oii.oiif.oiifm.OiifmTreeItem;
import oracle.sysman.oii.oiif.oiifp.OiifpWizPanel;
import oracle.sysman.oii.oiii.OiiiInstallCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiix.OiixLanguage;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiifpAddNodeSummaryPanel
extends OiifpWizPanel {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 256;
    private static final int LIST_BUTTON_GAP = 5;
    private final int BORDER_VGAP = 5;
    private final int BORDER_HGAP = 5;
    private OiicPullSession m_pullSession;
    private OiiiInstallInventory m_inventory;
    private OiifmTree m_oSummaryTree;
    private ScrollBox scrollbox;
    private LWContainer compPanel;
    private Font m_tBoldFont;
    private boolean m_diskFull;
    private Boolean m_bSummary = new Boolean(true);
    private long m_lTotalBytes = 0L;
    private OiicAddNodeSummaryInformation m_oSummaryInfo = null;

    public OiifpAddNodeSummaryPanel() {
        super(OiixResourceBundle.getString("S_ADDNODE_SUMMARY"));
    }

    @Override
    public void createPanelElements() {
        this.m_pullSession = this.m_wcde.getVarOwner().getSession();
        this.dlgPanel.setLayout((LayoutManager)new BorderLayout());
        this.compPanel = new LWContainer();
        this.compPanel.setLayout((LayoutManager)new BorderLayout(5, 5));
        this.dlgPanel.add((Component)this.compPanel, (Object)"Center");
        this.m_oSummaryTree = new OiifmTree();
        this.scrollbox = new ScrollBox((Component)((Object)this.m_oSummaryTree), 0, 0);
        this.compPanel.add((Component)this.scrollbox, (Object)"Center");
        this.init();
        this.validate();
    }

    @Override
    public void dispose() {
        if (this.scrollbox != null) {
            this.scrollbox.removeAll();
        }
        if (this.m_oSummaryTree != null) {
            this.m_oSummaryTree.dispose();
        }
        if (this.compPanel != null) {
            this.compPanel.removeAll();
        }
        if (this.dlgPanel != null) {
            this.dlgPanel.removeAll();
        }
        if (this.mainPanel != null) {
            this.mainPanel.removeAll();
        }
        this.removeAll();
        this.dlgPanel = null;
        this.compPanel = null;
        this.scrollbox = null;
        this.mainPanel = null;
        this.m_oSummaryTree = null;
        this.m_pullSession = null;
        this.m_inventory = null;
    }

    public Boolean getShowSummary() {
        return this.m_bSummary;
    }

    public void setShowSummary(Boolean bShow) {
        this.m_bSummary = bShow;
    }

    public void init() {
        this.m_inventory = this.m_pullSession.getInstallAreaControl().getInstallInventory();
        this.populateTree();
        this.scrollbox.validate();
        this.validate();
    }

    public void populateTree() {
        if (this.m_tBoldFont == null) {
            this.m_tBoldFont = new Font(OiixResourceBundle.getFont(), OiixLanguage.getFontStyle(1), 12);
        }
        this.m_oSummaryInfo = new OiicAddNodeSummaryInformation(this.m_pullSession);
        this.addAddNodeGlobalInfos();
        this.addAddNodeSpaceInfos();
        this.addHomeComponentsInfos();
    }

    public void logSummaryInfo() {
        if (this.m_oSummaryTree != null) {
            this.m_oSummaryTree.logTree(null, "", OiiolTextLogger.LOG_BASIC);
        }
    }

    private void addAddNodeGlobalInfos() {
        DTreeSimpleRoot root = this.m_oSummaryTree.getSimpleRoot();
        OiifmTreeItem oSettingsItem = new OiifmTreeItem(OiixResourceBundle.getString("S_SUMMARY_TREE_GS"), null, null);
        oSettingsItem.setFont(this.m_tBoldFont);
        root.addItem((DTreeItem)oSettingsItem);
        Object[] msgArr = new String[]{this.m_oSummaryInfo.getSourceHomeLocation()};
        String sSrcLabel = MessageFormat.format(OiixResourceBundle.getString("S_SUMMARY_INFO_STAGE"), msgArr);
        OiifmTreeItem oStagingAreaItem = new OiifmTreeItem(sSrcLabel, null, null);
        oSettingsItem.addItem((DTreeItem)oStagingAreaItem);
        String[] clsNodes = this.m_oSummaryInfo.getClusterNodeNames();
        String sClusterNodes = OiixResourceBundle.getString("S_ENTIRE_CLUSTER_NODES");
        OiifmTreeItem oClusterNodesItem = new OiifmTreeItem(sClusterNodes, null, null);
        for (int i = 0; i < clsNodes.length; ++i) {
            OiifmTreeItem oclsNodes = new OiifmTreeItem(clsNodes[i], null, null);
            oClusterNodesItem.addItem((DTreeItem)oclsNodes);
        }
        oSettingsItem.addItem((DTreeItem)oClusterNodesItem);
        String[] nodeMsgArr = this.m_oSummaryInfo.getNewClusterNodes();
        if (nodeMsgArr != null && nodeMsgArr.length > 0) {
            String sNodeNamesLabel = OiixResourceBundle.getString("S_NEW_NODES");
            OiifmTreeItem oClusterNewNodesItem = new OiifmTreeItem(sNodeNamesLabel, null, null);
            for (int i = 0; i < nodeMsgArr.length; ++i) {
                String sNodeMsg = nodeMsgArr[i];
                OiifmTreeItem oNodeItem = new OiifmTreeItem(sNodeMsg, null, null);
                oClusterNewNodesItem.addItem((DTreeItem)oNodeItem);
            }
            oClusterNewNodesItem.setExpanded(true);
            oSettingsItem.addItem((DTreeItem)oClusterNewNodesItem);
        }
        oSettingsItem.setExpanded(true);
    }

    private void addAddNodeSpaceInfos() {
        boolean bCFS = false;
        DTreeSimpleRoot root = this.m_oSummaryTree.getSimpleRoot();
        OiifmTreeItem oSpaceTopItem = new OiifmTreeItem(OiixResourceBundle.getString("S_SUMMARY_TREE_SPACE"), null, null);
        oSpaceTopItem.setFont(this.m_tBoldFont);
        root.addItem((DTreeItem)oSpaceTopItem);
        String[] msgArr1 = new String[]{this.m_oSummaryInfo.getSourceHomeLocation()};
        File oHome = new File(msgArr1[0]);
        OiipgFileSystem fSystem = new OiipgFileSystem();
        String sVolume = fSystem.getVolumeName(msgArr1[0]);
        OiisVariable oNodeNames = this.m_pullSession.getSessionContext().getVariable("CLUSTER_NEW_NODES");
        String[] nodeMsgArr = (String[])oNodeNames.getValue();
        bCFS = this.m_oSummaryInfo.isVolumeOnCFS(sVolume);
        if (!bCFS) {
            String newNodes = OiixResourceBundle.getString("S_NEW_NODES");
            boolean expand = false;
            OiifmTreeItem clusterSpaceItem = new OiifmTreeItem(newNodes, null, null);
            String sClusterLabel = null;
            long lAvailSpaceCluster = 0L;
            Object sAvailSpaceCluster = null;
            String[] slInsufficientSpace = this.m_oSummaryInfo.getClusterNodeNamesWithInsufficientSpace();
            Vector vInsufficientSpace = OiixVectorOps.strArr2Vect(slInsufficientSpace);
            for (int i = 0; i < nodeMsgArr.length; ++i) {
                OiifmTreeItem NewNodeItem = new OiifmTreeItem(nodeMsgArr[i], null, null);
                clusterSpaceItem.addItem((DTreeItem)NewNodeItem);
                String[] spaceInfo = this.m_oSummaryInfo.getRemoteVolumeDetails(nodeMsgArr[i]);
                Object[] clusterobj = new String[]{sVolume, spaceInfo[1], spaceInfo[0]};
                sClusterLabel = OiixResourceBundle.getString("S_CLUSTER_SUMMARY_INFO_SPACE");
                sClusterLabel = MessageFormat.format(sClusterLabel, clusterobj);
                OiifmTreeItem clusterNodesSpaceItem = new OiifmTreeItem(sClusterLabel, null, null);
                NewNodeItem.addItem((DTreeItem)clusterNodesSpaceItem);
                if (vInsufficientSpace.contains(nodeMsgArr[i])) {
                    expand = true;
                    clusterNodesSpaceItem.setForeground(Color.red);
                    continue;
                }
                clusterNodesSpaceItem.setForeground(Color.black);
            }
            clusterSpaceItem.setExpanded(expand);
            oSpaceTopItem.addItem((DTreeItem)clusterSpaceItem);
            oSpaceTopItem.setExpanded(true);
        }
    }

    private void addHomeComponentsInfos() {
        DTreeSimpleRoot root = this.m_oSummaryTree.getSimpleRoot();
        OiifmTreeItem oComponentsTopItem = new OiifmTreeItem(OiixResourceBundle.getString("S_SUMMARY_TREE_COMPONENTS"), null, null);
        oComponentsTopItem.setFont(this.m_tBoldFont);
        root.addItem((DTreeItem)oComponentsTopItem);
        String components = OiixResourceBundle.getString("S_SUMMARY_INSTALLED_PRODUCTS");
        OiifmTreeItem ComponentsItem = new OiifmTreeItem(components, null, null);
        List oInstalledComps = this.m_oSummaryInfo.getInstalledComponents();
        boolean bNoComps = oInstalledComps.size() == 0;
        for (int i = 0; i < oInstalledComps.size(); ++i) {
            OiiiInstallCompInvEntry icie = (OiiiInstallCompInvEntry)oInstalledComps.get(i);
            OiifmTreeItem CompItem = new OiifmTreeItem(icie.getFullDisplayName(), null, null);
            ComponentsItem.addItem((DTreeItem)CompItem);
        }
        if (bNoComps) {
            OiifmTreeItem CompItem = new OiifmTreeItem(OiixResourceBundle.getString("S_NO_INST_PRODS_PROMPT"), null, null);
            ComponentsItem.addItem((DTreeItem)CompItem);
        }
        ComponentsItem.setExpanded(true);
        oComponentsTopItem.addItem((DTreeItem)ComponentsItem);
        oComponentsTopItem.setExpanded(true);
    }
}

