/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifp;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.ewt.button.ButtonBar;
import oracle.ewt.dataSource.ArrayOneDDataSource;
import oracle.ewt.dataSource.ArrayTwoDDataSource;
import oracle.ewt.dataSource.OneDDataSource;
import oracle.ewt.dataSource.TwoDDataSource;
import oracle.ewt.grid.Grid;
import oracle.ewt.grid.GridEditListener;
import oracle.ewt.grid.GridEvent;
import oracle.ewt.grid.GridToolTipClient;
import oracle.ewt.grid.MultipleRowSelection;
import oracle.ewt.grid.NullInputHandler;
import oracle.ewt.grid.SingleRowSelection;
import oracle.ewt.grid.StandardNavigator;
import oracle.ewt.grid.TextFieldInputHandler;
import oracle.ewt.header.Header;
import oracle.ewt.header.NullItemSelection;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.painter.Painter;
import oracle.ewt.painter.TextPainter;
import oracle.ewt.table.SpreadTable;
import oracle.ewt.table.TableEditListener;
import oracle.ewt.table.TableEvent;
import oracle.ewt.table.TableScrollBox;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.sysman.oii.oiic.OiicClusterInstallInfo;
import oracle.sysman.oii.oiic.OiicClusterNode;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiif.oiifb.OiifbStackLayout;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiif.oiifm.OiifmGraphicInterfaceManager;
import oracle.sysman.oii.oiif.oiifm.OiifmICellStateSelector;
import oracle.sysman.oii.oiif.oiifm.OiifmSelNodeGrid;
import oracle.sysman.oii.oiif.oiifm.OiifmSpreadTable;
import oracle.sysman.oii.oiif.oiifp.OiifpNodeStatusPainter;
import oracle.sysman.oii.oiif.oiifp.OiifpWizPanel;
import oracle.sysman.oii.oiif.oiifw.OiifwAddNodeWCDE;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgDetectCluster;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixLanguage;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixUtilityOps;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiifpAddNodePanel
extends OiifpWizPanel
implements ActionListener,
GridEditListener,
TableEditListener,
OiifmICellStateSelector {
    private static final int INSETS = 3;
    private static int INIT_NODES = 8;
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 256;
    private String[] m_nodeList = null;
    private String[] m_asExistingPrivateNodeNames = null;
    private String[] m_asExistingVirtualHostNames = null;
    private String[] m_newNodes = null;
    private String[] m_asPrivateNodeNames = null;
    private String[] m_asVirtualHostNames = null;
    private boolean m_bEnableVirtualHostNames = false;
    private OiicPullSession m_pullSession;
    private OiisVariableOwner m_vo;
    private final int HGAP = 10;
    private final int VGAP = 5;
    private final String S_DEFAULT_VIRTUAL_HOSTNAME_STR = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFP1012");
    private final String S_DEFAULT_PRIVATE_NODENAME_STR = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFP1011");
    private final String S_DEFAULT_NODENAME_STR = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIFP1013");
    public static final int S_DEFAULT_MAX_WIDTH = 588;
    public static final int S_DEFAULT_PRIVATE_NODE_NAME_WIDTH = 123;
    public static final int S_DEFAULT_EXISTING_VIRTUAL_HOST_NAME_WIDTH = 113;
    public static final int S_DEFAULT_NEW_VIRTUAL_HOST_NAME_WIDTH = 113;
    public static final int S_DEFAULT_SCROLLBAR_WIDTH = 15;
    public static final int S_DEFAULT_NODE_STATUS_WIDTH = 200;
    public static final int S_DEFAULT_NODE_SELECTION_WIDTH = 19;
    private int m_nNewNodesColumnCnt = 2;
    private int m_nExistingNodesColumnCnt = 2;
    private final int PREF_ROWS = 4;
    private static final int S_NOSHOW_COL = -1;
    private int m_iExistingNodeNameCol = -1;
    private int m_iExistingPrivateNodeNameCol = -1;
    private int m_iExistingVirtualHostNameCol = -1;
    private int m_iExistingNodeStatusCol = -1;
    private int m_iNewNodeNameSelectionCol = -1;
    private int m_iNewNodeNameCol = -1;
    private int m_iNewPrivateNodeNameCol = -1;
    private int m_iNewVirtualHostNameCol = -1;
    private int m_iNewNodeStatusCol = -1;
    private int m_iExistingNodeNameColWidth = -1;
    private int m_iExistingPrivateNodeNameColWidth = -1;
    private int m_iExistingVirtualHostNameColWidth = -1;
    private int m_iExistingNodeStatusColWidth = -1;
    private int m_iNewNodeNameSelectionColWidth = -1;
    private int m_iNewNodeNameColWidth = -1;
    private int m_iNewPrivateNodeNameColWidth = -1;
    private int m_iNewVirtualHostNameColWidth = -1;
    private int m_iNewNodeStatusColWidth = -1;
    private ArrayTwoDDataSource m_existingDataSource;
    private ArrayTwoDDataSource m_newDataSource;
    private ArrayOneDDataSource m_existingHeaderSource;
    private ArrayOneDDataSource m_newHeaderSource;
    private LWButton m_btnDeselectAll;
    private LWButton m_btnSelectAll;
    MultipleRowSelection rowSelObj;
    SpreadTable m_tblNodeList;
    private boolean m_bShowStatus = false;
    private Map m_oSelectedNodes = new HashMap();
    private boolean m_bCRS = false;
    private boolean m_bVendorCW = false;
    private SpreadTable m_table = null;

    public OiifpAddNodePanel() {
        super(OiixResourceBundle.getString("S_NODE_ADDITION_TITLE"));
    }

    private int setupExistingNodesTableColumns(boolean bShowStatus, boolean bCRSHome) {
        int nColIdx = 0;
        this.m_iExistingNodeNameColWidth = 588;
        this.m_iExistingNodeNameCol = nColIdx++;
        if (bCRSHome) {
            this.m_iExistingPrivateNodeNameCol = nColIdx++;
            this.m_iExistingPrivateNodeNameColWidth = 123;
            this.m_iExistingNodeNameColWidth -= this.m_iExistingPrivateNodeNameColWidth;
            this.m_iExistingVirtualHostNameCol = nColIdx++;
            this.m_iExistingVirtualHostNameColWidth = 113;
            this.m_iExistingNodeNameColWidth -= this.m_iExistingVirtualHostNameColWidth + 15;
            ++this.m_iExistingVirtualHostNameColWidth;
        } else {
            this.m_iExistingPrivateNodeNameCol = -1;
            this.m_iExistingVirtualHostNameCol = -1;
            this.m_iExistingNodeNameColWidth += 2;
        }
        if (bShowStatus) {
            this.m_iExistingNodeStatusCol = nColIdx++;
            this.m_iExistingNodeStatusColWidth = 200;
            this.m_iExistingNodeNameColWidth -= this.m_iExistingNodeStatusColWidth;
        } else {
            int iAThirdOfStatusWidth = 66;
            if (this.m_iExistingPrivateNodeNameCol != -1) {
                this.m_iExistingPrivateNodeNameColWidth += iAThirdOfStatusWidth;
                this.m_iExistingNodeNameColWidth -= iAThirdOfStatusWidth;
            }
            if (this.m_iExistingVirtualHostNameCol != -1) {
                this.m_iExistingVirtualHostNameColWidth += iAThirdOfStatusWidth;
                this.m_iExistingNodeNameColWidth -= iAThirdOfStatusWidth;
            }
            this.m_iExistingNodeStatusCol = -1;
        }
        return nColIdx;
    }

    private int setupNewNodesTableColumns(boolean bShowStatus, boolean bCRSHome) {
        int nColIdx = 0;
        this.m_iNewNodeNameColWidth = 588;
        if (bCRSHome) {
            this.m_iNewNodeNameCol = nColIdx++;
            this.m_iNewPrivateNodeNameCol = nColIdx++;
            this.m_iNewPrivateNodeNameColWidth = 123;
            this.m_iNewNodeNameColWidth -= this.m_iNewPrivateNodeNameColWidth;
            this.m_iNewVirtualHostNameCol = nColIdx++;
            this.m_iNewVirtualHostNameColWidth = 113;
            this.m_iNewNodeNameColWidth -= this.m_iNewVirtualHostNameColWidth + 15;
            this.m_iNewNodeNameSelectionCol = -1;
            ++this.m_iNewVirtualHostNameColWidth;
        } else {
            this.m_iNewNodeNameSelectionCol = nColIdx++;
            this.m_iNewNodeNameSelectionColWidth = 19;
            this.m_iNewNodeNameColWidth -= this.m_iNewNodeNameSelectionColWidth;
            this.m_iNewNodeNameCol = nColIdx++;
            this.m_iNewPrivateNodeNameCol = -1;
            this.m_iNewVirtualHostNameCol = -1;
        }
        if (bShowStatus) {
            this.m_iNewNodeStatusCol = nColIdx++;
            this.m_iNewNodeStatusColWidth = 200;
            this.m_iNewNodeNameColWidth -= this.m_iNewNodeStatusColWidth;
        } else {
            int iAThirdOfStatusWidth = 66;
            if (this.m_iNewPrivateNodeNameCol != -1) {
                this.m_iNewPrivateNodeNameColWidth += iAThirdOfStatusWidth;
                this.m_iNewNodeNameColWidth -= iAThirdOfStatusWidth;
            }
            if (this.m_iNewVirtualHostNameCol != -1) {
                this.m_iNewVirtualHostNameColWidth += iAThirdOfStatusWidth;
                this.m_iNewNodeNameColWidth -= iAThirdOfStatusWidth;
            }
            this.m_iNewNodeStatusCol = -1;
        }
        return nColIdx;
    }

    @Override
    public void createPanelElements() {
        String[] newNodeList;
        OiifwAddNodeWCDE anwcde = (OiifwAddNodeWCDE)this.m_wcde;
        this.m_pullSession = anwcde.getVarOwner().getSession();
        String[] nodeList = anwcde.getClusterNodesForHome();
        if (nodeList != null) {
            this.m_nodeList = new String[nodeList.length];
            System.arraycopy(nodeList, 0, this.m_nodeList, 0, nodeList.length);
        }
        if ((newNodeList = anwcde.getNewNodes()) != null) {
            this.m_newNodes = new String[newNodeList.length];
            System.arraycopy(newNodeList, 0, this.m_newNodes, 0, newNodeList.length);
        }
        this.m_bShowStatus = anwcde.showStatus();
        this.m_bCRS = anwcde.isCRSHome();
        this.m_bVendorCW = anwcde.isVendorClusterware();
        this.m_nNewNodesColumnCnt = this.setupNewNodesTableColumns(this.m_bShowStatus, this.m_bCRS);
        this.m_nExistingNodesColumnCnt = this.setupExistingNodesTableColumns(this.m_bShowStatus, this.m_bCRS);
        this.dlgPanel.setLayout((LayoutManager)new GridLayout(2, 1, 5, 5));
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 0, 0);
        c.fill = 1;
        c.gridwidth = 0;
        c.weightx = 0.0;
        c.weighty = 0.2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        LWContainer existingPanel = this.createExistingNodesPanel();
        this.dlgPanel.add((Component)existingPanel);
        c.weightx = 1.0;
        c.weighty = 1.0;
        LWContainer nodesPanel = null;
        nodesPanel = !this.m_bCRS ? this.createNodeSelectionPanel() : this.createNodeEntryPanel();
        this.dlgPanel.add((Component)nodesPanel);
        OiifmGraphicInterfaceManager ogim = (OiifmGraphicInterfaceManager)OiicSessionInterfaceManager.getInterfaceManager();
        ogim.getWizardDialog().setViewOnly(true);
        this.validate();
    }

    private List performUniquenessChecks(String[] saNodes, String[] saPrivateNodeNames, String[] saVirtualHostNames) {
        int i;
        ArrayList<String> oErrors = new ArrayList<String>();
        ArrayList<String[]> oasNamesToCheck = new ArrayList<String[]>();
        ArrayList oErroneousNamesLists = new ArrayList();
        boolean bErroroneousNameFound = false;
        ArrayList<String> oErroneousResIDsForDuplicates = new ArrayList<String>();
        oasNamesToCheck.add(saNodes);
        oErroneousNamesLists.add(new ArrayList());
        oErroneousResIDsForDuplicates.add("OIIFP1020");
        int nListCnt = oasNamesToCheck.size();
        HashMap<String, String> oNamesMap = new HashMap<String, String>();
        for (i = 0; i < nListCnt; ++i) {
            String[] asCurrentArray = (String[])oasNamesToCheck.get(i);
            List oErrorneousList = (List)oErroneousNamesLists.get(i);
            if (asCurrentArray == null) continue;
            for (int j = 0; j < asCurrentArray.length; ++j) {
                if (asCurrentArray[j] == null || asCurrentArray[j].equals("")) continue;
                if (!asCurrentArray[j].equals("olsnodes") && oNamesMap.containsKey(asCurrentArray[j])) {
                    oErrorneousList.add(asCurrentArray[j]);
                    bErroroneousNameFound = true;
                    continue;
                }
                oNamesMap.put(asCurrentArray[j], asCurrentArray[j]);
            }
        }
        if (bErroroneousNameFound) {
            for (i = 0; i < oErroneousNamesLists.size(); ++i) {
                List oErrorList = (List)oErroneousNamesLists.get(i);
                if (oErrorList.isEmpty()) continue;
                Object[] args = new String[]{OiixFunctionOps.implodeList(OiixVectorOps.list2StrArr(oErrorList), ",")};
                oErrors.add(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", (String)oErroneousResIDsForDuplicates.get(i), args));
            }
        }
        return oErrors;
    }

    @Override
    public boolean validateInput() {
        boolean retVal = true;
        String[] saNewNodes = null;
        String[] saPrivInterconnect = null;
        String[] saVirtualHostNames = null;
        saNewNodes = this.getNewNodes();
        saPrivInterconnect = this.getNewPrivateNodeNames();
        if (this.m_bEnableVirtualHostNames) {
            saVirtualHostNames = this.getNewVirtualHostNames();
        }
        if (saNewNodes == null || saNewNodes.length == 0) {
            OiifmAlert.displayAlert(OiixResourceBundle.getString("S_WARNING"), OiixResourceBundle.getString("S_NO_NEW_NODES_SPECIFIED"), 50, 1, 1, 20);
            retVal = false;
        } else {
            ArrayList oErrors = new ArrayList();
            if (this.m_bCRS) {
                oErrors.addAll(this.performNodeNameChecks(saNewNodes));
            }
            if (oErrors.size() > 0) {
                Object[] obj = new String[]{OiixFunctionOps.implodeList(OiixVectorOps.list2StrArr(oErrors), System.getProperty("line.separator"))};
                OiifmAlert.displayAlert(OiixResourceBundle.getString("S_ERROR"), OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-5001", obj), 50, 1, 1, 20);
                retVal = false;
            }
        }
        return retVal;
    }

    private List performNodeNameChecks(String[] saNodes) {
        ArrayList<String> oErrors = new ArrayList<String>();
        List oErroneousNames = this.performBasicNameChecks(saNodes);
        if (oErroneousNames == null || oErroneousNames.size() > 0) {
            Object[] args = new String[]{OiixFunctionOps.implodeList(OiixVectorOps.list2StrArr(oErroneousNames), ",")};
            String sErr = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-5002", args);
            oErrors.add(sErr);
        }
        return oErrors;
    }

    private List performPrivateNodeNameChecks(String[] saPrivNodes) {
        ArrayList<String> oErrors = new ArrayList<String>();
        List oErroneousNames = this.performBasicNameChecks(saPrivNodes);
        if (oErroneousNames == null || oErroneousNames.size() > 0) {
            Object[] args = new String[]{OiixFunctionOps.implodeList(OiixVectorOps.list2StrArr(oErroneousNames), ",")};
            String sErr = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-5003", args);
            oErrors.add(sErr);
        }
        return oErrors;
    }

    private List performVirtualHostNameChecks(String[] saVirtualHostNames) {
        ArrayList<String> oErrors = new ArrayList<String>();
        List oErroneousNames = this.performBasicNameChecks(saVirtualHostNames);
        if (oErroneousNames == null || oErroneousNames.size() > 0) {
            Object[] args = new String[]{OiixFunctionOps.implodeList(OiixVectorOps.list2StrArr(oErroneousNames), ",")};
            String sErr = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-5004", args);
            oErrors.add(sErr);
        }
        return oErrors;
    }

    private List performBasicNameChecks(String[] saNames) {
        ArrayList<String> oErroneousNames = new ArrayList<String>();
        for (int i = 0; i < saNames.length; ++i) {
            if (saNames[i] != null && saNames[i].trim().length() != 0) continue;
            oErroneousNames.add(saNames[i]);
        }
        return oErroneousNames;
    }

    private boolean isElementUnique(String element, int index, String[] strList) {
        boolean retval = false;
        if (element != null && strList != null && strList.length > 0 && index <= strList.length) {
            for (int i = 0; i < index; ++i) {
                if (!element.equalsIgnoreCase(strList[i])) continue;
                return false;
            }
            retval = true;
        }
        return retval;
    }

    public void setExistingClusterNodes(String[] asExistingClusterNodes) {
        this.m_nodeList = asExistingClusterNodes;
        this.updateExistingNodesDataSources(this.m_iExistingNodeNameCol, asExistingClusterNodes);
    }

    public void setExistingPrivateNodeNames(String[] asExistingPrivateNodeNames) {
        this.m_asExistingPrivateNodeNames = asExistingPrivateNodeNames;
        this.updateExistingNodesDataSources(this.m_iExistingPrivateNodeNameCol, asExistingPrivateNodeNames);
    }

    public void setExistingVirtualHostNames(String[] asExistingVirtualHostNames) {
        this.m_asExistingVirtualHostNames = asExistingVirtualHostNames;
        this.updateExistingNodesDataSources(this.m_iExistingVirtualHostNameCol, asExistingVirtualHostNames);
    }

    private void updateNewNodesDataSources(int iCol, String[] asData) {
        if (iCol != -1 && asData != null) {
            int i;
            int iRowCount = this.m_newDataSource.getRowCount();
            if (asData.length > iRowCount && this.m_bCRS) {
                this.m_newDataSource.addRows(iRowCount, asData.length - iRowCount);
            }
            if (this.m_iNewNodeNameCol == iCol) {
                this.m_oSelectedNodes.clear();
                if (this.m_iNewNodeNameSelectionCol != -1) {
                    for (i = 0; i < iRowCount; ++i) {
                        this.m_newDataSource.setData(this.m_iNewNodeNameSelectionCol, i, (Object)OiixUtilityOps.booleanValueOf(false));
                    }
                }
            }
            for (i = 0; i < asData.length; ++i) {
                this.m_newDataSource.setData(iCol, i, (Object)asData[i]);
                if (this.m_iNewNodeNameCol != iCol || this.m_iNewNodeNameSelectionCol == -1) continue;
                this.m_newDataSource.setData(this.m_iNewNodeNameSelectionCol, i, (Object)OiixUtilityOps.booleanValueOf(true));
                this.m_oSelectedNodes.put(asData[i], asData[i]);
            }
        }
        this.m_tblNodeList.setDataSources((TwoDDataSource)this.m_newDataSource, (OneDDataSource)this.m_newHeaderSource, null);
    }

    private void updateExistingNodesDataSources(int iCol, String[] asData) {
        if (iCol != -1 && asData != null) {
            int iRowCount = this.m_existingDataSource.getRowCount();
            if (asData.length > iRowCount) {
                this.m_existingDataSource.addRows(iRowCount, asData.length - iRowCount);
            }
            for (int i = 0; i < asData.length; ++i) {
                this.m_existingDataSource.setData(iCol, i, (Object)asData[i]);
            }
        }
        this.m_table.setDataSources((TwoDDataSource)this.m_existingDataSource, (OneDDataSource)this.m_existingHeaderSource, null);
    }

    public void setClusterNodes(String[] nodes) {
    }

    public void setEnableVirtualHostNameEntry(Boolean oEnableVirtualHostNameEntry) {
        this.m_bEnableVirtualHostNames = oEnableVirtualHostNameEntry;
        this.m_tblNodeList.getGrid().setColumnCellInputHandler(this.m_iNewVirtualHostNameCol, this.m_bEnableVirtualHostNames ? TextFieldInputHandler.getCellInputHandler() : NullInputHandler.getCellInputHandler());
        this.setDefaultsForNodeEntry(0);
    }

    public void setRemoteNodes(String[] asNewNodes) {
    }

    public void setNewNodes(String[] asNewNodes) {
        this.updateNewNodesDataSources(this.m_iNewNodeNameCol, asNewNodes);
        this.updateSelectionBtns();
    }

    public void setNewPrivateNodeNames(String[] asNewPrivateNodeNames) {
        this.m_asPrivateNodeNames = asNewPrivateNodeNames;
        this.updateNewNodesDataSources(this.m_iNewPrivateNodeNameCol, asNewPrivateNodeNames);
    }

    public void setNewVirtualHostNames(String[] asNewVirtualNodeNames) {
        this.m_asVirtualHostNames = asNewVirtualNodeNames;
        this.updateNewNodesDataSources(this.m_iNewVirtualHostNameCol, asNewVirtualNodeNames);
    }

    public String[] getNewNodes() {
        return this.getNewNodesImpl();
    }

    public String[] getRemoteNodes() {
        return this.getNewNodesImpl();
    }

    private String[] getNewNodesImpl() {
        List<Object> indices = new ArrayList();
        if (!this.m_bCRS) {
            for (int i = 0; i < this.m_newNodes.length; ++i) {
                if (this.m_newDataSource.getData(this.m_iNewNodeNameSelectionCol, i) == null || !this.m_newDataSource.getData(this.m_iNewNodeNameSelectionCol, i).toString().equalsIgnoreCase("true")) continue;
                indices.add(this.m_newDataSource.getData(this.m_iNewNodeNameCol, i));
            }
        } else {
            indices = this.getStringDataFromColumn(this.m_tblNodeList, (TwoDDataSource)this.m_newDataSource, this.m_iNewNodeNameCol);
        }
        return OiixVectorOps.list2StrArr(indices);
    }

    public String[] getNewVirtualHostNames() {
        List indices = new ArrayList(1);
        if (this.m_bCRS && this.m_bEnableVirtualHostNames) {
            indices = this.getStringDataFromColumn(this.m_tblNodeList, (TwoDDataSource)this.m_newDataSource, this.m_iNewVirtualHostNameCol);
        }
        return OiixVectorOps.list2StrArr(indices);
    }

    public String[] getNewPrivateNodeNames() {
        List indices = new ArrayList(1);
        if (this.m_bCRS) {
            indices = this.getStringDataFromColumn(this.m_tblNodeList, (TwoDDataSource)this.m_newDataSource, this.m_iNewPrivateNodeNameCol);
        }
        return OiixVectorOps.list2StrArr(indices);
    }

    private List getStringDataFromColumn(SpreadTable oTable, TwoDDataSource oDataSource, int iCol) {
        ArrayList<String> oData = new ArrayList<String>();
        if (iCol != -1) {
            for (int i = 0; i < oTable.getGrid().getRowCount(); ++i) {
                String dataStr = (String)oDataSource.getData(iCol, i);
                if (this.isRowEmpty(oDataSource, i)) continue;
                dataStr = dataStr == null ? "" : dataStr.trim();
                oData.add(dataStr);
            }
        }
        return oData;
    }

    private boolean isRowEmpty(TwoDDataSource oDataSource, int row) {
        boolean bEmptyRow = true;
        if (oDataSource != null && oDataSource.getRowCount() > row) {
            int[] aiColsToCheck = new int[]{this.m_iNewNodeNameCol, this.m_iNewPrivateNodeNameCol, this.m_iNewVirtualHostNameCol};
            String[] asColsDefaults = new String[]{this.S_DEFAULT_NODENAME_STR, this.S_DEFAULT_PRIVATE_NODENAME_STR, this.S_DEFAULT_VIRTUAL_HOSTNAME_STR};
            for (int i = 0; i < aiColsToCheck.length && bEmptyRow; ++i) {
                if (aiColsToCheck[i] == -1) continue;
                String dataStr = (String)oDataSource.getData(aiColsToCheck[i], row);
                bEmptyRow = dataStr == null || dataStr.trim().length() == 0 || dataStr.trim().length() > 0 && dataStr.equals(asColsDefaults[i]);
            }
        }
        return bEmptyRow;
    }

    private LWContainer createExistingNodesPanel() {
        this.createExistingDataSources();
        this.m_table = new SpreadTable((TwoDDataSource)this.m_existingDataSource, (OneDDataSource)this.m_existingHeaderSource, null);
        int[] aiExistingNodesTableCols = new int[]{this.m_iExistingNodeNameCol, this.m_iExistingPrivateNodeNameCol, this.m_iExistingVirtualHostNameCol, this.m_iExistingNodeStatusCol};
        int[] aiExistingNodesTableColWidths = new int[]{this.m_iExistingNodeNameColWidth, this.m_iExistingPrivateNodeNameColWidth, this.m_iExistingVirtualHostNameColWidth, this.m_iExistingNodeStatusColWidth};
        this.setupTableColumnWidths(this.m_table, aiExistingNodesTableCols, aiExistingNodesTableColWidths);
        return this.createNodePanel(OiixResourceBundle.getString("S_EXISTING_NODES"), OiixResourceBundle.getString("S_EXISTING_NODES_DESC"), this.m_table, false);
    }

    private void setupTableColumnWidths(SpreadTable oTable, int[] aiCols, int[] aiColWidths) {
        if (oTable != null) {
            int iMaxColCount = oTable.getGrid().getColumnCount();
            for (int i = 0; i < aiCols.length; ++i) {
                if (aiCols[i] == -1 || aiCols[i] >= iMaxColCount) continue;
                OiiolTextLogger.appendText("Setting col:" + aiCols[i] + ":" + aiColWidths[i]);
                oTable.setColumnWidth(aiCols[i], aiColWidths[i]);
                OiiolTextLogger.appendText("Set col:" + aiCols[i] + ":" + oTable.getColumnWidth(aiCols[i]));
            }
        }
    }

    private LWContainer createNodeEntryPanel() {
        this.createNodeEntryDataSources();
        this.m_tblNodeList = new SpreadTable((TwoDDataSource)this.m_newDataSource, (OneDDataSource)this.m_newHeaderSource, null);
        int[] aiNewNodeCols = new int[]{this.m_iNewNodeNameCol, this.m_iNewPrivateNodeNameCol, this.m_iNewVirtualHostNameCol, this.m_iNewNodeStatusCol};
        int[] aiNewNodeColWidths = new int[]{this.m_iNewNodeNameColWidth, this.m_iNewPrivateNodeNameColWidth, this.m_iNewVirtualHostNameColWidth, this.m_iNewNodeStatusColWidth};
        this.setupTableColumnWidths(this.m_tblNodeList, aiNewNodeCols, aiNewNodeColWidths);
        this.setDefaultsForNodeEntry(0);
        return this.createNodePanel(OiixResourceBundle.getString("S_SPECIFY_NEW_NODES"), OiixResourceBundle.getString("S_ENTER_NODES_DESC"), this.m_tblNodeList, true);
    }

    private LWContainer createNodePanel(String sHdrLbl, String sDescLbl, SpreadTable oTable, boolean bEnabled) {
        LWContainer panel = new LWContainer();
        String prompt = sHdrLbl;
        LWLabel lblEnterNodesHeader = new LWLabel(prompt);
        Font boldFont = new Font(OiixResourceBundle.getFont(), OiixLanguage.getFontStyle(1), 14);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, 0, 0, 0);
        c.fill = 1;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        lblEnterNodesHeader.setFont(boldFont);
        panel.setLayout((LayoutManager)gridbag);
        gridbag.setConstraints((Component)lblEnterNodesHeader, c);
        panel.add((Component)lblEnterNodesHeader);
        prompt = sDescLbl;
        MultiLineLabel lblEnterNodes = new MultiLineLabel(WordWrapper.getTextWrapper(), prompt);
        Font smallfont = new Font(OiixResourceBundle.getFont(), OiixLanguage.getFontStyle(0), 12);
        c.weightx = 1.0;
        c.weighty = 1.0;
        lblEnterNodes.setFont(smallfont);
        lblEnterNodes.setPreferredAspectRatio(0.0f);
        gridbag.setConstraints((Component)lblEnterNodes, c);
        panel.add((Component)lblEnterNodes);
        Grid grid = oTable.getGrid();
        if (bEnabled) {
            grid.setGridKeyNavigator(StandardNavigator.getTabKeyNavigator());
            grid.setDefaultPainter((Painter)new TextPainter());
            oTable.addEditListener((TableEditListener)this);
            grid.requestFocus(0, 0, (AWTEvent)new ComponentEvent((Component)grid, 102));
            grid.setColumnCellInputHandler(this.m_iNewNodeNameCol, TextFieldInputHandler.getCellInputHandler());
            grid.setColumnCellInputHandler(this.m_iNewPrivateNodeNameCol, TextFieldInputHandler.getCellInputHandler());
            grid.setColumnCellInputHandler(this.m_iNewVirtualHostNameCol, this.m_bEnableVirtualHostNames ? TextFieldInputHandler.getCellInputHandler() : NullInputHandler.getCellInputHandler());
            SingleRowSelection rowSelObj = new SingleRowSelection();
            rowSelObj.setParent(grid);
            rowSelObj.setCellSelected(0, 0, true);
        }
        if (this.m_iNewNodeStatusCol != -1) {
            grid.setColumnPainter(this.m_iNewNodeStatusCol, (Painter)new OiifpNodeStatusPainter());
        }
        grid.setEnabled(bEnabled);
        grid.setVerticalSeparatorsVisible(true);
        grid.setHorizontalSeparatorsVisible(true);
        grid.setPreferredRowsOnScreen(4);
        grid.setToolTipValue(GridToolTipClient.getToolTipClient());
        TableScrollBox tableScroll = new TableScrollBox((Component)oTable, 0, 0);
        Header header = oTable.getColumnHeader();
        header.setHeaderSelection(NullItemSelection.getHeaderSelection());
        header.setCanResizeItems(true);
        c.weightx = 1.0;
        c.weighty = 1.0;
        gridbag.setConstraints((Component)tableScroll, c);
        panel.add((Component)tableScroll);
        return panel;
    }

    private LWContainer createNodeSelectionPanel() {
        LWContainer panel = new LWContainer((LayoutManager)new BorderLayout());
        Font boldFont = new Font(OiixResourceBundle.getFont(), 1, 14);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, 0, 0, 0);
        c.fill = 1;
        c.gridwidth = 0;
        c.weightx = 0.0;
        c.weighty = 0.5;
        String prompt = OiixResourceBundle.getString("S_SPECIFY_NEW_NODES");
        MultiLineLabel lblNewNodeTableTitle = new MultiLineLabel(WordWrapper.getTextWrapper(), prompt);
        lblNewNodeTableTitle.setFont(boldFont);
        lblNewNodeTableTitle.setPreferredAspectRatio(0.0f);
        gridbag.setConstraints((Component)lblNewNodeTableTitle, c);
        panel.add((Component)lblNewNodeTableTitle, (Object)"North");
        prompt = OiixResourceBundle.getString("S_NEW_NODES_DESC");
        Font smallfont = new Font(OiixResourceBundle.getFont(), 0, 12);
        MultiLineLabel lblNewNodeTable = new MultiLineLabel(WordWrapper.getTextWrapper(), prompt);
        lblNewNodeTable.setFont(smallfont);
        lblNewNodeTable.setPreferredAspectRatio(0.0f);
        c.weightx = 1.0;
        c.weighty = 0.3;
        gridbag.setConstraints((Component)lblNewNodeTable, c);
        panel.add((Component)lblNewNodeTable, (Object)"Center");
        this.createNodeSelectionDataSources();
        this.m_tblNodeList = OiifmSpreadTable.createSpreadTable((TwoDDataSource)this.m_newDataSource, (OneDDataSource)this.m_newHeaderSource, null, 2);
        Grid grid = this.m_tblNodeList.getGrid();
        grid.addEditListener((GridEditListener)this);
        TableScrollBox tableScroll = new TableScrollBox((Component)this.m_tblNodeList, 0, 0);
        Header header = this.m_tblNodeList.getColumnHeader();
        header.setHeaderSelection(NullItemSelection.getHeaderSelection());
        header.setCanResizeItems(false);
        int[] aiNewNodeCols = new int[]{this.m_iNewNodeNameSelectionCol, this.m_iNewNodeNameCol, this.m_iNewNodeStatusCol};
        int[] aiNewNodeColWidths = new int[]{this.m_iNewNodeNameSelectionColWidth, this.m_iNewNodeNameColWidth, this.m_iNewNodeStatusColWidth};
        this.setupTableColumnWidths(this.m_tblNodeList, aiNewNodeCols, aiNewNodeColWidths);
        this.m_btnSelectAll = new LWButton(OiixResourceBundle.getString("S_SELECT_ALL"));
        this.m_btnSelectAll.setRightmost(true);
        this.m_btnSelectAll.setLeftmost(true);
        this.m_btnSelectAll.addActionListener((ActionListener)this);
        this.m_btnDeselectAll = new LWButton(OiixResourceBundle.getString("S_DESELECT_ALL"));
        this.m_btnDeselectAll.setLeftmost(true);
        this.m_btnDeselectAll.setRightmost(true);
        this.m_btnDeselectAll.addActionListener((ActionListener)this);
        ButtonBar bBar = new ButtonBar();
        bBar.add((Component)this.m_btnSelectAll);
        bBar.add((Component)this.m_btnDeselectAll);
        LWContainer tmpPanel = new LWContainer((LayoutManager)new OiifbStackLayout(1));
        tmpPanel.add("Top Left Wide Tall", (Component)tableScroll);
        tmpPanel.add("Top Right", (Component)bBar);
        c.insets = new Insets(0, 0, 0, 0);
        c.weightx = 1.0;
        c.weighty = 1.0;
        gridbag.setConstraints((Component)tmpPanel, c);
        panel.add((Component)tmpPanel, (Object)"South");
        panel.setLayout((LayoutManager)gridbag);
        this.updateSelectionBtns();
        return panel;
    }

    private void createExistingNodeHeader() {
        Object[] headerItems = new String[this.m_nExistingNodesColumnCnt];
        if (this.m_iExistingNodeNameCol != -1) {
            headerItems[this.m_iExistingNodeNameCol] = OiixResourceBundle.getString("S_EXISTING_NODE_NAMES");
        }
        if (this.m_iExistingPrivateNodeNameCol != -1) {
            headerItems[this.m_iExistingPrivateNodeNameCol] = OiixResourceBundle.getString("S_PRIV_INTERCONNECT_NAMES");
        }
        if (this.m_iExistingVirtualHostNameCol != -1) {
            headerItems[this.m_iExistingVirtualHostNameCol] = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFP1013");
        }
        if (this.m_iExistingNodeStatusCol != -1) {
            headerItems[this.m_iExistingNodeStatusCol] = OiixResourceBundle.getString("S_STATUS");
        }
        this.m_existingHeaderSource = new ArrayOneDDataSource(headerItems);
    }

    private void createExistingDataSources() {
        this.createExistingNodeHeader();
        this.m_existingDataSource = new ArrayTwoDDataSource(this.m_nExistingNodesColumnCnt, this.m_nodeList.length);
        OiicClusterInstallInfo clusterInfo = OiicClusterInstallInfo.getClusterInstallInfo();
        for (int i = 0; i < this.m_nodeList.length; ++i) {
            this.m_existingDataSource.setData(this.m_iExistingNodeNameCol, i, (Object)this.m_nodeList[i]);
            if (!this.m_bShowStatus) continue;
            this.m_existingDataSource.setData(this.m_iExistingNodeStatusCol, i, (Object)this.getNodeStatus(this.m_nodeList[i]));
        }
    }

    private void createNodeEntryDataSources() {
        block13: {
            OiipgDetectCluster oDetectCluster;
            block12: {
                this.createNewNodeHeader();
                this.m_newDataSource = new ArrayTwoDDataSource(this.m_nNewNodesColumnCnt, INIT_NODES);
                OiicClusterInstallInfo clusterInfo = OiicClusterInstallInfo.getClusterInstallInfo();
                Vector clusterNodes = clusterInfo.getClusterNodes();
                oDetectCluster = OiipgDetectCluster.getDetectCluster();
                if (clusterNodes == null) break block12;
                int j = 0;
                for (int i = 0; i < clusterNodes.size(); ++i) {
                    String sNodeName;
                    OiicClusterNode cNode;
                    if (j == INIT_NODES) {
                        this.m_newDataSource.addRows(INIT_NODES, 1);
                        ++INIT_NODES;
                    }
                    if (null == (cNode = (OiicClusterNode)clusterNodes.elementAt(i)) || !this.isElementUnique(sNodeName = cNode.getName(), this.m_nodeList.length, this.m_nodeList)) continue;
                    this.m_newDataSource.setData(this.m_iNewNodeNameCol, j, (Object)sNodeName);
                    if (this.m_iNewPrivateNodeNameCol != -1) {
                        String sPrivNodeName = oDetectCluster.getPrivateNodeName(sNodeName);
                        if (sPrivNodeName == null) {
                            sPrivNodeName = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFP1011");
                        }
                        this.m_newDataSource.setData(this.m_iNewPrivateNodeNameCol, j, (Object)sPrivNodeName);
                    }
                    if (this.m_iNewVirtualHostNameCol != -1) {
                        String sVirtualHostName = oDetectCluster.getVirtualHostName(sNodeName);
                        if (sVirtualHostName == null) {
                            sVirtualHostName = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFP1012");
                        }
                        this.m_newDataSource.setData(this.m_iNewVirtualHostNameCol, j, (Object)sVirtualHostName);
                    }
                    String availStatusStr = OiixResourceBundle.getString("S_NODE_AVAILABLE");
                    if (this.m_bShowStatus) {
                        this.m_newDataSource.setData(this.m_iNewNodeStatusCol, j, (Object)this.getNodeStatus(sNodeName));
                    }
                    ++j;
                }
                break block13;
            }
            if (!this.m_bVendorCW) break block13;
            for (int i = 0; i < this.m_newNodes.length; ++i) {
                if (i == INIT_NODES) {
                    this.m_newDataSource.addRows(INIT_NODES, 1);
                    ++INIT_NODES;
                }
                this.m_newDataSource.setData(this.m_iNewNodeNameCol, i, (Object)this.m_newNodes[i]);
                if (this.m_iNewPrivateNodeNameCol != -1) {
                    String sPrivNodeName = oDetectCluster.getPrivateNodeName(this.m_newNodes[i]);
                    if (sPrivNodeName == null) {
                        sPrivNodeName = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFP1011");
                    }
                    this.m_newDataSource.setData(this.m_iNewPrivateNodeNameCol, i, (Object)sPrivNodeName);
                }
                if (this.m_iNewVirtualHostNameCol == -1) continue;
                String sVirtualHostName = oDetectCluster.getVirtualHostName(this.m_newNodes[i]);
                if (sVirtualHostName == null) {
                    sVirtualHostName = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFP1012");
                }
                this.m_newDataSource.setData(this.m_iNewVirtualHostNameCol, i, (Object)sVirtualHostName);
            }
        }
    }

    private void createNewNodeHeader() {
        Object[] headerItems = new String[this.m_nNewNodesColumnCnt];
        if (this.m_iNewNodeNameSelectionCol != -1) {
            headerItems[this.m_iNewNodeNameSelectionCol] = null;
        }
        if (this.m_iNewNodeNameCol != -1) {
            headerItems[this.m_iNewNodeNameCol] = OiixResourceBundle.getString("S_PUBLIC_NAMES");
        }
        if (this.m_iNewPrivateNodeNameCol != -1) {
            headerItems[this.m_iNewPrivateNodeNameCol] = OiixResourceBundle.getString("S_PRIV_INTERCONNECT_NAMES");
        }
        if (this.m_iNewVirtualHostNameCol != -1) {
            headerItems[this.m_iNewVirtualHostNameCol] = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFP1013");
        }
        if (this.m_iNewNodeStatusCol != -1) {
            headerItems[this.m_iNewNodeStatusCol] = OiixResourceBundle.getString("S_STATUS");
        }
        this.m_newHeaderSource = new ArrayOneDDataSource(headerItems);
    }

    private void createNodeSelectionDataSources() {
        this.createNewNodeHeader();
        this.m_newDataSource = new ArrayTwoDDataSource(this.m_nNewNodesColumnCnt, this.m_newNodes.length);
        OiicClusterInstallInfo clusterInfo = OiicClusterInstallInfo.getClusterInstallInfo();
        for (int i = 0; i < this.m_newNodes.length; ++i) {
            List availStatus;
            this.m_newDataSource.setData(this.m_iNewNodeNameCol, i, (Object)this.m_newNodes[i]);
            String availStatusStr = OiixResourceBundle.getString("S_NODE_AVAILABLE");
            OiicClusterNode cNode = clusterInfo.getClusterNode(this.m_newNodes[i]);
            if (null == cNode || !cNode.getName().equalsIgnoreCase(this.m_newNodes[i])) continue;
            this.m_newDataSource.setData(this.m_iNewNodeNameSelectionCol, i, (Object)OiixUtilityOps.booleanValueOf(true));
            this.m_oSelectedNodes.put(this.m_newNodes[i], this.m_newNodes[i]);
            if (!this.m_bShowStatus || null == (availStatus = cNode.getAvailabilityErrorList()) || 0 >= availStatus.size()) continue;
            String[] availStatusArr = OiixVectorOps.list2StrArr(availStatus);
            availStatusStr = OiixFunctionOps.implodeList(availStatusArr, ",");
            this.m_newDataSource.setData(this.m_iNewNodeStatusCol, i, (Object)availStatusStr);
        }
    }

    private String getNodeStatus(String sNode) {
        OiicClusterInstallInfo clusterInfo = OiicClusterInstallInfo.getClusterInstallInfo();
        OiicClusterNode oNode = clusterInfo.getClusterNode(sNode);
        String availStatusStr = "";
        if (oNode != null) {
            List availStatus = oNode.getAvailabilityErrorList();
            if (availStatusStr.length() > 0) {
                availStatusStr = availStatusStr + ", ";
            }
            if (null != availStatus && 0 < availStatus.size()) {
                String[] availStatusArr = OiixVectorOps.list2StrArr(availStatus);
                availStatusStr = availStatusStr + OiixFunctionOps.implodeList(availStatusArr, ",");
            } else {
                availStatusStr = availStatusStr + oNode.getAvailabilityStatusStr();
            }
        }
        return availStatusStr;
    }

    private void updateSelectionBtns() {
        if (this.m_btnSelectAll != null) {
            this.m_btnSelectAll.setEnabled(this.m_newNodes.length > this.m_oSelectedNodes.size());
        }
        if (this.m_btnDeselectAll != null) {
            this.m_btnDeselectAll.setEnabled(this.m_oSelectedNodes.size() > 0);
        }
    }

    private void setDefaultsForNodeEntry(int row) {
        if (this.m_iNewNodeNameCol != -1 && this.m_newDataSource.getData(this.m_iNewNodeNameCol, row) == null) {
            this.m_newDataSource.setData(this.m_iNewNodeNameCol, row, (Object)this.S_DEFAULT_NODENAME_STR);
        }
        if (this.m_iNewPrivateNodeNameCol != -1 && this.m_newDataSource.getData(this.m_iNewPrivateNodeNameCol, row) == null) {
            this.m_newDataSource.setData(this.m_iNewPrivateNodeNameCol, row, (Object)this.S_DEFAULT_PRIVATE_NODENAME_STR);
        }
        if (this.m_iNewVirtualHostNameCol != -1 && this.m_newDataSource.getData(this.m_iNewVirtualHostNameCol, row) == null && this.m_bEnableVirtualHostNames) {
            this.m_newDataSource.setData(this.m_iNewVirtualHostNameCol, row, (Object)this.S_DEFAULT_VIRTUAL_HOSTNAME_STR);
        }
    }

    public void cellEditing(TableEvent e) {
        int row_count = this.m_tblNodeList.getGrid().getRowCount();
        int row = e.getRow();
        this.setDefaultsForNodeEntry(row);
    }

    public void cellEdited(TableEvent e) {
        int row_count = this.m_tblNodeList.getGrid().getRowCount();
        int row = e.getRow();
        int column = e.getColumn();
        if (column == this.m_iNewNodeNameCol) {
            String sNodeName;
            String sData = (String)this.m_newDataSource.getData(this.m_iNewPrivateNodeNameCol, row);
            if ((sData == null || sData.equals(this.S_DEFAULT_PRIVATE_NODENAME_STR)) && (sNodeName = (String)this.m_newDataSource.getData(this.m_iNewNodeNameCol, row)).trim().length() > 0 && !sNodeName.equals(this.S_DEFAULT_NODENAME_STR)) {
                sData = sNodeName.concat("-priv");
                this.m_newDataSource.setData(this.m_iNewPrivateNodeNameCol, row, (Object)sData);
            }
            sData = (String)this.m_newDataSource.getData(this.m_iNewVirtualHostNameCol, row);
            if (this.m_bEnableVirtualHostNames && (sData == null || sData.equals(this.S_DEFAULT_VIRTUAL_HOSTNAME_STR)) && (sNodeName = (String)this.m_newDataSource.getData(this.m_iNewNodeNameCol, row)).trim().length() > 0 && !sNodeName.equals(this.S_DEFAULT_NODENAME_STR)) {
                sData = sNodeName.concat("-vip");
                this.m_newDataSource.setData(this.m_iNewVirtualHostNameCol, row, (Object)sData);
            }
        }
        if (row == row_count - 1) {
            this.m_newDataSource.addRows(row_count, 1);
            ++INIT_NODES;
        }
    }

    public void cellEditing(GridEvent e) {
    }

    public void cellEdited(GridEvent e) {
        Grid grid = this.m_tblNodeList.getGrid();
        if (this.m_iNewNodeNameSelectionCol != -1) {
            int row = grid.getFocusCell().row;
            boolean bSelected = (Boolean)this.m_newDataSource.getData(this.m_iNewNodeNameSelectionCol, row);
            if (bSelected) {
                this.m_oSelectedNodes.put(this.m_newNodes[row], this.m_newNodes[row]);
            } else {
                this.m_oSelectedNodes.remove(this.m_newNodes[row]);
            }
            this.updateSelectionBtns();
        }
    }

    @Override
    public boolean isCellEnabled(int col, int row) {
        return true;
    }

    @Override
    public boolean isErrorCell(int col, int row) {
        return col == this.m_iNewNodeStatusCol || col == this.m_iExistingNodeStatusCol;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        int rowCount = this.m_newDataSource.getRowCount();
        OiifmSelNodeGrid grid = (OiifmSelNodeGrid)this.m_tblNodeList.getGrid();
        for (int i = 0; i < rowCount; ++i) {
            String v_strNodeName = (String)this.m_newDataSource.getData(this.m_iNewNodeNameCol, i);
            if (source == this.m_btnSelectAll) {
                this.m_newDataSource.setData(this.m_iNewNodeNameSelectionCol, i, (Object)OiixUtilityOps.booleanValueOf(true));
                this.m_oSelectedNodes.put(v_strNodeName, v_strNodeName);
                continue;
            }
            if (source != this.m_btnDeselectAll) continue;
            this.m_newDataSource.setData(this.m_iNewNodeNameSelectionCol, i, (Object)OiixUtilityOps.booleanValueOf(false));
            this.m_oSelectedNodes.remove(v_strNodeName);
        }
        this.updateSelectionBtns();
    }
}

