/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifp;

import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import oracle.sysman.oii.oiic.OiicInstallSession;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiif.oiifj.OiifjAlertHandler;
import oracle.sysman.oii.oiif.oiifp.MultiLineLabelUI;
import oracle.sysman.oii.oiix.OiixOCMValidation;
import oracle.sysman.oii.oiix.OiixOraparam;
import oracle.sysman.oii.oiix.OiixResourceBundle;

class JHyperlinkLabel
extends JLabel
implements MouseMotionListener {
    public JHyperlinkLabel(String text) {
        super("<html>" + text + "</html>");
        this.addMouseMotionListener(this);
        this.setUI(new MultiLineLabelUI());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                try {
                    String sFileName = OiixOraparam.getOraparamProfileString("SUPPORT_POLICY_LOCATION", "http://www.oracle.com/support/policies.html");
                    OiixOCMValidation ocmValidation = new OiixOCMValidation();
                    ocmValidation.openURL(sFileName);
                }
                catch (Exception ex) {
                    OiicSessionInterfaceManager m_osim = OiicSessionInterfaceManager.getInterfaceManager();
                    OiicInstallSession instSession = (OiicInstallSession)m_osim.getSession();
                    int n = new OiifjAlertHandler((Frame)((Object)instSession.getMainFrame())).displayAlert(OiixResourceBundle.getString("S_OCM_BROWSER_ERROR_TITLE"), OiixResourceBundle.getString("S_OCM_POLICY_LAUNCH_ERROR", new Object[]{OiixResourceBundle.getString("S_OCM_POLICY_LOCATION")}), 50, 1, 1, 1);
                }
            }
        });
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    private Rectangle getTextRectangle() {
        Icon icon;
        String text = "View Details";
        Icon icon2 = icon = this.isEnabled() ? this.getIcon() : this.getDisabledIcon();
        if (icon == null && text == null) {
            return null;
        }
        Rectangle paintIconR = new Rectangle();
        Rectangle paintTextR = new Rectangle();
        Rectangle paintViewR = new Rectangle();
        Insets paintViewInsets = new Insets(0, 0, 0, 0);
        paintViewInsets = this.getInsets(paintViewInsets);
        paintViewR.x = paintViewInsets.left;
        paintViewR.y = paintViewInsets.top;
        paintViewR.width = this.getWidth() - (paintViewInsets.left + paintViewInsets.right);
        paintViewR.height = this.getHeight() - (paintViewInsets.top + paintViewInsets.bottom);
        Graphics g = this.getGraphics();
        if (g == null) {
            return null;
        }
        String clippedText = SwingUtilities.layoutCompoundLabel(this, g.getFontMetrics(), text, icon, this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getVerticalTextPosition(), this.getHorizontalTextPosition(), paintViewR, paintIconR, paintTextR, this.getIconTextGap());
        return paintTextR;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.getTextRectangle().contains(e.getPoint())) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }
}

