/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifo;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.TextWrapper;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.util.WindowUtils;
import oracle.sysman.oii.oiif.oiifj.OiifjAlertHandler;
import oracle.sysman.oii.oiif.oiifm.OiifmMnemonicOps;
import oracle.sysman.oii.oiif.oiifo.AccessFocusLabel;
import oracle.sysman.oii.oiif.oiifo.OiifoIOCMAlert;
import oracle.sysman.oii.oiif.oiifo.OiifoIOCMProgressListener;
import oracle.sysman.oii.oiif.oiifo.OiifoIOCMProxy;
import oracle.sysman.oii.oiif.oiifo.OiifoIOCMUI;
import oracle.sysman.oii.oiif.oiifo.OiifoOCMProxy;
import oracle.sysman.oii.oiix.OiixOCMException;
import oracle.sysman.oii.oiix.OiixOCMNetworkException;
import oracle.sysman.oii.oiix.OiixOCMValidation;
import oracle.sysman.oii.oiix.OiixOraparam;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifoOCMUI
implements OiifoIOCMUI,
ActionListener,
ItemListener,
OiifoIOCMAlert,
KeyListener,
MouseMotionListener {
    private String fontname = OiixResourceBundle.getFont();
    private Font font = new Font(this.fontname, 0, 14);
    private boolean bProxyDialogShown = false;
    private boolean bProxyConnAvbl = false;
    private boolean cancelProxy = false;
    private JCheckBox cb_useMetalinkPwd = null;
    private boolean isNoConnection = false;
    private JTextField tf_email = null;
    private JTextField tf_metapwd = null;
    private GridBagLayout gridBag;
    private GridBagConstraints gbc;
    private OiixOCMValidation ocmValidation = new OiixOCMValidation();
    private boolean isEmailEdited = false;
    private Boolean b_clicked = new Boolean(false);
    private boolean yesSelected = true;
    private boolean noSelected = false;
    private String sEmail = "";
    private String sMetaPwd = "";
    private int nAttempts = 3;
    private OiifoIOCMAlert alertHandler;
    private OiifoIOCMProgressListener listener;
    private JPanel ocmUIPanel;
    private AccessFocusLabel cs_desc;
    private HashMap ocmVarMap;
    private boolean isUIMode = false;
    private boolean declineSecurityUpdates = false;
    private String sErrorTitle = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ERROR");
    private OiifoIOCMProxy oProxy = null;
    private boolean bSilentMode = false;
    private int EMAIL_FIELD = 2;
    private int PWD_FIELD = 7;
    private int CHECK_FIELD = 6;
    private int PWD_LBL_FIELD;
    private JPanel lblContainer;

    public OiifoOCMUI() {
    }

    public OiifoOCMUI(OiixOCMValidation oOCMValidation) {
        this.ocmValidation = oOCMValidation;
    }

    public static void main(String[] args) {
        System.setProperty("ORACLE_HOME", "/scratch/orabase");
        final OiifoOCMUI oiifoOCMUI = new OiifoOCMUI();
        JFrame testFrame = new JFrame();
        testFrame.setSize(450, 250);
        testFrame.setLayout(new FlowLayout());
        testFrame.setDefaultCloseOperation(3);
        testFrame.add(oiifoOCMUI.getUIComponent());
        JButton btn = new JButton("validate");
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean bRet = oiifoOCMUI.validateInputs(oiifoOCMUI.getOCMUIVarMap(), false);
                HashMap updatedMap = oiifoOCMUI.getOCMUIVarMap();
                if (!updatedMap.isEmpty()) {
                    for (String key : updatedMap.keySet()) {
                        System.out.println("KEY =  " + key + " VALUE = " + updatedMap.get(key));
                    }
                }
            }
        });
        testFrame.add(btn);
        testFrame.show();
    }

    @Override
    public JPanel getUIComponent() {
        this.createUI();
        this.isUIMode = true;
        return this.ocmUIPanel;
    }

    @Override
    public void setMetalinkUsername(String sName) {
        if (this.isUIMode) {
            ((JTextField)this.ocmUIPanel.getComponent(this.EMAIL_FIELD)).setText(sName);
        }
    }

    @Override
    public void setMetalinkPassword(String sPwd) {
        if (this.isUIMode) {
            ((JTextField)this.ocmUIPanel.getComponent(this.PWD_FIELD)).setText(sPwd);
        }
    }

    @Override
    public String getMetalinkUsername() {
        if (this.isUIMode) {
            return ((JTextField)this.ocmUIPanel.getComponent(this.EMAIL_FIELD)).getText();
        }
        if (null != this.ocmVarMap && !this.ocmVarMap.isEmpty()) {
            return (String)this.ocmVarMap.get("MYORACLESUPPORT_USERNAME");
        }
        return null;
    }

    @Override
    public String getMetalinkPassword() {
        if (this.isUIMode) {
            return ((JTextField)this.ocmUIPanel.getComponent(this.PWD_FIELD)).getText();
        }
        if (null != this.ocmVarMap && !this.ocmVarMap.isEmpty()) {
            return (String)this.ocmVarMap.get("MYORACLESUPPORT_PASSWORD");
        }
        return null;
    }

    @Override
    public JTextField getMetalinkPasswordReference() {
        if (this.isUIMode) {
            return (JTextField)this.ocmUIPanel.getComponent(this.PWD_FIELD);
        }
        return null;
    }

    @Override
    public JTextField getMetalinkUsernameReference() {
        if (this.isUIMode) {
            return (JTextField)this.ocmUIPanel.getComponent(this.EMAIL_FIELD);
        }
        return null;
    }

    @Override
    public void setSecurityUpdatesViaMetalink(boolean bSecUpdates) {
        if (this.isUIMode) {
            ((JCheckBox)this.ocmUIPanel.getComponent(this.CHECK_FIELD)).setSelected(bSecUpdates);
        }
    }

    @Override
    public boolean isSecurityUpdatesViaMetalink() {
        if (this.isUIMode) {
            return ((JCheckBox)this.ocmUIPanel.getComponent(this.CHECK_FIELD)).isSelected();
        }
        if (null != this.ocmVarMap && !this.ocmVarMap.isEmpty() && null != this.ocmVarMap.get("SECURITY_UPDATES_VIA_MYORACLESUPPORT")) {
            return (Boolean)this.ocmVarMap.get("SECURITY_UPDATES_VIA_MYORACLESUPPORT");
        }
        return false;
    }

    @Override
    public HashMap getOCMUIVarMap() {
        this.copyUIValuesToMap();
        return this.ocmVarMap;
    }

    @Override
    public void setOCMUIVarMap(HashMap varMap) {
        this.ocmVarMap = varMap;
        this.copyMapValuesToUI();
    }

    private boolean validateEmail() {
        boolean result = false;
        this.setDeclineSecurityUpdates(false);
        if (this.getMetalinkUsername() == null || this.getMetalinkUsername().trim().length() == 0) {
            int selectedButton;
            String sMsg = OiixResourceBundle.getString("S_OCM_EMAIL_NOT_PROVIDED_FOR_SEC_ISSUES") + "\n\n" + OiixResourceBundle.getString("S_OCM_SEC_UPDATES_QUESTION");
            if (!this.isUIMode && null != this.ocmVarMap && !this.ocmVarMap.isEmpty()) {
                if (null != this.ocmVarMap.get("DECLINE_SECURITY_UPDATES")) {
                    this.setDeclineSecurityUpdates((Boolean)this.ocmVarMap.get("DECLINE_SECURITY_UPDATES"));
                }
                if (this.isDeclineSecurityUpdates()) {
                    this.setSecurityUpdatesViaMetalink(false);
                    this.setMetalinkPassword("");
                    this.setMetalinkUsername("");
                    result = true;
                    return result;
                }
                sMsg = OiixResourceBundle.getString("S_OCM_EMAIL_NOT_SPECIFIED");
            }
            if ((selectedButton = this.getAlertHandler().showAlert(OiixResourceBundle.getString("S_OCM_EMAIL_NOT_SPECIFIED"), sMsg, 50, 3, 1, 10)) == 1) {
                this.setDeclineSecurityUpdates(true);
                this.setSecurityUpdatesViaMetalink(false);
                this.setMetalinkPassword("");
                result = true;
            }
        } else {
            try {
                result = this.ocmValidation.isEmailValid(this.getMetalinkUsername().trim());
            }
            catch (OiixOCMException e) {
                this.getAlertHandler().showAlert(this.sErrorTitle, e.getMessage(), 50, 1, 1, 20);
            }
        }
        return result;
    }

    private void showProxyDialog() {
        this.oProxy.setProxyVarMap(this.getOCMUIVarMap());
        this.oProxy.setAlertHandler(this.getAlertHandler());
        this.bProxyDialogShown = true;
        if (!this.bSilentMode) {
            this.oProxy.doModal();
            this.cancelProxy = this.oProxy.isProxyCancelled();
        } else {
            this.isNoConnection = this.oProxy.declineSecurityUpdatesInProxy();
            this.noSelected = this.oProxy.declineSecurityUpdatesInProxy();
            boolean validate = false;
            if (!this.isNoConnection) {
                if (this.oProxy.getRepeaterURL() != null && this.oProxy.getRepeaterURL().trim().length() != 0) {
                    validate = this.oProxy.getProxyServer() != null && this.oProxy.getProxyServer().trim().length() != 0 ? this.oProxy.validateRepeater() : this.oProxy.validateRepeaterWithProxy();
                } else if (this.oProxy.getProxyServer() != null && this.oProxy.getProxyServer().trim().length() != 0) {
                    validate = this.oProxy.validateProxy();
                } else {
                    Map rptrVarMap = this.ocmValidation.setRepeaterFromAgentHome();
                    if (null == rptrVarMap) {
                        validate = false;
                    } else {
                        this.oProxy.setProxyVarMap((HashMap)rptrVarMap);
                        validate = true;
                    }
                }
            }
            if (!validate) {
                HashMap<String, Boolean> proxyMap = new HashMap<String, Boolean>();
                proxyMap.put("COLLECTOR_SUPPORTHUB_URL", null);
                proxyMap.put("PROXY_HOST", null);
                proxyMap.put("PROXY_PORT", null);
                proxyMap.put("PROXY_USER", null);
                proxyMap.put("PROXY_PWD", null);
                proxyMap.put("DECLINE_SECURITY_UPDATES", new Boolean(this.oProxy.declineSecurityUpdatesInProxy()));
                this.oProxy.setProxyVarMap(proxyMap);
            }
        }
        this.isNoConnection = this.oProxy.declineSecurityUpdatesInProxy();
        this.noSelected = this.oProxy.declineSecurityUpdatesInProxy();
        this.ocmVarMap.putAll(this.oProxy.getProxyVarMap());
    }

    public OiifoIOCMProgressListener getListener() {
        return this.listener;
    }

    @Override
    public void setProgressListener(OiifoIOCMProgressListener listener) {
        this.listener = listener;
    }

    private boolean validateConnection() {
        this.bProxyDialogShown = false;
        boolean directConnection = this.ocmValidation.isDirectConnectionAvailable();
        if (!directConnection) {
            Map rptrVarMap;
            if (!this.bSilentMode && (rptrVarMap = this.ocmValidation.setRepeaterFromAgentHome()) != null) {
                this.ocmVarMap.putAll(rptrVarMap);
            } else {
                if (null == this.oProxy) {
                    this.oProxy = !this.bSilentMode ? new OiifoOCMProxy((JFrame)WindowUtils.parentFrame((Component)this.ocmUIPanel), this.ocmValidation) : new OiifoOCMProxy(null, this.ocmValidation);
                }
                this.showProxyDialog();
                if (this.cancelProxy) {
                    return false;
                }
                if (this.bSilentMode) {
                    return null != this.oProxy.getProxyServer() || null != this.oProxy.getRepeaterURL() || this.isNoConnection;
                }
            }
        }
        return true;
    }

    private void resetMap() {
        this.ocmVarMap = new HashMap();
    }

    @Override
    public boolean validateInputs(HashMap varMap, boolean isSilentMode) {
        Object sResponseFile;
        this.bSilentMode = isSilentMode;
        this.isUIMode = !this.bSilentMode;
        this.bProxyDialogShown = false;
        this.resetMap();
        this.ocmVarMap.putAll(varMap);
        if (null != this.oProxy && null != this.oProxy.getProxyVarMap() && !this.oProxy.getProxyVarMap().isEmpty()) {
            this.ocmVarMap.putAll(this.oProxy.getProxyVarMap());
        }
        if (null != (sResponseFile = this.ocmVarMap.get("COLLECTOR_RESPONSE_FILE")) && ((String)sResponseFile).trim().length() > 0) {
            return true;
        }
        Object sUpgrade = this.ocmVarMap.get("COLLECTOR_UPGRADE");
        if (null != sUpgrade) {
            return true;
        }
        boolean emailValidation = this.validateEmail();
        if (!emailValidation) {
            this.resetMap();
            if (this.isDeclineSecurityUpdates()) {
                this.ocmVarMap.put("DECLINE_SECURITY_UPDATES", new Boolean(true));
                this.ocmVarMap.put("COLLECTOR_IGNORE_CONFIGURATION", "true");
            }
            return false;
        }
        if (isSilentMode && null != this.ocmVarMap && !this.ocmVarMap.isEmpty() && this.ocmVarMap.containsKey("DECLINE_SECURITY_UPDATES")) {
            this.setDeclineSecurityUpdates((Boolean)this.ocmVarMap.get("DECLINE_SECURITY_UPDATES"));
        } else {
            this.ocmVarMap.put("DECLINE_SECURITY_UPDATES", new Boolean(this.isDeclineSecurityUpdates()));
        }
        if (this.isUIMode) {
            this.copyUIValuesToMap();
        }
        if (this.getMetalinkUsername() == null || this.getMetalinkUsername().trim().length() == 0 && this.isDeclineSecurityUpdates()) {
            return true;
        }
        if (!this.isSecurityUpdatesViaMetalink() && this.getMetalinkPassword() != null && this.getMetalinkPassword().trim().length() > 0) {
            this.setSecurityUpdatesViaMetalink(true);
            this.ocmVarMap.put("SECURITY_UPDATES_VIA_MYORACLESUPPORT", new Boolean(true));
        }
        if (this.isSecurityUpdatesViaMetalink() && (this.getMetalinkPassword() == null || this.getMetalinkPassword() != null && this.getMetalinkPassword().trim().length() == 0)) {
            if (!isSilentMode) {
                this.getAlertHandler().showAlert(this.sErrorTitle, OiixResourceBundle.getString("S_OCM_PASSWORD_EMPTY_UI"), 50, 1, 1, 20);
                this.resetMap();
                return false;
            }
            this.nAttempts = 0;
        }
        if (this.nAttempts >= 0 && !this.bProxyConnAvbl) {
            boolean connValidation = this.validateConnection();
            if (connValidation) {
                this.bProxyConnAvbl = true;
            } else {
                this.bProxyConnAvbl = false;
                return false;
            }
        }
        if (null != this.oProxy && this.oProxy.declineSecurityUpdatesInProxy()) {
            this.ocmVarMap.put("DECLINE_SECURITY_UPDATES", new Boolean(this.noSelected));
            return true;
        }
        boolean metaLinkConnection = true;
        if (this.isSecurityUpdatesViaMetalink() && this.bProxyConnAvbl) {
            this.yesSelected = true;
            String pwd = this.getMetalinkPassword();
            if ((null == pwd || null != pwd && pwd.trim().length() == 0) && !isSilentMode) {
                this.getAlertHandler().showAlert(this.sErrorTitle, OiixResourceBundle.getString("S_OCM_PASSWORD_EMPTY_UI"), 50, 1, 1, 20);
                metaLinkConnection = false;
            } else {
                String errMsg = OiixResourceBundle.getString("S_OCM_INVALID_METALINK_CREDENTIALS");
                String metaLinkConnectionMsg = "";
                try {
                    metaLinkConnection = this.ocmValidation.testMetaLinkconnection(this.getMetalinkUsername(), this.getMetalinkPassword());
                }
                catch (OiixOCMNetworkException e) {
                    metaLinkConnectionMsg = e.getMessage();
                    metaLinkConnection = true;
                    errMsg = OiixResourceBundle.getString("S_OCM_SERVER_CONNECTION_FAILED");
                    this.getAlertHandler().showAlert(this.sErrorTitle, errMsg, 50, 1, 1, 20);
                    this.ocmVarMap.put("DECLINE_SECURITY_UPDATES", new Boolean(true));
                    this.ocmVarMap.put("MYORACLESUPPORT_USERNAME", "");
                    this.ocmVarMap.put("MYORACLESUPPORT_PASSWORD", "");
                    this.ocmVarMap.put("SECURITY_UPDATES_VIA_MYORACLESUPPORT", new Boolean(false));
                    this.setDeclineSecurityUpdates(true);
                    this.setSecurityUpdatesViaMetalink(false);
                    this.setMetalinkPassword("");
                    this.setMetalinkUsername("");
                    return true;
                }
                catch (OiixOCMException e) {
                    metaLinkConnectionMsg = e.getMessage();
                    metaLinkConnection = false;
                }
                if (null != metaLinkConnectionMsg && metaLinkConnectionMsg.trim().length() > 0) {
                    errMsg = metaLinkConnectionMsg;
                }
                if (!metaLinkConnection) {
                    if (this.nAttempts > 0) {
                        --this.nAttempts;
                        errMsg = OiixResourceBundle.getString("S_OCM_INVALID_METALINK_CREDENTIALS") + "\n" + OiixResourceBundle.getString("S_OCM_CONNECTION_ATTEMPTS", new Object[]{Integer.toString(this.nAttempts)});
                    }
                    if (this.nAttempts == 0) {
                        errMsg = OiixResourceBundle.getString("S_OCM_FAILED_CONNECTION_ATTEMPT");
                        this.yesSelected = false;
                        this.setMetalinkPassword("");
                        if (null != this.ocmVarMap && !this.ocmVarMap.isEmpty() && this.ocmVarMap.containsKey("MYORACLESUPPORT_PASSWORD")) {
                            this.ocmVarMap.put("MYORACLESUPPORT_PASSWORD", "");
                            this.ocmVarMap.put("SECURITY_UPDATES_VIA_MYORACLESUPPORT", new Boolean(false));
                        }
                        metaLinkConnection = true;
                    }
                    if (this.nAttempts > 0) {
                        this.getAlertHandler().showAlert(this.sErrorTitle, errMsg, 50, 1, 1, 20);
                        return false;
                    }
                    this.getAlertHandler().showAlert(this.sErrorTitle, errMsg, 50, 1, 1, 20);
                    return true;
                }
            }
        } else {
            this.yesSelected = false;
        }
        return emailValidation && metaLinkConnection;
    }

    @Override
    public void resetCount() {
        this.nAttempts = 3;
    }

    private void copyMapValuesToUI() {
        if (null != this.ocmVarMap && !this.ocmVarMap.isEmpty()) {
            this.setMetalinkUsername((String)this.ocmVarMap.get("MYORACLESUPPORT_USERNAME"));
            this.setMetalinkPassword((String)this.ocmVarMap.get("MYORACLESUPPORT_PASSWORD"));
            if (null != this.ocmVarMap.get("SECURITY_UPDATES_VIA_MYORACLESUPPORT")) {
                this.setSecurityUpdatesViaMetalink((Boolean)this.ocmVarMap.get("SECURITY_UPDATES_VIA_MYORACLESUPPORT"));
            } else if (null != this.ocmVarMap.get("MYORACLESUPPORT_PASSWORD")) {
                this.setSecurityUpdatesViaMetalink(true);
            }
            if (null != this.ocmVarMap.get("DECLINE_SECURITY_UPDATES")) {
                this.setDeclineSecurityUpdates((Boolean)this.ocmVarMap.get("DECLINE_SECURITY_UPDATES"));
            }
        }
    }

    private void copyUIValuesToMap() {
        if (null == this.ocmVarMap) {
            this.ocmVarMap = new HashMap();
        }
        this.ocmVarMap.put("MYORACLESUPPORT_USERNAME", this.getMetalinkUsername());
        this.ocmVarMap.put("MYORACLESUPPORT_PASSWORD", this.getMetalinkPassword());
        this.ocmVarMap.put("SECURITY_UPDATES_VIA_MYORACLESUPPORT", new Boolean(this.isSecurityUpdatesViaMetalink()));
        this.ocmVarMap.put("DECLINE_SECURITY_UPDATES", new Boolean(this.isDeclineSecurityUpdates()));
        if (null != this.oProxy && this.oProxy.declineSecurityUpdatesInProxy()) {
            this.ocmVarMap.put("DECLINE_SECURITY_UPDATES", new Boolean(this.oProxy.declineSecurityUpdatesInProxy()));
        }
    }

    private void createUI() {
        if (null == this.ocmUIPanel) {
            this.ocmUIPanel = new JPanel();
        }
        if (null == this.lblContainer) {
            this.lblContainer = new JPanel();
        }
        this.gridBag = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.ocmUIPanel.setLayout(this.gridBag);
        this.ocmUIPanel.setOpaque(false);
        String sDesc = OiixResourceBundle.getString("S_CM_PROVIDE_EMAIL_ADDRESS_WITH_LINK");
        this.cs_desc = new AccessFocusLabel("<html>" + sDesc + "</html>");
        this.cs_desc.setLabelAccessAndFocus(true, "<html>" + sDesc + "</html>", sDesc);
        this.cs_desc.addKeyListener(this);
        this.cs_desc.addMouseMotionListener(this);
        this.cs_desc.setLabelFor(this.cs_desc);
        this.cs_desc.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                OiifoOCMUI.this.launchBrowser();
            }
        });
        this.lblContainer.setLayout(new GridLayout(1, 0));
        this.lblContainer.add(this.cs_desc);
        this.cs_desc.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                OiifoOCMUI.this.lblContainer.setBorder(BorderFactory.createLineBorder(UIManager.getColor("Button.focus")));
                e.getComponent().repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                OiifoOCMUI.this.lblContainer.setBorder(BorderFactory.createEmptyBorder());
                e.getComponent().repaint();
            }
        });
        OiifmMnemonicOps.processMnemonic(this.cs_desc);
        this.setAlertHandler(this);
        String sEmail = OiixResourceBundle.getString("S_OCM_EMAIL_ADDRESS");
        JLabel lbl_email = new JLabel(sEmail);
        OiifmMnemonicOps.processMnemonic(lbl_email);
        this.tf_email = new JTextField();
        lbl_email.setLabelFor(this.tf_email);
        this.tf_email.setSize(30, 10);
        String sYes = OiixResourceBundle.getString("S_OCM_RECEIVE_SECURITY_UPDATES");
        this.cb_useMetalinkPwd = new JCheckBox(sYes, true);
        this.cb_useMetalinkPwd.setOpaque(false);
        this.cb_useMetalinkPwd.setBackground(lbl_email.getBackground());
        this.cb_useMetalinkPwd.addItemListener(this);
        String sMetalinkPwd = OiixResourceBundle.getString("S_OCM_PASSWORD");
        JLabel lbl_metapwd = new JLabel(sMetalinkPwd);
        OiifmMnemonicOps.processMnemonic(lbl_metapwd);
        this.tf_metapwd = new JPasswordField();
        lbl_metapwd.setLabelFor(this.tf_metapwd);
        this.tf_metapwd.setEnabled(true);
        this.tf_metapwd.setSize(50, 10);
        JLabel lbl = new JLabel("");
        String sEmailNote = OiixResourceBundle.getString("S_OCM_EMAIL_TIP");
        TextWrapper twrap = WordWrapper.getTextWrapper();
        MultiLineLabel lbl_emailNote = new MultiLineLabel(twrap, sEmailNote);
        this.font = new Font(this.fontname, 0, 11);
        OiifmMnemonicOps.processMnemonic((Container)lbl_emailNote);
        this.CHECK_FIELD = 6;
        OiifmMnemonicOps.processMnemonic(this.cb_useMetalinkPwd);
        this.gbc = new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 23, 2, new Insets(0, 0, 0, 0), 0, 0);
        this.gridBag.setConstraints(this.lblContainer, this.gbc);
        this.ocmUIPanel.add(this.lblContainer);
        this.gbc = new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 21, 0, new Insets(10, 15, 0, 0), 0, 0);
        this.gridBag.setConstraints(lbl_email, this.gbc);
        this.ocmUIPanel.add(lbl_email);
        this.gbc = new GridBagConstraints(3, 1, 0, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 0, 185), 0, 0);
        this.gridBag.setConstraints(this.tf_email, this.gbc);
        this.ocmUIPanel.add(this.tf_email);
        this.EMAIL_FIELD = 2;
        this.gbc = new GridBagConstraints(3, 2, 0, 1, 0.0, 0.0, 10, 2, new Insets(0, 10, 0, 20), 0, 0);
        this.gridBag.setConstraints((Component)lbl_emailNote, this.gbc);
        this.ocmUIPanel.add((Component)lbl_emailNote);
        this.gbc = new GridBagConstraints(0, 3, 0, 1, 0.0, 0.0, 21, 2, new Insets(20, 0, 0, 0), 0, 0);
        this.gridBag.setConstraints(this.cb_useMetalinkPwd, this.gbc);
        this.ocmUIPanel.add(this.cb_useMetalinkPwd);
        this.CHECK_FIELD = 4;
        this.gbc = new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 21, 0, new Insets(10, 15, 0, 0), 0, 0);
        this.gridBag.setConstraints(lbl_metapwd, this.gbc);
        this.ocmUIPanel.add(lbl_metapwd);
        this.PWD_LBL_FIELD = 5;
        this.gbc = new GridBagConstraints(3, 4, 0, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 0, 185), 0, 0);
        this.gridBag.setConstraints(this.tf_metapwd, this.gbc);
        this.ocmUIPanel.add(this.tf_metapwd);
        this.PWD_FIELD = 6;
        Component glue = Box.createGlue();
        this.gbc = new GridBagConstraints(0, 5, 0, 0, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0);
        this.gridBag.setConstraints(glue, this.gbc);
        this.ocmUIPanel.add(glue);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == (JCheckBox)this.ocmUIPanel.getComponent(this.CHECK_FIELD)) {
            ((JTextField)this.ocmUIPanel.getComponent(this.PWD_FIELD)).setEnabled(((JCheckBox)this.ocmUIPanel.getComponent(this.CHECK_FIELD)).isSelected());
            ((JLabel)this.ocmUIPanel.getComponent(this.PWD_LBL_FIELD)).setEnabled(((JCheckBox)this.ocmUIPanel.getComponent(this.CHECK_FIELD)).isSelected());
            if (!((JCheckBox)this.ocmUIPanel.getComponent(this.CHECK_FIELD)).isSelected()) {
                this.setMetalinkPassword("");
            }
            this.yesSelected = true;
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        Frame f = WindowUtils.parentFrame((Component)this.ocmUIPanel);
        if (source != this.tf_email || this.tf_email.getText() == null || this.tf_email.getText().trim().length() > 0) {
            // empty if block
        }
        if (source instanceof Component) {
            ((Component)source).requestFocus();
        }
    }

    @Override
    public void setAlertHandler(OiifoIOCMAlert aHandler) {
        this.alertHandler = aHandler;
    }

    public OiifoIOCMAlert getAlertHandler() {
        return this.alertHandler;
    }

    @Override
    public int showAlert(String title, String message, int alertType, int userChoices, int defaultChoice, int severity) {
        if (this.bSilentMode) {
            System.out.println(message);
            if ((userChoices & 2) == 2 && (userChoices & 1) == 1) {
                return 2;
            }
            return 1;
        }
        int retValue = new OiifjAlertHandler(WindowUtils.parentFrame((Component)this.ocmUIPanel), true).displayAlert(title, message, alertType, userChoices, defaultChoice, severity);
        return retValue;
    }

    public void setDeclineSecurityUpdates(boolean declineSecurityUpdates) {
        this.declineSecurityUpdates = declineSecurityUpdates;
    }

    public boolean isDeclineSecurityUpdates() {
        return this.declineSecurityUpdates;
    }

    @Override
    public void setProxyHandler(OiifoIOCMProxy iProxy) {
        this.oProxy = iProxy;
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10 || (e.getModifiers() & 8) != 0 && e.getKeyCode() == 86) {
            this.launchBrowser();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.getTextRectangle().contains(e.getPoint())) {
            this.cs_desc.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.cs_desc.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private Rectangle getTextRectangle() {
        String text = OiixResourceBundle.getString("S_OCM_VIEW_DETAILS_TEXT");
        if (text == null) {
            return null;
        }
        Rectangle paintIconR = new Rectangle();
        Rectangle paintTextR = new Rectangle();
        Rectangle paintViewR = new Rectangle();
        Insets paintViewInsets = new Insets(0, 0, 0, 0);
        paintViewInsets = this.cs_desc.getInsets(paintViewInsets);
        paintViewR.x = paintViewInsets.left;
        paintViewR.y = paintViewInsets.top;
        paintViewR.width = this.cs_desc.getWidth() - (paintViewInsets.left + paintViewInsets.right);
        paintViewR.height = this.cs_desc.getHeight() - (paintViewInsets.top + paintViewInsets.bottom);
        Graphics g = this.cs_desc.getGraphics();
        if (g == null) {
            return null;
        }
        String clippedText = SwingUtilities.layoutCompoundLabel(this.cs_desc, g.getFontMetrics(), text, null, this.cs_desc.getVerticalAlignment(), this.cs_desc.getHorizontalAlignment(), this.cs_desc.getVerticalTextPosition(), this.cs_desc.getHorizontalTextPosition(), paintViewR, paintIconR, paintTextR, this.cs_desc.getIconTextGap());
        return paintTextR;
    }

    private void launchBrowser() {
        try {
            String sFileName = OiixOraparam.getOraparamProfileString("SUPPORT_POLICY_LOCATION", "http://www.oracle.com/support/policies.html");
            OiixOCMValidation ocmValidation = new OiixOCMValidation();
            ocmValidation.openURL(sFileName);
        }
        catch (Exception ex) {
            this.getAlertHandler().showAlert(OiixResourceBundle.getString("S_OCM_BROWSER_ERROR_TITLE"), OiixResourceBundle.getString("S_OCM_POLICY_LAUNCH_ERROR", new Object[]{OiixResourceBundle.getString("S_OCM_POLICY_LOCATION")}), 50, 1, 1, 20);
        }
    }
}

