/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifo;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.NumberTextField;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.util.WindowUtils;
import oracle.sysman.oii.oiif.oiifm.OiifmMnemonicOps;
import oracle.sysman.oii.oiif.oiifo.OiifoIOCMAlert;
import oracle.sysman.oii.oiif.oiifo.OiifoIOCMProgressListener;
import oracle.sysman.oii.oiif.oiifo.OiifoIOCMProxy;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixHelp;
import oracle.sysman.oii.oiix.OiixOCMException;
import oracle.sysman.oii.oiix.OiixOCMLibraryUtils;
import oracle.sysman.oii.oiix.OiixOCMValidation;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifoOCMProxy
implements OiifoIOCMProxy,
ActionListener,
WindowListener,
ItemListener,
MouseListener,
KeyListener,
OiifoIOCMAlert {
    private JDialog proxyDialog;
    private boolean bSilentMode = true;
    private Frame fParentFrame = null;
    private HashMap mProxyVarMap = null;
    private Dimension m_prefSize;
    private GridBagLayout gridBag;
    private GridBagConstraints gbc;
    private String fontname = OiixResourceBundle.getFont();
    private MultiLineLabel cs_proxyDescription;
    private JTextField s_proxyServerRptr;
    private JLabel proxyServerLbl;
    private NumberTextField s_proxyPortRptr;
    private JLabel proxyPortLbl;
    private JTextField s_proxyUserRptr;
    private JLabel proxyUserLbl;
    private JPasswordField s_proxyPasswordRptr;
    private JLabel proxyPswdLbl;
    private JCheckBox cb_no = null;
    private JButton cancelButton;
    private JButton continueButton;
    private JTextField s_proxyServer;
    private NumberTextField s_proxyPort;
    private JTextField s_proxyUser;
    private JPasswordField s_proxyPassword;
    private JLabel proxyServerLbl1;
    private JLabel proxyUserLbl1;
    private JLabel proxyPortLbl1;
    private JLabel proxyPswdLbl1;
    private JLabel repeaterURLLbl;
    private JPanel repeaterPanel;
    private JPanel proxyPanel;
    private JTextField s_RepeaterURL;
    private ButtonGroup bg;
    private JRadioButton repeaterOption;
    private JRadioButton proxyOption;
    private JLabel repeaterHelp;
    JPanel titlePanel;
    private static String sTxtRepeaterThroughProxy = OiixResourceBundle.getString("S_OCM_SUPPORT_HUB_THRU_PROXY");
    private static String sTxtRepeaterDirect = OiixResourceBundle.getString("S_OCM_SUPPORT_HUB_DIRECT");
    private JCheckBox checkRepeaterProxy;
    private static String PROXY_ACTION_COMMAND = "PROXY";
    private static String REPEATER_ACTION_COMMAND = "REPEATER";
    private OiixOCMValidation ocmValidation = new OiixOCMValidation();
    private OiifoIOCMAlert alertHandler = null;
    private boolean bCancel = false;
    private OiifoIOCMProgressListener listener = null;
    private static String sEmptyProxy = OiixResourceBundle.getString("S_OCM_PROXY_EMPTY");
    private static String sErrorConnection = OiixResourceBundle.getString("S_OCM_PROXY_CONNECTIVITY_ERROR_TITLE");
    private static String sEmptyProxyPwd = OiixResourceBundle.getString("S_OCM_PROXY_PASSWORD_EMPTY");
    private static String sInvalidRepeaterUrl = OiixResourceBundle.getString("S_OCM_SUPPORT_HUB_INVALID_URL");
    private static String sErrorConnectionRepeater = OiixResourceBundle.getString("S_OCM_SUPPORT_HUB_CONNECTION_ERROR");

    public OiifoOCMProxy(Frame parentFrame) {
        this(parentFrame, new OiixOCMValidation());
    }

    public OiifoOCMProxy(Frame parentFrame, OiixOCMValidation oOCMValidation) {
        if (null != parentFrame) {
            this.bSilentMode = false;
            this.proxyDialog = new JDialog(parentFrame, OiixResourceBundle.getString("S_OCM_PROXY_TITLE"), true);
            this.createUI();
        }
        this.fParentFrame = parentFrame;
        this.ocmValidation = oOCMValidation;
    }

    @Override
    public JDialog getUIComponent() {
        return this.proxyDialog;
    }

    @Override
    public HashMap getProxyVarMap() {
        return this.mProxyVarMap;
    }

    @Override
    public String getProxyUsername() {
        if (this.bSilentMode) {
            if (null != this.mProxyVarMap && !this.mProxyVarMap.isEmpty() && null != this.mProxyVarMap.get("PROXY_USER")) {
                return (String)this.mProxyVarMap.get("PROXY_USER");
            }
            return null;
        }
        if (this.isProxyUsed()) {
            return this.s_proxyUser.getText();
        }
        return this.s_proxyUserRptr.getText();
    }

    @Override
    public void setProxyUsername(String sUserName) {
        if (this.isProxyUsed()) {
            this.s_proxyUser.setText(sUserName);
        } else {
            this.s_proxyUserRptr.setText(sUserName);
        }
    }

    @Override
    public void setProxyPassword(String sPwd) {
        if (this.isProxyUsed()) {
            this.s_proxyPassword.setText(sPwd);
        } else {
            this.s_proxyPasswordRptr.setText(sPwd);
        }
    }

    @Override
    public String getProxyPassword() {
        if (this.bSilentMode) {
            if (null != this.mProxyVarMap && !this.mProxyVarMap.isEmpty() && null != this.mProxyVarMap.get("PROXY_PWD")) {
                return (String)this.mProxyVarMap.get("PROXY_PWD");
            }
            return null;
        }
        if (this.isProxyUsed()) {
            return this.s_proxyPassword.getText();
        }
        return this.s_proxyPasswordRptr.getText();
    }

    @Override
    public void setProxyServer(String sServer) {
        if (this.isProxyUsed()) {
            this.s_proxyServer.setText(sServer);
        } else {
            this.s_proxyServerRptr.setText(sServer);
        }
    }

    @Override
    public void setRepeaterURL(String sRepeater) {
        this.s_RepeaterURL.setText(sRepeater);
    }

    public void setRepeaterOption(boolean bSelect) {
        if (this.repeaterOption.isEnabled()) {
            this.repeaterOption.setSelected(bSelect);
        }
    }

    public void setRepeaterProxyOption(boolean bSelect) {
        if (this.repeaterOption.isEnabled()) {
            this.checkRepeaterProxy.setSelected(bSelect);
        }
    }

    public boolean getRepeaterOption() {
        return this.repeaterOption.isSelected();
    }

    public boolean getRepeaterProxyOption() {
        return this.checkRepeaterProxy.isSelected();
    }

    @Override
    public String getProxyServer() {
        if (this.bSilentMode) {
            if (null != this.mProxyVarMap && !this.mProxyVarMap.isEmpty() && null != this.mProxyVarMap.get("PROXY_HOST")) {
                return (String)this.mProxyVarMap.get("PROXY_HOST");
            }
            return null;
        }
        if (this.isProxyUsed()) {
            return this.s_proxyServer.getText();
        }
        return this.s_proxyServerRptr.getText();
    }

    @Override
    public String getRepeaterURL() {
        if (this.bSilentMode) {
            if (null != this.mProxyVarMap && !this.mProxyVarMap.isEmpty() && null != this.mProxyVarMap.get("COLLECTOR_SUPPORTHUB_URL")) {
                return (String)this.mProxyVarMap.get("COLLECTOR_SUPPORTHUB_URL");
            }
            return null;
        }
        return this.s_RepeaterURL.getText();
    }

    @Override
    public void setProxyPort(int iPort) {
        this.setProxyPort(Integer.toString(iPort));
    }

    public void setProxyPort(String port) {
        if (this.isProxyUsed()) {
            this.s_proxyPort.setText(port);
        } else {
            this.s_proxyPortRptr.setText(port);
        }
    }

    @Override
    public int getProxyPort() {
        if (this.bSilentMode) {
            if (null != this.mProxyVarMap && !this.mProxyVarMap.isEmpty() && null != this.mProxyVarMap.get("PROXY_PORT")) {
                String proxyPort = (String)this.mProxyVarMap.get("PROXY_PORT");
                if (null == proxyPort || null != proxyPort && proxyPort.trim().length() <= 0) {
                    return -1;
                }
                return Integer.parseInt(proxyPort.trim());
            }
            return -1;
        }
        if (this.isProxyUsed()) {
            if (this.s_proxyPort.getText().trim().length() == 0) {
                return -1;
            }
            return Integer.parseInt(this.s_proxyPort.getText());
        }
        if (this.s_proxyPortRptr.getText().trim().length() == 0) {
            return -1;
        }
        return Integer.parseInt(this.s_proxyPortRptr.getText());
    }

    @Override
    public boolean declineSecurityUpdatesInProxy() {
        if (this.bSilentMode) {
            if (null != this.mProxyVarMap && !this.mProxyVarMap.isEmpty() && null != this.mProxyVarMap.get("DECLINE_SECURITY_UPDATES")) {
                return (Boolean)this.mProxyVarMap.get("DECLINE_SECURITY_UPDATES");
            }
            return false;
        }
        return this.cb_no.isSelected();
    }

    @Override
    public void setDeclineSecurityUpdatesInProxy(boolean bDecline) {
        this.cb_no.setSelected(bDecline);
    }

    @Override
    public void setProxyVarMap(HashMap varMap) {
        this.mProxyVarMap = varMap;
        if (!this.bSilentMode) {
            this.copyDataFromMapToUI();
        }
    }

    @Override
    public void onCancel() {
        this.mProxyVarMap = new HashMap();
        this.resetValues();
        this.proxyDialog.setVisible(false);
    }

    @Override
    public void onContinue() {
        if (this.declineSecurityUpdatesInProxy()) {
            this.proxyDialog.setVisible(false);
        } else if (this.isProxyUsed()) {
            if (this.validateProxy()) {
                this.proxyDialog.setVisible(false);
                this.setRepeaterURL("");
            }
        } else if (this.isRepeaterUsedWithProxy()) {
            if (this.validateRepeaterWithProxy()) {
                this.proxyDialog.setVisible(false);
            }
        } else if (this.isRepeaterUsed()) {
            if (this.validateRepeater()) {
                this.proxyDialog.setVisible(false);
            }
        } else {
            this.proxyDialog.setVisible(true);
        }
    }

    private void copyDataFromMapToUI() {
        if (null != this.mProxyVarMap && !this.mProxyVarMap.isEmpty()) {
            if (this.mProxyVarMap.containsKey("COLLECTOR_SUPPORTHUB_URL")) {
                this.setRepeaterURL((String)this.mProxyVarMap.get("COLLECTOR_SUPPORTHUB_URL"));
                this.repeaterOption.setSelected(true);
                this.showCard(REPEATER_ACTION_COMMAND);
            }
            if (this.mProxyVarMap.containsKey("PROXY_HOST")) {
                this.setProxyServer((String)this.mProxyVarMap.get("PROXY_HOST"));
            }
            if (this.mProxyVarMap.containsKey("PROXY_PORT")) {
                String proxyPortStr = (String)this.mProxyVarMap.get("PROXY_PORT");
                if (proxyPortStr != null && proxyPortStr.trim().length() > 0) {
                    this.setProxyPort(Integer.parseInt((String)this.mProxyVarMap.get("PROXY_PORT")));
                } else {
                    this.setProxyPort(80);
                }
            }
            if (this.mProxyVarMap.containsKey("PROXY_USER")) {
                this.setProxyUsername((String)this.mProxyVarMap.get("PROXY_USER"));
            }
            if (this.mProxyVarMap.containsKey("PROXY_PWD")) {
                this.setProxyPassword((String)this.mProxyVarMap.get("PROXY_PWD"));
            }
            if (this.mProxyVarMap.containsKey("DECLINE_SECURITY_UPDATES")) {
                this.setDeclineSecurityUpdatesInProxy((Boolean)this.mProxyVarMap.get("DECLINE_SECURITY_UPDATES"));
            }
        }
    }

    private void showCard(String actionCommand) {
        ((CardLayout)this.titlePanel.getLayout()).show(this.titlePanel, actionCommand);
    }

    private void copyDataFromUIToMap() {
        if (null == this.mProxyVarMap) {
            this.mProxyVarMap = new HashMap();
        }
        this.mProxyVarMap.put("PROXY_HOST", this.getProxyServer());
        this.mProxyVarMap.put("PROXY_PORT", Integer.toString(this.getProxyPort()));
        this.mProxyVarMap.put("PROXY_USER", this.getProxyUsername());
        this.mProxyVarMap.put("PROXY_PWD", this.getProxyPassword());
        this.mProxyVarMap.put("DECLINE_SECURITY_UPDATES", new Boolean(this.declineSecurityUpdatesInProxy()));
        this.mProxyVarMap.put("COLLECTOR_SUPPORTHUB_URL", this.getRepeaterURL());
    }

    private void createUI() {
        this.gridBag = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.cs_proxyDescription = this.mkMllLabel(OiixResourceBundle.getString("S_OCM_PROXY_DESC"));
        this.s_proxyServerRptr = new JTextField();
        this.proxyServerLbl = this.mkLabel(OiixResourceBundle.getString("S_OCM_PROXY_SERVER"), this.s_proxyServerRptr);
        this.s_proxyPortRptr = new NumberTextField();
        this.proxyPortLbl = this.mkLabel(OiixResourceBundle.getString("S_OCM_PROXY_PORT"), (Component)this.s_proxyPortRptr);
        this.s_proxyUserRptr = new JTextField();
        this.proxyUserLbl = this.mkLabel(OiixResourceBundle.getString("S_OCM_PROXY_USER"), this.s_proxyUserRptr);
        this.s_proxyPasswordRptr = new JPasswordField();
        this.proxyPswdLbl = this.mkLabel(OiixResourceBundle.getString("S_OCM_PROXY_PWD"), this.s_proxyPasswordRptr);
        this.cancelButton = OiixOCMLibraryUtils.mkButton(OiixResourceBundle.getString("S_CANCEL_BUTTON"));
        this.continueButton = OiixOCMLibraryUtils.mkButton(OiixResourceBundle.getString("S_CONTINUE_BUTTON"));
        this.s_proxyServer = new JTextField();
        this.s_proxyPort = new NumberTextField();
        this.s_proxyUser = new JTextField();
        this.s_proxyPassword = new JPasswordField();
        this.proxyServerLbl1 = OiixOCMLibraryUtils.mkLabel(OiixResourceBundle.getString("S_OCM_PROXY_SERVER"), this.s_proxyServer);
        this.proxyUserLbl1 = OiixOCMLibraryUtils.mkLabel(OiixResourceBundle.getString("S_OCM_PROXY_USER"), this.s_proxyUser);
        this.proxyPortLbl1 = OiixOCMLibraryUtils.mkLabel(OiixResourceBundle.getString("S_OCM_PROXY_PORT"), (Component)this.s_proxyPort);
        this.proxyPswdLbl1 = OiixOCMLibraryUtils.mkLabel(OiixResourceBundle.getString("S_OCM_PROXY_PWD"), this.s_proxyPassword);
        this.repeaterURLLbl = new JLabel(OiixResourceBundle.getString("S_OCM_SUPPORT_HUB_TITLE"));
        this.repeaterPanel = new JPanel();
        this.proxyPanel = new JPanel();
        this.s_RepeaterURL = new JTextField();
        this.bg = new ButtonGroup();
        this.repeaterOption = new JRadioButton(OiixResourceBundle.getString("S_OCM_SUPPORT_HUB_DESC"), false);
        this.proxyOption = new JRadioButton(OiixResourceBundle.getString("S_OCM_PROXY_OPTION_TITLE"), true);
        this.repeaterHelp = new JLabel(OiixResourceBundle.getString("S_OCM_SUPPORT_HUB_HELP"));
        this.titlePanel = new JPanel(new CardLayout());
        this.checkRepeaterProxy = new JCheckBox(sTxtRepeaterThroughProxy);
        this.proxyPanel = this.createProxyPanel();
        this.repeaterPanel = this.createRepeaterProxyPanel();
        this.proxyDialog.setLayout(new BorderLayout());
        this.m_prefSize = new Dimension(500, 200);
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new BorderLayout());
        this.proxyDialog.add((Component)centerPanel, "Center");
        JPanel southPanel = new JPanel();
        southPanel.setLayout(new BorderLayout());
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 4, 10, 1));
        JPanel dummySpace = new JPanel();
        buttonPanel.add(dummySpace);
        buttonPanel.add(new JLabel(""));
        buttonPanel.add(new JLabel(""));
        buttonPanel.add(this.cancelButton);
        buttonPanel.add(this.continueButton);
        this.continueButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        southPanel.add((Component)buttonPanel, "South");
        centerPanel.add((Component)this.getConnectionPanel(), "North");
        this.titlePanel = new JPanel(new CardLayout());
        this.titlePanel.add((Component)this.repeaterPanel, REPEATER_ACTION_COMMAND);
        this.titlePanel.add((Component)this.proxyPanel, PROXY_ACTION_COMMAND);
        JPanel tmp1 = new JPanel(new BorderLayout());
        tmp1.add((Component)this.titlePanel, "Center");
        tmp1.add((Component)this.getDeclinePanel(), "South");
        centerPanel.add((Component)tmp1, "Center");
        centerPanel.add((Component)southPanel, "South");
        this.showCard(PROXY_ACTION_COMMAND);
        this.s_proxyPasswordRptr.setBackground(this.s_proxyServerRptr.getBackground());
        this.proxyDialog.setDefaultCloseOperation(2);
        this.proxyDialog.addWindowListener(this);
        this.setAlertHandler(this);
        this.proxyDialog.setResizable(false);
        this.proxyDialog.setVisible(false);
        this.proxyDialog.pack();
        this.proxyDialog.validate();
    }

    public Dimension getPreferredSize() {
        return this.m_prefSize;
    }

    public Dimension getMaximumSize() {
        return this.m_prefSize;
    }

    public Dimension getMinimumSize() {
        return this.m_prefSize;
    }

    public JPanel getConnectionPanel() {
        JPanel connectionMethodPanel = new JPanel();
        connectionMethodPanel.setLayout(new FlowLayout(0, 5, 5));
        connectionMethodPanel.add(new JLabel(OiixResourceBundle.getString("S_OCM_CONNECTION_METHOD")));
        this.proxyOption.setActionCommand(PROXY_ACTION_COMMAND);
        this.repeaterOption.setActionCommand(REPEATER_ACTION_COMMAND);
        this.bg.add(this.proxyOption);
        this.bg.add(this.repeaterOption);
        this.proxyOption.setSelected(true);
        if (!this.ocmValidation.isRepeaterAvailable()) {
            this.repeaterOption.setEnabled(false);
        }
        this.repeaterOption.addItemListener(this);
        this.proxyOption.addItemListener(this);
        this.repeaterHelp.addMouseListener(this);
        connectionMethodPanel.add(this.proxyOption);
        connectionMethodPanel.add(this.repeaterOption);
        connectionMethodPanel.add(this.repeaterHelp);
        return connectionMethodPanel;
    }

    private JPanel createRepeaterProxyPanel() {
        JPanel frameAround = new JPanel(this.gridBag);
        Font font = new Font(this.fontname, 0, 11);
        this.proxyServerLbl.setFont(font);
        this.proxyPortLbl.setFont(font);
        this.cs_proxyDescription.setFont(font);
        this.repeaterURLLbl.setFont(font);
        this.checkRepeaterProxy.setFont(font);
        this.checkRepeaterProxy.addItemListener(this);
        OiixOCMLibraryUtils.addComponent(this.repeaterURLLbl, frameAround, this.gridBag, this.gbc, 2, 13, 1, 0, 1, 1, 1.0, 1.0, new Insets(0, 50, 5, 5));
        OiixOCMLibraryUtils.addComponent(this.s_RepeaterURL, frameAround, this.gridBag, this.gbc, 2, 13, 1, 0, 1, 1, 2.0, 1.0, new Insets(0, 160, 5, 100));
        OiixOCMLibraryUtils.addComponent(this.checkRepeaterProxy, frameAround, this.gridBag, this.gbc, 2, 13, 1, 1, -1, 1, 1.0, 1.0, new Insets(0, 45, 5, 5));
        OiixOCMLibraryUtils.addComponent(this.proxyServerLbl, frameAround, this.gridBag, this.gbc, 2, 13, 1, 2, 1, 1, 1.0, 1.0, new Insets(0, 90, 5, 5));
        OiixOCMLibraryUtils.addComponent(this.s_proxyServerRptr, frameAround, this.gridBag, this.gbc, 2, 13, 1, 2, 1, 1, 2.0, 1.0, new Insets(0, 185, 5, 100));
        OiixOCMLibraryUtils.addComponent(this.proxyPortLbl, frameAround, this.gridBag, this.gbc, 2, 13, 1, 3, 1, 1, 1.0, 1.0, new Insets(0, 90, 5, 5));
        this.s_proxyPortRptr.setSigned(false);
        OiixOCMLibraryUtils.addComponent((Component)this.s_proxyPortRptr, frameAround, this.gridBag, this.gbc, 2, 13, 1, 3, 1, 1, 2.0, 1.0, new Insets(0, 185, 5, 100));
        OiixOCMLibraryUtils.addComponent(this.proxyUserLbl, frameAround, this.gridBag, this.gbc, 2, 13, 1, 4, 1, 1, 1.0, 1.0, new Insets(0, 90, 5, 5));
        OiixOCMLibraryUtils.addComponent(this.s_proxyUserRptr, frameAround, this.gridBag, this.gbc, 2, 13, 1, 4, 1, 1, 2.0, 1.0, new Insets(0, 185, 5, 100));
        OiixOCMLibraryUtils.addComponent(this.proxyPswdLbl, frameAround, this.gridBag, this.gbc, 2, 13, 1, 5, 1, 1, 1.0, 1.0, new Insets(0, 90, 5, 5));
        OiixOCMLibraryUtils.addComponent(this.s_proxyPasswordRptr, frameAround, this.gridBag, this.gbc, 2, 13, 1, 5, 1, 1, 2.0, 1.0, new Insets(0, 185, 5, 100));
        this.checkRepeaterProxy.setSelected(false);
        this.s_proxyPasswordRptr.setEnabled(this.checkRepeaterProxy.isSelected());
        this.s_proxyPortRptr.setEnabled(this.checkRepeaterProxy.isSelected());
        this.s_proxyServerRptr.setEnabled(this.checkRepeaterProxy.isSelected());
        this.s_proxyUserRptr.setEnabled(this.checkRepeaterProxy.isSelected());
        String sNo = OiixResourceBundle.getString("S_OCM_DECLINE_SECURITY_UPDATES");
        this.cb_no = OiixOCMLibraryUtils.mkCb(sNo, false);
        this.cb_no.addItemListener(this);
        return frameAround;
    }

    private JPanel createProxyPanel() {
        this.gridBag = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        JPanel frameAroundProxy = new JPanel(this.gridBag);
        Font font = new Font(this.fontname, 0, 11);
        this.proxyServerLbl.setFont(font);
        this.proxyPortLbl.setFont(font);
        this.cs_proxyDescription.setFont(font);
        OiixOCMLibraryUtils.addComponent(this.proxyServerLbl1, frameAroundProxy, this.gridBag, this.gbc, 2, 13, 1, 2, 1, 1, 1.0, 0.0, new Insets(10, 50, 5, 0));
        OiixOCMLibraryUtils.addComponent(this.s_proxyServer, frameAroundProxy, this.gridBag, this.gbc, 2, 13, 1, 2, 1, 1, 2.0, 0.0, new Insets(10, 160, 5, 125));
        OiixOCMLibraryUtils.addComponent(this.proxyPortLbl1, frameAroundProxy, this.gridBag, this.gbc, 2, 13, 1, 3, 1, 1, 1.0, 0.0, new Insets(0, 50, 5, 0));
        this.s_proxyPort.setBackground(this.s_proxyServer.getBackground());
        this.s_proxyPort.setSigned(false);
        OiixOCMLibraryUtils.addComponent((Component)this.s_proxyPort, frameAroundProxy, this.gridBag, this.gbc, 2, 13, 1, 3, 1, 1, 2.0, 0.0, new Insets(0, 160, 5, 125));
        OiixOCMLibraryUtils.addComponent(this.proxyUserLbl1, frameAroundProxy, this.gridBag, this.gbc, 2, 13, 1, 4, 1, 1, 1.0, 0.0, new Insets(0, 50, 5, 0));
        OiixOCMLibraryUtils.addComponent(this.s_proxyUser, frameAroundProxy, this.gridBag, this.gbc, 2, 13, 1, 4, 1, 1, 2.0, 0.0, new Insets(0, 160, 5, 125));
        OiixOCMLibraryUtils.addComponent(this.proxyPswdLbl1, frameAroundProxy, this.gridBag, this.gbc, 2, 13, 1, 5, 1, 1, 1.0, 0.0, new Insets(0, 50, 5, 0));
        OiixOCMLibraryUtils.addComponent(this.s_proxyPassword, frameAroundProxy, this.gridBag, this.gbc, 2, 13, 1, 5, 1, 1, 2.0, 0.0, new Insets(0, 160, 5, 125));
        OiixOCMLibraryUtils.addComponent(new JLabel(""), frameAroundProxy, this.gridBag, this.gbc, 2, 13, 1, 6, 0, 1, 1.0, 1.0, new Insets(0, 10, 5, 5));
        return frameAroundProxy;
    }

    private JPanel getDeclinePanel() {
        this.gridBag = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        JPanel frameAroundProxy = new JPanel(this.gridBag);
        String sNo = OiixResourceBundle.getString("S_OCM_DECLINE_SECURITY_UPDATES");
        this.cb_no = OiixOCMLibraryUtils.mkCb(sNo, false);
        this.cb_no.addItemListener(this);
        OiixOCMLibraryUtils.addComponent(this.cb_no, frameAroundProxy, this.gridBag, this.gbc, 2, 13, 1, 1, 0, 1, 1.0, 1.0, new Insets(0, 10, 5, 5));
        return frameAroundProxy;
    }

    public void dispose() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.bCancel = false;
        Object source = e.getSource();
        this.copyDataFromUIToMap();
        if (source == this.continueButton) {
            this.onContinue();
        } else if (source == this.cancelButton) {
            this.bCancel = true;
            this.onCancel();
        }
    }

    private void resetValues() {
        this.s_proxyServerRptr.setText("");
        this.s_proxyPortRptr.setText("");
        this.s_proxyPasswordRptr.setText("");
        this.s_proxyUserRptr.setText("");
        this.s_proxyServer.setText("");
        this.s_proxyPort.setText("");
        this.s_proxyPassword.setText("");
        this.s_proxyUser.setText("");
        this.s_RepeaterURL.setText("");
    }

    public boolean isProxyUsed() {
        if (!this.bSilentMode) {
            return this.proxyOption.isSelected();
        }
        String repeaterURL = this.getRepeaterURL();
        return (repeaterURL == null || repeaterURL != null && repeaterURL.trim().length() == 0) && this.getProxyServer().trim().length() > 0;
    }

    public boolean isRepeaterUsedWithProxy() {
        if (this.bSilentMode) {
            return this.isRepeaterUsed() && null != this.getProxyServer() && this.getProxyServer().trim().length() > 0;
        }
        return this.checkRepeaterProxy.isSelected();
    }

    public boolean isRepeaterUsed() {
        if (!this.bSilentMode) {
            return this.repeaterOption.isSelected();
        }
        String repeaterURL = this.getRepeaterURL();
        return repeaterURL != null && repeaterURL.trim().length() == 0;
    }

    @Override
    public boolean validateRepeater() {
        String sRepeaterURL = this.getRepeaterURL();
        if (sRepeaterURL == null || sRepeaterURL.trim().length() == 0) {
            OiiolTextLogger.appendText(sInvalidRepeaterUrl, OiiolTextLogger.LOG_WARNING);
            this.getAlertHandler().showAlert(sErrorConnection, sInvalidRepeaterUrl, 50, 1, 1, 20);
            return false;
        }
        try {
            return this.ocmValidation.testRepeaterConnection(sRepeaterURL);
        }
        catch (OiixOCMException e) {
            OiiolTextLogger.appendText(e.getMessage(), OiiolTextLogger.LOG_WARNING);
            this.getAlertHandler().showAlert(sErrorConnection, e.getMessage(), 50, 1, 1, 20);
            return false;
        }
    }

    @Override
    public boolean validateRepeaterWithProxy() {
        String sRepeaterURL = this.getRepeaterURL();
        if (sRepeaterURL == null || sRepeaterURL.trim().length() == 0) {
            OiiolTextLogger.appendText(sInvalidRepeaterUrl, OiiolTextLogger.LOG_WARNING);
            this.getAlertHandler().showAlert(sErrorConnection, sInvalidRepeaterUrl, 50, 1, 1, 20);
            return false;
        }
        try {
            this.ocmValidation.setRepeater(sRepeaterURL);
        }
        catch (OiixOCMException e) {
            OiiolTextLogger.appendText(e.getMessage(), OiiolTextLogger.LOG_WARNING);
            this.getAlertHandler().showAlert(sErrorConnection, e.getMessage(), 50, 1, 1, 20);
            return false;
        }
        return this.validateProxy();
    }

    @Override
    public boolean validateProxy() {
        if (this.getProxyServer().length() == 0 || this.getProxyPort() == -1) {
            this.getAlertHandler().showAlert(sErrorConnection, OiixOCMLibraryUtils.getMessage(sEmptyProxy), 50, 1, 1, 20);
            return false;
        }
        if (this.getProxyPort() == -1) {
            this.setProxyPort(80);
        }
        if (this.getProxyServer().length() == 0 && (this.getProxyPort() == -1 || this.getProxyUsername().length() > 0 || this.getProxyPassword().length() > 0)) {
            this.getAlertHandler().showAlert(sErrorConnection, OiixOCMLibraryUtils.getMessage(sEmptyProxy), 50, 1, 1, 20);
            return false;
        }
        if (this.getProxyServer().length() == 0 && (this.getProxyPort() == -1 || this.getProxyUsername().length() > 0 || this.getProxyPassword().length() > 0)) {
            this.getAlertHandler().showAlert(sErrorConnection, OiixOCMLibraryUtils.getMessage(sEmptyProxy), 50, 1, 1, 20);
            return false;
        }
        if (this.getProxyUsername() != null && this.getProxyUsername().trim().length() > 0 && (this.getProxyPassword() == null || this.getProxyPassword().trim().length() <= 0)) {
            this.getAlertHandler().showAlert(sErrorConnection, OiixOCMLibraryUtils.getMessage(sEmptyProxyPwd), 50, 1, 1, 20);
            return false;
        }
        boolean status = false;
        try {
            OiiolTextLogger.appendText("Testing the proxy connection with " + this.getProxyServer() + ":" + this.getProxyPort());
            status = this.ocmValidation.testInstallProxyConnection(this.getProxyServer(), new Integer(this.getProxyPort()), this.getProxyUsername(), this.getProxyPassword());
            if (!status) {
                return false;
            }
        }
        catch (OiixOCMException e) {
            this.getAlertHandler().showAlert(sErrorConnection, OiixResourceBundle.getString("S_OCM_PROXY_CONNECTION_ERROR"), 50, 1, 1, 20);
            return false;
        }
        catch (Exception e) {
            this.getAlertHandler().showAlert(sErrorConnection, OiixResourceBundle.getString("S_OCM_PROXY_CONNECTION_ERROR"), 50, 1, 1, 20);
            return false;
        }
        return true;
    }

    @Override
    public int doModal() {
        WindowUtils.centerWindow((Window)this.proxyDialog, (Component)this.fParentFrame);
        Toolkit.getDefaultToolkit().beep();
        this.proxyDialog.setVisible(true);
        this.s_proxyServerRptr.requestFocus();
        return 0;
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.onCancel();
        this.resetValues();
        this.proxyDialog.setVisible(false);
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent event) {
    }

    @Override
    public void keyReleased(KeyEvent event) {
        switch (event.getKeyCode()) {
            case 27: {
                this.resetValues();
                event.consume();
                this.proxyDialog.setVisible(false);
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getSource() == this.repeaterHelp && this.repeaterOption.isEnabled()) {
            OiixHelp.addInstHelp();
            OiixHelp.displayInstHelp("OiifoOCMProxySupportHub", this.proxyDialog);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private MultiLineLabel mkMllLabel(String text) {
        MultiLineLabel mllb = new MultiLineLabel(WordWrapper.getTextWrapper(), text);
        mllb.setPreferredAspectRatio(0.0f);
        mllb.setForeground(Color.black);
        mllb.setFont(OiixOCMLibraryUtils.font_plain);
        return mllb;
    }

    private JLabel mkLabel(String text, Component target) {
        JLabel lbl = new JLabel(text);
        lbl.setForeground(Color.black);
        lbl.setFont(OiixOCMLibraryUtils.font_plain);
        if (target != null) {
            lbl.setLabelFor(target);
        }
        lbl.setText(text);
        OiifmMnemonicOps.processMnemonic(lbl);
        return lbl;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.cb_no) {
            this.resetValues();
            this.s_proxyServerRptr.setEnabled(!this.cb_no.isSelected());
            this.s_proxyPortRptr.setEnabled(!this.cb_no.isSelected());
            this.s_proxyPasswordRptr.setEnabled(!this.cb_no.isSelected());
            this.s_proxyUserRptr.setEnabled(!this.cb_no.isSelected());
            this.s_proxyPasswordRptr.setEditable(!this.cb_no.isSelected());
            this.s_proxyPortRptr.setEditable(!this.cb_no.isSelected());
            this.s_proxyPortRptr.setBackground(this.s_proxyServerRptr.getBackground());
            this.s_proxyPasswordRptr.setBackground(this.s_proxyServerRptr.getBackground());
            this.s_proxyServer.setEnabled(!this.cb_no.isSelected());
            this.s_proxyPort.setEnabled(!this.cb_no.isSelected());
            this.s_proxyPassword.setEnabled(!this.cb_no.isSelected());
            this.s_proxyUser.setEnabled(!this.cb_no.isSelected());
            this.s_proxyPassword.setEditable(!this.cb_no.isSelected());
            this.s_proxyPort.setEditable(!this.cb_no.isSelected());
            this.s_proxyPort.setBackground(this.s_proxyServer.getBackground());
            this.s_proxyPassword.setBackground(this.s_proxyServer.getBackground());
            this.checkRepeaterProxy.setEnabled(!this.cb_no.isSelected());
        }
        if (e.getSource() == this.checkRepeaterProxy) {
            this.s_proxyPasswordRptr.setEnabled(this.checkRepeaterProxy.isSelected());
            this.s_proxyPortRptr.setEnabled(this.checkRepeaterProxy.isSelected());
            this.s_proxyServerRptr.setEnabled(this.checkRepeaterProxy.isSelected());
            this.s_proxyUserRptr.setEnabled(this.checkRepeaterProxy.isSelected());
            this.s_proxyPasswordRptr.setBackground(this.s_proxyServerRptr.getBackground());
        }
        if (e.getSource() == this.repeaterOption && this.repeaterOption.isSelected()) {
            ((CardLayout)this.titlePanel.getLayout()).show(this.titlePanel, this.repeaterOption.getActionCommand());
        } else if (e.getSource() == this.proxyOption && this.proxyOption.isSelected()) {
            ((CardLayout)this.titlePanel.getLayout()).show(this.titlePanel, this.proxyOption.getActionCommand());
        }
    }

    public static void main(String[] args) {
        JFrame parent = new JFrame();
        parent.setSize(400, 400);
        parent.setDefaultCloseOperation(3);
        OiifoOCMProxy pnl = new OiifoOCMProxy(parent);
        HashMap<String, String> varMap = new HashMap<String, String>();
        varMap.put("PROXY_HOST", "www-proxy.us.oracle.com");
        varMap.put("PROXY_PORT", "80");
        varMap.put("PROXY_USER", "");
        varMap.put("PROXY_PWD", "");
        pnl.setProxyVarMap(varMap);
        pnl.setAlertHandler(new OiifoIOCMAlert(){

            @Override
            public int showAlert(String title, String message, int alertType, int userChoices, int defaultChoice, int severity) {
                System.out.println(message);
                return 1;
            }
        });
        pnl.doModal();
        HashMap updatedMap = pnl.getProxyVarMap();
        if (!updatedMap.isEmpty()) {
            Iterator itr = updatedMap.keySet().iterator();
            while (itr.hasNext()) {
                System.out.println(updatedMap.get(itr.next()));
            }
        }
        parent.dispose();
    }

    @Override
    public void setAlertHandler(OiifoIOCMAlert alertHandler) {
        this.alertHandler = alertHandler;
    }

    @Override
    public OiifoIOCMAlert getAlertHandler() {
        return this.alertHandler;
    }

    @Override
    public int showAlert(String title, String message, int alertType, int userChoices, int defaultChoice, int severity) {
        OiixOCMLibraryUtils.showErrorMessage(title, message);
        return 0;
    }

    @Override
    public boolean isProxyCancelled() {
        return this.bCancel;
    }

    private OiifoIOCMProgressListener getListener() {
        return this.listener;
    }

    @Override
    public void setProgressListener(OiifoIOCMProgressListener oListener) {
        this.listener = this.listener;
    }
}

