/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifo;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import oracle.bali.ewt.util.WindowUtils;
import oracle.sysman.oii.oiif.oiifo.OiifoIOCMAlert;
import oracle.sysman.oii.oiif.oiifo.OiifoIOCMProgressListener;
import oracle.sysman.oii.oiif.oiifo.OiifoIOCMProxy;
import oracle.sysman.oii.oiif.oiifo.OiifoIOCMUI;
import oracle.sysman.oii.oiif.oiifo.OiifoOCMProxy;
import oracle.sysman.oii.oiif.oiifo.OiifoOCMUI;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixOCMValidation;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifoOCMInterfaceManager {
    private static OiifoOCMInterfaceManager ocmIntfMgr;
    private OiifoIOCMUI ocmUI;
    private OiifoIOCMAlert ocmAlert;
    private OiifoIOCMProxy ocmProxy;
    private OiifoIOCMProgressListener ocmProgress;
    private static boolean isSilentMode;
    private Component uiComp;
    private OiixOCMValidation ocmValidation = new OiixOCMValidation();

    private OiifoOCMInterfaceManager() {
        this.ocmAlert = new OiifoIOCMAlert(){

            @Override
            public int showAlert(String title, String message, int alertType, int userChoices, int defaultChoice, int severity) {
                OiiolTextLogger.writeToLogAndConsole(message);
                System.out.println(message);
                return 1;
            }
        };
        if (null == this.ocmUI) {
            this.ocmUI = new OiifoOCMUI(this.ocmValidation);
            if (!isSilentMode) {
                this.uiComp = this.ocmUI.getUIComponent();
            }
            this.ocmProxy = isSilentMode ? new OiifoOCMProxy(null, this.ocmValidation) : new OiifoOCMProxy(WindowUtils.parentFrame((Component)this.uiComp), this.ocmValidation);
            if (!isSilentMode && null != WindowUtils.parentFrame((Component)this.uiComp)) {
                this.ocmUI.setProxyHandler(this.ocmProxy);
            }
            if (isSilentMode) {
                this.ocmUI.setAlertHandler(this.ocmAlert);
            }
        }
    }

    private void setProxy() {
        this.ocmProxy = !isSilentMode ? new OiifoOCMProxy(WindowUtils.parentFrame((Component)this.ocmUI.getUIComponent()), this.ocmValidation) : new OiifoOCMProxy(null, this.ocmValidation);
        this.ocmUI.setProxyHandler(this.ocmProxy);
    }

    public void dispose() {
        ocmIntfMgr = null;
        this.ocmProxy = null;
        this.ocmUI = null;
        this.ocmAlert = null;
        this.ocmValidation = null;
        this.uiComp = null;
        this.ocmProgress = null;
    }

    public static synchronized OiifoOCMInterfaceManager getInstance(boolean bSilent) {
        isSilentMode = bSilent;
        if (null == ocmIntfMgr) {
            ocmIntfMgr = new OiifoOCMInterfaceManager();
        }
        return ocmIntfMgr;
    }

    public OiifoIOCMUI getOCMUIInstance() {
        return this.ocmUI;
    }

    public Component getOCMUI() {
        if (isSilentMode) {
            return null;
        }
        if (this.uiComp == null) {
            this.uiComp = this.ocmUI.getUIComponent();
        }
        return this.uiComp;
    }

    public void setAlertHandler(OiifoIOCMAlert oAlert) {
        this.ocmAlert = oAlert;
        if (null != this.ocmUI) {
            this.ocmUI.setAlertHandler(oAlert);
        }
        if (null != this.ocmProxy) {
            this.ocmProxy.setAlertHandler(oAlert);
        }
    }

    public void setVariableMap(HashMap oVarMap) {
        this.ocmUI.setOCMUIVarMap(oVarMap);
    }

    public HashMap getVariableMap() {
        return this.ocmUI.getOCMUIVarMap();
    }

    public List getVariablesList() {
        ArrayList<String> al = new ArrayList<String>();
        al.add("MYORACLESUPPORT_USERNAME");
        al.add("MYORACLESUPPORT_PASSWORD");
        al.add("PROXY_HOST");
        al.add("PROXY_PORT");
        al.add("PROXY_USER");
        al.add("PROXY_PWD");
        al.add("DECLINE_SECURITY_UPDATES");
        al.add("COLLECTOR_RESPONSE_FILE");
        al.add("COLLECTOR_SUPPORTHUB_URL");
        al.add("SECURITY_UPDATES_VIA_MYORACLESUPPORT");
        return al;
    }

    public void resetCount() {
        if (null != this.ocmUI && !isSilentMode) {
            this.ocmUI.resetCount();
        }
    }

    public String getTitle() {
        return OiixResourceBundle.getString("S_OCM_PAGE_TITLE");
    }

    public boolean validate(HashMap varMap) {
        boolean result = this.ocmUI.validateInputs(varMap, isSilentMode);
        return result;
    }

    public void setProgressListener(OiifoIOCMProgressListener oListener) {
        this.ocmProgress = oListener;
        this.ocmUI.setProgressListener(oListener);
        this.ocmProxy.setProgressListener(oListener);
    }

    public static void main(String[] args) {
        OiifoOCMInterfaceManager ocmIntfMgr = OiifoOCMInterfaceManager.getInstance(true);
        System.out.println("USE CASE 1 : proper input values");
        HashMap<String, Object> varMap = new HashMap<String, Object>();
        varMap.put("MYORACLESUPPORT_USERNAME", "");
        varMap.put("DECLINE_SECURITY_UPDATES", new Boolean("true"));
        ocmIntfMgr.setVariableMap(varMap);
        ocmIntfMgr.setAlertHandler(new OiifoIOCMAlert(){

            @Override
            public int showAlert(String title, String message, int alertType, int userChoices, int defaultChoice, int severity) {
                System.out.println(" *** " + message);
                return 1;
            }
        });
        boolean isValid = ocmIntfMgr.validate(varMap);
        System.out.println("VALID ? " + isValid);
        System.out.println(ocmIntfMgr.getVariableMap());
        final OiifoOCMInterfaceManager ocmIntfMgr1 = OiifoOCMInterfaceManager.getInstance(false);
        JFrame f = new JFrame("Test");
        f.setLayout(new FlowLayout());
        f.setSize(800, 400);
        f.setDefaultCloseOperation(3);
        f.add(ocmIntfMgr1.getOCMUI());
        JButton btn = new JButton("Validate");
        System.out.println(ocmIntfMgr1.getVariableMap());
        f.setLayout(new FlowLayout());
        f.setSize(800, 400);
        f.setDefaultCloseOperation(3);
        f.add(ocmIntfMgr1.getOCMUI());
        btn = new JButton("Validate");
        System.out.println(ocmIntfMgr1.getVariableMap());
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println(ocmIntfMgr1.getVariableMap());
                boolean bRet = ocmIntfMgr1.validate(ocmIntfMgr1.getVariableMap());
                System.out.println("VALID ?? " + bRet);
                HashMap updatedMap = ocmIntfMgr1.getVariableMap();
                if (!updatedMap.isEmpty()) {
                    System.out.println(ocmIntfMgr1.getVariableMap());
                }
            }
        });
        f.add(btn);
        f.show();
    }

    static {
        isSilentMode = false;
    }
}

